
<cfset mailto = Application.currentUpdate["contact_list"]>
<cfset mailfrom = "ecotox.support@epa.gov">

<!--- notifications will not show up unless checked --->
<cfparam name="form.notifications" default="">
<cfparam name="form.updatesignup" default="">


<cfif form.notifications neq "1">
	<cfset form.notifications = "">
</cfif>
<cfif form.updatesignup neq "1">
	<cfset form.updatesignup = "">
</cfif>

<cfset textEntryRegExp = "^[a-zA-Z0-9~*\(\)\?\/\""\''\{\}\[\],._\s-]*$">
<!--- <cfset textEntryRegExp = "^[a-zA-Z0-9~*\(\),._\s-]*$"> --->
<cfset emailEntryRegExp = "^[a-zA-Z0-9~*\(\),._\s-@]*$">

<cfif IsValid("regex", form.contact_form_concern, textEntryRegExp)>
	<cfif Len(form.contact_form_concern) GT 1000>
		<cfset form.contact_form_concern = Left(form.contact_form_concern, 997) & "...">
	</cfif>
<cfelse>
	<cfset form.contact_form_concern = Replace(form.contact_form_concern, "`", "BACKTICK", "all")>
	<cfset form.contact_form_concern = Replace(form.contact_form_concern, "~", "TILDE", "all")>
	<cfset form.contact_form_concern = Replace(form.contact_form_concern, "!", "EXCLAMATIONPOINT", "all")>
	<cfset form.contact_form_concern = Replace(form.contact_form_concern, "@", "ATSYMBOL", "all")>
	<cfset form.contact_form_concern = Replace(form.contact_form_concern, "##", "POUNDSIGN", "all")>
	<cfset form.contact_form_concern = Replace(form.contact_form_concern, "$", "DOLLARSIGN", "all")>
	<cfset form.contact_form_concern = Replace(form.contact_form_concern, "%", "PERCENT", "all")>
	<cfset form.contact_form_concern = Replace(form.contact_form_concern, "^", "CARAT", "all")>
	<cfset form.contact_form_concern = Replace(form.contact_form_concern, "&", "AMPERSAND", "all")>
	<cfset form.contact_form_concern = Replace(form.contact_form_concern, "*", "ASTERISK", "all")>
	<cfset form.contact_form_concern = Replace(form.contact_form_concern, "|", "PIPE", "all")>
	<cfset form.contact_form_concern = Replace(form.contact_form_concern, "+", "PLUS", "all")>
	<cfset form.contact_form_concern = Replace(form.contact_form_concern, "=", "EQUALS", "all")>
	<cfset form.contact_form_concern = Replace(form.contact_form_concern, "?", "QUESTIONMARK", "all")>
	<cfset form.contact_form_concern = Replace(form.contact_form_concern, "<", "LEFTANGLEBRACKET", "all")>
	<cfset form.contact_form_concern = Replace(form.contact_form_concern, ">", "RIGHTANGLEBRACKET", "all")>
	<cfset form.contact_form_concern = Replace(form.contact_form_concern, "\\", "BACKSLASH", "all")>
	<cfset form.contact_form_concern = Replace(form.contact_form_concern, "\/", "FORWARDSLASH", "all")>
</cfif>

<cfif IsValid("regex", form.emailaddress, emailEntryRegExp)>
	<cfif Len(form.emailaddress) GT 100>
		<cfset form.emailaddress = Left(form.emailaddress, 97) & "...">
	</cfif>
<cfelse>
	<cfset form.emailaddress = "">
</cfif>

<cfif IsValid("regex", form.contactname, emailEntryRegExp)>
	<cfif Len(form.contactname) GT 100>
		<cfset form.contactname = Left(form.contactname, 97) & "...">
	</cfif>
<cfelse>
	<cfset form.contactname = "">
</cfif>

<cfif IsValid("regex", form.organizationSelect, textEntryRegExp)>
	<cfif Len(form.organizationSelect) GT 50>
		<cfset form.organizationSelect = Left(form.organizationSelect, 47) & "...">
	</cfif>
<cfelse>
	<cfset form.organizationSelect = "">
</cfif>

<cfif IsValid("regex", form.organization, textEntryRegExp)>
	<cfif Len(form.organization) GT 50>
		<cfset form.organization = Left(form.organization, 47) & "...">
	</cfif>
<cfelse>
	<cfset form.organization = "">
</cfif>

<CFPROCESSINGDIRECTIVE SUPPRESSWHITESPACE="No">
<CFMAIL
TO="#mailto#"
FROM="#mailfrom#"
SUBJECT="ECOTOX Comments"
TYPE="text">

<cfif isDefined("form.contact_form_concern")>
CONCERN
#form.contact_form_concern#
</cfif>

EMAIL_OF_REQUESTOR
#form.emailaddress#

<cfif isDefined("form.contactname")>
NAME_OF_REQUESTOR
#form.contactname#
</cfif>

<cfif isDefined("form.organizationSelect")>
ORG_OF_REQUESTOR
#form.organizationSelect#<cfelse>No Organization selected</cfif><cfif isDefined("form.organization") AND form.organization neq ""> - #form.organization#</cfif>

NOTIFICATIONS
<cfif form.notifications eq "1">
Yes, I wish to receive notifications when quarterly updates are available.
<cfelse>
No, I do not wish to receive notifications when quarterly updates are available.
</cfif>

</CFMAIL>
</CFPROCESSINGDIRECTIVE>

<cfif form.updatesignup eq "1">

<h3 class="title">Thank you!</h3>
<p>You will be notified at <b><cfoutput>#form.emailaddress#</cfoutput></b> when the next quarterly update is available.</p>

<div class="reveal-footer">
	<a class="button secondary cancel" data-close>Close</a>
</div>

<cfelse>

<h3>Thank you for your feedback.</h3>
<p>Your comments have been submitted to the ECOTOX support group. We will respond to the message as soon as possible.</p>

</cfif>
