<cfset OutFunc = CreateObject("component", "cfc.output_functions")>
    
<cfparam name="URL.dataview" default="">
<cfparam name="URL.datamode" default="">

<cfparam name="URL.export" default="">
<cfparam name="URL.format" default="">
        
<!--- paging / sorting vars --->  
<cfparam name="FORM.sortfield" default="">       <!--- UI will pass this or default to col 1 on DT.  Exports will use the default value here  --->
<cfparam name="FORM.sortdir" default="">
<cfparam name="FORM.length" default="10000">   <!--- default is application max.  UI will pass page size, exports will not and will be capped at 10000 rows --->
<cfparam name="FORM.start" default="0">       <!--- offset position for query results.  UI will pass this, default to beginning.  Exports will have full range 0-10000 --->

<cfset SORTFIELD = OutFunc.generateOrderByClause( FORM.sortfield, FORM.sortdir )>
<cfset PAGESIZE = FORM.length>
<cfset STARTPOS = FORM.start>
<cfset STARTPOSPLUS1 = STARTPOS + 1>
<cfset ENDPOS = PAGESIZE + STARTPOS>
    
<!--- jquery datatable specific --->
<cfparam name ="FORM.draw" default="">
<cfset RETURNDRAW = FORM.draw>

<cfif URL.dataview eq "">
      
    <!--- SET CONDITIONS OF ERROR HERE FOR RETURN MESSAGING --->
      
    <cfinclude template="publications/error_pubs_response.cfm">
      
<cfelse>
    
    <cfswitch expression="#url.dataview#">

        <cfcase value="explorePubsSummary">

            <cfif URL.datamode EQ "landing">
                <!--- for default mode (loading initial summary) --->
                <cfparam name="FORM.pubauthor" default="">
                <cfparam name="FORM.pubtitle" default="">
                <cfparam name="FORM.pubchemicals" default="">
                <cfparam name="FORM.pubspecies" default="">
                <cfparam name="FORM.pubeffects" default="">
    
                <cfinclude template="publications/queries/fetch_refnums_from_landing.cfm">
                <cfinclude template="publications/refnums_response_JSON.cfm">

            <cfelseif URL.datamode EQ "explore">
                <cfif SORTFIELD EQ "">
                    <cfset SORTFIELD = "ecoref_number">
                </cfif>

                <cfif URL.export EQ "1">
                    <cfset OUTPUTFORMAT = "CSV">                             <!--- might change later and there will be more formats --->
                <cfelse>
                    <cfset OUTPUTFORMAT = "JSON">                    
                </cfif>
 
                <cfinclude template="../pages/explore/explore_param_check.cfm" />
                <cfparam name="URL.category" default="">

                <cfinclude template="publications/queries/pub_summary_by_filter.cfm">
                <cfinclude template="publications/pubs_summary_response_JSON.cfm">

            <cfelseif URL.datamode EQ "export">
                <cfif SORTFIELD EQ "">
                    <cfset SORTFIELD = "ecoref_number">
                </cfif>

                <cfif URL.format NEQ "">
                    <cfset OUTPUTFORMAT = URL.format>
                <cfelse>
                    <cfset OUTPUTFORMAT = "CSV">                    
                </cfif>
 
                <cfinclude template="../pages/explore/explore_param_check.cfm" />
                <cfparam name="URL.category" default="">

                <cfinclude template="publications/queries/export_summary_by_filter.cfm">
                <cfinclude template="publications/export_summary_response_CSV.cfm">

            <cfelse>

                <!--- error handling??? --->    

            </cfif>

        </cfcase>
        
        <cfcase value="explorePubsRecords">
            <cfif URL.datamode EQ "export">
                <cfif SORTFIELD EQ "">
                    <cfset SORTFIELD = "ecoref_number">
                </cfif>

                <cfif URL.format NEQ "">
                    <cfset OUTPUTFORMAT = URL.format>
                <cfelse>
                    <cfset OUTPUTFORMAT = "CSV">                    
                </cfif>
 
                <cfinclude template="../pages/explore/explore_param_check.cfm" />
                <cfparam name="URL.category" default="">

                <cfinclude template="publications/queries/export_records_by_filter.cfm">
                <cfinclude template="publications/export_records_response_CSV.cfm">

            <cfelse>
                <cfif SORTFIELD EQ "">
                    <cfset SORTFIELD = "ecoref_number">
                </cfif>

                <cfif URL.export EQ "1">
                    <cfset OUTPUTFORMAT = "CSV">                             <!--- might change later and there will be more formats --->
                <cfelse>
                    <cfset OUTPUTFORMAT = "JSON">                    
                </cfif>

                <cfinclude template="../pages/explore/explore_param_check.cfm" />
                <cfparam name="URL.category" default="">

                <cfinclude template="publications/queries/pub_records_count_by_filter.cfm">
                <cfinclude template="publications/queries/pub_records_by_filter.cfm">
                <cfinclude template="publications/pubs_records_response_JSON.cfm">

            </cfif>
        </cfcase>
        
        <cfcase value="explorePubsCharts">

        </cfcase>        

        <cfcase value="fetchCitations">

            <!--- for default mode (loading initial summary) --->
            <cfparam name="FORM.refnums" default="">
            <cfset REFNUMS = FORM.refnums>
            <cfif REFNUMS NEQ "">
            
                <cfif SORTFIELD EQ "">
                    <cfset SORTFIELD = "ecoref_number">
                </cfif>

                <cfif URL.export EQ "1">
                    <cfset OUTPUTFORMAT = "CSV">                             <!--- might change later and there will be more formats --->
                <cfelse>
                    <cfset OUTPUTFORMAT = "JSON">
                </cfif>

                <cfinclude template="publications/queries/full_citation_by_ref_num.cfm">
                <cfinclude template="publications/citations_response_JSON.cfm">

            <cfelse>

                <!--- error handling??? --->    

            </cfif>

        </cfcase>
        
        <cfdefaultcase>

            <!--- UNKNOWN TYPE --->
      
            <!--- SET CONDITIONS OF ERROR HERE FOR RETURN MESSAGING --->
    
            <cfinclude template="publications/error_pubs_response.cfm">

        </cfdefaultcase>
    
    </cfswitch>   
      
</cfif>