
<cfset OutFunc = CreateObject("component", "cfc.output_functions")>
    
<!---construct csv output --->

<!--- TODO: error handling when we determine process flow
<cfif error eq "1">
    <cfset errorHtml = "<div class='#messageClass#'><h5 class='title'>#messageTitle#</h5><p>#messageText#</p></div>">
</cfif>
--->
        
<cfset outputFormat = "CSV">
    
<CFHEADER NAME="Content-Disposition" VALUE="attachment; filename=ECOTOX-Reference-Records.csv">
<CFCONTENT TYPE="text/plain">
  
<cfprocessingdirective suppressWhiteSpace = "Yes">

<cfoutput>"REF. NUMBER","AUTHOR","TITLE","SOURCE","REF. TYPE","DOI","PUB. YEAR","TEST NUM.","CAS NUMBER","CHEMICAL NAME","SPECIES COMMON NAME","EFFECT","EFFECT MEASUREMENT","ENDPOINT","DUR. (MEAN) OP","DUR. (MEAN)","DUR. (MIN) OP","DUR. (MIN)","DUR. (MAX) OP","DUR. (MAX)","DURATION UNIT","CONC. TYPE","CONC. STD (MEAN) OP","CONC. STD (MEAN)","CONC. STD (MIN) OP","CONC. STD (MIN)","CONC. STD (MAX) OP","CONC. STD (MAX)","CONC. STD UNIT","CONC. (MEAN) OP","CONC. (MEAN)","CONC. (MIN) OP","CONC. (MIN)","CONC. (MAX) OP","CONC. (MAX)","CONC. UNIT","CITATION"#chr(13)##chr(10)#</cfoutput>

<cfloop query="PubsRecordsExport">
    <cfset recordArray = "">

    <cfset encTitle = EncodeForURL(PubsRecordsExport.TITLE)>
        
    <cfset qRef_num = OutFunc.cleanStringForDataTable(PubsRecordsExport.ECOREF_NUMBER, outputFormat)>
    <cfset qAuthor = OutFunc.cleanStringForDataTable(PubsRecordsExport.AUTHOR, outputFormat)>
    <cfset qTitle = OutFunc.cleanStringForDataTable(PubsRecordsExport.TITLE, outputFormat)>
    <cfset qSource = OutFunc.cleanStringForDataTable(PubsRecordsExport.SOURCE, outputFormat)>
    <cfset qPub_year = OutFunc.cleanStringForDataTable(PubsRecordsExport.PUB_YEAR, outputFormat)>
    <cfset qRef_type = OutFunc.cleanStringForDataTable(PubsRecordsExport.REFTYPEDESC, outputFormat)>
    <cfset qDOI = OutFunc.cleanStringForDataTable(PubsRecordsExport.DOI, outputFormat)>
    <cfset qTest = OutFunc.cleanStringForDataTable(PubsRecordsExport.TEST_ID, outputFormat)>
    <cfset qCas = OutFunc.cleanStringForDataTable(PubsRecordsExport.CAS_NUMBER, outputFormat)>
    <cfset qChemical = OutFunc.cleanStringForDataTable(PubsRecordsExport.EPA_CHEM_SUBSTANCE_NAME, outputFormat)>
    <cfset qSpecCommon = OutFunc.cleanStringForDataTable(PubsRecordsExport.COMMON_NAME, outputFormat)>
    <cfset qEffect = OutFunc.cleanStringForDataTable(PubsRecordsExport.EFFECT_DESC, outputFormat)>
    <cfset qMeas = OutFunc.cleanStringForDataTable(PubsRecordsExport.MEASUREMENT_DESC, outputFormat)>
    <cfset qEndpoint = OutFunc.cleanStringForDataTable(PubsRecordsExport.ENDPOINT, outputFormat)>
    
    <cfset qDurMeanOp = OutFunc.cleanStringForDataTable(PubsRecordsExport.dur_mean_op, outputFormat)>
    <cfset qDurMean = OutFunc.cleanStringForDataTable(PubsRecordsExport.obs_dur_std, outputFormat)>
    <cfset qDurMinOp = OutFunc.cleanStringForDataTable(PubsRecordsExport.dur_min_op, outputFormat)>
    <cfset qDurMin = OutFunc.cleanStringForDataTable(PubsRecordsExport.obs_dur_min_std, outputFormat)>
    <cfset qDurMaxOp = OutFunc.cleanStringForDataTable(PubsRecordsExport.dur_max_op, outputFormat)>
    <cfset qDurMax = OutFunc.cleanStringForDataTable(PubsRecordsExport.obs_dur_max_std, outputFormat)>
    <cfset qDurUnit = OutFunc.cleanStringForDataTable(PubsRecordsExport.dur_unit, outputFormat)>

    <cfset qConcType = OutFunc.cleanStringForDataTable(PubsRecordsExport.CONC1_TYPE_DESC, outputFormat)>
    
    <cfset qConcStdMean = OutFunc.cleanStringForDataTable(PubsRecordsExport.conc1_mean_std_num, outputFormat)>
    <cfset qConcStdMin = OutFunc.cleanStringForDataTable(PubsRecordsExport.conc1_min_std_num, outputFormat)>
    <cfset qConcStdMax = OutFunc.cleanStringForDataTable(PubsRecordsExport.conc1_max_std_num, outputFormat)>
    <cfset qConcStdUnit = OutFunc.cleanStringForDataTable(PubsRecordsExport.conc_units_std, outputFormat)>
    
    <cfset qConcMeanOp = OutFunc.cleanStringForDataTable(PubsRecordsExport.conc_mean_op, outputFormat)>
    <cfset qConcMean = OutFunc.cleanStringForDataTable(PubsRecordsExport.conc1_mean_auth_num, outputFormat)>
    <cfset qConcMinOp = OutFunc.cleanStringForDataTable(PubsRecordsExport.conc_min_op, outputFormat)>
    <cfset qConcMin = OutFunc.cleanStringForDataTable(PubsRecordsExport.conc1_min_auth_num, outputFormat)>
    <cfset qConcMaxOp = OutFunc.cleanStringForDataTable(PubsRecordsExport.conc_max_op, outputFormat)>
    <cfset qConcMax = OutFunc.cleanStringForDataTable(PubsRecordsExport.conc1_max_auth_num, outputFormat)>
    <cfset qConcUnit = OutFunc.cleanStringForDataTable(PubsRecordsExport.conc_units_auth, outputFormat)>

    <cfset recordArray = listAppend(recordArray,'#qRef_num#')>
    <cfset recordArray = listAppend(recordArray,'#qAuthor#')>
    <cfset recordArray = listAppend(recordArray,'#qTitle#')>
    <cfset recordArray = listAppend(recordArray,'#qSource#')>

    <cfif ListFind("OECDF,MED03,MED04,MED02,OECDN,OECDG,MED01,MED05,OPP,RUSSN,USGS", PubsRecordsExport.REFERENCE_TYPE) gt 0>
        <cfset recordArray = listAppend(recordArray,'#qRef_type#')>
    <cfelse>        
        <cfset recordArray = listAppend(recordArray,'')>
    </cfif>

    <cfset recordArray = listAppend(recordArray,'#qDOI#')>
    <cfset recordArray = listAppend(recordArray,'#qPub_year#')>
    <cfset recordArray = listAppend(recordArray,'#qTest#')>
    <cfset recordArray = listAppend(recordArray,'#qCas#')>
    <cfset recordArray = listAppend(recordArray,'#qChemical#')>
    <cfset recordArray = listAppend(recordArray,'#qSpecCommon#')>
    <cfset recordArray = listAppend(recordArray,'#qEffect#')>
    <cfset recordArray = listAppend(recordArray,'#qMeas#')>
    <cfset recordArray = listAppend(recordArray,'#qEndpoint#')>
    
    <cfset recordArray = listAppend(recordArray,'#qDurMeanOp#')>
    <cfset recordArray = listAppend(recordArray,'#qDurMean#')>
    <cfset recordArray = listAppend(recordArray,'#qDurMinOp#')>
    <cfset recordArray = listAppend(recordArray,'#qDurMin#')>
    <cfset recordArray = listAppend(recordArray,'#qDurMaxOp#')>
    <cfset recordArray = listAppend(recordArray,'#qDurMax#')>
    <cfset recordArray = listAppend(recordArray,'#qDurUnit#')>
    
    <cfset recordArray = listAppend(recordArray,'#qConcType#')>

    <cfset recordArray = listAppend(recordArray,'#qConcMeanOp#')>
    <cfset recordArray = listAppend(recordArray,'#qConcStdMean#')>
    <cfset recordArray = listAppend(recordArray,'#qConcMinOp#')>
    <cfset recordArray = listAppend(recordArray,'#qConcStdMin#')>
    <cfset recordArray = listAppend(recordArray,'#qConcMaxOp#')>
    <cfset recordArray = listAppend(recordArray,'#qConcStdMax#')>
    <cfset recordArray = listAppend(recordArray,'#qConcStdUnit#')>

    <cfset recordArray = listAppend(recordArray,'#qConcMeanOp#')>
    <cfset recordArray = listAppend(recordArray,'#qConcMean#')>
    <cfset recordArray = listAppend(recordArray,'#qConcMinOp#')>
    <cfset recordArray = listAppend(recordArray,'#qConcMin#')>
    <cfset recordArray = listAppend(recordArray,'#qConcMaxOp#')>
    <cfset recordArray = listAppend(recordArray,'#qConcMax#')>
    <cfset recordArray = listAppend(recordArray,'#qConcUnit#')>
    
    <cfset fullCitation = OutFunc.cleanStringForDataTable(PubsRecordsExport.citation, outputFormat)>        
    <cfset recordArray = listAppend(recordArray,'#fullCitation#')>
        
    <cfoutput>#recordArray##chr(13)##chr(10)#</cfoutput>
</cfloop>
</cfprocessingdirective>