
<cfset OutFunc = CreateObject("component", "cfc.output_functions")>
    
<!---construct csv output --->

<!--- TODO: error handling when we determine process flow
<cfif error eq "1">
    <cfset errorHtml = "<div class='#messageClass#'><h5 class='title'>#messageTitle#</h5><p>#messageText#</p></div>">
</cfif>
--->
        
<cfset outputFormat = "CSV">
    
<CFHEADER NAME="Content-Disposition" VALUE="attachment; filename=ECOTOX-Reference-Summary.csv">
<CFCONTENT TYPE="text/plain">
  
<cfprocessingdirective suppressWhiteSpace = "Yes">

<cfoutput>"REF. NUMBER","AUTHOR","TITLE","SOURCE","REF. TYPE","DOI","PUB. YEAR","CHEMICALS","SPECIES","TESTS","RESULTS","CITATION"#chr(13)##chr(10)#</cfoutput>

<cfloop query="PubsSummaryExport">
    <cfset recordArray = "">

    <cfset encTitle = EncodeForURL(PubsSummaryExport.TITLE)>
        
    <cfset qRef_num = OutFunc.cleanStringForDataTable(PubsSummaryExport.ECOREF_NUMBER, outputFormat)>
    <cfset qAuthor = OutFunc.cleanStringForDataTable(PubsSummaryExport.AUTHOR, outputFormat)>
    <cfset qTitle = OutFunc.cleanStringForDataTable(PubsSummaryExport.TITLE, outputFormat)>
    <cfset qSource = OutFunc.cleanStringForDataTable(PubsSummaryExport.SOURCE, outputFormat)>
    <cfset qPub_year = OutFunc.cleanStringForDataTable(PubsSummaryExport.PUB_YEAR, outputFormat)>
    <cfset qRef_type = OutFunc.cleanStringForDataTable(PubsSummaryExport.REFTYPEDESC, outputFormat)>
    <cfset qDOI = OutFunc.cleanStringForDataTable(PubsSummaryExport.DOI, outputFormat)>
    <cfset qChemicals = OutFunc.cleanStringForDataTable(PubsSummaryExport.num_chemicals, outputFormat)>
    <cfset qSpecies = OutFunc.cleanStringForDataTable(PubsSummaryExport.num_species, outputFormat)>
    <cfset qTests = OutFunc.cleanStringForDataTable(PubsSummaryExport.num_tests, outputFormat)>
    <cfset qResults = OutFunc.cleanStringForDataTable(PubsSummaryExport.num_results, outputFormat)>

    <cfset recordArray = listAppend(recordArray,'#qRef_num#')>
    <cfset recordArray = listAppend(recordArray,'#qAuthor#')>
    <cfset recordArray = listAppend(recordArray,'#qTitle#')>
    <cfset recordArray = listAppend(recordArray,'#qSource#')>

    <cfif ListFind("OECDF,MED03,MED04,MED02,OECDN,OECDG,MED01,MED05,OPP,RUSSN,USGS", PubsSummaryExport.REFERENCE_TYPE) gt 0>
        <cfset recordArray = listAppend(recordArray,'#qRef_type#')>
    <cfelse>        
        <cfset recordArray = listAppend(recordArray,'')>
    </cfif>

    <cfset recordArray = listAppend(recordArray,'#qDOI#')>
    <cfset recordArray = listAppend(recordArray,'#qPub_year#')>
    <cfset recordArray = listAppend(recordArray,'#qChemicals#')>
    <cfset recordArray = listAppend(recordArray,'#qSpecies#')>
    <cfset recordArray = listAppend(recordArray,'#qTests#')>
    <cfset recordArray = listAppend(recordArray,'#qResults#')>
    
    <cfset fullCitation = OutFunc.cleanStringForDataTable(PubsSummaryExport.citation, outputFormat)>        
    <cfset recordArray = listAppend(recordArray,'#fullCitation#')>
        
    <cfoutput>#recordArray##chr(13)##chr(10)#</cfoutput>
</cfloop>
</cfprocessingdirective>