<cfset OutFunc = CreateObject("component", "cfc.output_functions")>
    
<!--- ERROR HANDLING, MAY NOT BE NEEDED HERE --->
<cfset error = "0">
<cfset errorHtml = "">
<cfset messageClass = ''>
<cfset messageTitle = ''>
<cfset messageText = ''>
<cfset linebreak = Chr(13) & Chr(10)>
    
<cfset rowCount = PubsQueryRecords.TotalRows>
<cfif rowCount eq "">
    <cfset rowCount = 0>
</cfif>

<cfif NOT IsDefined("REFNUMS")>
    <cfset REFNUMS = "">
</cfif>

<cfif rowCount eq 0>
    <cfset error = "1">
    <cfset messageClass = "callout primary">
    <cfset messageTitle = "Sorry">
    <cfset messageText = "There were no results found for this selection. Please refine your search.">    
</cfif>


<cfset resultsArray = arrayNew(1)>
<cfloop query="PubsQueryRecords">
    <cfset rowData = "">
    <cfset REFNUMS = listAppend(REFNUMS, PubsQueryRecords.ecoref_number)>

    <cfset colVal = replace(PubsQueryRecords.ecoref_number," ","&nbsp;","All")>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"refNum":' & colVal)>

    <cfset colVal = PubsQueryRecords.short_ref>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"shortRef":' & colVal)>

    <cfset colVal = EncodeForHTML(PreserveSingleQuotes(PubsQueryRecords.citation))>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"citation":' & colVal)>

    <cfset colVal = PubsQueryRecords.test_id>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"testId":' & colVal)>
    
    <cfset colVal = PubsQueryRecords.cas_number>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"casNumber":' & colVal)>

    <cfset colVal = PubsQueryRecords.epa_chem_substance_name>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"chemName":' & colVal)>

    <cfset colVal = EncodeForHTML(PreserveSingleQuotes(PubsQueryRecords.common_name))>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"commonName":' & colVal)>

    <cfset colVal = PubsQueryRecords.effect_desc>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"effect":' & colVal)>

    <cfset colVal = PubsQueryRecords.measurement_desc>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"effectMeas":' & colVal)>

    <cfset colVal = PubsQueryRecords.endpoint>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"endpoint":' & colVal)>

    <cfset colVal = PubsQueryRecords.obs_duration>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"duration":' & colVal)>

    <cfset concType = PubsQueryRecords.conc1_type_desc>
    <cfset concVal = PubsQueryRecords.concentration>

    <cfset colVal = concVal>
    <cfif colVal NEQ "">
        <cfif concType NEQ "">
            <cfset colVal = concType & linebreak & colVal>
        </cfif>
    </cfif>

    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"conc":' & colVal)>


    <cfset colVal = PubsQueryRecords.dtxsid>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"dtxsid":' & colVal)>

    <cfset colVal = PubsQueryRecords.title>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"title":' & colVal)>

    <cfset rowData = "{" & rowData & "}">
    <cfset ArrayAppend(resultsArray, rowData)>
</cfloop>

<!---construct json output --->

<cfif error eq "1">
    <cfset errorHtml = "<div class='#messageClass#'><h5 class='title'>#messageTitle#</h5><p>#messageText#</p></div>">
</cfif>
    
<cfset dataString = "">
<cfloop array="#resultsArray#" index="thisRow">
    <cfset dataString = listAppend(dataString, thisRow)>
</cfloop>
    
<cfset jsonString = '{"queryError":"#error#","errorHtml":"#errorHtml#","allRecsCount":"#CountQuery.cnt_allrecs#","totalCount":"#CountQuery.cnt_distinct#","draw":"#RETURNDRAW#","refNumsGroup":"#REFNUMS#","recordsTotal":"#rowCount#","recordsFiltered":"#rowCount#","records":[' & dataString & ']}'>

<cfprocessingdirective suppressWhiteSpace = "Yes">
<cfoutput>#jsonString#</cfoutput>
</cfprocessingdirective>
