<cfset OutFunc = CreateObject("component", "cfc.output_functions")>
<cfprocessingdirective suppressWhiteSpace = "Yes">
    
<!--- ERROR HANDLING, MAY NOT BE NEEDED HERE --->
<cfset error = "0">
<cfset errorHtml = "">
<cfset messageClass = ''>
<cfset messageTitle = ''>
<cfset messageText = ''>
    
<cfset rowCount = PubsQuerySummary.TotalRows>
<cfif rowCount eq "">
    <cfset rowCount = 0>
</cfif>

<cfif NOT IsDefined("REFNUMS")>
    <cfset REFNUMS = "">
</cfif>

<cfif rowCount eq 0>
    <cfset error = "1">
    <cfset messageClass = "callout primary">
    <cfset messageTitle = "Sorry">
    <cfset messageText = "There were no results found for this selection. Please refine your search.">    
</cfif>


<cfset resultsArray = arrayNew(1)>
<cfloop query="PubsQuerySummary">
    <cfset rowData = "">
    <cfset REFNUMS = listAppend(REFNUMS, PubsQuerySummary.ecoref_number)>

    <cfset fullCitation = PubsQuerySummary.citation>
    <cfset thisRefNum = PubsQuerySummary.ecoref_number>

    <cfif LEN(fullCitation) gt 50>
        <cfset abbrevCitation = LEFT(fullCitation, 50) & "...">
    <cfelse>
        <cfset abbrevCitation = fullCitation>
    </cfif>

    <cfset fullCitation = fullCitation & "<br/>[ CLICK CELL TO COPY ]">

    <cfset colVal = "<abbr title=""" & EncodeForHTML(fullCitation) & """>##" & thisRefNum & ".  " & EncodeForHTML(abbrevCitation) & "</abbr>">
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"ecoref":' & colVal)>

    <cfset colVal = PubsQuerySummary.num_tests>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"num_tests":' & colVal)>

    <cfset colVal = PubsQuerySummary.num_results>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"num_results":' & colVal)>

    <cfset colVal = PubsQuerySummary.num_chemicals>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"num_chemicals":' & colVal)>

    <cfset colVal = PubsQuerySummary.num_species>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"num_species":' & colVal)>

    <cfset colVal = PubsQuerySummary.pub_year>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"pub_year":' & colVal)>

    <cfset colVal = PubsQuerySummary.title>
    <cfset colVal = OutFunc.cleanStringForDataTable(colVal, OUTPUTFORMAT)>
    <cfset rowData = listAppend(rowData, '"title":' & colVal)>

    <cfset rowData = "{" & rowData & "}">
    <cfset ArrayAppend(resultsArray, rowData)>
</cfloop>

<!---construct json output --->

<cfif error eq "1">
    <cfset errorHtml = "<div class='#messageClass#'><h5 class='title'>#messageTitle#</h5><p>#messageText#</p></div>">
</cfif>
    
<cfset dataString = "">
<cfloop array="#resultsArray#" index="thisRow">
    <cfset dataString = listAppend(dataString, thisRow)>
</cfloop>
    
<cfset jsonString = '{"queryError":"#error#","errorHtml":"#errorHtml#","draw":"#RETURNDRAW#","refNumsGroup":"#REFNUMS#","recordsTotal":"#rowCount#","recordsFiltered":"#rowCount#","records":[' & dataString & ']}'>

<cfoutput>#jsonString#</cfoutput>
</cfprocessingdirective>
