<cfset GenFunc = CreateObject("component", "cfc.generic_functions")>

<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cftry>    

    <cfquery name="PubsRecordsExport" datasource="#application.datasource#" dbtype="Oracle80" timeout="300" result="PubsRecordsExportVars">

        SELECT   
            oq.ecoref_number, r.author, r.title, r.source, r.reference_type,
            CASE
                WHEN r.reference_type = 'OECDG' THEN 'German Dataset'
                WHEN r.reference_type = 'OECDF' THEN 'French Dataset'
                WHEN r.reference_type = 'OECDN' THEN 'Dutch Dataset'
                WHEN r.reference_type = 'RUSSN' THEN 'Russian Dataset'
                WHEN r.reference_type = 'USGS'  THEN 'USGS Acute Toxicity Database'
                WHEN r.reference_type = 'OPP'   THEN 'EPA Office of Pesticides Program Database'
                WHEN r.reference_type IN ('MED01','MED02','MED03','MED04','MED05') THEN 'EPA Fathead Minnow Acute Toxicity Database (MED-Duluth)'
                ELSE NULL
            END AS reftypedesc,
            r.doi, r.publication_year as pub_year, oq.test_id, oq.cas_number, oq.epa_chem_substance_name, oq.common_name, oq.effect_desc, oq.measurement_desc
            , oq.endpoint
            , oq.dur_unit, oq.dur_mean_op, oq.obs_dur_std, oq.dur_min_op, oq.obs_dur_min_std, oq.dur_max_op, oq.obs_dur_max_std
            , oq.conc1_type_desc
            , oq.conc_units_std, oq.conc1_mean_std_num, oq.conc1_min_std_num, oq.conc1_max_std_num
            , oq.conc_units_auth, oq.conc1_mean_auth_num, oq.conc1_min_auth_num, oq.conc1_max_auth_num
            , oq.dtxsid, oq.citation, oq.conc_mean_op, oq.conc_min_op, oq.conc_max_op
        FROM (
            SELECT
                iq.ecoref_number, iq.citation, iq.test_id, iq.cas_number, iq.epa_chem_substance_name, iq.common_name, iq.effect_desc
                , iq.measurement_desc, iq.endpoint
                , iq.dur_unit, iq.dur_mean_op, iq.obs_dur_std, iq.dur_min_op, iq.obs_dur_min_std, iq.dur_max_op, iq.obs_dur_max_std
                , iq.conc1_type_desc
                , iq.conc_units_std, iq.conc1_mean_std_num, iq.conc1_min_std_num, iq.conc1_max_std_num
                , iq.conc_units_auth, iq.conc1_mean_auth_num, iq.conc1_min_auth_num, iq.conc1_max_auth_num
                , iq.dtxsid, iq.conc_mean_op, iq.conc_min_op, iq.conc_max_op
            FROM (
                select
                    COUNT(*) as inner_cnt_distinct, v.ecoref_number
                    , v.citation, v.test_id, v.result_id, v.cas_number, v.epa_chem_substance_name, v.common_name, v.effect_desc, v.measurement_desc
                    , v.endpoint, v.dtxsid
                    , CAST(REGEXP_REPLACE(v.obs_duration_std, '[^0-9.]', '') as FLOAT) as obs_dur_std
                    , CAST(REGEXP_REPLACE(v.obs_duration_min_std, '[^0-9.]', '') as FLOAT) as obs_dur_min_std
                    , CAST(REGEXP_REPLACE(v.obs_duration_max_std, '[^0-9.]', '') as FLOAT) as obs_dur_max_std
                    , du.description as dur_unit
                    , v.obs_duration_unit_std, v.conc1_type_desc
                    , v.conc1_mean_std_num, v.conc1_min_std_num, v.conc1_max_std_num, v.conc_units_std
                    , v.conc1_mean_auth_num, v.conc1_min_auth_num, v.conc1_max_auth_num, v.conc_units_auth
                    , v.conc1_mean_op as conc_mean_op, v.conc1_min_op as conc_min_op, v.conc1_max_op as conc_max_op
                    , v.obs_duration_std_op as dur_mean_op, v.obs_duration_min_std_op as dur_min_op, v.obs_duration_max_std_op as dur_max_op
                from
                    ecotox_group_summary3_mv v
                    LEFT JOIN duration_unit_codes du ON du.code = v.obs_duration_unit_std
                WHERE (
                    1=1
        <!---
            this refers to the original group of ecorefs from EP, if applicable.  we always want to filter by these if there is a value,
            regardless of whether there is further filtering by other user inputs (ie. author/title below)
        --->
        <cfif IN_origreflist neq "">
            <cfif ListLen(IN_origreflist) LTE 1000>
                AND v.ecoref_number IN (<CFQUERYPARAM VALUE="#IN_origreflist#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
            <cfelse>
                <cfset arrayOfLists = GenFunc.splitListToSublists(IN_origreflist, 1000)>
                <cfif ArrayLen(arrayOfLists) GTE 1>
                AND (
                    <cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
                        <cfset thisSubList = arrayOfLists[i]>
                        <cfif i GT 1> OR </cfif>                            
                        v.ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                    </cfloop>
                )
                </cfif>
            </cfif>
        </cfif>

        <!--- for author / title --->
        <cfif IN_ecoref neq "All">
            <cfif ListLen(IN_ecoref) LTE 1000>
                AND v.ecoref_number IN (<CFQUERYPARAM VALUE="#IN_ecoref#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
            <cfelse>
                <cfset arrayOfLists = GenFunc.splitListToSublists(IN_ecoref, 1000)>
                <cfif ArrayLen(arrayOfLists) GTE 1>
                AND (
                    <cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
                        <cfset thisSubList = arrayOfLists[i]>
                        <cfif i GT 1> OR </cfif>                            
                        v.ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                    </cfloop>
                )
                </cfif>
            </cfif>
        </cfif>

        <!--- check group selectors --->
        <cfif IN_chemGroupId neq "All">
            <cfif IN_chemGroupId eq "99" AND IN_casList neq "">
                <cfif len(IN_casList)>                
                    <cfif ListLen(IN_casList) LTE 1000>
                        AND v.cas_number IN (<CFQUERYPARAM VALUE="#IN_casList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                    <cfelse>
                        <cfset arrayOfLists = GenFunc.splitListToSublists(IN_casList, 1000)>
                        <cfif ArrayLen(arrayOfLists) GTE 1>
                        AND (
                            <cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
                                <cfset thisSubList = arrayOfLists[i]>
                                <cfif i GT 1> OR </cfif>                            
                                v.cas_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                            </cfloop>
                        )
                        </cfif>
                    </cfif>
                </cfif>
            <cfelseif IN_chemGroupId eq "99" AND IN_dtsxIdList neq "">
                AND dtxsid IN (<CFQUERYPARAM VALUE="#IN_dtsxIdList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
            <cfelseif IN_chemGroupId eq "99">
                <!--- do nothing - this is handled with chemicals below --->
            <cfelse>
                AND cas_number IN (
                    SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
                )
            </cfif>
        </cfif>
        
        <cfif IN_specGroupId neq "All">
            <cfif IN_specGroupId eq "99" AND IN_ncbiList neq "">
                AND ncbi_taxid IN (<CFQUERYPARAM VALUE="#IN_ncbiList#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
            <cfelseif IN_specGroupId eq "99">
                <!--- do nothing - this is handled with species below --->
            <cfelse>
                AND v.species_list_id in (<CFQUERYPARAM VALUE="#IN_specGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
            </cfif>
        </cfif>

        <cfif IN_effGroupId neq "All" AND IN_effGroupId neq "99">
        <cfif ListLen(IN_effGroupId, ",") gt 1>
            AND (
                <cfloop from="1" to="#ListLen(IN_effGroupId)#" index="idx">
                    <cfif idx neq 1> OR </cfif>
                    (effect LIKE <CFQUERYPARAM VALUE="#ListGetAt(IN_effGroupId, idx)#%" CFSQLTYPE="CF_SQL_VARCHAR">)
                </cfloop>
            )
        <cfelse>
            AND effect LIKE <CFQUERYPARAM VALUE="#IN_effGroupId#%" CFSQLTYPE="CF_SQL_VARCHAR">
        </cfif>
        </cfif>

        <!--- check additional filters --->
        <cfif IN_chemListId neq "All">
            AND cas_number IN (
                SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
            )
        </cfif>

        <cfif IN_casId neq "All">
            AND v.cas_number IN (<CFQUERYPARAM VALUE="#IN_casId#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
        </cfif>
        
        <cfif IN_speciesListId neq "All">
            AND v.species_list_id in (<CFQUERYPARAM VALUE="#IN_speciesListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
        </cfif>		

        <cfif IN_class neq "All">
            AND v.class IN (<CFQUERYPARAM VALUE="#IN_class#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>		
        
        <cfif IN_taxOrder neq "All">
            AND v.tax_order IN (<CFQUERYPARAM VALUE="#IN_taxOrder#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>	

        <cfif IN_genus neq "All">
            AND v.genus IN (<CFQUERYPARAM VALUE="#IN_genus#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>
        
        <cfif IN_family neq "All">
            AND v.family IN (<CFQUERYPARAM VALUE="#IN_family#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>

        <cfif IN_speciesId neq "All">
            AND v.species_number IN (<CFQUERYPARAM VALUE="#IN_speciesId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
        </cfif>

        <cfif IN_special neq "All">
            <cfset loop = 0>
            AND (
            <cfloop index="thisSpecInt" list="#IN_special#" delimiters=",">
                <cfif loop gt 0> OR </cfif>
                (#thisSpecInt# = 'Y')
                <cfset loop = loop + 1>
            </cfloop>
            )
        </cfif>
        
        <cfif IN_effectId neq "All">
            AND v.effect IN (<CFQUERYPARAM VALUE="#IN_effectId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>
        
        <cfif IN_measurementId neq "All">
            AND v.measurement IN (<CFQUERYPARAM VALUE="#IN_measurementId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>
                
        <!--- custom effects / measurement groups --->
        <cfif concatCustEffMeasList neq "All">
            AND CONCAT(v.effect, v.measurement) IN (<CFQUERYPARAM VALUE="#concatCustEffMeasList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>
        
        <cfif IN_endpointId neq "All">
            AND v.endpoint IN (<CFQUERYPARAM VALUE="#IN_endpointId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>

        <!--- DURATION LOGIC HERE (v.) --->
        <cfinclude template="../../../pages/explore/duration_logic_sql.cfm">

        <cfif IN_habitat neq "All">
            AND v.habitat IN (<CFQUERYPARAM VALUE="#IN_habitat#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>
        
            AND v.publication_year between <CFQUERYPARAM VALUE="#IN_pubYearMin#" CFSQLTYPE="CF_SQL_VARCHAR"> AND <CFQUERYPARAM VALUE="#IN_pubYearMax#" CFSQLTYPE="CF_SQL_VARCHAR">
        
            <!--- special interest groups are no longer determined by species group, so include this to make sure not to return any of these items matching species_list_id between 13-15 --->
            AND (v.species_list_id IS NULL OR v.species_list_id NOT IN (13,14,15))            
                    
                )
                GROUP BY v.ecoref_number, v.citation, v.test_id, v.result_id, v.cas_number, v.epa_chem_substance_name, v.common_name, v.effect_desc, v.measurement_desc
                    , v.endpoint, v.dtxsid
                    , CAST(REGEXP_REPLACE(v.obs_duration_std, '[^0-9.]', '') as FLOAT)
                    , CAST(REGEXP_REPLACE(v.obs_duration_min_std, '[^0-9.]', '') as FLOAT)
                    , CAST(REGEXP_REPLACE(v.obs_duration_max_std, '[^0-9.]', '') as FLOAT)
                    , du.description, v.obs_duration_unit_std, v.conc1_type_desc
                    , v.conc1_mean_std_num, v.conc1_min_std_num, v.conc1_max_std_num, v.conc_units_std
                    , v.conc1_mean_auth_num, v.conc1_min_auth_num, v.conc1_max_auth_num, v.conc_units_auth
                    , v.conc1_mean_op, v.conc1_min_op, v.conc1_max_op, v.obs_duration_std_op, v.obs_duration_min_std_op, v.obs_duration_max_std_op
            ) iq
        ) oq
        INNER JOIN REFERENCES r ON r.reference_number = oq.ecoref_number

    </cfquery>
    
<!--- <cflog text ="#PubsRecordsExportVars.sql#"> --->
<!--- <cflog text ="#ArrayToList(PubsRecordsExportVars.sqlparameters)#"> --->
    
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>

<!--- ADD BACK IN AT LATER DATE			
    <cfset SQLErrorOccurred = 1>
--->

    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>

    <cfif thisInternalOnly eq 1>
        <cfinclude template="outputError.cfm">
    <cfelse>
        <cfinclude template="emailError.cfm">
    </cfif>

    <cfif errorDetail eq "[Macromedia][Oracle JDBC Driver]Execution timeout expired.">
        <cfinclude template="timeout_error.cfm">
    <cfelse>
        <cfinclude template="db_error.cfm">
    </cfif>
                    
</cfcatch>
</cftry>
</cflock>
