
<!--- Build 2 dimensional array to hold available AQUIRE output field SQL column names and display values
	based on criteria specified in advanced query forms.
	  - Column Order determined by order below.

	  aquireOutputFields[x][y]:
	  	- x dimension represents Out put field selections.
		- [x][1] - represents form field name
		- [x][2] - represents display name (column header)
		- [x][3] - represents SQL column names
		- [x][4] - represents SQL table alias
		- [x][5] - represents Full name for display fields JSON lookup
--->
<cfset aquireOutputFields = arrayNew(2)>

<!--- <cfoutput>
#form.fieldnames#
</cfoutput> --->


<cfset ofIndex = 1>
    
<cfif isdefined("form.cbLocation_number") and form.cbLocation_number is not "" and form.cbLocation_number is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbLocation_number>
	<cfset aquireOutputFields[#ofIndex#][2] = "Test##">
	<cfset aquireOutputFields[#ofIndex#][3] = "TEST_NUMBER">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Test Number">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbResult_number") and form.cbResult_number is not "" and form.cbResult_number is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbResult_number>
	<cfset aquireOutputFields[#ofIndex#][2] = "Result##">
	<cfset aquireOutputFields[#ofIndex#][3] = "RESULT_NUMBER">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Results Record Number">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbCAS_Number_Name") and form.cbCAS_Number_Name is not "" and form.cbCAS_Number_Name is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbCAS_Number_Name>
	<cfset aquireOutputFields[#ofIndex#][2] = "CAS Num|Chem. Name">
	<cfset aquireOutputFields[#ofIndex#][3] = "TEST_CAS,CHEM_PRIMARY_NAME">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "CAS Number | Chemical Name">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbCAS_Number_Name") and form.cbCAS_Number_Name is not "" and form.cbCAS_Number_Name is not 0>
<cfelse>
	<cfif isdefined("form.cbCAS_number") and form.cbCAS_number is not "" and form.cbCAS_number is not 0>
		<cfset aquireOutputFields[#ofIndex#][1] = form.cbCAS_number>
		<cfset aquireOutputFields[#ofIndex#][2] = "CAS Num">
		<cfset aquireOutputFields[#ofIndex#][3] = "TEST_CAS">
		<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
		<cfset aquireOutputFields[#ofIndex#][5] = "CAS Number">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>

<cfif isdefined("form.cbCAS_Number_Name") and form.cbCAS_Number_Name is not "" and form.cbCAS_Number_Name is not 0>
<cfelse>
	<cfif isdefined("form.cbChemical_name") and form.cbChemical_name is not "" and form.cbChemical_name is not 0>
		<cfset aquireOutputFields[#ofIndex#][1] = form.cbChemical_name>
		<cfset aquireOutputFields[#ofIndex#][2] = "Chem. Name">
		<cfset aquireOutputFields[#ofIndex#][3] = "CHEM_PRIMARY_NAME">
		<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
		<cfset aquireOutputFields[#ofIndex#][5] = "Chemical Name">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>

<cfif isdefined("form.cbChemical_grade") and form.cbChemical_grade is not "" and form.cbChemical_grade is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbChemical_grade>
	<cfset aquireOutputFields[#ofIndex#][2] = "Chem. Grade">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "TEST_GRADE">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "TEST_GRADE_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Chemical Grade">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbMethod") and form.cbMethod is not "" and form.cbMethod is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbMethod>
	<cfset aquireOutputFields[#ofIndex#][2] = "Chem. Anal.">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "TEST_METHOD">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "TEST_METHOD_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Chemical Analysis">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbTest_method") and form.cbTest_method is not "" and form.cbTest_method is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbTest_method>
	<cfset aquireOutputFields[#ofIndex#][2] = "Test Method">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "TEST_METHOD_NEW">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "TEST_METHOD_NEW_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Chemical Analysis (Method)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbChemical_purity") and form.cbChemical_purity is not "" and form.cbChemical_purity is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbChemical_purity>
	<cfset aquireOutputFields[#ofIndex#][2] = "Chem. Pur.">
	<cfset aquireOutputFields[#ofIndex#][3] = "TEST_PURITY,TEST_PURITY_MEAN_OP,TEST_PURITY_MEAN,TEST_PURITY_MIN_OP,TEST_PURITY_MIN,TEST_PURITY_MAX_OP,TEST_PURITY_MAX">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Chemical Purity">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbSpecies_latin_common_name") and form.cbSpecies_latin_common_name is not "" and form.cbSpecies_latin_common_name is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbSpecies_latin_common_name>
	<cfset aquireOutputFields[#ofIndex#][2] = "Spec. Sci. Name|Spec. Common Name">
	<cfset aquireOutputFields[#ofIndex#][3] = "LATIN_NAME,COMMON_NAME">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Species Scientific Name | Species Common Name">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbSpecies_latin_name") and form.cbSpecies_latin_name is not "" and form.cbSpecies_latin_name is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbSpecies_latin_name>
	<cfset aquireOutputFields[#ofIndex#][2] = "Spec. Sci. Name">
	<cfset aquireOutputFields[#ofIndex#][3] = "LATIN_NAME">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Species Scientific Name">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbSpecies_common_name") and form.cbSpecies_common_name is not "" and form.cbSpecies_common_name is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbSpecies_common_name>
	<cfset aquireOutputFields[#ofIndex#][2] = "Spec. Common Name">
	<cfset aquireOutputFields[#ofIndex#][3] = "COMMON_NAME">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Species Common Name">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbSpecies_tax_info") and form.cbSpecies_tax_info is not "" and form.cbSpecies_tax_info is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbSpecies_tax_info>
	<cfset aquireOutputFields[#ofIndex#][2] = "Spec. Taxon. Info.">
	<cfset aquireOutputFields[#ofIndex#][3] = "KINGDOM,PHYLUM_DIVISION,SUBPHYLUM_DIV,SUPERCLASS,CLASS,TAX_ORDER,FAMILY,GENUS,SPECIES,VARIETY">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Species Taxonomic Information">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbSpecies_group") and form.cbSpecies_group is not "" and form.cbSpecies_group is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbSpecies_group>
	<cfset aquireOutputFields[#ofIndex#][2] = "Spec. Group">
	<cfset aquireOutputFields[#ofIndex#][3] = "SPECIES_LIST_DESC">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Species Group">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbOrganism_lifestage") and form.cbOrganism_lifestage is not "" and form.cbOrganism_lifestage is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbOrganism_lifestage>
	<cfset aquireOutputFields[#ofIndex#][2] = "Org. Lifestg.">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "LIFESTAGE">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "LIFESTAGE_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Organism Lifestage">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbOrganism_age") and form.cbOrganism_age is not "" and form.cbOrganism_age is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbOrganism_age>
	<cfset aquireOutputFields[#ofIndex#][2] = "Org. Age">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "AGE,ORGANISM_AGE_MEAN_OP,ORGANISM_AGE_MEAN,ORGANISM_AGE_MIN_OP,ORGANISM_AGE_MIN,ORGANISM_AGE_MAX_OP,ORGANISM_AGE_MAX,AGE_UNIT">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "AGE_DESC,ORGANISM_AGE_MEAN_OP,ORGANISM_AGE_MEAN,ORGANISM_AGE_MIN_OP,ORGANISM_AGE_MIN,ORGANISM_AGE_MAX_OP,ORGANISM_AGE_MAX,AGE_UNIT_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Organism Age">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbOrganism_length") and form.cbOrganism_length is not "" and form.cbOrganism_length is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbOrganism_length>
	<cfset aquireOutputFields[#ofIndex#][2] = "Org. Init. Length">
	<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "ORGANISM_LENGTH,ORGANISM_LENGTH_MEAN_OP,ORGANISM_LENGTH_MEAN,ORGANISM_LENGTH_MIN_OP,ORGANISM_LENGTH_MIN,ORGANISM_LENGTH_MAX_OP,ORGANISM_LENGTH_MAX,ORGANISM_LENGTH_UNIT,ORGANISM_LENGTH_TYPE">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "ORGANISM_LENGTH_DESC,ORGANISM_LENGTH_MEAN_OP,ORGANISM_LENGTH_MEAN,ORGANISM_LENGTH_MIN_OP,ORGANISM_LENGTH_MIN,ORGANISM_LENGTH_MAX_OP,ORGANISM_LENGTH_MAX,ORGANISM_LENGTH_UNIT_DESC,ORGANISM_LENGTH_TYPE_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Organism Initial Length">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbOrganism_init_wt") and form.cbOrganism_init_wt is not "" and form.cbOrganism_init_wt is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbOrganism_init_wt>
	<cfset aquireOutputFields[#ofIndex#][2] = "Organism Initial Weight">
	<cfset aquireOutputFields[#ofIndex#][3] = "ORGANISM_INIT_WT,ORGANISM_INIT_WT_MEAN_OP,ORGANISM_INIT_WT_MEAN,ORGANISM_INIT_WT_MIN_OP,ORGANISM_INIT_WT_MIN,ORGANISM_INIT_WT_MAX_OP,ORGANISM_INIT_WT_MAX,ORGANISM_INIT_WT_UNIT">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Organism Initial Weight">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbOrganism_strain") and form.cbOrganism_strain is not "" and form.cbOrganism_strain is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbOrganism_strain>
	<cfset aquireOutputFields[#ofIndex#][2] = "Org. Strain">
	<cfset aquireOutputFields[#ofIndex#][3] = "ORGANISM_STRAIN">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Organism Strain">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbNumber_replicates") and form.cbNumber_replicates is not "" and form.cbNumber_replicates is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbNumber_replicates>
	<cfset aquireOutputFields[#ofIndex#][2] = "Num. Replicates">
	<cfset aquireOutputFields[#ofIndex#][3] = "NUMBER_REPLICATES">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Number of Replicates">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbOrganism_source") and form.cbOrganism_source is not "" and form.cbOrganism_source is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbOrganism_source>
	<cfset aquireOutputFields[#ofIndex#][2] = "Organism Source">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "ORGANISM_SOURCE">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "ORGANISM_SOURCE_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Organism Source">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbGender") and form.cbGender is not "" and form.cbGender is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbGender>
	<cfset aquireOutputFields[#ofIndex#][2] = "Gender">
	<cfset aquireOutputFields[#ofIndex#][3] = "GENDER">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Gender">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbOrganism_comment") and form.cbOrganism_comment is not "" and form.cbOrganism_comment is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbOrganism_comment>
	<cfset aquireOutputFields[#ofIndex#][2] = "Org. Comment">
	<cfset aquireOutputFields[#ofIndex#][3] = "ORGANISM_CHAR">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Organism Comment">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbExposure_type") and form.cbExposure_type is not "" and form.cbExposure_type is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbExposure_type>
	<cfset aquireOutputFields[#ofIndex#][2] = "Exposure Type">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "EXPOSURE_TYPE">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "EXPOSURE_TYPE_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Exposure Type">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbExposure_type_analysis") and form.cbExposure_type_analysis is not "" and form.cbExposure_type_analysis is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbExposure_type_analysis>
	<cfset aquireOutputFields[#ofIndex#][2] = "Exp. Type|Chem. Anal.">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "EXPOSURE_TYPE,TEST_METHOD">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "EXPOSURE_TYPE_DESC,TEST_METHOD_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Exposure Type | Chemical Analysis">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbMediatype_Loc") and form.cbMediatype_Loc is not "" and form.cbMediatype_Loc is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbMediatype_Loc>
	<cfset aquireOutputFields[#ofIndex#][2] = "Media Type|Loc">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "WATER_TYPE,TEST_LOCATION">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "WATER_TYPE_DESC,TEST_LOCATION_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Media Type | Test Location">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbMediatype_Loc") and form.cbMediatype_Loc is not "" and form.cbMediatype_Loc is not 0>
	<!--- do not display standalone media(water) type field if stacked combo field is selected --->
<cfelse>
	<cfif isdefined("form.cbMediaType") and form.cbMediaType is not "" and form.cbMediaType is not 0>
		<cfset aquireOutputFields[#ofIndex#][1] = form.cbMediaType>
		<cfset aquireOutputFields[#ofIndex#][2] = "Media Type">
		<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
			<cfset aquireOutputFields[#ofIndex#][3] = "WATER_TYPE">
		<cfelse>
			<cfset aquireOutputFields[#ofIndex#][3] = "WATER_TYPE_DESC">
		</cfif>
		<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
		<cfset aquireOutputFields[#ofIndex#][5] = "Media Type">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>

<cfif isdefined("form.cbMediatype_Loc") and form.cbMediatype_Loc is not "" and form.cbMediatype_Loc is not 0>
	<!--- do not display standalone test loc field if stacked combo field is selected --->
<cfelse>
	<cfif isdefined("form.cbLocation_test") and form.cbLocation_test is not "" and form.cbLocation_test is not 0>
		<cfset aquireOutputFields[#ofIndex#][1] = FORM.cbLocation_test>
		<cfset aquireOutputFields[#ofIndex#][2] = "Test Location">
		<cfif isdefined("form.cbIncludeCodeDesc") and FORM.cbIncludeCodeDesc IS NOT "" AND FORM.cbIncludeCodeDesc IS NOT 0>
			<cfset aquireOutputFields[#ofIndex#][3] = "TEST_LOCATION">
		<cfelse>
			<cfset aquireOutputFields[#ofIndex#][3] = "TEST_LOCATION_DESC">
		</cfif>
		<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
		<cfset aquireOutputFields[#ofIndex#][5] = "Test Location">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>

<cfif isdefined("form.cbNumDoses") and form.cbNumDoses is not "" and form.cbNumDoses is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbNumDoses>
	<cfset aquireOutputFields[#ofIndex#][2] = "Number of Doses">
	<cfset aquireOutputFields[#ofIndex#][3] = "DOSE_NUMBER">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Number of Doses">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbConcentration_author") and form.cbConcentration_author is not "" and form.cbConcentration_author is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbConcentration_author>
	<cfset aquireOutputFields[#ofIndex#][2] = "Conc. Type: Conc. (Author)">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "CONC1_TYPE,CONC1_MEAN_OP,CONC1_MEAN,CONC1_MIN_OP,CONC1_MIN,CONC1_MAX_OP,CONC1_MAX,CONC1_UNIT,CONC2_TYPE,CONC2_MEAN_OP,CONC2_MEAN,CONC2_MIN_OP,CONC2_MIN,CONC2_MAX_OP,CONC2_MAX,CONC2_UNIT,CONC3_TYPE,CONC3_MEAN_OP,CONC3_MEAN,CONC3_MIN_OP,CONC3_MIN,CONC3_MAX_OP,CONC3_MAX,CONC3_UNIT">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "CONC1_TYPE_DESC,CONC1_MEAN_OP,CONC1_MEAN,CONC1_MIN_OP,CONC1_MIN,CONC1_MAX_OP,CONC1_MAX,CONC1_UNIT,CONC2_TYPE_DESC,CONC2_MEAN_OP,CONC2_MEAN,CONC2_MIN_OP,CONC2_MIN,CONC2_MAX_OP,CONC2_MAX,CONC2_UNIT,CONC3_TYPE_DESC,CONC3_MEAN_OP,CONC3_MEAN,CONC3_MIN_OP,CONC3_MIN,CONC3_MAX_OP,CONC3_MAX,CONC3_UNIT">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Concentration/Dose (Author)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbConcentration_standard") and form.cbConcentration_standard is not "" and form.cbConcentration_standard is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbConcentration_standard>
	<cfset aquireOutputFields[#ofIndex#][2] = "Conc. Type: Conc. (Std)">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "CONC1_TYPE_STD,CONC1_MEAN_STD_OP,CONC1_MEAN_STD,CONC1_MIN_STD_OP,CONC1_MIN_STD,CONC1_MAX_STD_OP,CONC1_MAX_STD,CONC1_UNITS_STD,CONC2_TYPE_STD,CONC2_MEAN_STD_OP,CONC2_MEAN_STD,CONC2_MIN_STD_OP,CONC2_MIN_STD,CONC2_MAX_STD_OP,CONC2_MAX_STD,CONC2_UNITS_STD,CONC3_TYPE_STD,CONC3_MEAN_STD_OP,CONC3_MEAN_STD,CONC3_MIN_STD_OP,CONC3_MIN_STD,CONC3_MAX_STD_OP,CONC3_MAX_STD,CONC3_UNITS_STD">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "CONC1_TYPE_STD_DESC,CONC1_MEAN_STD_OP,CONC1_MEAN_STD,CONC1_MIN_STD_OP,CONC1_MIN_STD,CONC1_MAX_STD_OP,CONC1_MAX_STD,CONC1_UNITS_STD,CONC2_TYPE_STD_DESC,CONC2_MEAN_STD_OP,CONC2_MEAN_STD,CONC2_MIN_STD_OP,CONC2_MIN_STD,CONC2_MAX_STD_OP,CONC2_MAX_STD,CONC2_UNITS_STD,CONC3_TYPE_STD_DESC,CONC3_MEAN_STD_OP,CONC3_MEAN_STD,CONC3_MIN_STD_OP,CONC3_MIN_STD,CONC3_MAX_STD_OP,CONC3_MAX_STD,CONC3_UNITS_STD">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Concentration/Dose (Standard)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbEffect_Measurement") and form.cbEffect_Measurement is not "" and form.cbEffect_Measurement is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbEffect_Measurement>
	<cfset aquireOutputFields[#ofIndex#][2] = "Effect|Effect Meas.">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "EFFECT,MEASUREMENT">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "EFFECT_DESC,MEASUREMENT_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Effect | Effect Measurement">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbEffect") and form.cbEffect is not "" and form.cbEffect is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbEffect>
	<cfset aquireOutputFields[#ofIndex#][2] = "Effect">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "EFFECT">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "EFFECT_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Effect">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbEffectMeas") and form.cbEffectMeas is not "" and form.cbEffectMeas is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbEffectMeas>
	<cfset aquireOutputFields[#ofIndex#][2] = "Effect Meas.">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "MEASUREMENT">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "MEASUREMENT_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Effect Measurement">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbEffect_endpoint_remark") and form.cbEffect_endpoint_remark is not "" and form.cbEffect_endpoint_remark is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbEffect_endpoint_remark>
	<cfset aquireOutputFields[#ofIndex#][2] = "EE Comment">
	<cfset aquireOutputFields[#ofIndex#][3] = "EECOMMENT">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "EE_Comment">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbEndpoint_BCF") and form.cbEndpoint_BCF is not "" and form.cbEndpoint_BCF is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbEndpoint_BCF>
	<cfset aquireOutputFields[#ofIndex#][2] = "Endpoint|BCF">
	<cfset aquireOutputFields[#ofIndex#][3] = "ENDPOINT,BCF1_MEAN_OP,BCF1_MEAN,BCF1_MIN_OP,BCF1_MIN,BCF1_MAX_OP,BCF1_MAX,BCF1_UNIT,BCF2_MEAN_OP,BCF2_MEAN,BCF2_MIN_OP,BCF2_MIN,BCF2_MAX_OP,BCF2_MAX,BCF2_UNIT,BCF3_MEAN_OP,BCF3_MEAN,BCF3_MIN_OP,BCF3_MIN,BCF3_MAX_OP,BCF3_MAX,BCF3_UNIT">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Endpoint | Bioconcentration">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbEndpoint") and form.cbEndpoint is not "" and form.cbEndpoint is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbEndpoint>
	<cfset aquireOutputFields[#ofIndex#][2] = "Endpoint">
	<cfset aquireOutputFields[#ofIndex#][3] = "ENDPOINT">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Endpoint">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbResponse_Site") and form.cbResponse_Site is not "" and form.cbResponse_Site is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbResponse_Site>
	<cfset aquireOutputFields[#ofIndex#][2] = "Resp. Site">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "TISSUE">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "TISSUE_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Response Site">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbEffect_percent") and form.cbEffect_percent is not "" and form.cbEffect_percent is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbEffect_percent>
	<cfset aquireOutputFields[#ofIndex#][2] = "Eff %">
	<cfset aquireOutputFields[#ofIndex#][3] = "EFFECT_PCT,EFFECT_PCT_MEAN_OP,EFFECT_PERCENT_MEAN,EFFECT_PCT_MIN_OP,EFFECT_PERCENT_MIN,EFFECT_PCT_MAX_OP,EFFECT_PERCENT_MAX">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Effect Percent">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbIon") and form.cbIon is not "" and form.cbIon is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbIon>
	<cfset aquireOutputFields[#ofIndex#][2] = "Ion">
	<cfset aquireOutputFields[#ofIndex#][3] = "ION1,ION2,ION3">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Ionic Fraction">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbSignificance_level_significant") and form.cbSignificance_level_significant is not "" and form.cbSignificance_level_significant is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbSignificance_level_significant>
	<cfset aquireOutputFields[#ofIndex#][2] = "Stat. Signif.|Sig. Level">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "SIGNIFICANT,STATISTICAL_SIG,SIGNIFICANCE_LEVEL_MEAN_OP,SIGNIFICANCE_LEVEL_MEAN,SIGNIFICANCE_LEVEL_MIN_OP,SIGNIFICANCE_LEVEL_MIN,SIGNIFICANCE_LEVEL_MAX_OP,SIGNIFICANCE_LEVEL_MAX">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "SIGNIFICANT_DESC,STATISTICAL_SIG,SIGNIFICANCE_LEVEL_MEAN_OP,SIGNIFICANCE_LEVEL_MEAN,SIGNIFICANCE_LEVEL_MIN_OP,SIGNIFICANCE_LEVEL_MIN,SIGNIFICANCE_LEVEL_MAX_OP,SIGNIFICANCE_LEVEL_MAX">
	</cfif>
		<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Statistical Significance | Significance Level">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbSignificance_level_significant") and form.cbSignificance_level_significant is not "" and form.cbSignificance_level_significant is not 0>
<cfelse>
	<cfif isdefined("form.cbStatistical_sig") and form.cbStatistical_sig is not "" and form.cbStatistical_sig is not 0>
		<cfset aquireOutputFields[#ofIndex#][1] = form.cbStatistical_sig>
		<cfset aquireOutputFields[#ofIndex#][2] = "Stat. Signif.">
		<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
			<cfset aquireOutputFields[#ofIndex#][3] = "SIGNIFICANT">
		<cfelse>
			<cfset aquireOutputFields[#ofIndex#][3] = "SIGNIFICANT_DESC">
		</cfif>
		<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
		<cfset aquireOutputFields[#ofIndex#][5] = "Statistical Significance">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>

<cfif isdefined("form.cbSignificance_level_significant") and form.cbSignificance_level_significant is not "" and form.cbSignificance_level_significant is not 0>
<cfelse>
	<cfif isdefined("form.cbSignificance_Level") and form.cbSignificance_Level is not "" and form.cbSignificance_Level is not 0>
		<cfset aquireOutputFields[#ofIndex#][1] = form.cbSignificance_Level>
		<cfset aquireOutputFields[#ofIndex#][2] = "Sig. Level">
		<cfset aquireOutputFields[#ofIndex#][3] = "STATISTICAL_SIG,SIGNIFICANCE_LEVEL_MEAN_OP,SIGNIFICANCE_LEVEL_MEAN,SIGNIFICANCE_LEVEL_MIN_OP,SIGNIFICANCE_LEVEL_MIN,SIGNIFICANCE_LEVEL_MAX_OP,SIGNIFICANCE_LEVEL_MAX">
		<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ">
		<cfset aquireOutputFields[#ofIndex#][5] = "Significance Level">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>

<cfif isdefined("form.cbEndpoint_Assignment") and form.cbEndpoint_Assignment is not "" and form.cbEndpoint_Assignment is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbEndpoint_Assignment>
	<cfset aquireOutputFields[#ofIndex#][2] = "Endpoint Assign.">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "ENDPOINT_ASSIGNED">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "ENDPOINT_ASSIGNED_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Endpoint Assignment">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbResponse_Site_Dur") and form.cbResponse_Site_Dur is not "" and form.cbResponse_Site_Dur is not 0>
	<!--- do not include duration field if response site/duration combo field is already there as it wouuld be redundant --->
<cfelse>
	<cfif isdefined("form.cbObserved_duration_std") and form.cbObserved_duration_std is not "" and form.cbObserved_duration_std is not 0>
		<cfset aquireOutputFields[#ofIndex#][1] = form.cbObserved_duration_std>
		<cfset aquireOutputFields[#ofIndex#][2] = "Obs. Dur. (Days)">
		<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
			<cfset aquireOutputFields[#ofIndex#][3] = "TEST_DURATION_STD_CONCAT,TEST_DURATION_STD_OP,TEST_DURATION_STD,MIN_DURATION_STD_OP,MIN_DURATION_STD,MAX_DURATION_STD_OP,MAX_DURATION_STD,DURATION_UNITS_STD">
		<cfelse>
			<cfset aquireOutputFields[#ofIndex#][3] = "TEST_DURATION_STD_CONCAT_LONG,TEST_DURATION_STD_OP,TEST_DURATION_STD,MIN_DURATION_STD_OP,MIN_DURATION_STD,MAX_DURATION_STD_OP,MAX_DURATION_STD,DURATION_UNITS_STD_LONG">
		</cfif>
		<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
		<cfset aquireOutputFields[#ofIndex#][5] = "Observed Duration (Days)">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>

<cfif isdefined("form.cbResponse_Site_Dur") and form.cbResponse_Site_Dur is not "" and form.cbResponse_Site_Dur is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbResponse_Site_Dur>
	<cfset aquireOutputFields[#ofIndex#][2] = "Resp. Site|Obs. Dur. (Days)">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "TISSUE,TEST_DURATION_STD_CONCAT,TEST_DURATION_STD_OP,TEST_DURATION_STD,MIN_DURATION_STD_OP,MIN_DURATION_STD,MAX_DURATION_STD_OP,MAX_DURATION_STD,DURATION_UNITS_STD">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "TISSUE_DESC,TEST_DURATION_STD_CONCAT_LONG,TEST_DURATION_STD_OP,TEST_DURATION_STD,MIN_DURATION_STD_OP,MIN_DURATION_STD,MAX_DURATION_STD_OP,MAX_DURATION_STD,DURATION_UNITS_STD_LONG">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Response Site | Observed Duration (Days)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbObserved_duration") and form.cbObserved_duration is not "" and form.cbObserved_duration is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbObserved_duration>
	<cfset aquireOutputFields[#ofIndex#][2] = "Obs. Dur. (Author)">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "TEST_DURATION_CONCAT,TEST_DURATION_OP,TEST_DURATION,MIN_DURATION_OP,MIN_DURATION,MAX_DURATION_OP,MAX_DURATION,DURATION_UNITS">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "TEST_DURATION_CONCAT_LONG,TEST_DURATION_OP,TEST_DURATION,MIN_DURATION_OP,MIN_DURATION,MAX_DURATION_OP,MAX_DURATION,DURATION_UNITS_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Observed Duration (Author)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbChemical_formulation") and form.cbChemical_formulation is not "" and form.cbChemical_formulation is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbChemical_formulation>
	<cfset aquireOutputFields[#ofIndex#][2] = "Chem. form.">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "TEST_FORMULATION">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "TEST_FORMULATION_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Chemical Formulation">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbChemical_radiolabel") and form.cbChemical_radiolabel is not "" and form.cbChemical_radiolabel is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbChemical_radiolabel>
	<cfset aquireOutputFields[#ofIndex#][2] = "Chem. Radiolabel">
	<cfset aquireOutputFields[#ofIndex#][3] = "TEST_RADIOLABEL">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Chemical Radiolabel">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbChemical_characteristics") and form.cbChemical_characteristics is not "" and form.cbChemical_characteristics is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbChemical_characteristics>
	<cfset aquireOutputFields[#ofIndex#][2] = "Chem. Comment">
	<cfset aquireOutputFields[#ofIndex#][3] = "TEST_CHAR">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Chemical Comment">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbChemical_carrier") and form.cbChemical_carrier is not "" and form.cbChemical_carrier is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbChemical_carrier>
	<cfset aquireOutputFields[#ofIndex#][2] = "Chem. Carrier">
	<cfset aquireOutputFields[#ofIndex#][3] = "CHEMICAL_CARRIER_CONCAT">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Chemical Carrier">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbNcbiTaxId") and form.cbNcbiTaxId is not "" and form.cbNcbiTaxId is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbNcbiTaxId>
	<cfset aquireOutputFields[#ofIndex#][2] = "Spec. NCBI ID">
	<cfset aquireOutputFields[#ofIndex#][3] = "NCBI_TAXID">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Species NCBI TaxID">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbDTXSID") and form.cbDTXSID is not "" and form.cbDTXSID is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbDTXSID>
	<cfset aquireOutputFields[#ofIndex#][2] = "Chem. DTXSID">
	<cfset aquireOutputFields[#ofIndex#][3] = "DTXSID">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Chemical DTXSID">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbSpecies_number") and form.cbSpecies_number is not "" and form.cbSpecies_number is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbSpecies_number>
	<cfset aquireOutputFields[#ofIndex#][2] = "Spec. ECO ##">
	<cfset aquireOutputFields[#ofIndex#][3] = "SPECIES_NUMBER">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Species ECOTOX Number">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbHabitat") and form.cbHabitat is not "" and form.cbHabitat is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbHabitat>
	<cfset aquireOutputFields[#ofIndex#][2] = "Habitat">
	<cfset aquireOutputFields[#ofIndex#][3] = "ORGANISM_HABITAT">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Habitat">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbDOI") and form.cbDOI is not "" and form.cbDOI is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbDOI>
	<cfset aquireOutputFields[#ofIndex#][2] = "DOI">
	<cfset aquireOutputFields[#ofIndex#][3] = "DOI">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "DOI">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbStudy_dur") and form.cbStudy_dur is not "" and form.cbStudy_dur is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbStudy_dur>
	<cfset aquireOutputFields[#ofIndex#][2] = "Study Duration (Author)">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "STUDY_DURATION_CONCAT,STUDY_DURATION_MEAN_OP,STUDY_DURATION_MEAN,STUDY_DURATION_MIN_OP,STUDY_DURATION_MIN,STUDY_DURATION_MAX_OP,STUDY_DURATION_MAX,STUDY_DURATION_UNITS">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "STUDY_DURATION_CONCAT_LONG,STUDY_DURATION_MEAN_OP,STUDY_DURATION_MEAN,STUDY_DURATION_MIN_OP,STUDY_DURATION_MIN,STUDY_DURATION_MAX_OP,STUDY_DURATION_MAX,STUDY_DURATION_UNITS_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Study Duration (Author)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbStudy_dur_std") and form.cbStudy_dur_std is not "" and form.cbStudy_dur_std is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbStudy_dur_std>
	<cfset aquireOutputFields[#ofIndex#][2] = "Study Duration (Standard)">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "STUDY_DURATION_STD_CONCAT,STUDY_DURATION_MEAN_STD_OP,STUDY_DURATION_MEAN_STD,STUDY_DURATION_MIN_STD_OP,STUDY_DURATION_MIN_STD,STUDY_DURATION_MAX_STD_OP,STUDY_DURATION_MAX_STD,STUDY_DURATION_UNITS_STD">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "STUDY_DURATION_STD_CONCAT_LONG,STUDY_DURATION_MEAN_STD_OP,STUDY_DURATION_MEAN_STD,STUDY_DURATION_MIN_STD_OP,STUDY_DURATION_MIN_STD,STUDY_DURATION_MAX_STD_OP,STUDY_DURATION_MAX_STD,STUDY_DURATION_UNITS_STD_LONG">
	</cfif>
		<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Study Duration (Standard)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbApplication_frequency") and form.cbApplication_frequency is not "" and form.cbApplication_frequency is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbApplication_frequency>
	<cfset aquireOutputFields[#ofIndex#][2] = "Appl. Freq.|Unit">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "APPLICATION_FREQ_SORT,APPLICATION_FREQ_MEAN_OP,APPLICATION_FREQ_MEAN,APPLICATION_FREQ_MIN_OP,APPLICATION_FREQ_MIN,APPLICATION_FREQ_MAX_OP,APPLICATION_FREQ_MAX,APP_FREQUENCY_UNIT">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "APPLICATION_FREQ_SORT,APPLICATION_FREQ_MEAN_OP,APPLICATION_FREQ_MEAN,APPLICATION_FREQ_MIN_OP,APPLICATION_FREQ_MIN,APPLICATION_FREQ_MAX_OP,APPLICATION_FREQ_MAX,APP_FREQUENCY_UNIT_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Application Frequency | Unit">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbExposure_duration_author") and form.cbExposure_duration_author is not "" and form.cbExposure_duration_author is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbExposure_duration_author>
	<cfset aquireOutputFields[#ofIndex#][2] = "Exp. Dur. (Author)">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "EXPOSURE_DURATION_CONCAT,EXPOSURE_DURATION_MEAN_OP,EXPOSURE_DURATION_MEAN,EXPOSURE_DURATION_MIN_OP,EXPOSURE_DURATION_MIN,EXPOSURE_DURATION_MAX_OP,EXPOSURE_DURATION_MAX,EXPOSURE_DURATION_UNITS">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "EXPOSURE_DURATION_CONCAT_LONG,EXPOSURE_DURATION_MEAN_OP,EXPOSURE_DURATION_MEAN,EXPOSURE_DURATION_MIN_OP,EXPOSURE_DURATION_MIN,EXPOSURE_DURATION_MAX_OP,EXPOSURE_DURATION_MAX,EXPOSURE_DURATION_UNITS_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Exposure Duration (Author)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbExposure_duration_stand") and form.cbExposure_duration_stand is not "" and form.cbExposure_duration_stand is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbExposure_duration_stand>
	<cfset aquireOutputFields[#ofIndex#][2] = "Exp. Dur. (Days)">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "EXPOSURE_DUR_STD_CONCAT,EXPOSURE_DURATION_MEAN_STD_OP,EXPOSURE_DUR_MEAN_STD,EXPOSURE_DURATION_MIN_STD_OP,EXPOSURE_DUR_MIN_STD,EXPOSURE_DURATION_MAX_STD_OP,EXPOSURE_DUR_MAX_STD,EXPOSURE_DUR_UNITS_STD">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "EXPOSURE_DUR_STD_CONCAT_LONG,EXPOSURE_DURATION_MEAN_STD_OP,EXPOSURE_DUR_MEAN_STD,EXPOSURE_DURATION_MIN_STD_OP,EXPOSURE_DUR_MIN_STD,EXPOSURE_DURATION_MAX_STD_OP,EXPOSURE_DUR_MAX_STD,EXPOSURE_DUR_UNITS_STD_LONG">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Exposure Duration (Days)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbStudy_control") and form.cbStudy_control is not "" and form.cbStudy_control is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbStudy_control>
	<cfset aquireOutputFields[#ofIndex#][2] = "Control">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "STUDY_CONTROL">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "STUDY_CONTROL_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Control">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbStudy_type") and form.cbStudy_type is not "" and form.cbStudy_type is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbStudy_type>
	<cfset aquireOutputFields[#ofIndex#][2] = "Study Type">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "STUDY_TYPE">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "STUDY_TYPE_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Study Type">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbTest_type") and form.cbTest_type is not "" and form.cbTest_type is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbTest_type>
	<cfset aquireOutputFields[#ofIndex#][2] = "Test Type">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "TEST_TYPE">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "TEST_TYPE_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Test Type">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbOrganism_number") and form.cbOrganism_number is not "" and form.cbOrganism_number is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbOrganism_number>
	<cfset aquireOutputFields[#ofIndex#][2] = "Exp. Sample Number">
	<cfset aquireOutputFields[#ofIndex#][3] = "ORGANISM_NUMBER">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Exposure Sample Number">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbDoses") and form.cbDoses is not "" and form.cbDoses is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbDoses>
	<cfset aquireOutputFields[#ofIndex#][2] = "Doses">
	<cfset aquireOutputFields[#ofIndex#][3] = "DOSES">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Doses">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbExperimental_design") and form.cbExperimental_design is not "" and form.cbExperimental_design is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbExperimental_design>
	<cfset aquireOutputFields[#ofIndex#][2] = "Exp. Design">
	<cfset aquireOutputFields[#ofIndex#][3] = "EXPDESIGN">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Experimental Design">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbHabitat_Code") and form.cbHabitat_Code is not "" and form.cbHabitat_Code is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbHabitat_Code>
	<cfset aquireOutputFields[#ofIndex#][2] = "Sub-Habitat">
	<cfset aquireOutputFields[#ofIndex#][3] = "HABITAT_CODE,HABITAT_CODE_DESC">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Sub-Habitat">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbHabitat_comment") and form.cbHabitat_comment is not "" and form.cbHabitat_comment is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbHabitat_comment>
	<cfset aquireOutputFields[#ofIndex#][2] = "Sub-Habitat Comments">
	<cfset aquireOutputFields[#ofIndex#][3] = "HABITAT_COMMENT">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Sub-Habitat Comments">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbGeoCode") and form.cbGeoCode is not "" and form.cbGeoCode is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbGeoCode>
	<cfset aquireOutputFields[#ofIndex#][2] = "Geog. Term">
	<cfset aquireOutputFields[#ofIndex#][3] = "GEO_CODE,GEO_CODE_DESC">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Geographic Term">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbGeographic_loc") and form.cbGeographic_loc is not "" and form.cbGeographic_loc is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbGeographic_loc>
	<cfset aquireOutputFields[#ofIndex#][2] = "Geog. Loc">
	<cfset aquireOutputFields[#ofIndex#][3] = "FS_TEST_LOCATION">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Geographic Location">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbLatLong") and form.cbLatLong is not "" and form.cbLatLong is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbLatLong>
	<cfset aquireOutputFields[#ofIndex#][2] = "Lat/Long">
	<cfset aquireOutputFields[#ofIndex#][3] = "LATITUDE,LONGITUDE">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Latitude/Longitude">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbSub_strate") and form.cbSub_strate is not "" and form.cbSub_strate is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbSub_strate>
	<cfset aquireOutputFields[#ofIndex#][2] = "Substr. Term">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "SUBSTRATE_CODE">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "SUBSTRATE_CODE_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Substrate Term/Description">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbSub_strate_Comment") and form.cbSub_strate_Comment is not "" and form.cbSub_strate_Comment is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbSub_strate_Comment>
	<cfset aquireOutputFields[#ofIndex#][2] = "Substrate Comment">
	<cfset aquireOutputFields[#ofIndex#][3] = "SUBSTRATE_DESC">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Substrate Term/Description">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbApplication_type") and form.cbApplication_type is not "" and form.cbApplication_type is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbApplication_type>
	<cfset aquireOutputFields[#ofIndex#][2] = "Appl. Type">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "APP_TYPE">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "APP_TYPE_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Application Type">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbApplication_date") and form.cbApplication_date is not "" and form.cbApplication_date is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbApplication_date>
	<cfset aquireOutputFields[#ofIndex#][2] = "Appl. Date">
	<cfset aquireOutputFields[#ofIndex#][3] = "APP_DATE">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Application Date/Season">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbApplication_date_season") and form.cbApplication_date_season is not "" and form.cbApplication_date_season is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbApplication_date_season>
	<cfset aquireOutputFields[#ofIndex#][2] = "Appl. Date|Appl. Seas.">
	<cfset aquireOutputFields[#ofIndex#][3] = "APP_DATE,APP_SEASON,APP_SEASON_DESC">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Application Date/Season | ">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbSeason") and form.cbSeason is not "" and form.cbSeason is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbSeason>
	<cfset aquireOutputFields[#ofIndex#][2] = "Appl. Seas.">
	<cfset aquireOutputFields[#ofIndex#][3] = "APP_SEASON,APP_SEASON_DESC">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Application Date/Season">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbChemical_halflife") and form.cbChemical_halflife is not "" and form.cbChemical_halflife is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbChemical_halflife>
	<cfset aquireOutputFields[#ofIndex#][2] = "Chem. Halflife">
	<cfset aquireOutputFields[#ofIndex#][3] = "HALFLIFE_MEAN_OP,HALFLIFE_MEAN,HALFLIFE_MIN_OP,HALFLIFE_MIN,HALFLIFE_MAX_OP,HALFLIFE_MAX,HALFLIFE_TIME_UNIT">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Chemical Half Life">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbApplication_rate") and form.cbApplication_rate is not "" and form.cbApplication_rate is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbApplication_rate>
	<cfset aquireOutputFields[#ofIndex#][2] = "Appl. Rate">
	<cfset aquireOutputFields[#ofIndex#][3] = "APP_RATE,APP_UNITS">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Application Rate">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbWater_Depth") and form.cbWater_Depth is not "" and form.cbWater_Depth is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbWater_Depth>
	<cfset aquireOutputFields[#ofIndex#][2] = "Water Depth">
	<cfset aquireOutputFields[#ofIndex#][3] = "WATER_DEPTH,DEPTH_MEAN_VALUE_OP,DEPTH_MEAN_VALUE,DEPTH_MIN_VALUE_OP,DEPTH_MIN_VALUE,DEPTH_MAX_VALUE_OP,DEPTH_MAX_VALUE,DEPTH_UNITS">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Water Depth">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbSample_num_unit") and form.cbSample_num_unit is not "" and form.cbSample_num_unit is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbSample_num_unit>
	<cfset aquireOutputFields[#ofIndex#][2] = "Res. Sample Number|Unit">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "SAMPLE_SIZE_MEAN_OP,SAMPLE_SIZE_MEAN,SAMPLE_SIZE_MIN_OP,SAMPLE_SIZE_MIN,SAMPLE_SIZE_MAX_OP,SAMPLE_SIZE_MAX,SAMPLE_UNIT">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "SAMPLE_SIZE_MEAN_OP,SAMPLE_SIZE_MEAN,SAMPLE_SIZE_MIN_OP,SAMPLE_SIZE_MIN,SAMPLE_SIZE_MAX_OP,SAMPLE_SIZE_MAX,SAMPLE_UNIT_DESC">
	</cfif>
		<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Result Sample Number | Unit">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbSample_unit") and form.cbSample_unit is not "" and form.cbSample_unit is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbSample_unit>
	<cfset aquireOutputFields[#ofIndex#][2] = "Res. Sample Unit">
	<cfset aquireOutputFields[#ofIndex#][3] = "SAMPLE_UNIT">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Result Sample Unit">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbBCF") and form.cbBCF is not "" and form.cbBCF is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbBCF>
	<cfset aquireOutputFields[#ofIndex#][2] = "BCF">
	<cfset aquireOutputFields[#ofIndex#][3] = "BCF1_MEAN_OP,BCF1_MEAN,BCF1_MIN_OP,BCF1_MIN,BCF1_MAX_OP,BCF1_MAX,BCF1_UNIT,BCF2_MEAN_OP,BCF2_MEAN,BCF2_MIN_OP,BCF2_MIN,BCF2_MAX_OP,BCF2_MAX,BCF2_UNIT,BCF3_MEAN_OP,BCF3_MEAN,BCF3_MIN_OP,BCF3_MIN,BCF3_MAX_OP,BCF3_MAX,BCF3_UNIT">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Bioconcentration">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbTrend_Effect_Pct") and form.cbTrend_Effect_Pct is not "" and form.cbTrend_Effect_Pct is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbTrend_Effect_Pct>
	<cfset aquireOutputFields[#ofIndex#][2] = "Trend|Eff %">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "TREND,EFFECT_PCT,EFFECT_PCT_MEAN_OP,EFFECT_PERCENT_MEAN,EFFECT_PCT_MIN_OP,EFFECT_PERCENT_MIN,EFFECT_PCT_MAX_OP,EFFECT_PERCENT_MAX">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "TREND_DESC,EFFECT_PCT,EFFECT_PCT_MEAN_OP,EFFECT_PERCENT_MEAN,EFFECT_PCT_MIN_OP,EFFECT_PERCENT_MIN,EFFECT_PCT_MAX_OP,EFFECT_PERCENT_MAX">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Trend | Effect Percent">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbTrend") and form.cbTrend is not "" and form.cbTrend is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbTrend>
	<cfset aquireOutputFields[#ofIndex#][2] = "Trend">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "TREND">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "TREND_DESC">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Trend">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbSpecies_final_wt") and form.cbSpecies_final_wt is not "" and form.cbSpecies_final_wt is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbSpecies_final_wt>
	<cfset aquireOutputFields[#ofIndex#][2] = "Species Final Weight">
	<cfset aquireOutputFields[#ofIndex#][3] = "ORGANISM_FINAL_WT,ORGANISM_FINAL_WT_MEAN_OP,ORGANISM_FINAL_WT_MEAN,ORGANISM_FINAL_WT_MIN_OP,ORGANISM_FINAL_WT_MIN,ORGANISM_FINAL_WT_MAX_OP,ORGANISM_FINAL_WT_MAX,ORGANISM_FINAL_WT_UNITS">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Species Final Weight">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbIntake_rate") and form.cbIntake_rate is not "" and form.cbIntake_rate is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbIntake_rate>
	<cfset aquireOutputFields[#ofIndex#][2] = "Intake Rate">
	<cfset aquireOutputFields[#ofIndex#][3] = "INTAKE_RATE,INTAKE_RATE_MEAN_OP,INTAKE_RATE_MEAN,INTAKE_RATE_MIN_OP,INTAKE_RATE_MIN,INTAKE_RATE_MAX_OP,INTAKE_RATE_MAX,INTAKE_RATE_UNIT">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Intake Rate">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbResult_pct_lipid") and form.cbResult_pct_lipid is not "" and form.cbResult_pct_lipid is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbResult_pct_lipid>
	<cfset aquireOutputFields[#ofIndex#][2] = "Result Percent Lipid">
	<cfset aquireOutputFields[#ofIndex#][3] = "PERCENT_LIPID,LIPID_PCT_MEAN_OP,LIPID_PCT_MEAN,LIPID_PCT_MIN_OP,LIPID_PCT_MIN,LIPID_PCT_MAX_OP,LIPID_PCT_MAX">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Result Percent Lipid">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbResult_drywet") and form.cbResult_drywet is not "" and form.cbResult_drywet is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbResult_drywet>
	<cfset aquireOutputFields[#ofIndex#][2] = "Result Percent Dry/Wet Weight">
	<cfset aquireOutputFields[#ofIndex#][3] = "DRY_WEIGHT_PERCENT,DRY_WET,DRY_WET_PCT_MEAN_OP,DRY_WET_PCT_MEAN,DRY_WET_PCT_MIN_OP,DRY_WET_PCT_MIN,DRY_WET_PCT_MAX_OP,DRY_WET_PCT_MAX">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Result Percent Dry/Wet Weight">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbSteady_state") and form.cbSteady_state is not "" and form.cbSteady_state is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbSteady_state>
	<cfset aquireOutputFields[#ofIndex#][2] = "Steady State">
	<cfset aquireOutputFields[#ofIndex#][3] = "STEADY_STATE">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Steady State">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbOther_Effects") and form.cbOther_Effects is not "" and form.cbOther_Effects is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbOther_Effects>
	<cfset aquireOutputFields[#ofIndex#][2] = "Other Effects">
	<cfset aquireOutputFields[#ofIndex#][3] = "OTHEREFFECT">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Other Effects">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbResult_comm") and form.cbResult_comm is not "" and form.cbResult_comm is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbResult_comm>
	<cfset aquireOutputFields[#ofIndex#][2] = "Result Comment">
	<cfset aquireOutputFields[#ofIndex#][3] = "RESULT_COMMENT">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Result Comment">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbTemperature") and form.cbTemperature is not "" and form.cbTemperature is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbTemperature>
	<cfset aquireOutputFields[#ofIndex#][2] = "Temp.">
	<cfset aquireOutputFields[#ofIndex#][3] = "TEMPERATURE,TEMP_MEAN_VALUE_OP,TEMP_MEAN_VALUE,TEMP_MIN_VALUE_OP,TEMP_MIN_VALUE,TEMP_MAX_VALUE_OP,TEMP_MAX_VALUE,TEMP_UNITS">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Temperature">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbHardness") and form.cbHardness is not "" and form.cbHardness is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbHardness>
	<cfset aquireOutputFields[#ofIndex#][2] = "Hardness">
	<cfset aquireOutputFields[#ofIndex#][3] = "HARDNESS,HARD_MEAN_VALUE_OP,HARD_MEAN_VALUE,HARD_MIN_VALUE_OP,HARD_MIN_VALUE,HARD_MAX_VALUE_OP,HARD_MAX_VALUE,HARD_UNITS">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Hardness">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbAlkalinity") and form.cbAlkalinity is not "" and form.cbAlkalinity is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbAlkalinity>
	<cfset aquireOutputFields[#ofIndex#][2] = "Alk.">
	<cfset aquireOutputFields[#ofIndex#][3] = "ALKALINITY,ALKA_MEAN_VALUE_OP,ALKA_MEAN_VALUE,ALKA_MIN_VALUE_OP,ALKA_MIN_VALUE,ALKA_MAX_VALUE_OP,ALKA_MAX_VALUE,ALKA_UNITS">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Alkalinity">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbDissolved_oxygen") and form.cbDissolved_oxygen is not "" and form.cbDissolved_oxygen is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbDissolved_oxygen>
	<cfset aquireOutputFields[#ofIndex#][2] = "D.O.">
	<cfset aquireOutputFields[#ofIndex#][3] = "DISSOLVED_OXYGEN,DISS_MEAN_VALUE_OP,DISS_MEAN_VALUE,DISS_MIN_VALUE_OP,DISS_MIN_VALUE,DISS_MAX_VALUE_OP,DISS_MAX_VALUE,DISS_UNITS">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Dissolved Oxygen">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbPh") and form.cbPh is not "" and form.cbPh is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbPh>
	<cfset aquireOutputFields[#ofIndex#][2] = "pH">
	<cfset aquireOutputFields[#ofIndex#][3] = "PH,PH_MEAN_VALUE_OP,PH_MEAN_VALUE,PH_MIN_VALUE_OP,PH_MIN_VALUE,PH_MAX_VALUE_OP,PH_MAX_VALUE">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "pH">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbSalinity") and form.cbSalinity is not "" and form.cbSalinity is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbSalinity>
	<cfset aquireOutputFields[#ofIndex#][2] = "Salin.">
	<cfset aquireOutputFields[#ofIndex#][3] = "SALINITY,SAL_MEAN_VALUE_OP,SAL_MEAN_VALUE,SAL_MIN_VALUE_OP,SAL_MIN_VALUE,SAL_MAX_VALUE_OP,SAL_MAX_VALUE,SAL_UNITS">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Salinity">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbConductivity") and form.cbConductivity is not "" and form.cbConductivity is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbConductivity>
	<cfset aquireOutputFields[#ofIndex#][2] = "Conductiv.">
	<cfset aquireOutputFields[#ofIndex#][3] = "CONDUCTIVITY,COND_MEAN_VALUE_OP,COND_MEAN_VALUE,COND_MIN_VALUE_OP,COND_MIN_VALUE,COND_MAX_VALUE_OP,COND_MAX_VALUE,COND_UNITS">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Conductivity">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbOrganic_Carbon_type") and form.cbOrganic_Carbon_type is not "" and form.cbOrganic_Carbon_type is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbOrganic_Carbon_type>
	<cfset aquireOutputFields[#ofIndex#][2] = "Org. Carb. Type|Org. Carb. Value">
	<cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
		<cfset aquireOutputFields[#ofIndex#][3] = "ORGANIC_CARBON_TYPE,ORGANIC_CARBON,ORG_MEAN_VALUE_OP,ORG_MEAN_VALUE,ORG_MIN_VALUE_OP,ORG_MIN_VALUE,ORG_MAX_VALUE_OP,ORG_MAX_VALUE,ORG_UNITS">
	<cfelse>
		<cfset aquireOutputFields[#ofIndex#][3] = "ORGANIC_CARBON_TYPE_DESC,ORGANIC_CARBON,ORG_MEAN_VALUE_OP,ORG_MEAN_VALUE,ORG_MIN_VALUE_OP,ORG_MIN_VALUE,ORG_MAX_VALUE_OP,ORG_MAX_VALUE,ORG_UNITS">
	</cfif>
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Organic Carbon Value/Type | ">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbHumic_acid") and form.cbHumic_acid is not "" and form.cbHumic_acid is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbHumic_acid>
	<cfset aquireOutputFields[#ofIndex#][2] = "Humic Acid">
	<cfset aquireOutputFields[#ofIndex#][3] = "HUMIC_ACID,HUMIC_ACID_MEAN_VALUE_OP,HUMIC_ACID_MEAN_VALUE,HUMIC_ACID_MIN_VALUE_OP,HUMIC_ACID_MIN_VALUE,HUMIC_ACID_MAX_VALUE_OP,HUMIC_ACID_MAX_VALUE,HUMIC_ACID_UNITS">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Organic Carbon Value/Type (Humic Acid)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbSodium") and form.cbSodium is not "" and form.cbSodium is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbSodium>
	<cfset aquireOutputFields[#ofIndex#][2] = "Sodium">
	<cfset aquireOutputFields[#ofIndex#][3] = "SODIUM,SODIUM_MEAN_VALUE_OP,SODIUM_MEAN_VALUE,SODIUM_MIN_VALUE_OP,SODIUM_MIN_VALUE,SODIUM_MAX_VALUE_OP,SODIUM_MAX_VALUE,SODIUM_UNITS">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Organic Carbon Value/Type (Sodium)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbChlorine") and form.cbChlorine is not "" and form.cbChlorine is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbChlorine>
	<cfset aquireOutputFields[#ofIndex#][2] = "Chlorine">
	<cfset aquireOutputFields[#ofIndex#][3] = "CHLORINE,CHLORINE_MEAN_VALUE_OP,CHLORINE_MEAN_VALUE,CHLORINE_MIN_VALUE_OP,CHLORINE_MIN_VALUE,CHLORINE_MAX_VALUE_OP,CHLORINE_MAX_VALUE,CHLORINE_UNITS">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Organic Carbon Value/Type (Chlorine)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbDissolved_inorganic_carbon") and form.cbDissolved_inorganic_carbon is not "" and form.cbDissolved_inorganic_carbon is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbDissolved_inorganic_carbon>
	<cfset aquireOutputFields[#ofIndex#][2] = "Dissolved Inorganic Carbon">
	<cfset aquireOutputFields[#ofIndex#][3] = "DISS_CARBON,DISS_CARBON_MEAN_VALUE_OP,DISS_CARBON_MEAN_VALUE,DISS_CARBON_MIN_VALUE_OP,DISS_CARBON_MIN_VALUE,DISS_CARBON_MAX_VALUE_OP,DISS_CARBON_MAX_VALUE,DISS_CARBON_UNITS">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Organic Carbon Value/Type (Dissolved Inorganic Carbon)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbCalcium") and form.cbCalcium is not "" and form.cbCalcium is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbCalcium>
	<cfset aquireOutputFields[#ofIndex#][2] = "Calcium">
	<cfset aquireOutputFields[#ofIndex#][3] = "CALCIUM,CALCIUM_MEAN_VALUE_OP,CALCIUM_MEAN_VALUE,CALCIUM_MIN_VALUE_OP,CALCIUM_MIN_VALUE,CALCIUM_MAX_VALUE_OP,CALCIUM_MAX_VALUE,CALCIUM_UNITS">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Organic Carbon Value/Type (Calcium)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbPotassium") and form.cbPotassium is not "" and form.cbPotassium is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbPotassium>
	<cfset aquireOutputFields[#ofIndex#][2] = "Potassium">
	<cfset aquireOutputFields[#ofIndex#][3] = "POTASSIUM,POTASSIUM_MEAN_VALUE_OP,POTASSIUM_MEAN_VALUE,POTASSIUM_MIN_VALUE_OP,POTASSIUM_MIN_VALUE,POTASSIUM_MAX_VALUE_OP,POTASSIUM_MAX_VALUE,POTASSIUM_UNITS">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Organic Carbon Value/Type (Potassium)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbMagnesium") and form.cbMagnesium is not "" and form.cbMagnesium is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbMagnesium>
	<cfset aquireOutputFields[#ofIndex#][2] = "Magnesium">
	<cfset aquireOutputFields[#ofIndex#][3] = "MAGNESIUM,MAGNESIUM_MEAN_VALUE_OP,MAGNESIUM_MEAN_VALUE,MAGNESIUM_MIN_VALUE_OP,MAGNESIUM_MIN_VALUE,MAGNESIUM_MAX_VALUE_OP,MAGNESIUM_MAX_VALUE,MAGNESIUM_UNITS">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Organic Carbon Value/Type (Magnesium)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbSulfate") and form.cbSulfate is not "" and form.cbSulfate is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbSulfate>
	<cfset aquireOutputFields[#ofIndex#][2] = "Sulfate">
	<cfset aquireOutputFields[#ofIndex#][3] = "SULFATE,SULFATE_MEAN_VALUE_OP,SULFATE_MEAN_VALUE,SULFATE_MIN_VALUE_OP,SULFATE_MIN_VALUE,SULFATE_MAX_VALUE_OP,SULFATE_MAX_VALUE,SULFATE_UNITS">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Organic Carbon Value/Type (Sulfate)">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbSulfur") and form.cbSulfur is not "" and form.cbSulfur is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbSulfur>
	<cfset aquireOutputFields[#ofIndex#][2] = "Sulfur">
	<cfset aquireOutputFields[#ofIndex#][3] = "SULFUR,SULFUR_MEAN_VALUE_OP,SULFUR_MEAN_VALUE,SULFUR_MIN_VALUE_OP,SULFUR_MIN_VALUE,SULFUR_MAX_VALUE_OP,SULFUR_MAX_VALUE,SULFUR_UNITS">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Organic Carbon Value/Type (Sulfur)">
	<cfset ofIndex = ofIndex + 1>
</cfif>


<cfif isdefined("form.cbGeneral_Comments") and form.cbGeneral_Comments is not "" and form.cbGeneral_Comments is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbGeneral_Comments>
	<cfset aquireOutputFields[#ofIndex#][2] = "General Comment">
	<cfset aquireOutputFields[#ofIndex#][3] = "GENERALCOMMENT">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "General Comment">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbGeneral_Comments") and form.cbGeneral_Comments is not "" and form.cbGeneral_Comments is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbGeneral_Comments>
	<cfset aquireOutputFields[#ofIndex#][2] = "Gen. Comment">
	<cfset aquireOutputFields[#ofIndex#][3] = "GENERALCOMMENT">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "General Comment">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbReference_Citation") and form.cbReference_Citation is not "" and form.cbReference_Citation is not 0>
<cfelse>
	<cfif isdefined("form.cbReference_Number") and form.cbReference_Number is not "" and form.cbReference_Number is not 0>
		<cfset aquireOutputFields[#ofIndex#][1] = form.cbReference_Number>
		<cfset aquireOutputFields[#ofIndex#][2] = "Ref##">
		<cfset aquireOutputFields[#ofIndex#][3] = "REFERENCE_NUMBER">
		<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
		<cfset aquireOutputFields[#ofIndex#][5] = "Reference Number">
		<cfset ofIndex = ofIndex + 1>
	</cfif>
</cfif>

<cfif isdefined("form.cbReference_Citation") and form.cbReference_Citation is not "" and form.cbReference_Citation is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbReference_Citation>
	<cfset aquireOutputFields[#ofIndex#][2] = "Ref. Citation">
	<cfset aquireOutputFields[#ofIndex#][3] = "AUTHOR,REFERENCE_NUMBER,TITLE,SOURCE,PUBLICATION_YEAR,FULL_CITATION">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ,AQ,AQ,AQ,AQ,AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Reference Citation">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbPublication_Year") and form.cbPublication_Year is not "" and form.cbPublication_Year is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbPublication_Year>
	<cfset aquireOutputFields[#ofIndex#][2] = "Pub. Year">
	<cfset aquireOutputFields[#ofIndex#][3] = "PUBLICATION_YEAR">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Publication Year">
	<cfset ofIndex = ofIndex + 1>
</cfif>

<cfif isdefined("form.cbAuthor") and form.cbAuthor is not "" and form.cbAuthor is not 0>
	<cfset aquireOutputFields[#ofIndex#][1] = form.cbAuthor>
	<cfset aquireOutputFields[#ofIndex#][2] = "Author">
	<cfset aquireOutputFields[#ofIndex#][3] = "AUTHOR">
	<cfset aquireOutputFields[#ofIndex#][4] = "AQ">
	<cfset aquireOutputFields[#ofIndex#][5] = "Author">
	<cfset ofIndex = ofIndex + 1>
</cfif>
