
<cfset ExcelFunc = CreateObject( "component", "cfc.excel_functions" )>
<cfset spreadsheet = CreateObject( "component", "lucee_ss.Spreadsheet" ).init( javaLoaderDotPath = "lucee_ss.javaLoader.JavaLoader" )>
    
<CFLOCK TIMEOUT="30" throwontimeout="no" TYPE="readonly" scope="application">
    <CFSET thisRecordMax = duplicate(Application.RecordMax)>  <!--- SPE 4/27/06 --->
    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>  <!--- SPE 4/27/06 --->
</CFLOCK>        

<cfif ExportQuery.RecordCount is 0>

    <div class="callout primary">
        <h5 class="title">Sorry</h5>
        <p>There were no results found for this search. Please refine your search.</p>
    </div>

<cfelseif ExportQuery.RecordCount gt thisRecordMax> <!--- SPE 04/27/06 --->

    <div class="callout alert">
        <h5 class="title">Warning</h5>
        <p>There were too many results found to display in a browser report format.  There is a limit of <cfoutput>#thisRecordMax#</cfoutput> records for a browser viewable report. Please refine your search.</p>
    </div>

<cfelse>
    
    <!--- Before you go into .xls code, find out if cbIncludeCodeDesc is in use --->
    <cfif isdefined("form.cbIncludeCodeDesc") and form.cbIncludeCodeDesc IS NOT "" AND form.cbIncludeCodeDesc IS NOT 0>
        <cfset displayLookupCodes = True>
    <cfelse>
        <cfset displayLookupCodes = False>
    </cfif>

    <cfset pipeSpacer = " | "> <!--- Used in Summary column output with NoWrap --->


    <!--- MATCH LISTS FOR SKIP FIELDS --->

    <cfset condensedColNameList = "Temperature,Hardness,Alkalinity,pH,Salinity,Conductivity,Organic Carbon Value,Dissolved Oxygen,Water Depth,Multiplier,Calcium,Chlorine,Dissolved Inorganic Carbon,Humic Acid,Magnesium,Species Final Weight,Organism Initial Weight Mean Op,Organism Initial Weight Mean,Organism Initial Weight Min Op,Organism Initial Weight Min,Organism Initial Weight Max Op,Organism Initial Weight Max,Organism Initial Weight Units,Potassium,Sodium,Sulfate,Sulfur,Study Duration (Author),Study Duration (Days),Effect Percent,Significance Level,Application Frequency,Result Percent Lipid,Intake Rate,Result Percent Dry/Wet Weight,Exposure Duration (Author),Exposure Duration (Days),Chemical Purity Mean Op,Chemical Purity Mean(%),Chemical Purity Min Op,Chemical Purity Min(%),Chemical Purity Max Op,Chemical Purity Max(%),Conc 2 Max (Standardized),Conc 2 Max Op (Standardized),Conc 2 Mean (Standardized),Conc 2 Mean Op (Standardized),Conc 2 Min Op (Standardized),Conc Min 2 (Standardized),Conc 2 Type (Standardized),Conc 2 Units (Standardized),Conc 3 Max (Standardized),Conc 3 Max Op (Standardized),Conc 3 Mean (Standardized),Conc 3 Mean Op (Standardized),Conc 3 Min Op (Standardized),Conc Min 3 (Standardized),Conc 3 Type (Standardized),Conc 3 Units (Standardized),Observed Duration Mean Op (Days),Observed Duration Mean (Days),Observed Duration Min Op (Days),Observed Duration Min (Days),Observed Duration Max Op (Days),Observed Duration Max (Days),Organism Age Mean,Organism Age Mean Op,Organism Age Min,Organism Age Min Op,Organism Age Max,Organism Age Max Op,Organism Initial Length Mean,Organism Initial Length Mean Op,Organism Initial Length Min,Organism Initial Length Min Op,Organism Initial Length Max,Organism Initial Length Max Op,Organism Initial Length Units,Organism Initial Length Type">

    <cfset condensedDBFieldList = "TEMPERATURE,HARDNESS,ALKALINITY,PH,SALINITY,CONDUCTIVITY,ORGANIC_CARBON,DISSOLVED_OXYGEN,WATER_DEPTH,UG_L_MULT,CALCIUM,CHLORINE,DISS_CARBON,HUMIC_ACID,MAGNESIUM,ORGANISM_FINAL_WT,ORGANISM_INIT_WT_MEAN_OP,ORGANISM_INIT_WT_MEAN,ORGANISM_INIT_WT_MIN_OP,ORGANISM_INIT_WT_MIN,ORGANISM_INIT_WT_MAX_OP,ORGANISM_INIT_WT_MAX,ORGANISM_INIT_WT_UNIT,POTASSIUM,SODIUM,SULFATE,SULFUR,STUDY_DURATION_CONCAT,STUDY_DURATION_CONCAT_LONG,STUDY_DURATION_STD_CONCAT,STUDY_DURATION_STD_CONCAT_LONG,EFFECT_PCT,STATISTICAL_SIG,APPLICATION_FREQ_SORT,PERCENT_LIPID,INTAKE_RATE,DRY_WEIGHT_PERCENT,EXPOSURE_DURATION_CONCAT,EXPOSURE_DURATION_CONCAT_LONG,EXPOSURE_DUR_STD_CONCAT,EXPOSURE_DUR_STD_CONCAT_LONG,TEST_PURITY_MEAN_OP,TEST_PURITY_MEAN,TEST_PURITY_MIN_OP,TEST_PURITY_MIN,TEST_PURITY_MAX_OP,TEST_PURITY_MAX,CONC2_MAX_STD_OP,CONC2_MAX_STD,CONC2_MEAN_STD_OP,CONC2_MEAN_STD,CONC2_MIN_STD_OP,CONC2_MIN_STD,CONC2_TYPE_STD_DESC,CONC2_TYPE_STD,CONC2_UNITS_STD,CONC3_MAX_STD_OP,CONC3_MAX_STD,CONC3_MEAN_STD_OP,CONC3_MEAN_STD,CONC3_MIN_STD_OP,CONC3_MIN_STD,CONC3_TYPE_STD_DESC,CONC3_TYPE_STD,CONC3_UNITS_STD,TEST_DURATION_STD_OP,TEST_DURATION_STD,MIN_DURATION_STD_OP,MIN_DURATION_STD,MAX_DURATION_STD_OP,MAX_DURATION_STD,ORGANISM_AGE_MEAN,ORGANISM_AGE_MEAN_OP,ORGANISM_AGE_MIN,ORGANISM_AGE_MIN_OP,ORGANISM_AGE_MAX,ORGANISM_AGE_MAX_OP,ORGANISM_LENGTH_MEAN,ORGANISM_LENGTH_MEAN_OP,ORGANISM_LENGTH_MIN,ORGANISM_LENGTH_MIN_OP,ORGANISM_LENGTH_MAX,ORGANISM_LENGTH_MAX_OP,ORGANISM_LENGTH_UNIT,ORGANISM_LENGTH_TYPE,ORGANISM_LENGTH_UNIT_DESC,ORGANISM_LENGTH_TYPE_DESC">

    <cfset fullColNameList = "Temperature,Hardness,Alkalinity,pH,Salinity,Conductivity,Organic Carbon Value,Dissolved Oxygen,Water Depth,Multiplier,Calcium,Chemical Purity,Chlorine,Dissolved Inorganic Carbon,Humic Acid,Magnesium,Species Final Weight,Organism Initial Weight,Potassium,Sodium,Sulfate,Sulfur,Organism Age,Organism Initial Length,Observed Duration (Author),Observed Duration (Days),Study Duration (Author),Study Duration (Days),Effect Percent,Significance Level,Application Frequency,Result Percent Lipid,Intake Rate,Result Percent Dry/Wet Weight,Exposure Duration (Author),Exposure Duration (Days)">

    <cfset fullDBFieldList = "TEMPERATURE,HARDNESS,ALKALINITY,PH,SALINITY,CONDUCTIVITY,ORGANIC_CARBON,DISSOLVED_OXYGEN,WATER_DEPTH,UG_L_MULT,CALCIUM,TEST_PURITY,CHLORINE,DISS_CARBON,HUMIC_ACID,MAGNESIUM,ORGANISM_FINAL_WT,ORGANISM_INIT_WT,POTASSIUM,SODIUM,SULFATE,SULFUR,AGE,AGE_DESC,ORGANISM_LENGTH,ORGANISM_LENGTH_DESC,TEST_DURATION_CONCAT,TEST_DURATION_CONCAT_LONG,TEST_DURATION_STD_CONCAT,TEST_DURATION_STD_CONCAT_LONG,STUDY_DURATION_CONCAT,STUDY_DURATION_CONCAT_LONG,STUDY_DURATION_STD_CONCAT,STUDY_DURATION_STD_CONCAT_LONG,EFFECT_PCT,STATISTICAL_SIG,APPLICATION_FREQ_SORT,PERCENT_LIPID,INTAKE_RATE,DRY_WEIGHT_PERCENT,EXPOSURE_DURATION_CONCAT,EXPOSURE_DURATION_CONCAT_LONG,EXPOSURE_DUR_STD_CONCAT,EXPOSURE_DUR_STD_CONCAT_LONG">


    <cfprocessingdirective suppressWhiteSpace = "Yes">

    <cfif ArrayLen(aquireOutputFields) is not 0>

        <cfset indexList = "">
        <cfset count = 0>

        <cfset columnNameList_pg1 = "">       
        
        <cfloop index = "i" from = "1" to = "#ArrayLen(aquireOutputFields)#">           <!--- fields --->

            <cfset formFieldNames = aquireOutputFields[i][1]>            
            <cfloop index=k list="#formFieldNames#" delimiters="|">                     <!--- each column name --->

                <cfset trimmedColHdrVal = trim(k)>

                <!--- Looking at the column names --->
                <cfset indexOf = ListFind(columnNameList_pg1,"#trimmedColHdrVal#")>
                <cfif indexOf eq 0>
                    <!--- Excludes headings of contatenated full field display of each of these in favor of the meanOp/mean/minOp/min/maxOp/max display ---> 
                    <!--- Additional conditions to check:
                        1. one of the risk assessor default fields is un-selected
                            - That column will not be in the TerrestrialOutputFields[] array, so whether the field is checked in the if-statement below is irrelevant.
                            - Still need to test the checkbox (ie. cbPurity?) when assembling the Summary Column string output to include or exclude that line
                        2. New checkbox for cbCondensed -- checked is condensed, unchecked is full
                            - If cbCondensed is checked, then do this normal logic, else don't check those 4 mean-min-max fields
                    --->
                    <cfif CONDENSED_EXCEL eq true>

                        <cfif ListFind(condensedColNameList, trimmedColHdrVal) eq 0>

                            <cfset columnNameList_pg1 = Listappend(columnNameList_pg1, trimmedColHdrVal)>

                        </cfif>
                    <cfelse>

                        <cfif ListFind(fullColNameList, trimmedColHdrVal) eq 0>

                            <cfset columnNameList_pg1 = Listappend(columnNameList_pg1, trimmedColHdrVal)>

                        </cfif>
                    </cfif>
                <cfelse>

                    <cfset indexList = Listappend(indexList, count)>
                </cfif>

                <cfset count = count + 1>

            </cfloop>      <!--- end each column name --->
        </cfloop>          <!--- end fields --->

        <cfif CONDENSED_EXCEL eq true> <!--- then condensed output --->
            <!--- Show the title for the "Summary of Additional Parameters" column. --->
            <cfset columnNameList_pg1 = Listappend(columnNameList_pg1, "Summary of Additional Parameters")>
        </cfif>
        

        <!---   PAGE 1      --->

        <cfset thisExcelWorkbook = ExcelFunc.generateStreamingXlsx(spreadsheet, columnNameList_pg1, "Aquatic-Export")>
 


<cflog text="acquire_search_excel_native - data loop starts">

       
        
        <cfset thisRow = 2>
        <cfloop query="ExportQuery">


<!---<cfset startTime = GetTickCount()>--->
<!---<cflog text="ROW = #thisRow#: Export Query Loop (1) - #TimeFormat(Now(),'HH:mm:ss.l')#">--->


            <cfset count = 0>

            <cfset dataRow = arrayNew(1)>

            <CFLOOP index = "i" from = "1" to = "#ArrayLen(aquireOutputFields)#">           <!--- fields --->


<!---<cfset groupStartTime = GetTickCount()>--->
<!---<cflog text="ROW = #thisRow#: aquireOutputFields Loop (2)">--->



                <cfloop index=j list="#aquireOutputFields[i][3]#" delimiters=",">           <!--- db column list, loop through each db col --->


<!---<cfset fieldStartTime = GetTickCount()>--->
<!---<cflog text="ROW = #thisRow#: db column list Loop (3) - value = #j#">--->


                    <cfset trimmedColVal = trim(j)>
                    <cfset evalColVal = evaluate(j)>

                    <cfif ListFind(indexList, "#count#") eq 0>
                        <!--- Excludes column concatenated full field display of each of these in favor of the meanOp/mean/minOp/min/maxOp/max display ---> 
                        <cfif CONDENSED_EXCEL eq true>

                            <cfif ListFind(condensedDBFieldList, trimmedColVal) eq 0>

                                <!--- Do some substitutions for condensed output --->
                                <cfif trimmedColVal eq "TEST_PURITY">
                                    <cfset cellValueToAdd = ExcelFunc.concatMean(TEST_PURITY_MEAN_OP, TEST_PURITY_MEAN)>

                                <cfelseif trimmedColVal eq "AGE" OR trimmedColVal eq "AGE_DESC">
                                    <cfset cellValueToAdd = ExcelFunc.concatMean(ORGANISM_AGE_MEAN_OP, ORGANISM_AGE_MEAN)>

                                <cfelseif (trimmedColVal eq "TEST_DURATION_STD_CONCAT") or (trimmedColVal eq "TEST_DURATION_STD_CONCAT_LONG")>
                                    <cfset cellValueToAdd = ExcelFunc.concatMean(TEST_DURATION_STD_OP, TEST_DURATION_STD)>

                                <cfelse>

                                    <cfset cellValueToAdd = evalColVal>
                                </cfif>

                                <cfset ArrayAppend(dataRow, cellValueToAdd)>

                            </cfif>
                        <cfelse>

                            <cfif ListFind(fullDBFieldList, trimmedColVal) eq 0>

                                <cfset ArrayAppend(dataRow, evalColVal)>

                            </cfif>
                        </cfif>
                    </cfif>
                    <cfset count = count + 1>


<!---<cfset fieldEndTime = GetTickCount()>--->
<!---<cfset fieldRunTime = fieldEndTime - fieldStartTime>--->
<!---<cflog text="ROW = #thisRow#: FIELD = #trimmedColVal# - #fieldRunTime#">--->
<!---<cflog text="ROW = #thisRow#: END LOOP (3)">--->

                </cfloop>


<!---<cfset groupEndTime = GetTickCount()>
<cfset groupRunTime = groupEndTime - groupStartTime>
<cflog text="ROW = #thisRow#: #groupRunTime# - GROUP = #aquireOutputFields[i][3]#">--->
<!---<cflog text="ROW = #thisRow#: END LOOP (2)">--->

            </cfloop>

            <!--- Summary of Additional Parameters column --->
            <cfif CONDENSED_EXCEL eq true>
       
                <cfif ListFindNoCase(ExportQuery.ColumnList, "TEST_DURATION_STD_CONCAT" )>
                    <cfset tempVar2 = duration_units_std>
                <cfelseif ListFindNoCase(ExportQuery.ColumnList, "TEST_DURATION_STD_CONCAT_LONG" )>
                    <cfset tempVar2 = duration_units_std_long>
                <cfelse>
                    <cfset tempVar2 = "">
                    <!--- Observed Duration (Days) was not checked, so there is no output for Duration in the additional parameters column --->
                </cfif>

                <cfif ListFindNoCase(ExportQuery.ColumnList, "conc1_type" )>
                    <cfset tempVar1 = conc1_type>
                    <cfset tempVar3 = conc2_type>
                    <cfset tempVar4 = conc3_type>
                <cfelseif ListFindNoCase(ExportQuery.ColumnList, "conc1_type_STD" )>
                    <cfset tempVar1 = conc1_type_STD>
                    <cfset tempVar3 = conc2_type_STD>
                    <cfset tempVar4 = conc3_type_STD>
                <cfelseif ListFindNoCase(ExportQuery.ColumnList, "conc1_type_desc" )>
                    <cfset tempVar1 = conc1_type_desc>
                    <cfset tempVar3 = conc2_type_desc>
                    <cfset tempVar4 = conc3_type_desc>
                <cfelseif ListFindNoCase(ExportQuery.ColumnList, "conc1_type_STD_desc" )>
                    <cfset tempVar1 = conc1_type_STD_desc>
                    <cfset tempVar3 = conc2_type_STD_desc>
                    <cfset tempVar4 = conc3_type_STD_desc>
                <cfelse>
                    <cfset tempVar2 = "">
                    <!--- Concentration(Author)|Application Rate was not checked, so there is no output for any conc# in the additional parameters column --->
                </cfif>

                <cfset tempText = "">
                <cfif ListFindNoCase( ExportQuery.ColumnList, "TEST_PURITY_MEAN_OP" )>
                    <cfset tempText = tempText & "Purity:  " &
                        ExcelFunc.additionalParameters("1","",TEST_PURITY_MEAN_OP,TEST_PURITY_MEAN,TEST_PURITY_MIN_OP,TEST_PURITY_MIN,TEST_PURITY_MAX_OP,TEST_PURITY_MAX," ")>
                </cfif>

                <cfif ListFindNoCase( ExportQuery.ColumnList, "ORGANISM_AGE_MEAN_OP" )>
                    <cfif len(tempText) GT 0>
                        <cfset tempText = tempText & pipeSpacer>
                    </cfif>
                    <!--- 01/19/17 SPE - add check for code desc --->
                    <cfif displayLookupCodes>
                        <cfset tempText = tempText & "Organism Age:  " &
                            ExcelFunc.additionalParameters("2","",ORGANISM_AGE_MEAN_OP,ORGANISM_AGE_MEAN,ORGANISM_AGE_MIN_OP,ORGANISM_AGE_MIN,ORGANISM_AGE_MAX_OP,ORGANISM_AGE_MAX,AGE_UNIT)>
                    <cfelse>
                        <cfset tempText = tempText & "Organism Age:  " &
                            ExcelFunc.additionalParameters("2","",ORGANISM_AGE_MEAN_OP,ORGANISM_AGE_MEAN,ORGANISM_AGE_MIN_OP,ORGANISM_AGE_MIN,ORGANISM_AGE_MAX_OP,ORGANISM_AGE_MAX,AGE_UNIT_DESC)>
                    </cfif>
                </cfif>

                <cfif ListFindNoCase( ExportQuery.ColumnList, "TEST_DURATION_STD_OP" )>
                    <cfif len(tempText) GT 0>
                        <cfset tempText = tempText & pipeSpacer>
                    </cfif>
                    <cfset tempText = tempText & "Duration (Days):  " &
                        ExcelFunc.additionalParameters("2","",TEST_DURATION_STD_OP,TEST_DURATION_STD,MIN_DURATION_STD_OP,MIN_DURATION_STD,MAX_DURATION_STD_OP,MAX_DURATION_STD,tempVar2)>
                </cfif>

                <cfif ListFindNoCase( ExportQuery.ColumnList, "CONC2_MEAN_STD_OP" )>
                    <cfif len(tempText) GT 0>
                        <cfset tempText = tempText & pipeSpacer>
                    </cfif>
                    <cfset tempText = tempText & "Conc 2 (Standardized):  " &
                        ExcelFunc.additionalParameters("4",tempVar3,CONC2_MEAN_STD_OP,CONC2_MEAN_STD,CONC2_MIN_STD_OP,CONC2_MIN_STD,CONC2_MAX_STD_OP,CONC2_MAX_STD,CONC2_UNITS_STD)>
                </cfif>

                <cfif ListFindNoCase( ExportQuery.ColumnList, "CONC3_MEAN_STD_OP" )>
                    <cfif len(tempText) GT 0>
                        <cfset tempText = tempText & pipeSpacer>
                    </cfif>
                    <cfset tempText = tempText & "Conc 3 (Standardized):  " &
                        ExcelFunc.additionalParameters("4",tempVar4,CONC3_MEAN_STD_OP,CONC3_MEAN_STD,CONC3_MIN_STD_OP,CONC3_MIN_STD,CONC3_MAX_STD_OP,CONC3_MAX_STD,CONC3_UNITS_STD)>
                </cfif>

                <cfset ArrayAppend(dataRow, tempText)>

            <cfelse>

                <!--- Don't print the summary with a full report --->

            </cfif>

            <cfset spreadsheet.addRow(thisExcelWorkbook, dataRow)>


<!---<cfset endTime = GetTickCount()>
<cfset runTime = endTime - startTime>
<cflog text="ROW = #thisRow#: END LOOP (1) - #runTime#">--->
<!---<cflog text="ROW = #thisRow#: END LOOP (1) - #TimeFormat(Now(),'HH:mm:ss.l')#">--->

                   
            <cfset thisRow = thisRow + 1>
        </cfloop>        
 


<cflog text="acquire_search_excel_native - data loop ends">

       
        
        <cfset spreadsheet.addFreezePane(thisExcelWorkbook, 1, 1)>
 
        <!---   END PAGE 1  --->


        <!---   PAGE 2      --->

        <cfinclude template="export_excel_native_pg2.cfm">
 

        <!---   PAGE 3          --->

        <!--- export time added to both page 3 and file name --->
        <cfset rightNow = Now()>
        <cfset thisYear = dateTimeFormat(rightNow, "yyyy")>
        <cfset thisMonth = dateTimeFormat(rightNow, "mm")>
        <cfset thisDay = dateTimeFormat(rightNow, "dd")>
        <cfset thisHour = dateTimeFormat(rightNow, "HH")>
        <cfset thisMinute = dateTimeFormat(rightNow, "nn")>
        <cfset thisSecond = dateTimeFormat(rightNow, "ss")>

        <cfset exportTime = thisYear & "-" & thisMonth & "-" & thisDay & " " & thisHour & ":" & thisMinute & ":" & thisSecond>    
        <cfset exportTimeFile = thisYear & thisMonth & thisDay & "_" & thisHour & thisMinute & thisSecond>
 
        <cfinclude template="export_excel_native_pg3.cfm">            
 

        <!---   OUTPUT THE ENTIRE WORKBOOK  --->

        <cfset spreadsheet.setActiveSheet(thisExcelWorkbook, "Aquatic-Export")>
        <cfset fileName = "ECOTOX-Aquatic-Export_" & exportTimeFile>
        
        <!--- stream it to the browser --->
        <cfset ExcelFunc.generateStreamingXlsxDownload(spreadsheet, thisExcelWorkbook, fileName)>
        
    </cfif>
        
    </cfprocessingdirective>

</cfif>
