
<!---

    Template for reference export
    Parameters expected:

        spreadsheet - lucee spreadsheet library object
        thisExcelWorkbook - current object containing the excel workbook generated during parent export file        

--->


<!---   PAGE 2      --->

<cfset columnNameList_pg2 = "Ref. Number,Author,Title,Source,Pub. Year,Ref. Type,Citation,Google Scholar">

<cfset ExcelFunc.addNewWorksheet(spreadsheet, thisExcelWorkbook, columnNameList_pg2, "References")>


<!---   get distinct ref nums from query    --->
<cfset distinctRefNumsAry = arrayNew(1)>
<cfoutput query="GetDistinctReferences">
    <cfset thisRefNum = #GetDistinctReferences.REFERENCE_NUMBER#>
    <cfset ArrayAppend(distinctRefNumsAry, thisRefNum)>
</cfoutput>

<cfset refNumStr = "">
<cfloop index="i" from="1" to="#ArrayLen(distinctRefNumsAry)#">
    <cfset refNumStr = listAppend(refNumStr, #distinctRefNumsAry[i]#)>
</cfloop>          

<!---   CALL REF HANDLER TO GET DATA    --->
<cfset FORM.refNums = refNumStr>
<cfset URL.type = "ssd">
<cfinclude template="../ref_handler.cfm">

<!--- google scholar link styles --->
<cfset linkStyle = StructNew()>
<cfset linkStyle.color="blue">
<cfset linkStyle.underline="true">

<cfset thisRow = 2>
<cfloop query="ReferenceQuery">

    <cfset dataRow = arrayNew(1)>

    <cfset ArrayAppend(dataRow, ReferenceQuery.REFERENCE_NUMBER)>
    <cfset ArrayAppend(dataRow, ReferenceQuery.AUTHOR)>
    <cfset ArrayAppend(dataRow, ReferenceQuery.TITLE)>
    <cfset ArrayAppend(dataRow, ReferenceQuery.SOURCE)>
    <cfset ArrayAppend(dataRow, ReferenceQuery.PUBLICATION_YEAR)>    

    <cfif ListFind("OECDF,MED03,MED04,MED02,OECDN,OECDG,MED01,MED05,OPP,RUSSN,USGS", ReferenceQuery.REFERENCE_TYPE) gt 0>
        <cfset ArrayAppend(dataRow, ReferenceQuery.REFTYPEDESC)>
    <cfelse>        
        <cfset ArrayAppend(dataRow, "")>
    </cfif>
    
    <cfset ArrayAppend(dataRow, ReferenceQuery.FULL_CITATION)>

    <!--- set placeholder for google scholar --->
    <cfset ArrayAppend(dataRow, "")>

    <!--- add the row to ss so we can add google scholar link afterwards --->
    <cfset ExcelFunc.addRow(spreadsheet, thisExcelWorkbook, dataRow)>

    <!--- now go back and fill in the google scholar link --->
    <cfset thisLink = OutFunc.generateGoogleScholarLink(ReferenceQuery.TITLE)>
    <cfset ExcelFunc.setGoogleScholarLink(spreadsheet, thisExcelWorkbook, thisLink, thisRow, 8, linkStyle)>

    
    <cfset thisRow = thisRow + 1>
</cfloop>

<cfset spreadsheet.addFreezePane(thisExcelWorkbook, 1, 1)>

<!---   END PAGE 2      --->
