
<cfoutput>
    
<cfset refNumAry = arrayNew(1)>
<cfloop list="#FORM.refNums#" index="thisRefNum">
    <cfset ArrayAppend(refNumAry, thisRefNum)>
</cfloop>
    
<cfprocessingdirective suppressWhiteSpace = "Yes">

<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cfset count = 0>
<cftry>
    <cfquery name="ReferenceQuery" datasource="#application.datasource#" dbtype="Oracle80" result="RefQueryVars">    

        SELECT * FROM (                
            SELECT /*+ first_rows(#REFPAGESIZE#) */            
                <!---DISTINCT---> 
                REFERENCE_NUMBER, 
                AUTHOR, 
                TITLE, 
                SOURCE,
                REFERENCE_TYPE,
                CASE
                    WHEN REFERENCE_TYPE = 'OECDG' THEN 'German Dataset'
                    WHEN REFERENCE_TYPE = 'OECDF' THEN 'French Dataset'
                    WHEN REFERENCE_TYPE = 'OECDN' THEN 'Dutch Dataset'
                    WHEN REFERENCE_TYPE = 'RUSSN' THEN 'Russian Dataset'
                    WHEN REFERENCE_TYPE = 'USGS'  THEN 'USGS Acute Toxicity Database'
                    WHEN REFERENCE_TYPE = 'OPP'   THEN 'EPA Office of Pesticides Program Database'
                    WHEN REFERENCE_TYPE IN ('MED01','MED02','MED03','MED04','MED05') THEN 'EPA Fathead Minnow Acute Toxicity Database (MED-Duluth)'
                    ELSE NULL
                END AS REFTYPEDESC,
                PUBLICATION_YEAR,
                DOI,
                FULL_CITATION, <!--- --+ ORDERED --->
                row_number() over (order by #REFSORTFIELD#, REFERENCE_NUMBER) rn,
                COUNT(*) OVER () TotalRows
            from REFERENCES
            where        
            (

            <cfset moreThanOne = 0>
            <cfset countItems = 0>
            <cfset refNumList = "">

            <cfloop index="i" from="1" to="#ArrayLen(refNumAry)#">
                <cfset thisRefNum = #refNumAry[i]#>

                <cfif countItems mod 1000 eq 0>
                      
                    <cfif countItems eq 0>
                        <cfset refNumList = thisRefNum>
                    <cfelse>
                        <cfset countItems = 0>

                        <cfif moreThanOne neq 0> OR </cfif>
                        REFERENCE_NUMBER IN ( <CFQUERYPARAM CFSQLTYPE="CF_SQL_INTEGER" list="true" VALUE="#refNumList#"> )  

                        <cfset refNumList = thisRefNum>
                        <cfset moreThanOne = 1>
                    </cfif>
    
                    <cfif i eq ArrayLen(refNumAry)>
                        <cfif moreThanOne neq 0> OR </cfif>
                        REFERENCE_NUMBER IN ( <CFQUERYPARAM CFSQLTYPE="CF_SQL_INTEGER" list="true" VALUE="#refNumList#"> )  
                    </cfif>
    
                <cfelseif i eq ArrayLen(refNumAry)>

                    <cfset refNumList = listAppend(refNumList, thisRefNum)> 
                    <cfif moreThanOne neq 0> OR </cfif>
                    REFERENCE_NUMBER IN ( <CFQUERYPARAM CFSQLTYPE="CF_SQL_INTEGER" list="true" VALUE="#refNumList#"> )
                <cfelse>

                    <cfset refNumList = listAppend(refNumList, thisRefNum)> 
                </cfif>

                <cfset countItems = countItems + 1>            
            </cfloop>
            )            
            <cfif #SEARCHVAL# neq "">
                AND (
                    UPPER(REFERENCE_NUMBER) like UPPER(<cfqueryparam cfsqltype="CF_SQL_VARCHAR" value="%#SEARCHVAL#%" />)
                    OR UPPER(AUTHOR) like UPPER(<cfqueryparam cfsqltype="CF_SQL_VARCHAR" value="%#SEARCHVAL#%" />)
                    OR UPPER(TITLE) like UPPER(<cfqueryparam cfsqltype="CF_SQL_VARCHAR" value="%#SEARCHVAL#%" />)
                    OR UPPER(SOURCE) like UPPER(<cfqueryparam cfsqltype="CF_SQL_VARCHAR" value="%#SEARCHVAL#%" />)
                )
            </cfif>
        )
        WHERE rn BETWEEN <cfqueryparam value="#REFSTARTPOSPLUS1#" cfsqltype="CF_SQL_SMALLINT"> AND <cfqueryparam value="#REFENDPOS#" cfsqltype="CF_SQL_SMALLINT">
        ORDER BY rn

    </cfquery>
    
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>
            
    <cflog text="#RefQueryVars.sql#">
                    
</cfcatch>
</cftry>    
    
</cflock>
</cfprocessingdirective>
</cfoutput>
