
<CFLOCK TIMEOUT="30" throwontimeout="no" TYPE="readonly" scope="application">
    <CFSET thisRecordMax = duplicate(Application.RecordMax)>
    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>
</CFLOCK>


<cfif ExportQuery.RecordCount is 0>

    <div class="callout primary">
        <h5 class="title">Sorry</h5>
        <p>There were no results found for this search. Please refine your search.</p>
    </div>

<cfelseif ExportQuery.RecordCount gt thisRecordMax>

    <div class="callout alert">
        <h5 class="title">Warning</h5>
        <p>There were too many results found to display in a browser report format.  There is a limit of <cfoutput>#thisRecordMax#</cfoutput> records for a browser viewable report. Please refine your search.</p>
    </div>

<cfelse>
    <cfprocessingdirective suppressWhiteSpace = "Yes">
    <cfsetting enablecfoutputonly="Yes">
    
    <CFHEADER NAME="Content-Disposition" VALUE="attachment; filename=TerrestrialReport.txt">
    <CFCONTENT TYPE="text/plain">

    <cfset TerrestrialFieldList = "">
    <cfset indexList = "">
    <cfset count = 0>
    <cfif ArrayLen(TerrestrialOutputFields) is not 0>
        <CFLOOP index = "i" from = "1" to = "#ArrayLen(TerrestrialOutputFields)#">
            <cfloop index=j list="#TerrestrialOutputFields[i][1]#" delimiters=",">
                <cfloop index=k list="#j#" delimiters="|">
                    <cfset indexOf = ListFind(TerrestrialFieldList,"#trim(k)#")>
                    <cfif indexOf eq 0>
                        <!--- Excludes headings of contatenated full field display of each of these in favor of the meanOp/mean/minOp/min/maxOp/max display ---> 
                        <!--- 06/09/16 SPE - made this the same field list as Excel, from terrestrial_report_excel.cfm --->
                        <cfif trim(k) neq "Dose" and trim(k) neq "Temperature" and trim(k) neq "Application Frequency" and trim(k) neq "Effect Percent" and trim(k) neq "Chemical Purity" and trim(k) neq "Organism Age" and trim(k) neq "Effect Percent" and trim(k) neq "Significance Level" and trim(k) neq "Chemical Half Life" and trim(k) neq "Result Percent Lipid" and trim(k) neq "Intake Rate" and trim(k) neq "Exposure Sample Number" and trim(k) neq "Result Sample Number" and trim(k) neq "Organism Initial Weight" and trim(k) neq "Organism Initial Length" and trim(k) neq "Species Final Weight" and trim(k) neq "Result Percent Dry/Wet Weight" and trim(k) neq "Doses">
                            <cfset TerrestrialFieldList = Listappend(TerrestrialFieldList,trim(k))>
                            <cfif Find(" ",k)>
                                <cfoutput>"#k#"|</cfoutput>
                            <cfelse>
                                <cfoutput>#k#|</cfoutput>
                            </cfif>
                        </cfif>
                    <cfelse>
                        <cfset indexList = Listappend(indexList,count)>
                    </cfif>
                    <cfset count = count + 1>
                </cfloop>
            </cfloop>
        </CFLOOP>
        <cfoutput>#chr(13)##chr(10)#</cfoutput>
    </cfif>
    <cfset fieldsToInclude="TEST_PURITY,AGE,OBSERV_RESPONSE_MEAN,OBSERV_RESPONSE_MIN,OBSERV_RESPONSE_MAX,EXP_DURATION_MEAN_STD,EXP_DURATION_MIN_STD,EXP_DURATION_MAX_STD,EXPOSURE_MEAN,EXPOSURE_MIN,EXPOSURE_MAX,OBSERV_DURATION_MEAN_STD,OBSERV_DURATION_MIN_STD,OBSERV_DURATION_MAX_STD,OBSERV_DURATION_MEAN,OBSERV_DURATION_MIN,OBSERV_DURATION_MAX,STUDY_MEAN_STD,STUDY_MIN_STD,STUDY_MAX_STD,STUDY_MEAN,STUDY_MIN,STUDY_MAX,DRY_WEIGHT_PERCENT,PERCENT_LIPID,ORGANISM_NUMBER,DOSE_NUMBER,SAMPLE_NUMBER,DOSE_MEAN,DOSE_MIN,DOSE_MAX,DOSE_VALUE,APP_FREQ_VALUE,SOIL_TEXTURE_SA_MEAN,SOIL_TEXTURE_SA_MIN,SOIL_TEXTURE_SA_MAX,SOIL_TEXTURE_SI_MEAN,SOIL_TEXTURE_SI_MIN,SOIL_TEXTURE_SI_MAX,SOIL_TEXTURE_CL_MEAN,SOIL_TEXTURE_CL_MIN,SOIL_TEXTURE_CL_MAX,SOIL_ORG_MATTER_MEAN,SOIL_ORG_MATTER_MIN,SOIL_ORG_MATTER_MAX,SOIL_PH_MEAN,SOIL_PH_MIN,SOIL_PH_MAX,SOIL_MOISTURE_MEAN,SOIL_MOISTURE_MIN,SOIL_MOISTURE_MAX,SOIL_CEC_MEAN,SOIL_CEC_MIN,SOIL_CEC_MAX,MEASURED,WET_DRY,SIGNIFICANCE_LEVEL">
    <cfloop query="ExportQuery">
        <cfset testrecord = ExportQuery.TEST_NUMBER>
        <cfset count = 0>
        <cfif ArrayLen(TerrestrialOutputFields) is not 0>
            <CFLOOP index = "i" from = "1" to = "#ArrayLen(TerrestrialOutputFields)#">           
                <cfloop index =j list="#TerrestrialOutputFields[i][3]#" delimiters=",">
                    <cfif ListFind(indexList,"#count#") eq 0>
                        <cfif terrestrialOutputFields[i][1] is "Result Record Number">
                            <cfoutput>#ExportQuery.ResultRecordNumber#|</cfoutput>
                        <cfelse>
                            <!--- Excludes column contatenated full field display of each of these in favor of the meanOp/mean/minOp/min/maxOp/max display ---> 
                            <cfif trim(j) neq "DOSE" and trim(j) neq "TEMPERATURE" and trim(j) neq "APP_FREQ_VALUE" and trim(j) neq "EFFECT_PCT" and trim(j) neq "TEST_PURITY" and trim(j) neq "AGE" and trim(j) neq "AGE_DESC" and trim(j) neq "SIGNIFICANCE_LEVEL" and trim(j) neq "HALFLIFE" and trim(j) neq "INTAKE_RATE" and trim(j) neq "PERCENT_LIPID" and trim(j) neq "ORGANISM_NUMBER" and trim(j) neq "SAMPLE_NUMBER" and trim(j) neq "ORGANISM_INIT_WT" and trim(j) neq "ORGANISM_FINAL_WT" and trim(j) neq "ORGANISM_LENGTH" and trim(j) neq "ORGANISM_LENGTH_DESC" and trim(j) neq "DRY_WEIGHT_PERCENT" and trim(j) neq "DOSES">
                                <cfset colVal = replace(evaluate(j), "#Chr(13)##Chr(10)#", " ", "ALL")>
                                <cfoutput><cfif Find("-",colVal) neq 0 and left(trim(colVal),1) neq "-" AND ListFind(fieldsToInclude,j,",") neq 0>'</cfif><cfif j eq "/">&nbsp;<cfelseif right(j,1) eq "/">#replace(right(colVal,len(colVal)-1),"<BR>"," , ","ALL")#|<cfelse>#replace(colVal,"<BR>"," , ","ALL")#|</cfif></cfoutput>
                            </cfif>
                        </cfif>
                    </cfif>
                    <cfset count = count + 1>
                </cfloop>
            </CFLOOP>
            <cfoutput>#chr(13)##chr(10)#</cfoutput>
        </cfif>	
    </cfloop>
    </cfprocessingdirective>
</cfif>