<!---
 * =================================================================================================
 *                                  Template for Reporting
 * =================================================================================================
 * AUTHOR				: r.s.
 * FILENAME				: report.cfm
 * DESCRIPTION			: Main reporting component template for advanced query. SPE 11/22/05
 * PROCESSING			: First time called,
 * HISTORY				: 12/22/2002 - created file (r.s.)
 *						  01/02/2003 - modified comment structure (r.s.)
 *						  11/22/2005 - comments added for clarity (SPE)
 *
 * =================================================================================================
--->

<cfset cleanInputs = CreateObject("component", "cfc.input_sanitize")>
<cfset SearchFunc = CreateObject("component", "cfc.search_functions")>
<cfset OutFunc = CreateObject("component", "cfc.output_functions")>

<cfparam name="URL.sub" default="">  <!--- {aquire; terrestrial} SPE 11/22/05 --->
<cfparam name="URL.type" default="short">  <!--- {long; delimited; excel} SPE 11/22/05 --->
<cfparam name="URL.condensed" default="0">    

<cfparam name="FORM.txExposureDurationStd" default="">    
<cfparam name="FORM.txExposureDurationMin" default="">    
<cfparam name="FORM.txExposureDurationMax" default="">    
    
<cfset CONDENSED_EXCEL = false>
<cfif URL.condensed EQ "1">
    <cfset CONDENSED_EXCEL = true>
</cfif>


<!--- paging / sorting vars --->  
<cfparam name="FORM.sortfield" default="">       <!--- UI will pass this or default to col 1 on DT.  Exports will use the default value here  --->
<cfparam name="FORM.sortdir" default="">
<cfparam name="FORM.length" default="10000">   <!--- default is application max.  UI will pass page size, exports will not and will be capped at 10000 rows --->
<cfparam name="FORM.start" default="0">       <!--- offset position for query results.  UI will pass this, default to beginning.  Exports will have full range 0-10000 --->

<cfset validParam = cleanInputs.checkSearchAndRefFormInputAlphaNumeric("sortfield", FORM.sortfield)>
<cfset validParam = cleanInputs.checkSearchAndRefFormInputAlphaNumeric("sortdir", FORM.sortdir)>
<cfset validParam = cleanInputs.checkSearchAndRefFormInputNumeric("length", FORM.length)>
<cfset validParam = cleanInputs.checkSearchAndRefFormInputNumeric("start", FORM.start)>
<cfset validParam = cleanInputs.checkSearchAndRefFormInputNumeric("Starting_Publication_Year", FORM.Starting_Publication_Year)>
<cfset validParam = cleanInputs.checkSearchAndRefFormInputNumeric("Ending_Publication_Year", FORM.Ending_Publication_Year)>
    
<cfparam name="FORM.hdnTestFlag" default="">
<cfif FORM.hdnTestFlag eq "TEST">
    <cfset testSearch = true>
<cfelse>
    <cfset testSearch = false>
</cfif>

<cfif testSearch>
    
    <!--- DO NOT ACTUALLY SUBMIT --->
    
    <div>URL params:</div>
    <cfset keyList = structKeyList(url)>
    <cfloop list="#keyList#" index="key">
            <div><cfoutput>#key# = #url[key]#</cfoutput></div>
    </cfloop>

    <div>FORM params:</div>
    <cfset keyList = structKeyList(form)>
    <cfloop list="#keyList#" index="key">
        <cfif key neq "FIELDNAMES">
            <div><cfoutput>#key# = #form[key]#</cfoutput></div>
        </cfif>
    </cfloop>
    
<cfelse>
    
    <!--- ADD BACK IN AT LATER DATE
    <cfset SQLErrorOccurred = 0>
    ---->



    <cfset textDate = "#dateformat(now(),"ddd mmm d")#">
    <cfset timeDate = "#timeformat(now(), "HH:mm:ss")#">
    <cfset yearDate = "#dateformat(now(),"yyyy")#">
    <cfset generatedDate = "#textDate# #timeDate# #yearDate#">

    <!---  Arrays for formatting data to pass to query --->
    <cfset specGroup1Array=["cbTaxGroupAmph","cbTaxGroupInsect","cbTaxGroupMoll","cbTaxGroupBird","cbTaxGroupOthInv","cbTaxGroupRept","cbTaxGroupCrust","cbTaxGroupMam","cbTaxGroupWorm","cbTaxGroupFish","cbAllAnimals"]>
    <cfset specGroup2Array=["cbTaxGroupAlgae","cbTaxGroupMoss","cbTaxGroupFungi","cbTaxGroupFlower","cbAllPlants"]>
    <cfset chemGroup1Array=["cbAluminum","cbCopper","cbOrganotin","cbAntimony","cbArsenic","cbChromium","cbIron","cbSelenium","cbBarium","cbLead","cbSilver","cbBeryllium","cbManganese","cbMercury","cbVanadium","cbCadmium","cbNickel","cbZinc","cbCobalt","cbThallium"]>
    <cfset chemGroup2Array=["cbDDT","cbNitrosamines","cbPAH","cbDibenzofurans","cbPhthalate","cbPCB","cbGlycol","cbPerchlorates","cbPPCPs","cbStrobins","cbExplosives","cbNeonicotinoids","cbPFAS","cbConazoles","cbCyanide","cbCyanotoxins","cbMajorIons","cbPBDE"<!---,"cbNonylphenol"--->]>
    <cfset testResGroup1Array=["cbResultsGroupAC","cbResultsGroupACa","cbResultsGroup12","cbResultsGroup12a","cbResultsGroup12b","cbResultsGroupLL","cbResultsGroupLL10","cbResultsGroupLL50","cbResultsGroup13","cbResultsGroup13a","cbResultsGroup13b","cbResultsGroupEL","cbResultsGroupEL10","cbResultsGroupEL50","cbResultsGroup14","cbResultsGroup14a","cbResultsGroup14b","cbResultsGroupOption2","cbResultsGroupOption2a","cbResultsGroupLOELR","cbResultsGroupOption4","cbResultsGroupOption4a","cbResultsGroupNOELR","cbResultsGroupOption6","cbResultsGroupOption8","cbResultsGroupOption10","cbResultsGroupOption12","cbResultsGroupOption18"]>
    <cfset testResGroup2Array=["cbResultsGroup15","cbResultsGroup15a","cbResultsGroup16","cbResultsGroup16a"]>
    <cfset testResGroup3Array=["cbResultsGroup17","cbResultsGroup17a","cbResultsGroup17b","cbResultsGroup17c","cbResultsGroup18","cbResultsGroup19","cbResultsIRxxGroup","cbResultsGroup21","cbResultsGroup22","cbResultsGroup23"]>
    <cfset testResGroup4Array=["cbResultsGroupOption0"]>
    <cfset testResGroup5Array=["cbResultsGroup1","cbResultsGroup2","cbResultsGroup2a","cbResultsGroup2b","cbResultsGroup2c","cbResultsGroup3","cbResultsGroup3a","cbResultsGroup3b","cbResultsGroup3c","cbResultsGroup4","cbResultsGroup4a","cbResultsGroup4b","cbResultsGroup4c","cbResultsGroup5","cbResultsGroup5a","cbResultsGroup5b","cbResultsGroup5c","cbResultsGroup6","cbResultsGroup7","cbResultsGroup7a","cbResultsGroup7b","cbResultsGroup7c","cbResultsGroup7d","cbResultsGroup8","cbResultsGroup9","cbResultsGroup10","cbResultsGroup11","cbExcludePostExpMeas"]>
    <cfset testCondGroup1Array=["cbtlLab","cbtlAllFld","cbtlFldA","cbtlFldN","cbtlFldU","cbtlNR"]>
    <cfset testCondGroup2Array=["cbemwFresh","cbemwSalt","cbemwUnknown","cbemsArtificial","cbemsHumus","cbemsLitter","cbemsManure","cbemsMineral","cbemsMixture","cbemsNatural","cbemsNR","cbemNoSub_strate","cbemHydroponic","cbemOther","cbemNR"]>
    <cfset testCondGroup3Array=["cbetDiet","cbetInjection","cbetTopical","cbetInvitro","cbetNR","cbetInhalation","cbetEnv","cbetMult","cbetFlow","cbetLotic","cbetIntermit","cbetRenewal","cbetLeaching","cbetStatic","cbetLentic","cbetTidal"]>
    <cfset testCondGroup4Array=["cbmcaMeasured","cbmcaUnmeasured","cbmcaNR"]>
    <cfset testCondGroup5Array=["cbctAllControls","cbctConcurrent","cbctMultipleentries","cbctBaseline","cbctOther","cbctSolvent","cbctPositive","cbctUndefined","cbctInsufficient","cbctMultiple","cbctSatisfactory","cbctUnsatisfactory","cbctControlNotReported","cbctNotReported"]>
    <cfset indCompGroup1Array=["cbFHMinnow","cbOPP","cbDutch","cbFrench","cbGerman","cbRussian","cbUSGS"]>


    <cfset chemicalgroup1 = SearchFunc.concatSearchValues( chemGroup1Array, "|" ) />
    <cfset chemicalgroup2 = SearchFunc.concatSearchValues( chemGroup2Array, "|" ) />
    <cfset speciesgroup1 = SearchFunc.concatSearchValues( specGroup1Array, "|" ) />
    <cfset speciesgroup2 = SearchFunc.concatSearchValues( specGroup2Array, "|" ) />

    <cfset standardTest = false>
    <cfset endangered = false>
    <cfset invasive = false>

    <cfif isdefined("FORM.cbStandardTest")>
        <cfset standardTest = true>
    </cfif>

    <cfif isdefined("FORM.cbEndangered")>
        <cfset endangered = true>
    </cfif>

    <cfif isdefined("FORM.cbInvasive")>
        <cfset invasive = true>
    </cfif>	

    <cfset testresultsgroup1 = SearchFunc.concatSearchNames( testResGroup1Array, "|" ) />
    <cfset testresultsgroup2 = SearchFunc.concatSearchNames( testResGroup2Array, "|" ) />
    <cfset testresultsgroup3 = SearchFunc.concatSearchNames( testResGroup3Array, "|" ) />
    <cfset testresultsgroup4 = SearchFunc.concatSearchNames( testResGroup4Array, "|" ) />
    <cfset testresultsgroup5 = SearchFunc.concatSearchNames( testResGroup5Array, "|" ) />
    <cfset testconditionsgroup1 = SearchFunc.concatSearchNames( testCondGroup1Array, "|" ) />
    <cfset testconditionsgroup2 = SearchFunc.concatSearchNames( testCondGroup2Array, "|" ) />
    <cfset testconditionsgroup3 = SearchFunc.concatSearchNames( testCondGroup3Array, "|" ) />
    <cfset testconditionsgroup4 = SearchFunc.concatSearchNames( testCondGroup4Array, "|" ) />
    <cfset testconditionsgroup5 = SearchFunc.concatSearchNames( testCondGroup5Array, "|" ) />
    <cfset ICDSETSGROUP1 = SearchFunc.concatSearchNames( indCompGroup1Array, "|" ) />       

    <cfset recentPubDatesValues = "">        
    <cfloop index="updDate" array="#Application.pubDateAry#">    
        <cfset inputName = listGetAt(updDate,3,';')>        
        <cfif isdefined("form." & inputName)>            
            <cfset recentPubDatesValues = ListAppend(recentPubDatesValues, "#form[inputName]#", "|")>
        </cfif>
    </cfloop>

    <cfif isdefined("FORM.txAdvancedSpecEntries")>
    <cfset speciesTextAreaWords = SearchFunc.textAreaParse( #FORM.txAdvancedSpecEntries#, "Species", "Words", "|", "" ) />
    <cfset speciesTextAreaNumbers = SearchFunc.textAreaParse( #FORM.txAdvancedSpecEntries#, "Species", "Numbers", "|", "" ) />
    </cfif>
    <cfif isdefined("FORM.txAdvancedChemicalEntries")>
    <cfset chemicalTextAreaWords = SearchFunc.textAreaParse( #FORM.txAdvancedChemicalEntries#, "Chemicals", "Words", "|", "" ) />
    <cfset chemicalTextAreaNumbers = SearchFunc.textAreaParse( #FORM.txAdvancedChemicalEntries#, "Chemicals", "Numbers", "|", "" ) />
    </cfif>
    <cfif isdefined("FORM.txAdvancedEffectEntries")>
    <cfset effectTextAreaWords = SearchFunc.textAreaParse( #FORM.txAdvancedEffectEntries#, "Effects", "Words", "|", "" ) />
    </cfif>

    <!--- Exposure Duration parameters --->
    <cfif FORM.txExposureDurationStd neq "">

        <cfset testExposureDurationStd = "#FORM.txExposureDurationStd#">
        <cfset testExposureDurationMin = "">
        <cfset testExposureDurationMax = "">

    <cfelseif FORM.txExposureDurationMin neq "" OR FORM.txExposureDurationMax neq "">

        <cfset testExposureDurationStd = "">

        <cfif isdefined("FORM.txExposureDurationMin")>
            <cfset testExposureDurationMin = "#FORM.txExposureDurationMin#">
        <cfelse>
            <cfset testExposureDurationMin = "">
        </cfif>

        <cfif isdefined("FORM.txExposureDurationMax")>
            <cfset testExposureDurationMax = "#FORM.txExposureDurationMax#">
        <cfelse>
            <cfset testExposureDurationMax = "">
        </cfif>

    <cfelse>

        <cfset testExposureDurationStd = "">
        <cfset testExposureDurationMin = "">
        <cfset testExposureDurationMax = "">

    </cfif>

    <cfset publicationsTextAreaWords = "">
    <cfset publicationsTextAreaNumbers = "">
    <cfif isdefined("FORM.txAdvancedPublicationsEntries")>
    <cfset publicationsTextAreaWords = SearchFunc.textAreaParse( #FORM.txAdvancedPublicationsEntries#, "Pubs", "Words", "|", "" ) />
    <cfset publicationsTextAreaNumbers = SearchFunc.textAreaParse( #FORM.txAdvancedPublicationsEntries#, "Pubs", "Numbers", "|", "" ) />
    </cfif>
    <cfif isdefined("FORM.txAdvancedAuthorsEntries")>
    <cfset publicationsTextAreaWords = SearchFunc.textAreaParse( #FORM.txAdvancedAuthorsEntries#, "Pubs", "Words", "|", "#publicationsTextAreaWords#" ) />
    <cfset publicationsTextAreaNumbers = SearchFunc.textAreaParse( #FORM.txAdvancedAuthorsEntries#, "Pubs", "Numbers", "|", "#publicationsTextAreaNumbers#" ) />
    </cfif>


    <cfparam name="form.RBCHEMSEARCHTYPE" default="CONTAINS">
    <cfparam name="form.RBSPECSEARCHTYPE" default="CONTAINS">
    <cfparam name="form.RBEFFECTSEARCHTYPE" default="CONTAINS">
    <cfparam name="form.rbPubFieldType" default="REFERENCE">
    <cfparam name="form.cbIncludeCodeDesc" default="">

    <cfset SORTFIELD = OutFunc.generateOrderByClause( FORM.sortfield, FORM.sortdir )>
    <cfset PAGESIZE = FORM.length>
    <cfset STARTPOS = FORM.start>
	<cfset STARTPOSPLUS1 = STARTPOS + 1>
	<cfset ENDPOS = PAGESIZE + STARTPOS>

    <!--- jquery datatable specific --->
    <cfparam name ="FORM.draw" default="">
    <cfset RETURNDRAW = FORM.draw>
    
    <cfswitch expression="#url.sub#">
        <cfcase value="aquire">

            <cfif SORTFIELD eq "">
                 <!--- default sort order for aquatic --->
                <cfset sortorder1 = "AQ.TEST_CAS || AQ.CHEM_PRIMARY_NAME">		<!--- CAS Number | Chemical Name --->
                <cfset sortorder2 = "AQ.SPECIES_LIST_DESC">                         <!--- Species Group --->
                <cfset sortorder3 = "AQ.ENDPOINT_SORT || AQ.BCF_SORT">		<!--- Endpoint | BCF Value --->
                <cfset orderBy = "#replace(SORTORDER1,"||",",","ALL")#, #replace(SORTORDER2,"||",",","ALL")#, #replace(SORTORDER3,"||",",","ALL")#">

                <cfset SORTFIELD = preservesinglequotes(orderBy)>  
            <cfelse>
                <cfset sortorder1 = "">
                <cfset sortorder2 = "">
                <cfset sortorder3 = "">
            </cfif>

            <cfinclude template="report/aquire_field_structure.cfm">

            <cfinclude template="report/queries/aquaticQry.cfm">

            <cfif qryOptionsSelected eq 1>

                <cfif tooManyEffects EQ 1 OR tooManyChem EQ 1 OR tooManySpecies EQ 1>

                    <cfinclude template="report/aquire_search_DT_json.cfm">

                <cfelse>

                    <cfswitch expression="#URL.type#">
                        <cfcase value="delimited">
                            <cfinclude template="report/aquire_search_delimited.cfm">
                        </cfcase>
                        <cfcase value="excel">
                            <cfinclude template="report/aquire_search_excel_native.cfm">
                        </cfcase>
                        <cfcase value="ssd">
                            <cfinclude template="report/aquire_search_ssd.cfm">
                        </cfcase>
                        <cfdefaultcase>
                            <cfinclude template="report/aquire_search_DT_json.cfm">
                        </cfdefaultcase>
                    </cfswitch>

                </cfif>

            <cfelse>

                <div class="callout alert">
                    <h5 class="title">Warning</h5>
                    <p>There were no query selections made. Please select or enter restricting query parameters.</p>
                </div>

            </cfif>

        </cfcase>

        <cfcase value="terrestrial">

            <cfif SORTFIELD eq "">
                 <!--- default sort order for aquatic --->
                <cfset sortorder1 = "VW.TEST_CAS || VW.CHEM_PRIMARY_NAME">		<!--- CAS Number | Chemical Name --->
                <cfset sortorder2 = "VW.LATIN_NAME">                         <!--- Species Group --->
                <cfset sortorder3 = "VW.ENDPOINT">		<!--- Endpoint | BCF Value --->
                <cfset orderBy = "#replace(SORTORDER1,"||",",","ALL")#, #replace(SORTORDER2,"||",",","ALL")#, #replace(SORTORDER3,"||",",","ALL")#">

                <cfset SORTFIELD = preservesinglequotes(orderBy)>  
            <cfelse>
                <cfset sortorder1 = "">
                <cfset sortorder2 = "">
                <cfset sortorder3 = "">
            </cfif> 

            <cfinclude template="report/terrestrial_field_structure.cfm">

            <cfinclude template="report/queries/terrestrialQry.cfm">

            <cfif qryOptionsSelected eq 1>

                <cfif tooManyEffects EQ 1 OR tooManyChem EQ 1 OR tooManySpecies EQ 1>
                    
                    <cfinclude template="report/terr_search_DT_json.cfm">

                <cfelse>

                    <cfswitch expression="#URL.type#">
                        <cfcase value="delimited">
                            <cfinclude template="report/terr_search_delimited.cfm">
                        </cfcase>
                        <cfcase value="excel">
                            <cfinclude template="report/terr_search_excel_native.cfm">
                        </cfcase>
                        <cfcase value="ssd">
                            <cfinclude template="report/terr_search_ssd.cfm">
                        </cfcase>
                        <cfdefaultcase>
                            <cfinclude template="report/terr_search_DT_json.cfm">
                        </cfdefaultcase>
                    </cfswitch>

                </cfif>

            <cfelse>

                <div class="callout alert">
                    <h5 class="title">Warning</h5>
                    <p>There were no query selections made. Please select or enter restricting query parameters.</p>
                </div>
            </cfif>

        </cfcase>

        <cfdefaultcase>

            <div>Search was neither aquatic nor terrestrial.</div>

        </cfdefaultcase>

    </cfswitch>
        
</cfif>

