    
<!---    

    EXPECTED VARIABLES FROM DB/DATA TEMPLATE:

        AppendixCodesQuery - a coldfusion query object with this name.  Needs to have columns labeled "THISCODE" and "THISDESC".
                                Designed to work with code/description style tables.

    EXPECTED VARIABLES FROM HANDLER:

        OUTPUTFORMAT - JSON for web, CSV, EXCEL (possibly others in future) for exports
        COL1_NAME - override for standard column 1 header name
        COL2_NAME - override for standard column 2 header name
        COL3_NAME - override for standard column 3 header name

--->

<cfif URL.export EQ "1">
    <cfset rowCount = "">
<cfelse>
    <cfset rowCount = AppendixCodesQuery.TotalRows>
</cfif>
    
<cfif rowCount eq "">
    <cfset rowCount = 0>
</cfif>


<cfif COL1_NAME eq "">
    <cfset COL1_NAME = "TERM">
</cfif>

<cfif COL2_NAME eq "">
    <cfset COL2_NAME = "DESCRIPTION">
</cfif>

<cfif COL3_NAME eq "">
    <cfset COL3_NAME = "DEFINITION">
</cfif>

<cfset columnDefs = arrayNew(2)>
    
<cfset col1Array = arrayNew(1)>
<cfset ArrayAppend(col1Array, COL1_NAME)>
<cfset ArrayAppend(col1Array, "code")>
<cfset ArrayAppend(columnDefs, col1Array)>
    
<cfset col2Array = arrayNew(1)>
<cfset ArrayAppend(col2Array, COL2_NAME)>
<cfset ArrayAppend(col2Array, "description")>
<cfset ArrayAppend(columnDefs, col2Array)>

<cfif useLongDefinition EQ "1">
    <cfset col3Array = arrayNew(1)>
    <cfset ArrayAppend(col3Array, COL3_NAME)>
    <cfset ArrayAppend(col3Array, "long_description")>
    <cfset ArrayAppend(columnDefs, col3Array)>
</cfif>
       
    
<cfset resultsArray = arrayNew(2)>
<cfloop query="AppendixCodesQuery">
    <cfset rowData = arrayNew(1)>
    
    <cfset col1Str = AppendixCodesQuery.THISCODE>
    <cfset col1Str = OutFunc.cleanStringForDataTable(col1Str, OUTPUTFORMAT)>
    <cfset ArrayAppend(rowData, col1Str)>

    <cfset col2Str = AppendixCodesQuery.THISDESC>
    <cfset col2Str = OutFunc.cleanStringForDataTable(col2Str, OUTPUTFORMAT)> 
    <cfset ArrayAppend(rowData, col2Str)>

    <cfif useLongDefinition EQ "1">
        <cfset col3Str = AppendixCodesQuery.THISLONGDESC>
        <cfset col3Str = OutFunc.cleanStringForDataTable(col3Str, OUTPUTFORMAT)> 
        <cfset ArrayAppend(rowData, col3Str)>
    </cfif>
           
    <cfset ArrayAppend(resultsArray, rowData)>
</cfloop>


<cfinclude template="output_router.cfm">