
<cfset OutFunc = CreateObject("component", "cfc.output_functions")>
    
<!---    

    EXPECTED VARIABLES FROM DB/DATA TEMPLATE:

        AppendixCodesQuery - a coldfusion query object with this name.

--->
       
<cfset group_effect_map = structNew()>
<cfset current_value = "">
    
<cfloop query="AppendixCodesQuery">    
    <cfset this_key_str = AppendixCodesQuery.THISGROUPCODE>
        
    <cfif structKeyExists(group_effect_map, this_key_str)>
        <cfset current_value = group_effect_map[this_key_str]>
        <cfset current_value["subgroups"] = current_value["subgroups"] & "|" & AppendixCodesQuery.THISCODE & ";" & AppendixCodesQuery.THISDESC>
    <cfelse>
        <cfset current_value = structNew()>
        <cfset current_value["description"] = AppendixCodesQuery.THISGROUPDESC>
        <cfset current_value["subgroups"] = AppendixCodesQuery.THISCODE & ";" & AppendixCodesQuery.THISDESC>
    </cfif>

    <cfset group_effect_map[this_key_str] = current_value>
</cfloop>
    

<cfset jsonString = "">
    
<cfset keyArray = StructKeyArray(group_effect_map)>
<cfset ArraySort(keyArray, "text", "asc")>
        
<cfloop array="#keyArray#" index="outerGroupKey">
    
    <cfset keyStr = OutFunc.cleanStringForDataTable(outerGroupKey, "JSON")>
        
    <cfset value = group_effect_map[outerGroupKey]>        
    <cfset descStr = OutFunc.cleanStringForDataTable(value["description"], "JSON")>   
    <cfset valueStr = OutFunc.cleanStringForDataTable(value["subgroups"], "JSON")>    
    
    <cfset rowData = '{"key":#keyStr#,"description":#descStr#,"value":#valueStr#}'>
           
    <cfset jsonString = ListAppend(jsonString, rowData)>
</cfloop>
    
<cfset jsonString = "[" & jsonString & "]">

<cfprocessingdirective suppressWhiteSpace = "Yes">
<cfoutput>
    #jsonString#
</cfoutput>
</cfprocessingdirective>
