
<cfif isDefined("URL.searchstr") AND URL.searchstr NEQ "">
    <cfset searchClauseValue = LCase(URL.searchstr)>
<cfelse>
    <cfset searchClauseValue = "">
</cfif>


<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cftry>    

    <cfquery name="AppendixCodesQuery" datasource="#application.datasource#" dbtype="Oracle80" timeout="300" result="AppendixCodesQueryVars">
        
        SELECT * FROM (                
            SELECT /*+ first_rows(#PAGESIZE#) */            
                <!---DISTINCT---> 
                mc.code as CODE, mc.description as DESCRIPTION, mc.long_description as LONG_DESCRIPTION, decode(mc.usage_water_yn, 'Y', 'Aquatic', 'Terrestrial') as HABITAT_TYPE, <!--- --+ ORDERED --->
                row_number() over (order by #PreserveSingleQuotes(SORTFIELD)#) rn,
                COUNT(*) OVER () TotalRows
            FROM
                media_type_codes mc
            WHERE mc.code != 'NC'
            
        <cfif whereClause NEQ "">
            AND #PreserveSingleQuotes(whereClause)#
        </cfif>
            
        <cfif searchClauseValue NEQ "">
            AND (lower(mc.code) like <CFQUERYPARAM VALUE="%#searchClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">
            OR lower(mc.description) like <CFQUERYPARAM VALUE="%#searchClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">
            OR lower(mc.long_description) like <CFQUERYPARAM VALUE="%#searchClauseValue#%" CFSQLTYPE="CF_SQL_VARCHAR">)
        </cfif>
                    
        )
        WHERE rn BETWEEN <cfqueryparam value="#STARTPOSPLUS1#" cfsqltype="CF_SQL_SMALLINT"> AND <cfqueryparam value="#ENDPOS#" cfsqltype="CF_SQL_SMALLINT">
        ORDER BY rn

    </cfquery>
    
    <!---<cflog text ="#AppendixCodesQuery.sql#">--->
    <!---<cflog text ="#ArrayToList(AppendixCodesQueryVars.sqlparameters)#">--->
    
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>

<!--- ADD BACK IN AT LATER DATE			
    <cfset SQLErrorOccurred = 1>
--->

    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>

    <cfif thisInternalOnly eq 1>
        <cfinclude template="outputError.cfm">
    <cfelse>
        <cfinclude template="emailError.cfm">
    </cfif>

    <cfif errorDetail eq "[Macromedia][Oracle JDBC Driver]Execution timeout expired.">
        <cfinclude template="timeout_error.cfm">
    <cfelse>
        <cfinclude template="db_error.cfm">
    </cfif>
                    
</cfcatch>
</cftry>
</cflock>

