<cfset GenFunc = CreateObject("component", "cfc.generic_functions")>

<cfset extraIdField = "''">

<cfif URL.category eq "Chemical">
	<cfset value_field = "v.cas_number">
	<cfset desc_field = "v.epa_chem_substance_name || ' - ' || v.cas_number">
	<cfset sort_field = "v.epa_chem_substance_name">
	<cfset order_by_fields = "v.epa_chem_substance_name">
	<cfset extraIdField = "v.dtxsid">
<cfelseif URL.category eq "Class">
	<cfset value_field = "v.class">
	<cfset desc_field = "v.class">
	<cfset sort_field = "v.class">
	<cfset order_by_fields = "v.class">
<cfelseif URL.category eq "TaxOrder">
	<cfset value_field = "v.tax_order">
	<cfset desc_field = "v.tax_order">
	<cfset sort_field = "v.tax_order">
	<cfset order_by_fields = "v.tax_order">
<cfelseif URL.category eq "Genus">
	<cfset value_field = "v.genus">
	<cfset desc_field = "v.genus">
	<cfset sort_field = "v.genus">
	<cfset order_by_fields = "v.genus">
<cfelseif URL.category eq "Family">
	<cfset value_field = "v.family">
	<cfset desc_field = "v.family">
	<cfset sort_field = "v.family">
	<cfset order_by_fields = "v.family">
<cfelseif URL.category eq "Species">
	<cfset value_field = "v.species_number">
	<cfset desc_field = "v.latin_name || ' (' || v.common_name || ')'">
	<cfset sort_field = "v.latin_name">
	<cfset order_by_fields = "v.latin_name">
	<cfset extraIdField = "v.ncbi_taxid">
<cfelseif URL.category eq "Publications">
	<cfset value_field = "v.ecoref_number">
	<cfset desc_field = "'##' || v.ecoref_number || '. ' || NVL(SUBSTR(f.author, 0, INSTR(f.author, ',')-1), f.author) || '. ' || v.publication_year">
	<cfset sort_field = "v.ecoref_number">
	<cfset order_by_fields = "v.ecoref_number">
<cfelseif URL.category eq "Effect">
	<cfset value_field = "v.measurement">
	<cfset desc_field = "v.measurement_desc">
	<cfset sort_field = "''">
	<cfset order_by_fields = "v.measurement_desc">
<cfelseif URL.category eq "Endpoint">
	<cfset value_field = "v.endpoint">
	<cfset desc_field = "v.endpoint">
	<cfset sort_field = "''">
	<cfset order_by_fields = "v.endpoint">
<cfelseif URL.category eq "ObsDuration">
	<cfset value_field = "CASE WHEN NOT v.obs_duration_std is null AND NOT v.obs_duration_std = 'NR' THEN to_number(v.obs_duration_std) ELSE -1 END">
	<cfset desc_field = "CASE WHEN NOT v.obs_duration_std is null AND NOT v.obs_duration_std = 'NR' THEN to_number(v.obs_duration_std) ELSE -1 END">
	<cfset sort_field = "CASE WHEN NOT v.obs_duration_std is null AND NOT v.obs_duration_std = 'NR' THEN to_number(v.obs_duration_std) ELSE -1 END">
	<cfset order_by_fields = "CASE WHEN NOT v.obs_duration_std is null AND NOT v.obs_duration_std = 'NR' THEN to_number(v.obs_duration_std) ELSE -1 END">
</cfif>

<cfquery name="OptionQuery" datasource="#application.datasource#" dbtype="Oracle80" cachedWithin="#CreateTimeSpan(0,0,5,0)#" result="optionsAddlQueryVars">
	SELECT DISTINCT #PreserveSingleQuotes(value_field)# as SEL_VALUE, #PreserveSingleQuotes(desc_field)# as SEL_DESC, #PreserveSingleQuotes(sort_field)# as SORTFIELD, #extraIdField# as EXTRAID_VALUE
	FROM #view_name# v
	<!--- pub only --->
<cfif URL.category eq "Publications">
    LEFT JOIN references f ON f.reference_number = v.ecoref_number
</cfif>
    <!--- end pub only --->
	WHERE 1=1

	<!---
		this refers to the original group of ecorefs from EP, if applicable.  we always want to filter by these if there is a value,
		regardless of whether there is further filtering by other user inputs (ie. author/title below)
	 --->
	<cfif IN_origreflist neq "">
		<cfif ListLen(IN_origreflist) LTE 1000>
			AND v.ecoref_number IN (<CFQUERYPARAM VALUE="#IN_origreflist#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelse>
			<cfset arrayOfLists = GenFunc.splitListToSublists(IN_origreflist, 1000)>
			<cfif ArrayLen(arrayOfLists) GTE 1>
			AND (
				<cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
					<cfset thisSubList = arrayOfLists[i]>
					<cfif i GT 1> OR </cfif>                            
					v.ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
				</cfloop>
			)
			</cfif>
		</cfif>
	</cfif>

	<!--- for author / title --->
	<cfif IN_ecoref neq "All">
		<cfif ListLen(IN_ecoref) LTE 1000>
			AND v.ecoref_number IN (<CFQUERYPARAM VALUE="#IN_ecoref#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelse>
			<cfset arrayOfLists = GenFunc.splitListToSublists(IN_ecoref, 1000)>
			<cfif ArrayLen(arrayOfLists) GTE 1>
			AND (
				<cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
					<cfset thisSubList = arrayOfLists[i]>
					<cfif i GT 1> OR </cfif>                            
					v.ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
				</cfloop>
			)
			</cfif>
		</cfif>
	</cfif>
	
	<!--- check group selectors --->
	<cfif IN_chemGroupId neq "All">
		<cfif IN_chemGroupId eq "99" AND IN_casList neq "">
			<cfif len(IN_casList)>                
                <cfif ListLen(IN_casList) LTE 1000>
                    AND v.cas_number IN (<CFQUERYPARAM VALUE="#IN_casList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                <cfelse>
                    <cfset arrayOfLists = GenFunc.splitListToSublists(IN_casList, 1000)>
                    <cfif ArrayLen(arrayOfLists) GTE 1>
                    AND (
                        <cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
                            <cfset thisSubList = arrayOfLists[i]>
                            <cfif i GT 1> OR </cfif>                            
                            v.cas_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                        </cfloop>
                    )
                    </cfif>
                </cfif>
            </cfif>
		<cfelseif IN_chemGroupId eq "99" AND IN_dtsxIdList neq "">
			AND v.dtxsid IN (<CFQUERYPARAM VALUE="#IN_dtsxIdList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
		<cfelseif IN_chemGroupId eq "99">
			<!--- do nothing - this is handled with chemicals below --->
		<cfelse>
            AND v.cas_number IN (
                SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
            )
		</cfif>
	</cfif>
		
	<cfif IN_specGroupId neq "All">
		<cfif IN_specGroupId eq "99" AND IN_ncbiList neq "">
			AND ncbi_taxid IN (<CFQUERYPARAM VALUE="#IN_ncbiList#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		<cfelseif IN_specGroupId eq "99">
			<!--- do nothing - this is handled with species below --->
		<cfelse>
			AND species_list_id in (<CFQUERYPARAM VALUE="#IN_specGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		</cfif>
	</cfif>
		
	<cfif IN_effGroupId neq "All" AND IN_effGroupId neq "99">
	  	<cfif ListLen(IN_effGroupId, ",") gt 1>
			AND (
				<cfloop from="1" to="#ListLen(IN_effGroupId)#" index="idx">
					<cfif idx neq 1> OR </cfif>
					(effect LIKE <CFQUERYPARAM VALUE="#ListGetAt(IN_effGroupId, idx)#%" CFSQLTYPE="CF_SQL_VARCHAR">)
				</cfloop>
			)
	  	<cfelse>
			AND effect LIKE <CFQUERYPARAM VALUE="#IN_effGroupId#%" CFSQLTYPE="CF_SQL_VARCHAR">
	  	</cfif>
	</cfif>	
	
	<!--- check additional filters --->
	<cfif IN_chemListId neq "All">
		AND v.cas_number IN (
			SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		)
	</cfif>
	
	<cfif IN_casId neq "All">
		AND v.cas_number IN (<CFQUERYPARAM VALUE="#IN_casId#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
	</cfif>			
	
	<cfif IN_class neq "All">
		AND v.class IN (<CFQUERYPARAM VALUE="#IN_class#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>		
	
	<cfif IN_taxOrder neq "All">
		AND v.tax_order IN (<CFQUERYPARAM VALUE="#IN_taxOrder#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>	
	
	<cfif IN_genus neq "All">
		AND v.genus IN (<CFQUERYPARAM VALUE="#IN_genus#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_family neq "All">
		AND v.family IN (<CFQUERYPARAM VALUE="#IN_family#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_speciesListId neq "All">
		AND v.species_list_id in (<CFQUERYPARAM VALUE="#IN_speciesListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
	</cfif>	
	
	<cfif IN_speciesId neq "All">
		AND v.species_number IN (<CFQUERYPARAM VALUE="#IN_speciesId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
	</cfif>
	
	<cfif IN_special neq "All">
		<cfset loop = 0>
		AND (
		<cfloop index="thisSpecInt" list="#IN_special#" delimiters=",">
			<cfif loop gt 0> OR </cfif>
			 (#thisSpecInt# = 'Y')
			 <cfset loop = loop + 1>
		</cfloop>
		)
	</cfif>
	
	<cfif IN_effectId neq "All">
		AND v.effect IN (<CFQUERYPARAM VALUE="#IN_effectId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_measurementId neq "All">
		AND v.measurement IN (<CFQUERYPARAM VALUE="#IN_measurementId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
                
	<!--- custom effects / measurement groups --->
	<cfif concatCustEffMeasList neq "All">
		AND CONCAT(v.effect, v.measurement) IN (<CFQUERYPARAM VALUE="#concatCustEffMeasList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_endpointId neq "All">
		AND v.endpoint IN (<CFQUERYPARAM VALUE="#IN_endpointId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>

	<!--- WE ONLY WANT TO GIVE OPTIONS WHEN THE DUR UNIT IS 'Days' --->
	<cfif URL.category eq "ObsDuration">
		AND obs_duration_unit_std = 'd'
	</cfif>

        <!--- DURATION LOGIC HERE (v.) --->
	<cfinclude template="duration_logic_sql.cfm">
	
	<cfif IN_habitat neq "All">
		AND v.habitat IN (<CFQUERYPARAM VALUE="#IN_habitat#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
		AND v.publication_year between <CFQUERYPARAM VALUE="#IN_pubYearMin#" CFSQLTYPE="CF_SQL_VARCHAR"> AND <CFQUERYPARAM VALUE="#IN_pubYearMax#" CFSQLTYPE="CF_SQL_VARCHAR">
		
		<!--- special interest groups are no longer determined by species group, so include this to make sure not to return any of these items matching species_list_id between 13-15 --->
                <!--- algae/moss/fungi split into 3 groups so exclude the old combined group as well (11) --->
		AND (v.species_list_id IS NULL OR v.species_list_id NOT IN (11,13,14,15))
                <!--- do not include 'NER' effect group --->
		AND (v.effect IS NULL OR v.effect NOT IN ('NER'))
                <!--- do not include measurement 'NRNR' --->
		AND (v.measurement IS NULL OR v.measurement NOT IN ('NRNR'))

	ORDER BY #PreserveSingleQuotes(order_by_fields)#	
</cfquery>
    
<!--- <cflog text ="#optionsAddlQueryVars.sql#"> --->
<!--- <cflog text ="#ArrayToList(optionsAddlQueryVars.sqlparameters)#"> --->


	<option value="All" class="default">All</option>
<cfif URL.category eq "Endpoint">
	<option value="LOEC,LOEL,NOEC,NOEL" class="grouped">LOEC/LOEL, NOEC/NOEL</option>
</cfif>
	<option value="--" disabled>------------------</option>

<cfoutput query="OptionQuery">

  <cfif #SEL_DESC# neq "" AND #SEL_VALUE# neq "">

	<cfset selStr = "">
	<cfset selUIval = "">
	<cfset comparisonVal = #SEL_VALUE#>
  
	<cfif URL.category eq "Chemical">
	
		<cfif IN_chemGroupId eq "99" AND IN_casList neq "">		
			<cfset selUIval = IN_casList>	
		<cfelseif IN_chemGroupId eq "99" AND IN_dtsxIdList neq "">
			<cfset selUIval = IN_dtsxIdList>	
			<cfset comparisonVal = #EXTRAID_VALUE#>		
		<cfelse>		
			<cfset selUIval = IN_casId>		
		</cfif>
		
	<cfelseif URL.category eq "Class">
	
		<cfset selUIval = IN_class>
		
	<cfelseif URL.category eq "TaxOrder">
	
		<cfset selUIval = IN_taxOrder>
		
	<cfelseif URL.category eq "Genus">
	
		<cfset selUIval = IN_genus>

	<cfelseif URL.category eq "Family">
	
		<cfset selUIval = IN_family>
	
	<cfelseif URL.category eq "Species">
	
		<cfif IN_specGroupId eq "99" AND IN_ncbiList neq "">		
			<cfset selUIval = IN_ncbiList>	
			<cfset comparisonVal = #EXTRAID_VALUE#>	
		<cfelse>		
			<cfset selUIval = IN_speciesId>		
		</cfif>
	
	<cfelseif URL.category eq "Publications">

		<cfif IN_ecoref eq "All">
			<cfset selUIval = IN_origreflist>
		<cfelse>
			<cfset selUIval = IN_ecoref>
		</cfif>
	
	<cfelseif URL.category eq "Effect">
	
		<cfset selUIval = IN_measurementId>
	
	<cfelseif URL.category eq "Endpoint">
	
		<cfset selUIval = IN_endpointId>
	
	<cfelseif URL.category eq "ObsDuration">
	
		<cfset selUIval = IN_obsDuration>
	
	</cfif>
	
	<cfif ListFind(selUIval, comparisonVal) gt 0>
		<cfset selStr = " selected">
	</cfif>
	  
	<cfif URL.category eq "ObsDuration">
		<cfif #SEL_VALUE# neq -1>
			<option value="#SEL_VALUE#"#selStr#>#SEL_DESC#</option>
		</cfif>
	<cfelse>
		<option value="#SEL_VALUE#"#selStr#>#SEL_DESC#</option>
	</cfif>
  </cfif>	
</cfoutput>

