
<cfinclude template="explore_param_check.cfm" />

<cfquery name="CountQuery" datasource="#application.datasource#" cachedWithin="#CreateTimeSpan(0,0,5,0)#">
	SELECT
	  SUM(oq.cnt_distinct) as cnt_allrecs,
	  COUNT(oq.cnt_distinct) as cnt_distinct
	FROM (	
	  SELECT MIN(iq.inner_cnt_distinct) as cnt_distinct
	  FROM (  
		SELECT count(*) as inner_cnt_distinct, cas_number, epa_chem_substance_name, common_name, effect_desc, measurement_desc, endpoint, publication_year, ecoref_number
		FROM ecotox_group_summary3_mv
		WHERE 1=1		

	<!---
		this refers to the original group of ecorefs from EP, if applicable.  we always want to filter by these if there is a value,
		regardless of whether there is further filtering by other user inputs (ie. author/title below)
	 --->
	<cfif IN_origreflist neq "">
		<cfif ListLen(IN_origreflist) LTE 1000>
			AND ecoref_number IN (<CFQUERYPARAM VALUE="#IN_origreflist#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelse>
			<cfset arrayOfLists = GenFunc.splitListToSublists(IN_origreflist, 1000)>
			<cfif ArrayLen(arrayOfLists) GTE 1>
			AND (
				<cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
					<cfset thisSubList = arrayOfLists[i]>
					<cfif i GT 1> OR </cfif>                            
					ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
				</cfloop>
			)
			</cfif>
		</cfif>
	</cfif>

	<!--- for author / title --->
	<cfif IN_ecoref neq "All">
		<cfif ListLen(IN_ecoref) LTE 1000>
			AND ecoref_number IN (<CFQUERYPARAM VALUE="#IN_ecoref#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelse>
			<cfset arrayOfLists = GenFunc.splitListToSublists(IN_ecoref, 1000)>
			<cfif ArrayLen(arrayOfLists) GTE 1>
			AND (
				<cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
					<cfset thisSubList = arrayOfLists[i]>
					<cfif i GT 1> OR </cfif>                            
					ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
				</cfloop>
			)
			</cfif>
		</cfif>
	</cfif>
		
	<!--- check group selectors --->
	<cfif IN_chemGroupId neq "All">
		<cfif IN_chemGroupId eq "99" AND IN_casList neq "">
			AND cas_number IN (<CFQUERYPARAM VALUE="#IN_casList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelseif IN_chemGroupId eq "99" AND IN_dtsxIdList neq "">
			AND dtxsid IN (<CFQUERYPARAM VALUE="#IN_dtsxIdList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
		<cfelseif IN_chemGroupId eq "99">
			<!--- do nothing - this is handled with chemicals below --->
		<cfelse>
            AND cas_number IN (
                SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
            )
		</cfif>
	</cfif>
		
	<cfif IN_specGroupId neq "All">
		<cfif IN_specGroupId eq "99" AND IN_ncbiList neq "">
			AND ncbi_taxid IN (<CFQUERYPARAM VALUE="#IN_ncbiList#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		<cfelseif IN_specGroupId eq "99">
			<!--- do nothing - this is handled with species below --->
		<cfelse>
			AND species_list_id in (<CFQUERYPARAM VALUE="#IN_specGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		</cfif>
	</cfif>

	<cfif IN_effGroupId neq "All" AND IN_effGroupId neq "99">
		<cfif ListLen(IN_effGroupId, ",") gt 1>
			AND (
				<cfloop from="1" to="#ListLen(IN_effGroupId)#" index="idx">
					<cfif idx neq 1> OR </cfif>
					(effect LIKE <CFQUERYPARAM VALUE="#ListGetAt(IN_effGroupId, idx)#%" CFSQLTYPE="CF_SQL_VARCHAR">)
				</cfloop>
			)
		<cfelse>
			AND effect LIKE <CFQUERYPARAM VALUE="#IN_effGroupId#%" CFSQLTYPE="CF_SQL_VARCHAR">
		</cfif>
	</cfif>

	<!--- check additional filters --->	
	<cfif IN_chemListId neq "All">
		AND cas_number IN (
			SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		)
	</cfif>

	<cfif IN_casId neq "All">
		AND cas_number IN (<CFQUERYPARAM VALUE="#IN_casId#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
	</cfif>
	
	<cfif IN_speciesListId neq "All">
		AND species_list_id in (<CFQUERYPARAM VALUE="#IN_speciesListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
	</cfif>		
	
	<cfif IN_class neq "All">
		AND class IN (<CFQUERYPARAM VALUE="#IN_class#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>		
	
	<cfif IN_taxOrder neq "All">
		AND tax_order IN (<CFQUERYPARAM VALUE="#IN_taxOrder#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>	
	
	<cfif IN_genus neq "All">
		AND genus IN (<CFQUERYPARAM VALUE="#IN_genus#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_family neq "All">
		AND family IN (<CFQUERYPARAM VALUE="#IN_family#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_speciesId neq "All">
		AND species_number IN (<CFQUERYPARAM VALUE="#IN_speciesId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
	</cfif>
	
	<cfif IN_special neq "All">
		<cfset loop = 0>
		AND (
		<cfloop index="thisSpecInt" list="#IN_special#" delimiters=",">
			<cfif loop gt 0> OR </cfif>
			 (#thisSpecInt# = 'Y')
			 <cfset loop = loop + 1>
		</cfloop>
		)
	</cfif>
	
	<cfif IN_effectId neq "All">
		AND effect IN (<CFQUERYPARAM VALUE="#IN_effectId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_measurementId neq "All">
		AND measurement IN (<CFQUERYPARAM VALUE="#IN_measurementId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
                
	<!--- custom effects / measurement groups --->
	<cfif concatCustEffMeasList neq "All">
		AND CONCAT(effect, measurement) IN (<CFQUERYPARAM VALUE="#concatCustEffMeasList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_endpointId neq "All">
		AND endpoint IN (<CFQUERYPARAM VALUE="#IN_endpointId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>	

        <!--- DURATION LOGIC HERE --->
	<cfinclude template="duration_logic_sql.cfm">
	
	<cfif IN_habitat neq "All">
		AND habitat IN (<CFQUERYPARAM VALUE="#IN_habitat#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
		AND publication_year between <CFQUERYPARAM VALUE="#IN_pubYearMin#" CFSQLTYPE="CF_SQL_VARCHAR"> AND <CFQUERYPARAM VALUE="#IN_pubYearMax#" CFSQLTYPE="CF_SQL_VARCHAR">
		
		<!--- special interest groups are no longer determined by species group, so include this to make sure not to return any of these items matching species_list_id between 13-15 --->
		<!--- algae/moss/fungi split into 3 groups so exclude the old combined group as well (11) --->
		AND (species_list_id IS NULL OR species_list_id NOT IN (11,13,14,15))
			
		GROUP BY cas_number, epa_chem_substance_name, common_name, effect_desc, measurement_desc, endpoint, publication_year, ecoref_number
	  ) iq
	  GROUP BY cas_number, epa_chem_substance_name, common_name, effect_desc, measurement_desc, endpoint, publication_year, ecoref_number
	) oq
</cfquery>


<cfquery name="SummaryQuery" datasource="#application.datasource#" cachedWithin="#CreateTimeSpan(0,0,5,0)#">

SELECT oq.rec_count, oq.cas_number, oq.epa_chem_substance_name, oq.common_name, oq.effect_desc, oq.measurement_desc, oq.endpoint, oq.publication_year, oq.ecoref_number, oq.inner_citation, (select title from references where reference_number = oq.ecoref_number) as title, oq.dtxsid
FROM (
	SELECT MIN(iq.inner_cnt_distinct) as rec_count, iq.cas_number, iq.epa_chem_substance_name, iq.common_name, iq.effect_desc, iq.measurement_desc, iq.endpoint, iq.publication_year, iq.ecoref_number
		, iq.inner_citation, iq.dtxsid
	FROM (  
		SELECT COUNT(*) as inner_cnt_distinct, cas_number, epa_chem_substance_name, common_name, effect_desc, measurement_desc, endpoint, publication_year, ecoref_number, citation as inner_citation, dtxsid
		FROM ecotox_group_summary3_mv v
		WHERE 1=1

	<!---
		this refers to the original group of ecorefs from EP, if applicable.  we always want to filter by these if there is a value,
		regardless of whether there is further filtering by other user inputs (ie. author/title below)
	 --->
	<cfif IN_origreflist neq "">
		<cfif ListLen(IN_origreflist) LTE 1000>
			AND v.ecoref_number IN (<CFQUERYPARAM VALUE="#IN_origreflist#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelse>
			<cfset arrayOfLists = GenFunc.splitListToSublists(IN_origreflist, 1000)>
			<cfif ArrayLen(arrayOfLists) GTE 1>
			AND (
				<cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
					<cfset thisSubList = arrayOfLists[i]>
					<cfif i GT 1> OR </cfif>                            
					v.ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
				</cfloop>
			)
			</cfif>
		</cfif>
	</cfif>

	<!--- for author / title --->
	<cfif IN_ecoref neq "All">
		<cfif ListLen(IN_ecoref) LTE 1000>
			AND v.ecoref_number IN (<CFQUERYPARAM VALUE="#IN_ecoref#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelse>
			<cfset arrayOfLists = GenFunc.splitListToSublists(IN_ecoref, 1000)>
			<cfif ArrayLen(arrayOfLists) GTE 1>
			AND (
				<cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
					<cfset thisSubList = arrayOfLists[i]>
					<cfif i GT 1> OR </cfif>                            
					v.ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
				</cfloop>
			)
			</cfif>
		</cfif>
	</cfif>
		
	<!--- check group selectors --->
	<cfif IN_chemGroupId neq "All">
		<cfif IN_chemGroupId eq "99" AND IN_casList neq "">
			AND cas_number IN (<CFQUERYPARAM VALUE="#IN_casList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
		<cfelseif IN_chemGroupId eq "99" AND IN_dtsxIdList neq "">
			AND dtxsid IN (<CFQUERYPARAM VALUE="#IN_dtsxIdList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
		<cfelseif IN_chemGroupId eq "99">
			<!--- do nothing - this is handled with chemicals below --->
		<cfelse>
            AND cas_number IN (
                SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
            )
		</cfif>
	</cfif>
		
	<cfif IN_specGroupId neq "All">
		<cfif IN_specGroupId eq "99" AND IN_ncbiList neq "">
			AND ncbi_taxid IN (<CFQUERYPARAM VALUE="#IN_ncbiList#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		<cfelseif IN_specGroupId eq "99">
			<!--- do nothing - this is handled with species below --->
		<cfelse>
			AND species_list_id in (<CFQUERYPARAM VALUE="#IN_specGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		</cfif>
	</cfif>

	<cfif IN_effGroupId neq "All" AND IN_effGroupId neq "99">
		<cfif ListLen(IN_effGroupId, ",") gt 1>
			AND (
				<cfloop from="1" to="#ListLen(IN_effGroupId)#" index="idx">
					<cfif idx neq 1> OR </cfif>
					(effect LIKE <CFQUERYPARAM VALUE="#ListGetAt(IN_effGroupId, idx)#%" CFSQLTYPE="CF_SQL_VARCHAR">)
				</cfloop>
			)
		<cfelse>
			AND effect LIKE <CFQUERYPARAM VALUE="#IN_effGroupId#%" CFSQLTYPE="CF_SQL_VARCHAR">
		</cfif>
	</cfif>

	<!--- check additional filters --->	
	<cfif IN_chemListId neq "All">
		AND cas_number IN (
			SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
		)
	</cfif>

	<cfif IN_casId neq "All">
		AND cas_number IN (<CFQUERYPARAM VALUE="#IN_casId#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
	</cfif>
	
	<cfif IN_speciesListId neq "All">
		AND species_list_id in (<CFQUERYPARAM VALUE="#IN_speciesListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
	</cfif>		
	
	<cfif IN_class neq "All">
		AND class IN (<CFQUERYPARAM VALUE="#IN_class#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>		
	
	<cfif IN_taxOrder neq "All">
		AND tax_order IN (<CFQUERYPARAM VALUE="#IN_taxOrder#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>	
	
	<cfif IN_genus neq "All">
		AND genus IN (<CFQUERYPARAM VALUE="#IN_genus#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_family neq "All">
		AND family IN (<CFQUERYPARAM VALUE="#IN_family#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_speciesId neq "All">
		AND species_number IN (<CFQUERYPARAM VALUE="#IN_speciesId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
	</cfif>
	
	<cfif IN_special neq "All">
		<cfset loop = 0>
		AND (
		<cfloop index="thisSpecInt" list="#IN_special#" delimiters=",">
			<cfif loop gt 0> OR </cfif>
			 (#thisSpecInt# = 'Y')
			 <cfset loop = loop + 1>
		</cfloop>
		)
	</cfif>
	
	<cfif IN_effectId neq "All">
		AND effect IN (<CFQUERYPARAM VALUE="#IN_effectId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_measurementId neq "All">
		AND measurement IN (<CFQUERYPARAM VALUE="#IN_measurementId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
                
	<!--- custom effects / measurement groups --->
	<cfif concatCustEffMeasList neq "All">
		AND CONCAT(effect, measurement) IN (<CFQUERYPARAM VALUE="#concatCustEffMeasList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
	<cfif IN_endpointId neq "All">
		AND endpoint IN (<CFQUERYPARAM VALUE="#IN_endpointId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>	

        <!--- DURATION LOGIC HERE --->
	<cfinclude template="duration_logic_sql.cfm">
	
	<cfif IN_habitat neq "All">
		AND habitat IN (<CFQUERYPARAM VALUE="#IN_habitat#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
	</cfif>
	
		AND publication_year between <CFQUERYPARAM VALUE="#IN_pubYearMin#" CFSQLTYPE="CF_SQL_VARCHAR"> AND <CFQUERYPARAM VALUE="#IN_pubYearMax#" CFSQLTYPE="CF_SQL_VARCHAR">
			
			<!--- special interest groups are no longer determined by species group, so include this to make sure not to return any of these items matching species_list_id between 13-15 --->
			AND (species_list_id IS NULL OR species_list_id NOT IN (13,14,15))

		GROUP BY cas_number, epa_chem_substance_name, common_name, effect_desc, measurement_desc, endpoint, publication_year, ecoref_number, citation, dtxsid
	) iq
		
	<!--- THIS MAY CHANGE?? --->
	GROUP BY iq.cas_number, iq.epa_chem_substance_name, iq.common_name, iq.effect_desc, iq.measurement_desc, iq.endpoint, iq.publication_year, iq.ecoref_number, iq.inner_citation, iq.dtxsid
	ORDER BY iq.cas_number, iq.common_name, iq.effect_desc
) oq
WHERE rownum <= #Application.ExploreRecordMax#  <!--- prevent overload of jQuery datatable; 5000 worked too. --->
</cfquery>

<!--- 11/03/16 SPE - can not get this to work consistantly..
<cfif SummaryQuery.recordCount eq 1000>(first 1000 records)
<cfelseif SummaryQuery.recordCount = 0>(no records found)
<cfelse>(all records)
</cfif>
--->

<cfset jsonString = '{"allRecsCount":"#CountQuery.cnt_allrecs#","totalCount":"#CountQuery.cnt_distinct#","data":['>
<cfset dataArray = "">
<cfoutput>

<cfloop query="SummaryQuery">
	<cfset dataArray = listAppend(dataArray,'{"casNumber":"#cas_number#","chemName":"#epa_chem_substance_name#","commonName":"#common_name#","effect":"#effect_desc#","effectMeas":"#measurement_desc#","endpoint":"#endpoint#","dtxsid":"#dtxsid#","year":"#publication_year#","reference":{"citation":"#EncodeForHTML(PreserveSingleQuotes(inner_citation))#","title":"#EncodeForHTML(PreserveSingleQuotes(title))#","refNum":"#replace(ecoref_number," ","&nbsp;","All")#"}, "recordCount":"#rec_count#"}')>
</cfloop>

<cfset jsonString = jsonString & dataArray & ']}'>
#jsonString#
</cfoutput>

