<section id="glossary">
  <h2 class="show-for-sr">Glossary</h2>

  <dl>
    <dt>Acute</dt>
    <dd>Having a sudden onset, lasting a short time. Of a stimulus, severe enough to induce a response rapidly. Can be used to define either the exposure or the response to an exposure (effect). For clarity, the length of the exposure (short, medium, or long) and the nature of the effect end point (lethal or nonlethal) should be specified. The duration of an acute aquatic toxicity test is generally 4d or less and mortality is the response measured.</dd>
    <dt>Acid Equivalent (ae)</dt>
    <dd>The theoretical yield of parent acid from the active ingredient content of a formulation.</dd>
    <dt>Active Ingredient (ai)</dt>
    <dd>The agent in product primarily responsible for the intended toxicity effects and which is shown as the active ingredient on the product's label.</dd>
    <dt>AQUIRE</dt>
    <dd>
	  NOTE: This site is located under EPA Archives.  <a class="epa-archive-link" href="https://archive.epa.gov/" title="EPA's Archive">Search EPA Archive</a><br/>
      <b>AQUatic toxicity Information REtrieval</b> database. Contains data concerning the effects of single chemicals on aquatic organisms.
    </dd>
    <dt>ASTER</dt>
    <dd>
	  NOTE: This site is located under EPA Archives.  <a class="epa-archive-link" href="https://archive.epa.gov/" title="EPA's Archive">Search EPA Archive</a><br/>
	  <b>ASsessment Tools for the Evaluation of Risk</b> is an application that integrates AQUIRE database information and quantitative structure activity relationships (QSARs) to assess the environmental risk of discrete chemicals.
	</dd>
    <dt>BCF</dt>
    <dd>The bioconcentration factor (BCF) or bioaccumulation factor (BAF) is the degree to which a chemical can be concentrated in the tissues of an organism in the environment as a result of exposure to chemicals at steady state during the uptake phase. The BCF/BAF is a value which is equal to the concentration of a chemical in one or more tissues of the exposed organism divided by the average exposure concentration of a chemical in the test. It is usually reported with units of L/kg. If a unit cannot be determined from the information in the paper or it is unitless, RA (ratio) is used for the unit.</dd>
    <dt><a href="https://www.cas.org/support/documentation/chemical-substances/faqs">CAS Registry Number</a>&nbsp;<a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a>, CAS Number, CAS #</dt>
    <dd>
	The <a href="http://www.cas.org/">Chemical Abstracts Service</a>&nbsp;<a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a> assigns a unique number to every chemical that it registers, making this a common way to identify chemicals. A Chemical Abstract Services (CAS) collective index name is generated by using rules for chemical nomenclature that have been developed and are usually in accordance with the rules published by the International Union of Pure and Applied Chemistry (IUPAC). CAS nomenclature deviates from the IUPAC nomenclature when IUPAC nomenclature names two compounds identically. Each CAS Registry Number includes a <nobr><a href="https://www.cas.org/support/documentation/chemical-substances/checkdig">check digit</a>&nbsp;<a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a></nobr> that can be used to check its validity.
    <br/>ECOTOX uses the Ninth Collective Index (9CI), which is one in a series of standardized chemicals names. The 9CI was published from 1972 to 1976.</dd>
    <dt>Chronic</dt>
    <dd>Involving a stimulus that is lingering or continues for a long time; often signifies periods from several weeks to years, depending of the reproductive life cycle of the aquatic species. Can be used to define either the exposure or the response to an exposure (effect). For clarity the length of the exposure and the nature of the effect end point should be specified. Chronic exposure typically induces a biological response of relatively slow progress and long continuance. The chronic aquatic toxicity test is used to study the effects of continuous, long-term exposure to a chemical or other potentially toxic material on organisms.</dd>
    <dt><a href="https://www.spa.usace.army.mil/Portals/16/docs/civilworks/regulatory/Bulk%20Upload/Bulk%20Data%20Cowardin.pdf">Cowardin Code</a>&nbsp;<a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a></dt>
    <dd>
      A classification for water habitats for the United States used in the ECOTOX to determine outdoor test system (Habitat Type) classification.
    </dd>
    <dt id="ecotox">ECOTOX</dt>
    <dd>
	  NOTE: This site is located under EPA Archives.  <a class="epa-archive-link" href="https://archive.epa.gov/" title="EPA's Archive">Search EPA Archive</a><br/>
	  ECOTOXicological retrieval database. Provides search capabilities on chemicals and their effects, using the AQUIRE, PHYTOTOX and TERRETOX databases.
	</dd>
    <dt>FIPS Country Codes</dt>
    <dd>For purposes of storing codes and names for countries or their geopolitical subdivisions, we follow the FIPS standard. The original text source for these standardized geographical names and codes was FIPS 10-4, which has been replaced with a new standard.  See <nobr>"<a href="https://www.nist.gov/system/files/documents/itl/FIPSCodesReplacementChart2012.pdf">FIPS Codes Replacement Chart</a>"&nbsp;<a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a>.</nobr></dd>
    <dt>ITIS</dt>
    <dd><a href="http://www.itis.gov/">Integrated Taxonomic Information System</a>&nbsp;<a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a> Commonly used to verify species. scientific names.</dd>
    <dt>LC50</dt>
    <dd>Median Lethal Concentration: Statistically estimated concentration that is expected to be lethal to 50% of a group of organisms tested. Death may be defined by the mortality, intoxification, and population effect groups. TLms and TL50s with death as the measured endpoint are reported as LC50.</dd>
    <dt>LOEC</dt>
    <dd>Lowest observed effect concentration: The lowest concentration of a material used in a toxicity test that has a statistically significant adverse effect on the exposed population of test organisms compared to the controls. When derived from a life cycle or partial life cycle test, it is numerically the same as the upper limit of the MATC. Also called lowest observed adverse effect level (LOAEL).</dd>
    <dt>NOEC</dt>
    <dd>No observed effect concentration: The highest concentration of a material in a toxicity test that has no statistically significant effect on the exposed population of test organisms compared to the controls. When derived from a life cycle or partial life cycle test, it is numerically the same as the lower limit of the MATC. Also called no observed adverse effect level (NOAEL) or no observed effect level (NOEL).</dd>
    <dt>OECD</dt>
    <dd><a href="http://www.oecd.org/about/">Organization for Economic Co-operation and Development</a>&nbsp;<a class="exit-disclaimer" href="https://www.epa.gov/home/exit-epa" title="EPA's External Link Disclaimer">Exit</a></dd>
    <dt>PHYTOTOX</dt>
    <dd>
	  NOTE: This site is located under EPA Archives.  <a class="epa-archive-link" href="https://archive.epa.gov/" title="EPA's Archive">Search EPA Archive</a><br/>
	  Terrestrial plant toxic effects database. Included in TERRETOX database in 1997.</dd>
    <dt>QSAR</dt>
    <dd>Quantitative Structure-Activity Relationship - a method of quantitatively predicting the activity (properties, behavior) of a chemical from its structure. The QSAR system uses both stored database values and structure-activity relationships to provide information on physical and chemical properties, fate, and the effects of organic chemicals on the environment.</dd>
    <dt id="smiles">SMILES Notation</dt>
    <dd>
	  NOTE: This site is located under EPA Archives.  <a class="epa-archive-link" href="https://archive.epa.gov/" title="EPA's Archive">Search EPA Archive</a><br/>
      Simplified Molecular Input Line Entry System - SMILES is a chemical notation that allows a user to represent a chemical structure in a way that can be used by the computer.
    </dd>
    <dt>TERRETOX</dt>
    <dd>
	  NOTE: This site is located under EPA Archives.  <a class="epa-archive-link" href="https://archive.epa.gov/" title="EPA's Archive">Search EPA Archive</a><br/>
      Terrestrial animal toxic effects database. Since, 1997, also includes plant (PHYTOTOX) data.
    </dd>
  </dl>

</section>
