<section id="info-about" data-magellan-target="info-about">
  <h2>Welcome to the U.S. EPA ECOTOX Web site!</h2>
  <p>The ECOTOXicology Knowledgebase (ECOTOX) is a source for locating single chemical toxicity data for aquatic life, terrestrial plants and wildlife. ECOTOX was created and is maintained by the U.S.EPA's <a href="http://www.epa.gov/aboutepa/about-center-computational-toxicology-and-exposure-ccte">Center for Computational Toxicology and Exposure's (CCTE's)</a> <a href="http://www.epa.gov/aboutepa/about-great-lakes-toxicology-and-ecology-division">Great Lakes Toxicology Ecology Division (GLTED)</a>.</p>
  <p>ECOTOX integrates three previously independent databases - AQUIRE, PHYTOTOX, and TERRETOX - into a unique system which includes toxicity data derived predominately from the peer-reviewed literature, for aquatic life, terrestrial plants, and terrestrial wildlife, respectively.</p>
  <p>You should review the <a href="help.cfm?sub=so-site-info#info-limitations">limitations</a> of ECOTOX data retrieval for an understanding of system and minimum data requirements prior to performing searches on this site.</p>
  <p><b>You should consult the original scientific paper to ensure an understanding of the context of the data retrieved from ECOTOX.</b></p>
  <div class="card">
    <div class="card-content">
      <h3>ECOTOX Documentation</h3>
      <cfoutput>
      <ul>
        <li>#Application.currentUpdate["user_link"]#</li>
        <li>#Application.currentUpdate["quick_link"]#</li>
        <li><a target="_blank" href="help.cfm?sub=term-appendix"><b>ECOTOX Terms Appendix</b></a></li>
      </ul>
      </cfoutput>
    </div>
  </div>
  <h3><b>ECOTOX History</b></h3>
  <p><b>AQUIRE:</b> In 1981, MED began developing the AQUIRE (AQUatic toxicity Information REtrieval) database with assistance from the Office of Toxic Substances and the Office of Water. AQUIRE was initially developed to store acute laboratory data, but underwent major changes in the early 1990s, encoding additional parameters to better present data from outdoor field and chronic exposures. AQUIRE was released to governmental users via a telephone dial in session in 1987. In April 1999, AQUIRE was made available on the World Wide Web to all interested parties, public and private.</p>
  <p><b>PHYTOTOX:</b> The PHYTOTOX database was developed at the NHEERL, Western Ecology Division in Corvallis, OR (WED-Corvallis) in the early 1980s, and was maintained at MED. PHYTOTOX was originally developed with funding from the U.S. EPA Office of Pesticides through a cooperative agreement with the University of Oklahoma.</p>
  <p><b>TERRETOX:</b> The TERRETOX database was developed at WED-Corvallis in the early 1980s and was maintained at MED-Duluth. Initial funding for TERRETOX came from the U.S. EPA's Office of Toxic Substances.</p>
  <p><b>ECOTOX:</b> In 1995, MED received funding from the U.S. Department of Defense's Strategic Environmental Research and Development Program (SERDP) and the U.S. EPA's Office of Research and Development to develop a unified interface called ECOTOX to assist in searching and retrieving data from the AQUIRE, PHYTOTOX and TERRETOX databases. In March of 1996, ECOTOX was released to governmental users through a telnet access procedure. In February, 2000 it was released as a web based interface system.</p>
  <!--- new add--->
  <p>In 2017, an interactive version of ECOTOX was developed. This version allows exploration and visualization of the data prior to completing a search.</p>
</section>
<hr>

<section id="info-limitations" data-magellan-target="info-limitations">
  <h2>ECOTOX Limitations</h2>
  <p>You should review the limitations of ECOTOX data retrieval and system requirements prior to performing searches on this site.</p>
  <h3>Disclaimer</h3>
  <p>You should consult the original scientific paper to ensure an understanding of the context of the data retrieved from ECOTOX.</p>
  <p>ECOTOX attempts to be comprehensive, but our searches do not locate all relevant literature. In addition, the time lag from conducting a literature search, acquiring the publication and extracting it into ECOTOX can be up to or exceeding six months. For this reason, we also suggest that you conduct searches of the most recent publication year to ensure you capture data that may not be applicable for entry into the ECOTOX Knowledgebase (see data limitations below).</p>
  <p>Data in ECOTOX is converted and presented in ppm equivalents in Explore, but not in Search. If you run the same query using Search and Explore, the same values may be presented in different units. Explore converts to ppm equivalents in order to aid in visualization with the plotting feature. When switching between the Search and Explore functions, keep in mind that while the data is the same, particular attention should be given to the difference in displayed concentration units. The unit differences between Search and Explore are intended to be temporary. In the future, the intent is to harmonize Search and Explore so that they display the same concentration unit values.</p>
  <p>Reference herein to any specific commercial product, process, or service by trade name, trademark, manufacturer, or otherwise, does not necessarily constitute or imply its endorsement, recommendation, or favoring by the U. S. government. You should review the limitations of ECOTOX data retrieval and system requirements prior to performing searches on this site.</p>
  <h3>ECOTOX Unit Conversion Logic</h3>
  
  <p>In the "Search" function, ECOTOX converts Author reported concentration units to more standardized units, if possible, for aquatic data only. Author reported concentrations can be viewed by clicking the green "Customize Output Fields" button, then selecting the "Concentration (Author)" field. In "Explore", Author reported concentration units for both aquatic and terrestrial data are converted to a standardized value to display the data uniformly in the plot feature.</br>Guidelines for unit conversions are as follows:</p>
  <p>The following are unit conversion rules that apply in the “Search” function (aquatic data only). Author reported units are converted to the following standardized units if possible:</p>
  <ul>
    <li>Aquatic exposures are converted to mg/L.</li>
	<li>Gavage, oral and injection exposures are converted to mg/kg bdwt.</li>
	<li>Food and diet exposures are converted to mg/kg food.</li>
	<li>Units are not converted for the remaining exposures such as topical studies.</li>
	<li>Some units cannot be converted (e.g. ml/L needs density of compound to convert).</li>
  </ul>
  <p>The following are unit conversion rules that apply in the “Explore” function (aquatic and terrestrial data). Author reported units are converted to the following standardized units:</p>
  <ul>
    <li>Data with units that can be expressed as a 1:1000000 ratio (ratio of ppm, mg/L, mg/kg. etc.) are converted to ppm equivalents.
	<li>Gavage, oral and injection exposures are converted to mg/kg bdwt.</li>
	<li>Food and diet exposures are converted to mg/kg food.</li>
	<li>Units for drinking water exposures are converted to mg/L.</li>
	<li>Molar concentrations are not converted.</li>
	<li>Units are not converted for the remaining exposures, e.g. environmental sprays and broadcasts or topical exposures.</li>
	<li>Some units cannot be converted (e.g. ml/L needs density of compound to convert).</li>
  </ul>
  <p>To display data uniformly in the "Explore" plot feature, data that can be expressed as a 1:1000000 ratio (ratio of ppm, mg/L, mg/kg. etc.), are converted to ppm equivalents. This aids in visualization purposes and allows data to be displayed with one pair of axis on the same plot.</p>
  <h3>Software Limitations</h3>
  <p>The following browser limitations exist when using ECOTOX:</p>
  <ul>  
    <li>The "Search" and "Explore" pages require that your browser support JavaScript and this feature must be activated in your browser preferences.</li>
    <li>If you use a popup blocker program, ECOTOX Report exports may not display. Please add the ECOTOX website to your popup browser exception list to ensure full usability.</li>
    <li>ECOTOX Version 5 requires a modern browser that supports HTML5. It has been tested in Chrome (v57), Firefox (v52), and Internet Explore (v11). Chrome is the recommended browser.</li>
    <li>Sometimes ECOTOX may not work properly in Chrome. It is recommended to clear your browsing data, cache, or history if you experience issues.</li>
    <li>In "Explore" there is a maximum of 3,000 records that can be displayed at one time, but all records are retrieved.  Multiple exports of tabular data records can be done to export total number of records retrieved.</li>
  </ul>  
  <p>In the "Explore" function, ECOTOX will display how many total or distinct records are available for your search and how many are being displayed. In the example below, there are 6,920 Distinct Records with 15,767 Total Records (with the first 3,000 being displayed). Additional information regarding the difference between Distinct and Total can be found in the Help under Frequent Questions.</p>  
  <p><img src="images/so_site_info_1.png" alt="3,653 Distinct Records (showing first 3,000).  Distinct Records selected by Effect and Endpoint and ordered by CAS Number (low-high)"></p>
  <h3>Data Limitations</h3>
  <p>The following restrictions are placed on ECOTOX data. Data not satisfying these requirements are excluded from ECOTOX:</p>
<div class="table-scroll">
  <table>
    <tbody>
      <thead>
        <th>
          Criteria
        </th>
        <th>
          Requirement/Inclusions
        </th>
        <th>
          Limitations/Exclusions
        </th>
      </thead>
      <tr>
        <td>
          <h5>Chemical</h5>
        </td>
        <td>
          <ul>
            <li>Single chemicals relevant to environmental exposure are included.</li>
            <li>Verifiable Chemical Abstract Services (CAS) number</li>
          </ul>
        </td>
        <td>
          <ul>
            <li>Mixtures (petroleum fuels, tank mix, effluent)</li>
            <li>Air pollution e.g., CO2, ozone (except when ozone is dissolved in water)</li>
            <li>Plastics and microplastics, Clay and diatomaceous earth products.</li>
            <li>Biological toxicants (e.g. algal species with registered CAS numbers).</li>
          </ul>
        </td>
      </tr>
      <tr>
        <td>
          <h5>Species</h5>
        </td>
        <td>
          <ul>
            <li>Ecologically relevant species</li>
            <li>Priority species are wild (test results for terrestrial domestic and laboratory species are used to fill data gaps when needed)</li>
            <li>Organism taxonomic information verifiable against standard taxonomic sources</li>
          </ul>
        </td>
        <td>
          <ul>
            <li>Human, monkey, bacteria, viral and yeast</li>
          </ul>
        </td>
      </tr>
      <tr>
        <td>
          <h5>Effect/Response</h5>
        </td>
        <td>
          <ul>
            <li>Biological effect on the test species</li>
            <li>Adverse effects are priority (beneficial, nutritional effects are lower priority)</li>
          </ul>
        </td>
        <td> 
        </td>
      </tr>
      <tr>
        <td>
          <h5>Concentration/Dose</h5>
        </td>
        <td>
          <ul>
            <li>Concurrent environmental chemical concentration/dose reported as concentration, dose or application rate</li>
            <li>Sediment studies must have a water concentration reported to be included</li>
          </ul>
        </td>
        <td>
          <ul>
            <li>Inhalation studies route (including intratracheal instillation)</li>
            <li>Sediment only concentration</li>
            <li>Lead shot</li>
            <li>Log values</li>
          </ul>
        </td>
      </tr>
      <tr>
        <td>
          <h5>Exposure Duration</h5>
        </td>
        <td>
          <ul>
            <li>Duration reports an associated exposure concurrent with a biological effect</li>
          </ul>
        </td>
        <td> 
        </td>
      </tr>
      <tr>
        <td>
          <h5>Publication/Data Format</h5>
        </td>
        <td>
          <ul>
            <li>Primary data source</li>
            <li>Full text English (some Non-English papers are extracted that have an English abstracts)</li>
          </ul>
        </td>
        <td>
          <ul>
            <li>Reviews</li>
            <li>Full text foreign language</li>
            <li>Abstract only format</li>
          </ul>
        </td>
      </tr>
    </tbody>
  </table>
</div>
</section>
