<cfset PageName="Stats">

<cfinclude template="includes/head.cfm" />

<div id="statsPage">
  <section id="statsPageHeader" class="page-header">
    <cfinclude template="includes/updates-header.cfm" />
  </section>

  <ul id="updatedDateDropdown" class="menu dropdown-pane small" data-dropdown>
        <cfoutput>
        <cfloop list="#Application.updateDateList#" index="updDate" delimiters="|">            
            <cfset updDateAry = ListToArray(updDate, ";")>
            <cfif ArrayLen(updDateAry) gte 2>
                <cfif updDateAry[1] neq "" AND updDateAry[2] neq "">
                    <cfset dateVal = updDateAry[1]>
                    <cfset dateDesc = updDateAry[2]>      
                    <li><a data-stats-date="#dateVal#">#dateDesc#</a></li>
                </cfif>
            </cfif>
        </cfloop>
        </cfoutput>    
  </ul>

  <main id="statsContent" class="main-content row">
    <div class="clearfix">
      <div id="statsViewButtons">
        <a id="viewTable" href="#statsAsTable" class="button primary-inverse">View as Table</a>
        <a id="viewVisuals" href="#statsAsGraphs" class="button secondary">View as Visuals</a>
        <button id="exportStats" class="button success export float-right">Export Update Stats</button>
        <cfinclude template="includes/updates/signup_button.cfm" />
      </div>
    </div>

    <div class="view" id="statsAsGraphs">
      <div class="row expand totalRecords">
        <div class="columns medium-6">
          <div class="card raised">
            <div class="card-header">
              <h2><em>New/Edited</em> References</h2>
            </div>

            <div class="card-content">
              <div class="flex">
                <div class="graph">
                  <span class="newRecords-references-pie">---</span>
                  <span class="newRecords-references-total">---</span>
                </div>
                <div class="legend">
                  <ul>
                    <li class="-a">
                      Aquatic:
                      <span class="newRecords-references-a">---</span>
                    </li>
                    <li class="-t">
                      Terrestrial:
                      <span class="newRecords-references-t">---</span>
                    </li>
                  </ul>
                </div>
              </div>
            </div>

            <div class="card-footer">

            <h3>Total in Database</h3>
            <ul>
              <li class="-a">Aquatic:
                <span class="databaseRecords-references-a">---</span>
              </li>
              <li class="-t">Terrestrial:
                <span class="databaseRecords-references-t">---</span>
              </li>
            </ul>

            </div>
          </div>
        </div>

        <div class="columns medium-6">
          <div class="publicationYears card raised">
            <div class="card-header">
              <h2><em>New Associated Result Records Added for the</em> Past Six Publication Years</h2>
            </div>
            <div class="card-content">
              <div class="row">
                <div class="columns small-5">
                  <span class="publicationYears-bar-a bar">---</span>
                  <p>Aquatic Total: <span class="show-for-sr">Aquatic: </span><span class="publicationYears-a">---</span></p>
                </div>
                <div class="columns small-5">
                  <span class="publicationYears-bar-t bar">---</span>
                  <p>Terrestrial Total: <span class="show-for-sr">Terrestrial: </span><span class="publicationYears-t">---</span></p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="row expand totalRecords">
        <div class="columns medium-6">
          <div class="card raised">
            <div class="card-header">
              <h2><em>New/Edited</em> Tests</h2>
            </div>

            <div class="card-content">
              <div class="flex">
                <div class="graph">
                  <span class="newRecords-tests-pie">---</span>
                  <span class="newRecords-tests-total">---</span>
                </div>
                <div class="legend">
                  <ul>
                    <li class="-a">
                      Aquatic:
                      <span class="newRecords-tests-a">---</span>
                    </li>
                    <li class="-t">
                      Terrestrial:
                      <span class="newRecords-tests-t">---</span>
                    </li>
                  </ul>
                </div>
              </div>
            </div>

            <div class="card-footer">

            <h3>Total in Database</h3>
            <ul>
              <li class="-a">Aquatic:
                <span class="databaseRecords-tests-a">---</span>
              </li>
              <li class="-t">Terrestrial:
                <span class="databaseRecords-tests-t">---</span>
              </li>
            </ul>

            </div>
          </div>
        </div>
        <div class="columns medium-6">
          <div class="card raised">
            <div class="card-header">
              <h2><em>New/Edited</em> Results</h2>
            </div>

            <div class="card-content">
              <div class="flex">
                <div class="graph">
                  <span class="newRecords-results-pie">---</span>
                  <span class="newRecords-results-total">---</span>
                </div>
                <div class="legend">
                  <ul>
                    <li class="-a">
                      Aquatic:
                      <span class="newRecords-results-a">---</span>
                    </li>
                    <li class="-t">
                      Terrestrial:
                      <span class="newRecords-results-t">---</span>
                    </li>
                  </ul>
                </div>
              </div>
            </div>

            <div class="card-footer">

            <h3>Total in Database</h3>
            <ul>
              <li>Aquatic:
                <span class="databaseRecords-results-a">---</span>
              </li>
              <li>Terrestrial:
                <span class="databaseRecords-results-t">---</span>
              </li>
            </ul>

            </div>
          </div>
        </div>
      </div>

      <div class="row expand used-by-data">
        <div class="columns medium-6">
          <div class="card raised">
            <div class="card-header">
              <h2>Chemicals</h2>
            </div>
            <div class="card-content">
              <progress class="aquatic chemicals-progress-a" max="100" value="0"></progress>
              <p class="clearfix">
                Aquatic: <span class="chemicals-a">---</span>
              </p>
              <progress class="terrestrial chemicals-progress-t" max="100" value="0"></progress>
              <p class="clearfix">
                Terrestrial: <span class="chemicals-t">---</span>
              </p>
            </div>
          </div>
        </div>
        <div class="columns medium-6">
          <div class="card raised">
            <div class="card-header">
              <h2>Species</h2>
            </div>
            <div class="card-content">
              <progress class="aquatic species-progress-a" max="100" value="0"></progress>
              <p class="clearfix">
                Aquatic: <span class="species-a">---</span>
              </p>
              <progress class="terrestrial species-progress-t" max="100" value="0"></progress>
              <p class="clearfix">
                Terrestrial: <span class="species-t">---</span>
              </p>
            </div>
          </div>
        </div>
      </div>
      
    </div>

    <div class="is-active view" id="statsAsTable">
      <table id="statsAsTable_Table" class="bordered only text-center">
        <thead>
          <tr>
            <th>Aquatic</th>
            <th>Terrestrial</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td colspan="2"><h2>Total New/Edited</h2></td>
          </tr>
          <tr>
            <td><span class="newRecords-references-a">---</span> <small>references</small></td>
            <td><span class="newRecords-references-t">---</span> <small>references</small></td>
          </tr>
          <tr>
            <td><span class="newRecords-tests-a">---</span> <small>tests <span data-tooltip class="has-tip" data-disable-hover="false" title="Unique tests (experiments) are defined by separate test chemicals, test species, test locations, exposure types, or other experimental design differences. References may include multiple tests."><svg class="icon" width="16" height="16" alt="More Info"><use xlink:href="#info-circle"></use></svg></span></small></td>
            <td><span class="newRecords-tests-t">---</span> <small>tests <span data-tooltip class="has-tip" data-disable-hover="false" title="Unique tests (experiments) are defined by separate test chemicals, test species, test locations, exposure types, or other experimental design differences. References may include multiple tests."><svg class="icon" width="16" height="16" alt="More Info"><use xlink:href="#info-circle"></use></svg></span></small></td>
          </tr>
          <tr>
            <td><span class="newRecords-results-a">---</span> <small>associated result records <span data-tooltip class="has-tip" data-disable-hover="false" title="A separate line (data record) is used for each effect or endpoint measured and reported for a toxicity test. A test may include multiple records to account for reported measurements of multiple types of  effects and associated endpoints."><svg class="icon" width="16" height="16" alt="More Info"><use xlink:href="#info-circle"></use></svg></span></small></td>
            <td><span class="newRecords-results-t">---</span> <small>associated result records <span data-tooltip class="has-tip" data-disable-hover="false" title="A separate line (data record) is used for each effect or endpoint measured and reported for a toxicity test. A test may include multiple records to account for reported measurements of multiple types of  effects and associated endpoints."><svg class="icon" width="16" height="16" alt="More Info"><use xlink:href="#info-circle"></use></svg></span></small></td>
          </tr>
          <tr>
            <td colspan="2" class="sub"><h3>Added from Last Six Publication Years</h3></td>
          </tr>
          <tr>
            <td>
                <table id="publicationYearsTable-a" class="statTable"></table>
            </td>

            <td>
                <table id="publicationYearsTable-t" class="statTable"></table>
            </td>
          </tr>
          <tr>
            <td colspan="2"><h2>Total Database</h2></td>
          </tr>
          <tr>
            <td><span class="references-a">---</span> <small>references</small></td>
            <td><span class="references-t">---</span> <small>references</small></td>
          </tr>
          <tr>
            <td><span class="databaseRecords-tests-a">---</span> <small>tests <span data-tooltip class="has-tip" data-disable-hover="false" title="Unique tests (experiments) are defined by separate test chemicals, test species, test locations, exposure types, or other experimental design differences. References may include multiple tests."><svg class="icon" width="16" height="16" alt="More Info"><use xlink:href="#info-circle"></use></svg></span></small></td>
            <td><span class="databaseRecords-tests-t">---</span> <small>tests <span data-tooltip class="has-tip" data-disable-hover="false" title="Unique tests (experiments) are defined by separate test chemicals, test species, test locations, exposure types, or other experimental design differences. References may include multiple tests."><svg class="icon" width="16" height="16" alt="More Info"><use xlink:href="#info-circle"></use></svg></span></small></td>
          </tr>
          <tr>
            <td><span class="databaseRecords-results-a">---</span> <small>associated result records <span data-tooltip class="has-tip" data-disable-hover="false" title="A separate line (data record) is used for each effect or endpoint measured and reported for a toxicity test. A test may include multiple records to account for reported measurements of multiple types of  effects and associated endpoints."><svg class="icon" width="16" height="16" alt="More Info"><use xlink:href="#info-circle"></use></svg></span></small></td>
            <td><span class="databaseRecords-results-t">---</span> <small>associated result records <span data-tooltip class="has-tip" data-disable-hover="false" title="A separate line (data record) is used for each effect or endpoint measured and reported for a toxicity test. A test may include multiple records to account for reported measurements of multiple types of  effects and associated endpoints."><svg class="icon" width="16" height="16" alt="More Info"><use xlink:href="#info-circle"></use></svg></span></small></td>
          </tr>
          <tr>
            <td><span class="species-a">---</span> <small>species</small></td>
            <td><span class="species-t">---</span> <small>species</small></td>
          </tr>
          <tr>
            <td><span class="chemicals-a">---</span> <small>chemicals</small></td>
            <td><span class="chemicals-t">---</span> <small>chemicals</small></td>
          </tr>
        </tbody>
      </table>
    </div>

    <div class="card update-notes">
      <div class="card-header">
        <h2>Notes on update</h2>
      </div>
      <div class="card-content"></div>
    </div>

    <ol class="footnotes">
      <li id="statsFootnote-1">Dose Response records are no longer counted in the Terrestrial Results totals. Dose responses were removed from the results table and replaced with a single result record for each dose-response grouping.</li>
    </ol>
  </main>
</div>

    <div class="reveal" id="ChemSearchDatesModal" data-reveal>
        <button class="close-button" data-close aria-label="Close modal" type="button">
            <span aria-hidden="true"><svg width="14" height="14"><use xlink:href="#times"></use></svg></span>
        </button>
        <cfinclude template="pages/lit-search-results.cfm" />
    </div>

<cfinclude template="includes/updates/signup_modal.cfm" />
<cfinclude template="includes/end.cfm" />
