/*
 * Decompiled with CFR 0.152.
 */
package com.compoundtheory.coldfusion.cfc.spring.config;

import coldfusion.filter.FusionContext;
import coldfusion.util.Utils;
import com.compoundtheory.coldfusion.cfc.spring.ColdFusionComponentFactory;
import javax.servlet.jsp.PageContext;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionDefaults;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.scripting.config.LangNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ColdFusionBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String SCRIPT_SOURCE_ATTRIBUTE = "script-source";
    private static final String SCRIPT_SOURCE_RELATIVE_ATTRIBUTE = "script-source-relative";
    private static final String SCRIPT_INTERFACES_ATTRIBUTE = "script-interfaces";
    private static final String SCOPE_ATTRIBUTE = "scope";
    private static final String AUTOWIRE_ATTRIBUTE = "autowire";
    private static final String DEPENDENCY_CHECK_ATTRIBUTE = "dependency-check";
    private static final String INIT_METHOD_ATTRIBUTE = "init-method";
    private static final String DESTROY_METHOD_ATTRIBUTE = "destroy-method";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        LangNamespaceUtils.registerScriptFactoryPostProcessorIfNecessary((BeanDefinitionRegistry)parserContext.getRegistry());
        GenericBeanDefinition beanDef = new GenericBeanDefinition();
        beanDef.setSource(parserContext.extractSource((Object)element));
        beanDef.setBeanClass(ColdFusionComponentFactory.class);
        String scope = element.getAttribute(SCOPE_ATTRIBUTE);
        if (StringUtils.hasLength((String)scope)) {
            beanDef.setScope(scope);
        }
        String autowire = element.getAttribute(AUTOWIRE_ATTRIBUTE);
        int autowireMode = parserContext.getDelegate().getAutowireMode(autowire);
        if (autowireMode == 4) {
            autowireMode = 2;
        } else if (autowireMode == 3) {
            autowireMode = 0;
        }
        beanDef.setAutowireMode(autowireMode);
        String dependencyCheck = element.getAttribute(DEPENDENCY_CHECK_ATTRIBUTE);
        beanDef.setDependencyCheck(parserContext.getDelegate().getDependencyCheck(dependencyCheck));
        BeanDefinitionDefaults beanDefinitionDefaults = parserContext.getDelegate().getBeanDefinitionDefaults();
        String initMethod = element.getAttribute(INIT_METHOD_ATTRIBUTE);
        if (StringUtils.hasLength((String)initMethod)) {
            beanDef.setInitMethodName(initMethod);
        } else if (beanDefinitionDefaults.getInitMethodName() != null) {
            beanDef.setInitMethodName(beanDefinitionDefaults.getInitMethodName());
        }
        String destroyMethod = element.getAttribute(DESTROY_METHOD_ATTRIBUTE);
        if (StringUtils.hasLength((String)destroyMethod)) {
            beanDef.setDestroyMethodName(destroyMethod);
        } else if (beanDefinitionDefaults.getDestroyMethodName() != null) {
            beanDef.setDestroyMethodName(beanDefinitionDefaults.getDestroyMethodName());
        }
        ConstructorArgumentValues constructorArgs = beanDef.getConstructorArgumentValues();
        String scriptSource = element.getAttribute(SCRIPT_SOURCE_ATTRIBUTE);
        if (!element.hasAttribute(SCRIPT_SOURCE_RELATIVE_ATTRIBUTE) || element.getAttribute(SCRIPT_SOURCE_RELATIVE_ATTRIBUTE).equals("true")) {
            scriptSource = scriptSource.substring(7);
            scriptSource = Utils.expandPath((String)scriptSource, (PageContext)FusionContext.getCurrent().pageContext);
            scriptSource = "file://" + scriptSource;
        }
        String[] interfaces = element.getAttribute(SCRIPT_INTERFACES_ATTRIBUTE).split(",");
        constructorArgs.addIndexedArgumentValue(0, (Object)scriptSource);
        constructorArgs.addIndexedArgumentValue(1, (Object)interfaces);
        parserContext.getDelegate().parsePropertyElements(element, (BeanDefinition)beanDef);
        return beanDef;
    }
}

