<cfcomponent>
  <cfscript>

	this.speciesGroups = [
		{ "sel_value": "All", 	"sel_desc": "All" },
		{ "sel_value": "--", 	"sel_desc": "--- Animals ----------",	"map": "1,2,3,4,5,6,7,8,9,10" },
		{ "sel_value": "1", 	"sel_desc": "Amphibians" },
		{ "sel_value": "2", 	"sel_desc": "Birds" },
		{ "sel_value": "3", 	"sel_desc": "Crustaceans" },
		{ "sel_value": "4", 	"sel_desc": "Fish" },
		{ "sel_value": "5", 	"sel_desc": "Insects/Spiders" },
		{ "sel_value": "6", 	"sel_desc": "Other Invertebrates" },
		{ "sel_value": "7", 	"sel_desc": "Mammals" },
		{ "sel_value": "8", 	"sel_desc": "Molluscs" },
		{ "sel_value": "9", 	"sel_desc": "Reptiles" },
		{ "sel_value": "10", 	"sel_desc": "Worms" },
		{ "sel_value": "--", 	"sel_desc": "--- Plants ----------",	"map": "19,18,17,12" },
		{ "sel_value": "35", 	"sel_desc": "Algae" },
		{ "sel_value": "34", 	"sel_desc": "Moss, Hornworts" },
		{ "sel_value": "33", 	"sel_desc": "Fungi" },
		{ "sel_value": "12", 	"sel_desc": "Flowers, Trees, Shrubs, Ferns" },
		{ "sel_value": "--", 	"sel_desc": "--- Other ----------",	"map": "16" },
		{ "sel_value": "16", 	"sel_desc": "Miscellaneous" }
	];

	this.chemicalGroups = [
		{ "sel_value": "All", 	"sel_desc": "All" },	  
		{ "sel_value": "--", 	"sel_desc": "--- Organic Compounds ---",	"map": "37,42,40,17,18,33,34,19,38,35,20,43,30,36,31,21,22,39,23,32" },
		{ "sel_value": "37", 	"sel_desc": "Conazoles" },
		{ "sel_value": "42", 	"sel_desc": "Cyanide" },
		{ "sel_value": "40", 	"sel_desc": "Cyanotoxins" },
		{ "sel_value": "17", 	"sel_desc": "DDT and Metabolites" },
		{ "sel_value": "18", 	"sel_desc": "Dibenzofurans" },
		{ "sel_value": "33", 	"sel_desc": "Endocrine Disrupting Chemicals (EDCs)" },
		{ "sel_value": "34", 	"sel_desc": "Explosives" },
		{ "sel_value": "19", 	"sel_desc": "Glycol Ethers" },
		{ "sel_value": "38", 	"sel_desc": "Major Ions" },
		{ "sel_value": "35", 	"sel_desc": "Neonicotinoids" },
		{ "sel_value": "20", 	"sel_desc": "Nitrosamines" },
		/*{ "sel_value": "43", 	"sel_desc": "Nonylphenol and Nonylphenol ethoxylates" },*/
		{ "sel_value": "30", 	"sel_desc": "Perchlorates" },
		{ "sel_value": "36", 	"sel_desc": "Per- and Polyfluoroalkyl Substances (PFAS) " },
		{ "sel_value": "31", 	"sel_desc": "Pharmaceutical Personal Care Products (PPCPs) " },
		{ "sel_value": "21", 	"sel_desc": "Phthalate Esters" },
		{ "sel_value": "22", 	"sel_desc": "Polyaromatic Hydrocarbons (PAHs) " },
		{ "sel_value": "39", 	"sel_desc": "Polybrominated Diphenyl Ethers (PBDEs) " },
		{ "sel_value": "23", 	"sel_desc": "Polychlorinated Biphenyls (PCBs)" },
		{ "sel_value": "32", 	"sel_desc": "Strobins" },
		{ "sel_value": "--", 	"sel_desc": "--- Metals or Organometal Compounds ---",	"map": "1,2,28,3,4,5,29,6,7,8,9,10,27,11,14,12,13,41,15,16" },
		{ "sel_value": "1", 	"sel_desc": "Aluminum" },
		{ "sel_value": "2", 	"sel_desc": "Antimony" },
		{ "sel_value": "28", 	"sel_desc": "Arsenic" },
		{ "sel_value": "3", 	"sel_desc": "Barium" },
		{ "sel_value": "4", 	"sel_desc": "Beryllium" },
		{ "sel_value": "5", 	"sel_desc": "Cadmium" },
		{ "sel_value": "29", 	"sel_desc": "Chromium" },
		{ "sel_value": "6", 	"sel_desc": "Cobalt" },
		{ "sel_value": "7", 	"sel_desc": "Copper" },
		{ "sel_value": "8", 	"sel_desc": "Iron" },
		{ "sel_value": "9", 	"sel_desc": "Lead" },
		{ "sel_value": "10", 	"sel_desc": "Manganese" },
		{ "sel_value": "27", 	"sel_desc": "Mercury" },
		{ "sel_value": "11", 	"sel_desc": "Nickel" },
		{ "sel_value": "12", 	"sel_desc": "Organotin" },
		{ "sel_value": "13", 	"sel_desc": "Selenium" },
		{ "sel_value": "14", 	"sel_desc": "Silver" },
		{ "sel_value": "41", 	"sel_desc": "Thallium" },
		{ "sel_value": "15", 	"sel_desc": "Vanadium" },
		{ "sel_value": "16", 	"sel_desc": "Zinc" }
	];

	this.effectGroups = [
        { "sel_value": "All", 	"sel_desc": "All" },
		{ "sel_value": "--", 	"sel_desc": "--- Accumulation Group ----------",	"map": "ACC" },		
		{ "sel_value": "ACC", 	"sel_desc": "Accumulation" },
		{ "sel_value": "--", 	"sel_desc": "--- Behavior Group ----------",	"map": "AVO,BEH,FDB" },
		{ "sel_value": "AVO", 	"sel_desc": "Avoidance" },
		{ "sel_value": "BEH", 	"sel_desc": "Behavior" },
		{ "sel_value": "FDB", 	"sel_desc": "Feeding behavior" },
		{ "sel_value": "--", 	"sel_desc": "--- Biochemical Group ----------",	"map": "BCM,ENZ,HRM" },
		{ "sel_value": "BCM", 	"sel_desc": "Biochemistry" },
		{ "sel_value": "ENZ", 	"sel_desc": "Enzyme(s)" },
		{ "sel_value": "HRM", 	"sel_desc": "Hormone(s)" },
		{ "sel_value": "--", 	"sel_desc": "--- Cellular Group ----------",	"map": "CEL,GEN,HIS" },
		{ "sel_value": "CEL", 	"sel_desc": "Cell(s)" },
		{ "sel_value": "GEN", 	"sel_desc": "Genetics" },
		{ "sel_value": "HIS", 	"sel_desc": "Histology" },
		{ "sel_value": "--", 	"sel_desc": "--- Ecosystem Group ----------",	"map": "PRS" },
		{ "sel_value": "PRS", 	"sel_desc": "Ecosystem process" },
		{ "sel_value": "--", 	"sel_desc": "--- Growth Group ----------",	"map": "DVP,GRO,MPH" },
		{ "sel_value": "DVP", 	"sel_desc": "Development" },
		{ "sel_value": "GRO", 	"sel_desc": "Growth" },
		{ "sel_value": "MPH", 	"sel_desc": "Morphology" },
		{ "sel_value": "--", 	"sel_desc": "--- Mortality Group ----------",	"map": "MOR" },
		{ "sel_value": "MOR", 	"sel_desc": "Mortality" },
		{ "sel_value": "--", 	"sel_desc": "--- Multiple Group ----------",	"map": "MLT" },
		{ "sel_value": "MLT", 	"sel_desc": "Multiple or Undefined" },
		{ "sel_value": "--", 	"sel_desc": "--- Physiology Group ----------",	"map": "INJ,IMM,ITX,PHY" },
		{ "sel_value": "INJ", 	"sel_desc": "Injury" },
		{ "sel_value": "IMM", 	"sel_desc": "Immunological" },
		{ "sel_value": "ITX", 	"sel_desc": "Intoxication" },
		{ "sel_value": "PHY", 	"sel_desc": "Physiology" },
		{ "sel_value": "--", 	"sel_desc": "--- Population Group ----------",	"map": "POP" },
		{ "sel_value": "POP", 	"sel_desc": "Population" },
		{ "sel_value": "--", 	"sel_desc": "--- Reproduction Group ----------",	"map": "REP" },
		{ "sel_value": "REP", 	"sel_desc": "Reproduction" }
	];
	
	
	function getAllChemGroupOptions() {
		return getAllGroupOptions(this.chemicalGroups);
	}
	function getAllSpecGroupOptions() {
		return getAllGroupOptions(this.speciesGroups);
	}
	function getAllEffectGroupOptions() {
		return getAllGroupOptions(this.effectGroups);
	}
	function getAllGroupOptions(arrayToSearch) {
		var sel_val = "";
		var sel_desc = "";
		var optionStr = "";
		var disabledStr = "";
		
		var optionsArray = ArrayNew(1);
		for (j = 1; j LTE arrayLen(arrayToSearch); j++) {
			sel_val = arrayToSearch[j].sel_value;
			sel_desc = arrayToSearch[j].sel_desc;
			if(sel_val eq "--") {
				disabledStr = " disabled";
			}
			else {
				disabledStr = "";
			}
			optionStr = "<option value='" & sel_val & "'" & disabledStr & ">" & sel_desc & "</option>";
			ArrayAppend(optionsArray, optionStr);
		}
		return optionsArray;
	}
	
	
	function getFilteredChemGroupOptions(filteredStruct) {
		return getFilteredGroupOptions(this.chemicalGroups, filteredStruct);
	}
	function getFilteredSpecGroupOptions(filteredStruct) {
		return getFilteredGroupOptions(this.speciesGroups, filteredStruct);
	}
	function getFilteredEffectGroupOptions(filteredStruct) {
		return getFilteredGroupOptions(this.effectGroups, filteredStruct);
	}
	function getFilteredGroupOptions(arrayToSearch, filteredStruct) {
		var sel_val = "";
		var sel_desc = "";
		var optionStr = "";
		var selectedStr = "";
		var disabledStr = "";
		
		var optionsArray = ArrayNew(1);
		for (j = 1; j LTE arrayLen(arrayToSearch); j++) {
			sel_val = arrayToSearch[j].sel_value;
			sel_desc = arrayToSearch[j].sel_desc;
			
			if(StructKeyExists(filteredStruct, sel_val) OR sel_val eq "All" OR (sel_val eq "--" AND headingHasValues(arrayToSearch[j], filteredStruct))) {
			
				if(sel_val eq "--") {
					disabledStr = " disabled";
				}
				else {
					disabledStr = "";
				}
				
				if(StructKeyExists(filteredStruct, sel_val)) {
					selectedStr = filteredStruct[sel_val];
				}
				
				optionStr = "<option value='" & sel_val & "'" & selectedStr & disabledStr & ">" & sel_desc & "</option>";
				ArrayAppend(optionsArray, optionStr);
			
			}			
		}
		return optionsArray;
	}
	
	
	function getDescriptionByValue(value, arrayToSearch) {
		var description = "";
		
		for (j = 1; j LTE arrayLen(arrayToSearch) AND description EQ ""; j++) {		
			if(arrayToSearch[j].sel_value EQ value) {
				description = arrayToSearch[j].sel_desc;
			}
		}
		
		return description;
	}
	
	function headingHasValues(thisHeadingStruct, filteredStruct) {
		var value = "";
		var hasValues = 0;
		if(StructKeyExists(thisHeadingStruct, "map")) {
			if(not isnull(thisHeadingStruct["map"]) AND thisHeadingStruct["map"] neq "") {
				for(i = 1; i <= ListLen(thisHeadingStruct["map"]) AND hasValues eq 0; i++) {
					value = ListGetAt(thisHeadingStruct["map"],i);
					if(StructKeyExists(filteredStruct, value)) {
						hasValues = 1;
					}
				}
			}
		}
		return hasValues;
	}

  </cfscript>
</cfcomponent>