<cfcomponent>
<cfscript>

    function strReplace( inStr, strToRep, repWith ) {
        return Replace( inStr, strToRep, repWith, "All" );
    }

    // DATABASE ORDERING FOR DATATABLES
    function generateOrderString( fieldsStr, aliasesStr) {
        var retstr = "";
        var tempAliasStr = "";
        var fieldsAry = listToArray(fieldsStr, ",");
        var aliasesAry = listToArray(aliasesStr, ",");

        for (i = 1; i LTE arrayLen(fieldsAry); i++) {

            if(arrayLen(aliasesAry) eq arrayLen(fieldsAry)) {
                tempAliasStr = aliasesAry[i] & ".";
            }
            else {
                tempAliasStr = "";
            }

            if(i > 1) {
                retstr = retstr & ",";
            }

            retstr = retstr & tempAliasStr & fieldsAry[i];
        }
        return retstr;
    }

    function generateOrderByClause( fieldsStr, dirStr ) {

        var retstr = "";
        if(fieldsStr neq "") {
            if(dirStr eq "desc") {
                var fieldsAry = listToArray(fieldsStr, ",");
                for (i = 1; i LTE arrayLen(fieldsAry); i++) {
                    if(i > 1) {
                        retstr = retstr & ",";
                    }

                    retstr = retstr & fieldsAry[i] & " " & dirStr;
                }
            }
            else {
                retstr = fieldsStr;
            }
        }
        return retstr;
    }
    
    function revertSpecialCaseChars(value) {
        var retValue = Replace(value, "BACKTICK", "`", "all");
        retValue = Replace(retValue, "TILDE", "~", "all");
        retValue = Replace(retValue, "EXCLAMATIONPOINT", "!", "all");
        retValue = Replace(retValue, "ATSYMBOL", "@", "all");
        retValue = Replace(retValue, "POUNDSIGN", "##", "all");
        retValue = Replace(retValue, "DOLLARSIGN", "$", "all");
        retValue = Replace(retValue, "PERCENT", "%", "all");
        retValue = Replace(retValue, "CARAT", "^", "all");
        retValue = Replace(retValue, "AMPERSAND", "&", "all");
        retValue = Replace(retValue, "ASTERISK", "*", "all");
        retValue = Replace(retValue, "PIPE", "|", "all");
        retValue = Replace(retValue, "PLUS", "+", "all");
        retValue = Replace(retValue, "EQUALS", "=", "all");
        retValue = Replace(retValue, "QUESTIONMARK", "?", "all");
        retValue = Replace(retValue, "LEFTANGLEBRACKET", "<", "all");
        retValue = Replace(retValue, "RIGHTANGLEBRACKET", ">", "all");
        retValue = Replace(retValue, "BACKSLASH", "\", "all");
        retValue = Replace(retValue, "FORWARDSLASH", "/", "all");
        
        return retValue;
    }

    function generateFilterSummaryForR( filterArray ) {
        var cmntChars = "##   ";
        var subInd = "";
        var lineLen = 100;

        var currentline = "";
        var currentPos = 0;
        var endOfStr = false;
        var linePart = "";
        var reversePos = 0;
        var foundPos = 0;

        var retstr = "";

        for (i = 1; i LTE arrayLen(filterArray); i++) {
            if (filterArray[i].value neq "" AND filterArray[i].value neq "All") {

                currentline =
                    revertSpecialCaseChars(filterArray[i].label)
                    & ": "
                    & revertSpecialCaseChars(filterArray[i].value);

                if(Len(currentline) GT lineLen) {
                    currentPos = 1;
                    endOfStr = false;

                    while(!endOfStr && currentPos LT Len(currentline)) {
                        linePart = Mid(currentline, currentPos, lineLen);
                        if(currentPos GT 1) {
                            subInd = cmntChars & "    ";
                        }
                        else {
                            subInd = cmntChars;
                        }

                        if(Len(linePart) LT lineLen) {
                            endOfStr = true;
                            retstr = retstr & subInd & LTrim(RTrim(linePart)) & Chr(13) & Chr(10);
                        }
                        else {
                            // find position of last comma
                            reversePos = Find(",", Reverse(linePart));
                            if (reversePos GT 0) {
                                // break at the last comma
                                foundPos = Len(linePart) - reversePos + 1; // +1 to convert to 1-based indexing
                                linePart = Left(linePart, foundPos);
                                retstr = retstr & subInd & LTrim(RTrim(linePart)) & Chr(13) & Chr(10);
                                currentPos = currentPos + foundPos; // not the full lineLen, but the position of the last comma
                            } else {
                                // no place to break, so we will just take the first lineLen characters
                                retstr = retstr & subInd & LTrim(RTrim(linePart)) & Chr(13) & Chr(10);
                                currentPos = currentPos + lineLen;
                            }
                        }
                    }
                }
                else {
                    retstr = retstr & cmntChars & currentline & Chr(13) & Chr(10);
                }                
            }
        }
        retstr = Left(retstr, -2);

        if (retstr EQ cmntChars) {
            // If no filters were added, return blank string
            retstr = "";
        }
        else {
            // Trim any trailing spaces
            retstr = RTrim(retstr);
        }
        return retstr;
    }


    function generateAbbreviatedSummaryForR( filterArray ) {
        var cmntChars = "####   ";
        var lineLen = 80;
        var tempVal = "";

        var retstr = "";
        var currentline = cmntChars;

        for (i = 1; i LTE arrayLen(filterArray); i++) {
            if (filterArray[i].value neq "" AND filterArray[i].value neq "All") {

                if(i GT 1 AND Len(currentline) GT Len(cmntChars)) {
                    currentline = currentline & "|**| ";
                }

                currentline = currentline
                    & revertSpecialCaseChars(filterArray[i].label)
                    & ": ";

                tempVal = revertSpecialCaseChars(filterArray[i].value);
                if(Len(tempVal) GT 30) {
                    tempVal = Left(tempVal, 30) & "...";
                }

                currentline = currentline & tempVal & " ";

                if(Len(currentline) GT lineLen) {
                    retstr = retstr & currentline & Chr(13) & Chr(10);
                    currentline = cmntChars;
                }
                else if(i EQ arrayLen(filterArray)) {
                    // If this is the last item, add it to the return string
                    retstr = retstr & currentline;
                }
            }
        }

        if (retstr EQ cmntChars) {
            // If no filters were added, return blank string
            retstr = "";
        }
        else {
            // Trim any trailing spaces
            retstr = RTrim(retstr);
        }
        return retstr;
    }

    function cleanStringForDataTable( input, format ) {
        var retstr = input;
        if(retstr neq "") {

            if(format eq "EXCEL") {
                // DO NOTHING FOR NOW
            }
            else if(format eq "JSON") {    
                retstr = replace(retstr, "#Chr(13)##Chr(10)#", "<br/>", "ALL");
                retstr = cleanStringForJSON(retstr);
                if(isNumeric(retstr)) {
                    retstr = '"' & retstr & '"';
                }
            }
            else if(format eq "CSV") {
                retstr = cleanStringForCSV(retstr);
            }
        }

        if(retstr eq "") {
            if(format eq "JSON") {
                retstr = '"&nbsp;"';
            }
        }

        return retstr;
    }

    function cleanStringForJSON( input ) {
        var retstr = input;
        if(retstr neq "") {
            retstr = SerializeJSON(retstr);
        }
        return retstr;
    }

    function cleanStringForCSV( input ) {
        var retstr = input;
        if(retstr neq "") {
            retstr = replace(retstr, '"', '""', 'ALL');

            retstr = '"' & retstr & '"';
        }
        return retstr;
    }

    function cleanStringForExcel( input ) {
        var retstr = input;
        if(retstr neq "") {

            retstr = replace(retstr, "'", "_", 'ALL');
            
            if(Right(retstr, 1) EQ ",") {
                retstr = Left(retstr, Len(retstr)-1);
            }

            if(ListLen(retstr) gt 1) {
                retstr = "'" & retstr & "'";
            }
        }
        return retstr;
    }

    function cleanStringForExcelDate( input ) {
        var retstr = cleanStringForExcel(input);

        if(FindNoCase("-", retstr) GT 0) {
            retstr = Replace(retstr, "-", " to ","all");
            retstr = " " & retstr;
        }
        
        return retstr;
    }

    function parseRecentChemStrToJson( fullStr ) {
        var retstr = '';
        var chemArray = arraynew(1);
        var innerArrayStr = '';
        var innerArray = arraynew(1);
        
        chemArray = ListToArray(fullStr, "|");
        for (i = 1; i LTE arrayLen(chemArray); i++) {
            innerArrayStr = chemArray[i];
            innerArray = ListToArray(innerArrayStr, ";", true);
            if(arrayLen(innerArray) eq 2) {
                if(i > 1) {
                    retstr = retstr & ",";
                }

                retstr = retstr & '{"chemicalName":"' & innerArray[1] & '","cas":"' & innerArray[2] & '"}';
            }
            else if(arrayLen(innerArray) eq 3) {
                if(i > 1) {
                    retstr = retstr & ",";
                }

                retstr = retstr & '{"chemicalName":"' & innerArray[1] & '","cas":"' & innerArray[2] & '","chemicalgroupid":"' & innerArray[3] & '"}';
            }
        }

        return retstr;
    }
    
    function generateGoogleScholarLink(title) {
        var googleLink = "";

        if(title NEQ "") {
            googleLink = "https://scholar.google.com/scholar?hl=en&as_q=&as_oq=&as_eq=&as_sauthors=&as_publication=&as_ylo=&as_yhi=&as_occt=title&as_sdt=0%2C5&as_epq=%22" & EncodeForURL(title);
        }

        return googleLink;
    }

</cfscript>
</cfcomponent>