<cfcomponent>
  <cfscript>

  this.cardnames = {
	chemicals = "Chemicals",
	pubs = "Publication Options",
	species = "Species",
	test = "Test Conditions",
	effect = "Effect Measurements",
	endpoint = "Endpoints",
	habitat = "Habitat"
  };

  this.chemicalMetalArray = ["Metal or Organometal Compounds", ["1,Aluminum,cbAluminum", "2,Antimony,cbAntimony", "28,Arsenic,cbArsenic", "3,Barium,cbBarium", "4,Beryllium,cbBeryllium", "5,Cadmium,cbCadmium", "29,Chromium,cbChromium", "6,Cobalt,cbCobalt", "7,Copper,cbCopper", "8,Iron,cbIron", "9,Lead,cbLead", "10,Manganese,cbManganese", "27,Mercury,cbMercury", "11,Nickel,cbNickel", "14,Silver,cbSilver", "12,Organotin,cbOrganotin", "13,Selenium,cbSelenium", "41,Thallium,cbThallium", "15,Vanadium,cbVanadium", "16,Zinc,cbZinc"], this.cardnames["chemicals"]];

  this.chemicalOrganicArray = ["Organic Compounds", ["37,Conazoles,cbConazoles", "42,Cyanide,cbCyanide", "40,Cyanotoxins,cbCyanotoxins", "17,DDT and Metabolites,cbDDT", "18,Dibenzofurans,cbDibenzofurans", "34,Explosives,cbExplosives", "19,Glycol Ethers,cbGlycol", "38,Major Ions,cbMajorIons", "35,Neonicotinoids,cbNeonicotinoids", "20,Nitrosamines,cbNitrosamines",/*"43,Nonylphenol and Nonylphenol ethoxylates,cbNonylphenol",*/"30,Perchlorates,cbPerchlorates", "36,Per- and Polyfluoroalkyl Substances (PFAS),cbPFAS", "21,Phthalate Esters,cbPhthalate", "22,Polyaromatic Hydrocarbons (PAHs),cbPAH", "39,Polybrominated Diphenyl Ethers (PBDEs),cbPBDE", "23,Polychlorinated Biphenyls (PCBs),cbPCB", "31,Pharmaceutical Personal Care Products (PPCPs),cbPPCPs", "32,Strobins,cbStrobins"], this.cardnames["chemicals"]];


  this.pubsIndependentDataArray = ["Independently Compiled Data", ["cbFHMinnow;EPA: Fathead Minnow Acute Toxicity Database (MED-Duluth);cbFHMinnow", "cbOPP;EPA: Office of Pesticides Program Database;cbOPP", "cbDutch;Dutch Dataset;cbDutch", "cbFrench;French Dataset;cbFrench", "cbGerman;German Dataset;cbGerman", "cbRussian;Russian Dataset;cbRussian", "cbUSGS;USGS Acute Toxicity Database;cbUSGS"], this.cardnames["pubs"]];

  this.pubsRecentModsArray = ["Recent Modifications/Additions", Application.pubDateAry, this.cardnames["pubs"]];


  this.speciesAnimalsArray  = ["Animals", ["1,Amphibians,cbTaxGroupAmph", "2,Birds,cbTaxGroupBird", "3,Crustaceans,cbTaxGroupCrust", "4,Fish,cbTaxGroupFish", "5,Insects/Spiders,cbTaxGroupInsect", "6,Other Invertebrates,cbTaxGroupOthInv", "7,Mammals,cbTaxGroupMam", "8,Molluscs,cbTaxGroupMoll", "9,Reptiles,cbTaxGroupRept", "10,Worms,cbTaxGroupWorm"], this.cardnames["species"]];

  this.speciesPlantsArray  = ["Plants", ["35;Algae;cbTaxGroupAlgae", "34;Moss, Hornworts;cbTaxGroupMoss", "33;Fungi;cbTaxGroupFungi", "12;Flowers, Trees, Shrubs, Ferns;cbTaxGroupFlower"], this.cardnames["species"]];

  this.speciesSpecialsArray = ["Special Interests", ["STANDARD_TEST_SPECIES_YN,Standard Test Species,cbStandardTest", "THREATENED_ENDANGERED_YN,U.S. Threatened/Endangered Species,cbEndangered", "EXOTIC_NUISANCE_YN,U.S. Invasive Species,cbInvasive"], this.cardnames["species"]];

  this.testLocationsArray = ["Test Locations", "tl",
  [["", ["Lab;Lab", "NR;Not Reported",
    ["AllFld;All Field Tests", ["FldA;Field, Artificial", "FldN;Field, Natural", "FldU;Field, Undeterminable"]]]]]];

  this.testExpMediaArray = ["Exposure Media", "em",
  [["Water", ["wFresh;Fresh Water", "wSalt;Salt Water", "wUnknown;Fresh or Saltwater Not Specified"]],
  ["Soil", ["sArtificial;Artificial Soil", "sHumus;Humus", "sLitter;Litter", "sManure;Manure", "sMineral;Mineral Soil", "sMixture;Soil Mixture", "sNatural;Natural Soil", "sNR;Unspecified Soil"]],
  ["Artificial", ["Hydroponic;Hydroponic", "Other;Other (e.g. Filter Paper, Plaster of Paris, Agar)"]],
  ["", ["NoSub_strate;No Substrate", "NR;Not Reported"]]]];

  this.testExpTypesArray = ["Exposure Types", "et",
  [["Both Aquatic and Terrestrial", ["Diet;Oral", "Injection;Injection", "Topical;Topical", "Invitro;In Vitro", "Env;Environmental", "Mult;Multiple Entry"]],
  ["Only Aquatic", ["Flow;Flow-through", "Lotic;Lotic", "Intermit;Intermittent", "Renewal;Renewal", "Leaching;Leaching", "Static;Static", "Lentic;Lentic", "Tidal;Tidal", "NR;Unspecified"]]]];

  this.testControlTypesArray = ["Control Types", "ct",
  [["ECOTOX Control Types", ["Concurrent;Concurrent(C)", "Multipleentries;Multiple Entries(ME)", "Baseline;Baseline(B)", "Other;Other(O)", "Solvent;Solvent(V)", "Positive;Positive(P)", "Undefined;Undefined(K)"]],
  ["ECOTOX Historical Control Types", ["Insufficient;Insufficient(I)", "Multiple;Multiple(M)", "Satisfactory;Satisfactory(S)", "Unsatisfactory;Unsatisfactory(U)"]],
  ["Control Not Reported", ["NotReported;Not Reported(NR)"]]]];

  this.testChemAnalysisArray = ["Chemical Analysis", "mca",
  [["", ["Measured;Measured", "Unmeasured;Unmeasured", "NR;Not Reported"]]]];


  this.effectsMeasurementsArray = [["", ["1,Accumulation Group,ACC"]],
    ["2,Behavior Group,zzzfiller", ["2a,Avoidance,AVO", "2b,Behavior,BEH", "2c,Feeding Behavior,FDB"]],
    ["3,Biochemical Group,zzzfiller", ["3a,Biochemistry,BCM", "3b,Enzyme(s),ENZ", "3c,Hormone(s),HRM"]],
    ["4,Cellular Group,zzzfiller", ["4a,Cell(s),CEL", "4b,Genetics,GEN", "4c,Histology,HIS"]],
    ["", ["10,Ecosystem Process,PRS"]],
    ["5,Growth Group,zzzfiller", ["5a,Development,DVP", "5b,Growth,GRO", "5c,Morphology,MPH"]],
    ["", ["6,Mortality Group,MOR"]], ["", ["11,Multiple Group,MLT"]],
    ["7,Physiology Group,zzzfiller", ["7a,Injury,INJ", "7b,Immunological,IMM", "7c,Intoxication,ITX", "7d,Physiology,PHY"]],
    ["", ["8,Population Group,POP"]],
    ["", ["9,Reproduction,REP"]]];

  this.other_effects = ["", ["EXCLUDEPOSTEXPMEAS;Exclude Post-exposure Measurements;cbExcludePostExpMeas"], this.cardnames["effect"]];


  this.concentrationsEndpointsArray  = ["Concentration Based Endpoints", ["acxx,AC xx (all % values),cbResultsGroupAC", "lcld,LC/LD xx (all % values),cbResultsGroup12", "llxx,LL xx (all % values),cbResultsGroupLL", "eced,EC/ED xx (all % values),cbResultsGroup13", "elxx,EL xx (all % values),cbResultsGroupEL", "bmcxx,BMC/BMD xx (all % values),cbResultsGroupOption18", "icxx,IC/ID xx (all % values),cbResultsGroup14", "loec,LOEC,cbResultsGroupOption2", "loel,LOEL,cbResultsGroupOption2a", "loelr,LOELR,cbResultsGroupLOELR", "noec,NOEC,cbResultsGroupOption4", "noel,NOEL,cbResultsGroupOption4a", "noelr,NOELR,cbResultsGroupNOELR", "matc,MATC,cbResultsGroupOption6", "letc,LETC/ATCN,cbResultsGroupOption8", "leth,LETH (100% mortality),cbResultsGroupOption10", "zero,ZERO (0% mortality),cbResultsGroupOption12"], this.cardnames["endpoint"]];

  this.acxxEndpointsArray  = ["Concentration Based Endpoints", ["ac50,AC50,cbResultsGroupACa"], this.cardnames["endpoint"]];
  this.lcldEndpointsArray  = ["Concentration Based Endpoints", ["lc50,LC50,cbResultsGroup12a", "ld50,LD50,cbResultsGroup12b"], this.cardnames["endpoint"]];
  this.llxxEndpointsArray  = ["Concentration Based Endpoints", ["ll10,LL10,cbResultsGroupLL10", "ll50,LL50,cbResultsGroupLL50"], this.cardnames["endpoint"]];
  this.ecedEndpointsArray  = ["Concentration Based Endpoints", ["ec50,EC50,cbResultsGroup13a", "ed50,ED50,cbResultsGroup13b"], this.cardnames["endpoint"]];
  this.elxxEndpointsArray  = ["Concentration Based Endpoints", ["el10,EL10,cbResultsGroupEL10", "el50,EL50,cbResultsGroupEL50"], this.cardnames["endpoint"]];
  this.icidEndpointsArray  = ["Concentration Based Endpoints", ["ic50,IC50,cbResultsGroup14a", "id50,ID50,cbResultsGroup14b"], this.cardnames["endpoint"]];

  this.timeEndpointsArray  = ["Time Based Endpoints", ["ltxx,LT xx (all % values),cbResultsGroup15", "etxx,ET xx (all % values),cbResultsGroup16"], this.cardnames["endpoint"]];

  this.lt50Array  = ["Time Based Endpoints", ["lt50,LT50,cbResultsGroup15a"], this.cardnames["endpoint"]];
  this.et50Array  = ["Time Based Endpoints", ["et50,ET50,cbResultsGroup16a"], this.cardnames["endpoint"]];

  this.other_endpoints = ["", ["cbStatAnalyzedRecords;Statistics, No Endpoint;cbStatAnalyzedRecords", "NR;Endpoint Not Reported (NR);cbResultsGroupOption0"], this.cardnames["endpoint"]];

  this.bioaccumulationFactorsArray  = ["Bioaccumulation/Bioconcentration Factor", ["bcf,BCF (based on wet wt. or unknown),cbResultsGroup17a", "bcfd,BCFD (based on dry wt),cbResultsGroup17b", "baf,BAF,cbResultsGroup17c", "LRxx,LR xx (all % values),cbResultsGroup18", "ERxx,ER xx (all % values),cbResultsGroup19", "IRxx,IR xx (all % values),cbResultsIRxxGroup", "loer,LOER,cbResultsGroup21", "noer,NOER,cbResultsGroup22", "matr,MATR,cbResultsGroup23"], this.cardnames["endpoint"]];


    this.textAreaArray = [
        "txAdvancedChemicalEntries,Name(s) / Number(s)," & this.cardnames["chemicals"],
        "txAdvancedEffectEntries,Effect(s)," & this.cardnames["effect"],
        "txAdvancedSpecEntries,Name(s) / Number(s)," & this.cardnames["species"],
        "txAdvancedAuthorsEntries,Author(s)," & this.cardnames["pubs"],
        "txAdvancedPublicationsEntries,Ref Num(s)," & this.cardnames["pubs"],
        "txExposureDurationStd,Obs. Duration (Num Days)," & this.cardnames["test"],
        "txExposureDurationMin,Obs. Duration (Min. Num Days)," & this.cardnames["test"],
        "txExposureDurationMax,Obs. Duration (Max. Num Days)," & this.cardnames["test"]
    ];


	function getSearchParamDesc( field, arrayToSearch, delim ) {
		var retstr = "";
		var teststr = "";
		if(field neq "") {
			for (i = 1; i LTE arrayLen(arrayToSearch[2]) && retstr eq ""; i++) {
				teststr = listGetAt(arrayToSearch[2][i], 3, delim);
				if(UCase(field) eq UCase(teststr)) {
					retstr = listGetAt(arrayToSearch[2][i], 2, delim);
				}
			}
		}
		return retstr;
	}

	function getSearchParamCardName( arrayToSearch ) {
		var retstr = "";
		if(NOT ArrayIsEmpty(arrayToSearch)) {
			retstr = arrayToSearch[3];
		}
		return retstr;
	}

	function getSearchParamGroupName( arrayToSearch ) {
		var retstr = "";
		if(NOT ArrayIsEmpty(arrayToSearch)) {
			if(arrayToSearch[1] neq "") {
				retstr = arrayToSearch[1];
			}
		}
		return retstr;
	}

	function getTextAreaArrayPos( field ) {
		var ret = 0;
		var teststr = "";

		for(i = 1; i LTE arrayLen(this.textAreaArray) && ret eq 0; i++) {
			teststr = listGetAt(this.textAreaArray[i], 1);
			if(UCase(field) eq UCase(teststr)) {
				ret = i;
			}
		}
		return ret;
	}

	function getTextAreaInfo( pos ) {
		var groupname = "NO-GROUP";
		var cardname = listGetAt(this.textAreaArray[pos], 3);
		var description = listGetAt(this.textAreaArray[pos], 2);
		var retstr = (description & "|" & groupname & "|" & cardname);
		return retstr;
	}

	function findParamInfo( field ) {
		var description = "";
		var textAreaArrayPos = getTextAreaArrayPos(field);

		if(textAreaArrayPos gt 0) {
			description = getTextAreaInfo(textAreaArrayPos);
		}
		else {
			description = checkStandardArrays(field);

			if(description eq "") {
				description = checkSemiDelimArrays(field);
			}

			if(description eq "") {
				description = checkEffectsArray(field);
			}

			if(description eq "") {
				description = checkTestArrays(field);
			}
		}
		return description;
	}


	function checkStandardArrays( field ) {
		var retstr = "";
		var groupname = "";
		var cardname = "";
		var currentArray = this.chemicalMetalArray;
		var description = getSearchParamDesc(field, currentArray, ",");

		if( description eq "" ) {
			currentArray = this.chemicalOrganicArray;
			description = getSearchParamDesc(field, currentArray, ",");
		}
		if( description eq "" ) {
			currentArray = this.speciesAnimalsArray;
			description = getSearchParamDesc(field, currentArray, ",");
		}
		if( description eq "" ) {
			currentArray = this.speciesSpecialsArray;
			description = getSearchParamDesc(field, currentArray, ",");
		}
		if( description eq "" ) {
			currentArray = this.concentrationsEndpointsArray;
			description = getSearchParamDesc(field, currentArray, ",");
		}
		if( description eq "" ) {
			currentArray = this.timeEndpointsArray;
			description = getSearchParamDesc(field, currentArray, ",");
		}
		if( description eq "" ) {
			currentArray = this.bioaccumulationFactorsArray;
			description = getSearchParamDesc(field, currentArray, ",");
		}
		if( description eq "" ) {
			currentArray = this.acxxEndpointsArray;
			description = getSearchParamDesc(field, currentArray, ",");
		}
		if( description eq "" ) {
			currentArray = this.lcldEndpointsArray;
			description = getSearchParamDesc(field, currentArray, ",");
		}
		if( description eq "" ) {
			currentArray = this.llxxEndpointsArray;
			description = getSearchParamDesc(field, currentArray, ",");
		}
		if( description eq "" ) {
			currentArray = this.ecedEndpointsArray;
			description = getSearchParamDesc(field, currentArray, ",");
		}
		if( description eq "" ) {
			currentArray = this.elxxEndpointsArray;
			description = getSearchParamDesc(field, currentArray, ",");
		}
		if( description eq "" ) {
			currentArray = this.icidEndpointsArray;
			description = getSearchParamDesc(field, currentArray, ",");
		}
		if( description eq "" ) {
			currentArray = this.lt50Array;
			description = getSearchParamDesc(field, currentArray, ",");
		}
		if( description eq "" ) {
			currentArray = this.et50Array;
			description = getSearchParamDesc(field, currentArray, ",");
		}

		if(description neq "") {
			groupname = getSearchParamGroupName(currentArray);
			cardname = getSearchParamCardName(currentArray);
			if(groupname eq "") {
				groupname = "NO-GROUP";
			}
			retstr = (description & "|" & groupname & "|" & cardname);
		}
		else {
			retstr = "";
		}

		return retstr;
	}

	function checkSemiDelimArrays( field ) {
		var retstr = "";
		var groupname = "";
		var cardname = "";
		var currentArray = this.pubsIndependentDataArray;
		var description = getSearchParamDesc(field, currentArray, ";");

		if( description eq "" ) {
			currentArray = this.pubsRecentModsArray;
			description = getSearchParamDesc(field, currentArray, ";");
		}
		if( description eq "" ) {
			currentArray = this.speciesPlantsArray;
			description = getSearchParamDesc(field, currentArray, ";");
		}
		if( description eq "" ) {
			currentArray = this.other_endpoints;
			description = getSearchParamDesc(field, currentArray, ";");
		}
                if( description eq "" ) {
                        currentArray = this.other_effects;
                        description = getSearchParamDesc(field, currentArray, ";");
                }

		if(description neq "") {
			groupname = getSearchParamGroupName(currentArray);
			cardname = getSearchParamCardName(currentArray);
			if(groupname eq "") {
				groupname = "NO-GROUP";
			}
			retstr = (description & "|" & groupname & "|" & cardname);
		}
		else {
			retstr = "";
		}

		return retstr;
	}

	function checkEffectsArray( field ) {
		var retstr = "";
		var groupname = "";
		var cardname = "";
		var description = "";
		var outerArray = "";

		for (j = 1; j LTE arrayLen(this.effectsMeasurementsArray) && description eq ""; j++) {
			outerArray = this.effectsMeasurementsArray[j];
			for (i = 1; i LTE arrayLen(outerArray[2]) && description eq ""; i++) {
				teststr = listGetAt(outerArray[2][i], 1);
				if(UCase(field) eq UCase(("cbResultsGroup" & teststr))) {
					description = listGetAt(outerArray[2][i], 2);
				}
			}

			if(description neq "") {
				if(outerArray[1] neq "") {
					groupname = listGetAt(outerArray[1], 2);
				}
				cardname = this.cardnames["effect"];
			}
		}

		if(description neq "") {
			if(groupname eq "") {
                            // this is its own group, so swap the description and group names
                            groupname = description;
                            description = REPLACE(description, " Group", "", "ALL");
			}
			retstr = (description & "|" & groupname & "|" & cardname);
		}
		else {
			retstr = "";
		}

		return retstr;
	}

	function checkTestArrays( field ) {
		var description = "";

		var currentArray = this.testLocationsArray;
		description = searchTestArray(field, currentArray);

		if( description eq "" ) {
			currentArray = this.testExpMediaArray;
			description = searchTestArray(field, currentArray);
		}
		if( description eq "" ) {
			currentArray = this.testExpTypesArray;
			description = searchTestArray(field, currentArray);
		}
		if( description eq "" ) {
			currentArray = this.testControlTypesArray;
			description = searchTestArray(field, currentArray);
		}
		if( description eq "" ) {
			currentArray = this.testChemAnalysisArray;
			description = searchTestArray(field, currentArray);
		}

		return description;
	}


	function searchTestArray( field, arrayToSearch ) {
		var retstr = "";
		var teststr = "";
		var groupname = "";
		var cardname = "";
		var description = "";
		var inputPrefix = "";
		var descPrefix = "";
		var subGroupsArray = "";
		var subGroupItemArray = "";
		var subGroupInputsArray = "";
		var subGroupInputItem = "";
		var subSubGroupInputsArray = "";
		var subSubGroupInputItem = "";

		var outerArray = arrayToSearch;
		inputPrefix = outerArray[2];
		subGroupsArray = outerArray[3];

		for(k = 1; k LTE ArrayLen(subGroupsArray) && description eq ""; k++) {
			subGroupItemArray = subGroupsArray[k];
			descPrefix = subGroupItemArray[1];
			subGroupInputsArray = subGroupItemArray[2];
			for(l = 1; l LTE ArrayLen(subGroupInputsArray) && description eq ""; l++) {
				subGroupInputItem = subGroupInputsArray[l];
				if(IsArray(subGroupInputItem)) {
					subSubGroupInputsArray = subGroupInputItem[2];
					for(m = 1; m LTE ArrayLen(subSubGroupInputsArray) && description eq ""; m++) {
						subSubGroupInputItem = subSubGroupInputsArray[m];
						teststr = inputPrefix & listGetAt(subSubGroupInputItem, 1, ";");
						if(UCase(field) eq UCase(teststr)) {
							if(descPrefix neq "") {
								description = descPrefix & " - ";
							}
							description = description & listGetAt(subSubGroupInputItem, 2, ";");
						}
					}
				}
				else {
					teststr = "cb" & inputPrefix & listGetAt(subGroupInputItem, 1, ";");
					if(UCase(field) eq UCase(teststr)) {
						if(descPrefix neq "") {
							description = descPrefix & " - ";
						}
						description = description & listGetAt(subGroupInputItem, 2, ";");
					}
				}
			}
		}

		if(description neq "") {
			groupname = outerArray[1];
			cardname = this.cardnames["test"];
			if(groupname eq "") {
				groupname = "NO-GROUP";
			}
			retstr = (description & "|" & groupname & "|" & cardname);
		}
		else {
			retstr = "";
		}

		return retstr;
	}


	function setParamToDisplay( paramsToDisplay, description, groupname, cardname, thisvalue ) {
		if(NOT StructKeyExists(paramsToDisplay, cardname)) {
			paramsToDisplay[cardname] = structnew();
		}

		if(NOT StructKeyExists(paramsToDisplay[cardname], groupname)) {
			paramsToDisplay[cardname][groupname] = structnew();
		}

		paramsToDisplay[cardname][groupname][description] = thisvalue;

		return paramsToDisplay;
	}

	function getCardTextAreas( cardname ) {
		var teststr = "";
		var description = "";
		var idx = 1;

		var textArray = [];

		if(cardname neq "") {
			for(i = 1; i lte ArrayLen(this.textAreaArray); i++) {
				description = listGetAt(this.textAreaArray[i], 2);
				teststr = listGetAt(this.textAreaArray[i], 3);
				if(UCase(cardname) eq UCase(teststr)) {
					textArray[idx] = description;
					idx++;
				}
			}
		}
		return textArray;
	}

	function addSelectedParameter( selectedItemStruct, itemGroup, itemId, itemName ) {
		var itemVal = "";

		if(itemGroup neq "" and itemName neq "") {
			itemVal = itemName;
			if(itemId neq "") {
				itemVal = itemVal & " - " & itemId;
			}

			if(NOT StructKeyExists(selectedItemStruct, itemGroup)) {
				selectedItemStruct[itemGroup] = ArrayNew(1);
			}

			ArrayAppend(selectedItemStruct[itemGroup], itemVal);
		}

		return selectedItemStruct;
	}


  </cfscript>
</cfcomponent>
