<cfcomponent>
  <cfscript>

    this.appendix_defs = {
        "A" = {
            "title": "Concentration Types",
            "export_title": "Conc_Types",
            "database_template": "concentration_types.cfm",
            "ui_template": "text_source_to_output.cfm"
        },
        "B" = {
            "title": "Chemical Grades and Standards",
            "export_title": "Chem_Grade_and_Standards",
            "database_template": "code_description_db_template.cfm",
            "code_table": "chemical_grade_codes",
            "ui_template": "code_description_to_output.cfm"
        },
        "C" = {
            "title": "Chemical Formulations",
            "export_title": "Chem_Formulation",
            "database_template": "code_description_db_template.cfm",
            "code_table": "chemical_formulation_codes",
            "ui_template": "code_description_to_output.cfm"
        },
        "D" = {
            "title": "Radiolabel Isotopes",
            "export_title": "Radio_Isotope",
            "database_template": "code_description_db_template.cfm",
            "code_table": "radio_label_codes",
            "ui_template": "code_description_to_output.cfm",
            "long_definition": "0"
        },
        "E" = {
            "title": "Organism Sources",
            "export_title": "Org_Source",
            "database_template": "code_description_db_template.cfm",
            "code_table": "organism_source_codes",
            "ui_template": "code_description_to_output.cfm"
        },
        "F" = {
            "title": "Lifestages",
            "export_title": "Lifestage",
            "database_template": "code_description_db_template.cfm",
            "code_table": "lifestage_codes",
            "ui_template": "code_description_to_output.cfm"
        },
        "G" = {
            "title": "Soil Types",
            "export_title": "Soil_Type",
            "database_template": "soil_types.cfm",
            "ui_template": "text_source_to_output.cfm"
        },
        "H" = {
            "title": "Test Locations",
            "export_title": "Test_Loc",
            "database_template": "code_description_db_template.cfm",
            "code_table": "test_location_codes",
            "ui_template": "code_description_to_output.cfm"
        },
        "I" = {
            "title": "Valid Duration Units",
            "export_title": "Dur_Units",
            "database_template": "code_description_db_template.cfm",
            "code_table": "duration_unit_codes",
            "ui_template": "code_description_to_output.cfm"
        },
        "J" = {
            "title": "Exposure Type Groups",
            "export_title": "Exposure_Groups",
            "database_template": "code_description_db_template.cfm",
            "code_table": "exposure_type_group_codes",
            "ui_template": "code_description_to_output.cfm"
        },
        "J-1" = {
            "title": "Exposure Types",
            "export_title": "Exposure_Types",
            "database_template": "exposure_types.cfm",
            "ui_template": "exposure_types_to_output.cfm"
        },
        "K" = {
            "title": "Application Frequencies",
            "export_title": "App_Freq",
            "database_template": "code_description_db_template.cfm",
            "code_table": "application_frequency_codes",
            "ui_template": "code_description_to_output.cfm",
            "long_definition": "0"
        },
        "L" = {
            "title": "Exposure Media Terms",
            "export_title": "Exp_Media",
            "database_template": "media_types.cfm",
            "code_table": "media_type_codes",
            "ui_template": "media_types_to_output.cfm"
        },
        "M" = {
            "title": "Control Type and Dose ID Terms",
            "export_title": "Control_Types",
            "database_template": "code_description_db_template.cfm",
            "code_table": "control_type_codes",
            "ui_template": "code_description_to_output.cfm"
        },
        "N" = {
            "title": "Exposure Dose and Observation/Response Value Units",
            "export_title": "Obsv_Resp_Units",
            "database_template": "code_description_db_template.cfm",
            "code_table": "concentration_unit_codes",
            "ui_template": "code_description_to_output.cfm",
            "long_definition": "0"
        },
        "O" = {
            "title": "Ionic Fraction Terms",
            "export_title": "Ion_Terms",
            "database_template": "code_description_db_template.cfm",
            "code_table": "ion_codes",
            "ui_template": "code_description_to_output.cfm",
            "long_definition": "0"
        },
        "P" = {
            "title": "Chemical Analysis Methods",
            "export_title": "Chem_Methods",
            "database_template": "code_description_db_template.cfm",
            "code_table": "chemical_analysis_codes",
            "ui_template": "code_description_to_output.cfm"
        },
        "Q" = {
            "title": "Sample Unit Terms",
            "export_title": "Sample_Units",
            "database_template": "code_description_db_template.cfm",
            "code_table": "sample_size_unit_codes",
            "ui_template": "code_description_to_output.cfm",
            "long_definition": "0"
        },
        "R" = {
            "title": "Effect Groups",
            "export_title": "Effect_Groups",
            "database_template": "effect_group_codes.cfm",
            "ui_template": "effect_group_and_codes_to_output.cfm"
        },
        "S" = {
            "title": "Effect Groups and Measurements",
            "export_title": "Measurements",
            "database_template": "measurements.cfm",
            "ui_template": "measurements_to_output.cfm"
        },
        "T" = {
            "title": "Endpoint Terms and Definitions",
            "export_title": "Endpoints",
            "database_template": "endpoints.cfm",
            "ui_template": "text_source_to_output.cfm"
        },
        "U" = {
            "title": "Response Site Terms",
            "export_title": "Response_Sites",
            "database_template": "code_description_db_template.cfm",
            "code_table": "response_site_codes",
            "ui_template": "code_description_to_output.cfm",
            "col1name": "CODE",
            "col2name": "SITE NAME",
            "col3name": "SITE DEFINITION/NOTES"
        },
        "V" = {
            "title": "Common Keywords for Other Effects Text Field",
            "export_title": "Other_Effects_KW",
            "database_template": "code_description_db_template.cfm",
            "code_table": "other_effects_codes",
            "ui_template": "code_description_to_output.cfm",
            "long_definition": "0"
        },
        "W" = {
            "title": "Media Characteristic Units",
            "export_title": "Media_Char_Units",
            "database_template": "code_description_db_template.cfm",
            "code_table": "media_char_unit_codes",
            "ui_template": "code_description_to_output.cfm",
            "long_definition": "0"
        },
        "X" = {
            "title": "Sub-Habitat Terms and Common Descriptors",
            "export_title": "Sub-Habitats",
            "database_template": "code_description_db_template.cfm",
            "code_table": "habitat_codes",
            "ui_template": "code_description_to_output.cfm",
            "col2name": "SUB-HABITAT"
        },
        "Y" = {
            "title": "Substrate Terms",
            "export_title": "Substrates",
            "database_template": "code_description_db_template.cfm",
            "code_table": "substrate_codes",
            "ui_template": "code_description_to_output.cfm",
            "long_definition": "0"
        },
        "Z" = {
            "title": "Depth Units",
            "export_title": "Depth_Units",
            "database_template": "code_description_db_template.cfm",
            "code_table": "media_char_unit_codes",
            "where_clause": "valid_depth_yn = 'Y'",
            "ui_template": "code_description_to_output.cfm",
            "long_definition": "0"
        },
        "AA" = {
            "title": "Geographic Locations",
            "export_title": "Geographic_Locations",
            "database_template": "field_locations.cfm",
            "ui_template": "text_source_to_output.cfm"
        },
        "AB" = {
            "title": "Geographic Terms",
            "export_title": "Geographic",
            "database_template": "code_description_db_template.cfm",
            "code_table": "geographic_codes",
            "ui_template": "code_description_to_output.cfm",
            "long_definition": "0"
        },
        "AC" = {
            "title": "Aquatic Field Name Terms",
            "export_title": "Aquatic_Fields",
            "database_template": "aquatic_fields.cfm",
            "ui_template": "text_source_to_output.cfm"
        },
        "AD" = {
            "title": "Terretox Field Name Terms",
            "export_title": "Terr_Fields",
            "database_template": "terr_fields.cfm",
            "ui_template": "text_source_to_output.cfm"
        },
        "AE-1" = {
            "title": "Organic Matter Types",
            "export_title": "Org_Matter_Types",
            "database_template": "code_description_db_template.cfm",
            "code_table": "organic_matter_type_codes",
            "ui_template": "code_description_to_output.cfm",
            "long_definition": "0"
        },
        "AE-2" = {
            "title": "Organic Carbon/Matter Units",
            "export_title": "Org_Carbon_Units",
            "database_template": "code_description_db_template.cfm",
            "code_table": "organic_carbon_type_codes",
            "ui_template": "code_description_to_output.cfm",
            "long_definition": "0"
        },
        "AF" = {
            "title": "Cation Exchange Capacity Units",
            "export_title": "CEC_Units",
            "database_template": "code_description_db_template.cfm",
            "code_table": "media_char_unit_codes",
            "where_clause": "valid_cec_yn = 'Y'",
            "ui_template": "code_description_to_output.cfm",
            "long_definition": "0",
            "col1name": "DOSE",
            "col2name": "DEFINITION"
        },
        "AG" = {
            "title": "Field Study Type Terms",
            "export_title": "Study_Types",
            "database_template": "code_description_db_template.cfm",
            "code_table": "field_study_type_codes",
            "ui_template": "code_description_to_output.cfm",
            "long_definition": "0"
        },
        "AH" = {
            "title": "Test Methods Terms",
            "export_title": "Test_Methods",
            "database_template": "code_description_db_template.cfm",
            "code_table": "test_method_codes",
            "ui_template": "code_description_to_output.cfm",
            "col3name": "CITATION"
        },
        "AI" = {
            "title": "Gender Terms",
            "export_title": "Genders",
            "database_template": "code_description_db_template.cfm",
            "code_table": "gender_codes",
            "ui_template": "code_description_to_output.cfm"
        },
        "AJ" = {
            "title": "Statistical Method Terms",
            "export_title": "Stat_Method_Terms",
            "database_template": "code_description_db_template.cfm",
            "code_table": "dose_stat_method_codes",
            "ui_template": "code_description_to_output.cfm",
            "long_definition": "0"
        },
        "AK" = {
            "title": "Trend Terms",
            "export_title": "Trend_Terms",
            "database_template": "code_description_db_template.cfm",
            "code_table": "trend_codes",
            "ui_template": "code_description_to_output.cfm",
            "long_definition": "0"
        },
        "AL" = {
            "title": "Statistical Significance Terms",
            "export_title": "Stat_Sig_Terms",
            "database_template": "code_description_db_template.cfm",
            "code_table": "statistical_significance_codes",
            "ui_template": "code_description_to_output.cfm"
        },
        "AM" = {
            "title": "Endpoint Assignment Terms",
            "export_title": "Endpoint_Assign_Terms",
            "database_template": "code_description_db_template.cfm",
            "code_table": "endpoint_assigned_codes",
            "ui_template": "code_description_to_output.cfm",
            "long_definition": "0"
        },
        "AN" = {
            "title": "Season Terms",
            "export_title": "Season_Terms",
            "database_template": "code_description_db_template.cfm",
            "code_table": "season_codes",
            "ui_template": "code_description_to_output.cfm",
            "long_definition": "0"
        },
        "AO" = {
            "title": "Result Dry/Wet Terms",
            "export_title": "Dry_Wet",
            "database_template": "dry_wet_terms.cfm",
            "ui_template": "text_source_to_output.cfm"
        },
        "AP" = {
            "title": "Test Type Terms",
            "export_title": "Test_Types",
            "database_template": "code_description_db_template.cfm",
            "code_table": "test_type_codes",
            "ui_template": "code_description_to_output.cfm"
        },
        "AQ" = {
            "title": "Application Type Terms",
            "export_title": "App_Types",
            "database_template": "code_description_db_template.cfm",
            "code_table": "application_type_codes",
            "ui_template": "code_description_to_output.cfm"
        },
        "AR" = {
            "title": "Length Type Terms",
            "export_title": "Length_Types",
            "database_template": "code_description_db_template.cfm",
            "code_table": "length_type_codes",
            "ui_template": "code_description_to_output.cfm"
        },
        "AS" = {
            "title": "Length Unit Terms",
            "export_title": "Length_Units",
            "database_template": "code_description_db_template.cfm",
            "code_table": "length_unit_codes",
            "ui_template": "code_description_to_output.cfm",
            "long_definition": "0"
        }
    };


    function getAllAppendixKeys() {
        return StructKeyArray(this.appendix_defs);
    }

    function getAllAppendixDefs() {
        return this.appendix_defs;
    }

    function getAllAppendixIDsNames() {             // returns in format: "letter|title;letter|title..."
        var ret_str = "";
        var apx_val = "";
        var temp_title = "";
        var currentKey = "";

        var keyArray = StructKeyArray(this.appendix_defs);
        ArraySort(keyArray, function (s1, s2) {
            var cs1 = "";
            var cs2 = "";
            var pos1 = find("-", s1);
            var pos2 = find("-", s2);

            if(pos1 gt 0) { cs1 = left(s1, pos1-1); } else { cs1 = s1; }
            if(pos2 gt 0) { cs2 = left(s2, pos2-1); } else { cs2 = s2; }

            if(len(cs1) eq len(cs2)) {
                return compare(s1, s2);
            }
            else {
                return len(cs1) - len(cs2);
            }
        });

        for(i=1; i <= arrayLen(keyArray); i++) {
            currentKey = keyArray[i];
            apx_val = this.appendix_defs[currentKey];
            temp_title = apx_val.title;
            ret_str = ListAppend(ret_str, "#currentKey#|#temp_title#", ";");
        }
        return ret_str;
    }

    function getAppendixDefinition(appendixId) {
        var apx_val = {};

        if(structKeyExists(this.appendix_defs, appendixId)) {
            apx_val = this.appendix_defs[appendixId];
        }

        return apx_val;
    }
    

  </cfscript>
</cfcomponent>
