 <!---construct csv output --->

<cfif URL.export EQ "1">
    <cfset rowCount = "">
<cfelse>
    <cfset rowCount = ChemSearchCasExportQuery.TotalRows>
</cfif>
    
<cfif rowCount eq "">
    <cfset rowCount = 0>
</cfif>

<cfset columnDefs = arrayNew(2)>
    
<cfset col1Array = arrayNew(1)>
<cfset ArrayAppend(col1Array, "CAS NUMBER")>
<cfset ArrayAppend(col1Array, "cas_number")>
<cfset ArrayAppend(columnDefs, col1Array)>
    
<cfset col2Array = arrayNew(1)>
<cfset ArrayAppend(col2Array, "ECOTOX PREFERRED NAME")>
<cfset ArrayAppend(col2Array, "epa_chem_substance_name")>
<cfset ArrayAppend(columnDefs, col2Array)>

<cfset col3Array = arrayNew(1)>
<cfset ArrayAppend(col3Array, "CHEMICAL PRIMARY NAME")>
<cfset ArrayAppend(col3Array, "chem_primary_name")>
<cfset ArrayAppend(columnDefs, col3Array)>

<cfset col4Array = arrayNew(1)>
<cfset ArrayAppend(col4Array, "SYNONYMS")>
<cfset ArrayAppend(col4Array, "synonyms")>
<cfset ArrayAppend(columnDefs, col4Array)>
       
    
<cfset resultsArray = arrayNew(2)>
<cfloop query="ChemSearchCasExportQuery">
    <cfset rowData = arrayNew(1)>

    <cfset project = ChemSearchCasExportQuery.project_name>
    <cfset search_date = ChemSearchCasExportQuery.search_date_str>
    
    <cfset col1Str = ChemSearchCasExportQuery.cas_number>
    <cfset col1Str = OutFunc.cleanStringForDataTable(col1Str, OUTPUTFORMAT)>
    <cfset ArrayAppend(rowData, col1Str)>

    <cfset col2Str = ChemSearchCasExportQuery.epa_chem_substance_name>
    <cfset col2Str = OutFunc.cleanStringForDataTable(col2Str, OUTPUTFORMAT)> 
    <cfset ArrayAppend(rowData, col2Str)>

    <cfset col3Str = ChemSearchCasExportQuery.chem_primary_name>
    <cfset col3Str = OutFunc.cleanStringForDataTable(col3Str, OUTPUTFORMAT)> 
    <cfset ArrayAppend(rowData, col3Str)>

    <cfset col4Str = ChemSearchCasExportQuery.synonyms>
    <cfset col4Str = OutFunc.cleanStringForDataTable(col4Str, OUTPUTFORMAT)> 
    <cfset ArrayAppend(rowData, col4Str)>
           
    <cfset ArrayAppend(resultsArray, rowData)>
</cfloop>


<cfset fileName = "ECOTOX-Chem-Search-CAS-#project#-#search_date#">
    
<CFHEADER NAME="Content-Disposition" VALUE="attachment; filename=#fileName#.csv">
<CFCONTENT TYPE="text/plain">
  
<cfprocessingdirective suppressWhiteSpace = "Yes">

<cfset columnNameList = "">
<cfloop array="#columnDefs#" index="thisDef">
    <cfset thisColName = OutFunc.cleanStringForDataTable(thisDef[1], OUTPUTFORMAT)>
    <cfset columnNameList = listAppend(columnNameList, '#thisColName#')>
</cfloop>

<cfoutput>#columnNameList##chr(13)##chr(10)#</cfoutput>
    
<cfset dataList = "">
<cfloop array="#resultsArray#" index="thisRow">
    <cfset row = "">
    <cfloop array="#thisRow#" index="thisValue">
        <cfset thisCsvValue = thisValue>
        <cfset row = listAppend(row, '#thisCsvValue#')>    
    </cfloop>
        
    <cfoutput>#row##chr(13)##chr(10)#</cfoutput>
</cfloop>
    
</cfprocessingdirective>
    
    