
<cfset defaultSortOrder = "search_term">

<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cftry>    

    <cfquery name="ChemSearchTermsExportQuery" datasource="#application.datasource#" dbtype="Oracle80" timeout="300" result="ChemSearchTermsExportQueryVars">

        SELECT
          cs.id as chem_search_id, cs.project_name, TO_CHAR(cs.search_date, 'YYYYMMDD') as search_date_str, cst.search_term
        from
          chemical_searches cs
          left join chemical_searches_terms cst on cs.id = cst.chem_search_id_fk
        where
          cs.display = 1
          AND cs.id = <CFQUERYPARAM VALUE="#URL.csid#" CFSQLTYPE="CF_SQL_INTEGER">
        order by #defaultSortOrder#

    </cfquery>
    
    <!---<cflog text ="#ChemSearchTermsExportQueryVars.sql#">--->
    <!---<cflog text ="#ArrayToList(ChemSearchTermsExportQueryVars.sqlparameters)#">--->
    
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>

<!--- ADD BACK IN AT LATER DATE			
    <cfset SQLErrorOccurred = 1>
--->

    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>

    <cfif thisInternalOnly eq 1>
        <cfinclude template="outputError.cfm">
    <cfelse>
        <cfinclude template="emailError.cfm">
    </cfif>

    <cfif errorDetail eq "[Macromedia][Oracle JDBC Driver]Execution timeout expired.">
        <cfinclude template="timeout_error.cfm">
    <cfelse>
        <cfinclude template="db_error.cfm">
    </cfif>
                    
</cfcatch>
</cftry>
</cflock>
