<cfset GenFunc = CreateObject("component", "cfc.generic_functions")>

<cflock type="READONLY" timeout="10" throwontimeout="Yes" scope="APPLICATION">
<cftry>    

    <cfquery name="PubsSummaryExport" datasource="#application.datasource#" dbtype="Oracle80" timeout="300" result="PubsSummaryExportVars">

        SELECT   
            oq.ecoref_number, r.author, r.title, r.source, r.reference_type,
            CASE
                WHEN r.reference_type = 'OECDG' THEN 'German Dataset'
                WHEN r.reference_type = 'OECDF' THEN 'French Dataset'
                WHEN r.reference_type = 'OECDN' THEN 'Dutch Dataset'
                WHEN r.reference_type = 'RUSSN' THEN 'Russian Dataset'
                WHEN r.reference_type = 'USGS'  THEN 'USGS Acute Toxicity Database'
                WHEN r.reference_type = 'OPP'   THEN 'EPA Office of Pesticides Program Database'
                WHEN r.reference_type IN ('MED01','MED02','MED03','MED04','MED05') THEN 'EPA Fathead Minnow Acute Toxicity Database (MED-Duluth)'
                ELSE NULL
            END AS reftypedesc,
            r.doi, oq.pub_year, oq.num_tests, oq.num_results, oq.num_chemicals, oq.num_species, oq.citation
        FROM (                
            SELECT   
                iq.ecoref_number, iq.publication_year as pub_year
                , COUNT(DISTINCT iq.test_id) as num_tests, COUNT(DISTINCT iq.result_id) as num_results
                , COUNT(DISTINCT iq.cas_number) as num_chemicals, COUNT(DISTINCT iq.species_number) as num_species
                , iq.citation
            FROM (
                select
                    mv.ecoref_number, mv.test_id, mv.result_id, mv.cas_number, mv.species_number, mv.citation, mv.publication_year
                from
                    ecotox_group_summary3_mv mv
                WHERE (
                    mv.ecoref_number in (
                            
        SELECT DISTINCT v.ecoref_number
        FROM ecotox_group_summary3_mv v
        WHERE 1=1

        <!---
            this refers to the original group of ecorefs from EP, if applicable.  we always want to filter by these if there is a value,
            regardless of whether there is further filtering by other user inputs (ie. author/title below)
        --->
        <cfif IN_origreflist neq "">
            <cfif ListLen(IN_origreflist) LTE 1000>
                AND v.ecoref_number IN (<CFQUERYPARAM VALUE="#IN_origreflist#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
            <cfelse>
                <cfset arrayOfLists = GenFunc.splitListToSublists(IN_origreflist, 1000)>
                <cfif ArrayLen(arrayOfLists) GTE 1>
                AND (
                    <cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
                        <cfset thisSubList = arrayOfLists[i]>
                        <cfif i GT 1> OR </cfif>                            
                        v.ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                    </cfloop>
                )
                </cfif>
            </cfif>
        </cfif>

        <!--- for author / title --->
        <cfif IN_ecoref neq "All">
            <cfif ListLen(IN_ecoref) LTE 1000>
                AND v.ecoref_number IN (<CFQUERYPARAM VALUE="#IN_ecoref#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
            <cfelse>
                <cfset arrayOfLists = GenFunc.splitListToSublists(IN_ecoref, 1000)>
                <cfif ArrayLen(arrayOfLists) GTE 1>
                AND (
                    <cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
                        <cfset thisSubList = arrayOfLists[i]>
                        <cfif i GT 1> OR </cfif>                            
                        v.ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                    </cfloop>
                )
                </cfif>
            </cfif>
        </cfif>

        <!--- check group selectors --->
        <cfif IN_chemGroupId neq "All">
            <cfif IN_chemGroupId eq "99" AND IN_casList neq "">
                <cfif len(IN_casList)>                
                    <cfif ListLen(IN_casList) LTE 1000>
                        AND v.cas_number IN (<CFQUERYPARAM VALUE="#IN_casList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                    <cfelse>
                        <cfset arrayOfLists = GenFunc.splitListToSublists(IN_casList, 1000)>
                        <cfif ArrayLen(arrayOfLists) GTE 1>
                        AND (
                            <cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
                                <cfset thisSubList = arrayOfLists[i]>
                                <cfif i GT 1> OR </cfif>                            
                                v.cas_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                            </cfloop>
                        )
                        </cfif>
                    </cfif>
                </cfif>
            <cfelseif IN_chemGroupId eq "99" AND IN_dtsxIdList neq "">
                AND dtxsid IN (<CFQUERYPARAM VALUE="#IN_dtsxIdList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
            <cfelseif IN_chemGroupId eq "99">
                <!--- do nothing - this is handled with chemicals below --->
            <cfelse>
                AND cas_number IN (
                    SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
                )
            </cfif>
        </cfif>
        
        <cfif IN_specGroupId neq "All">
            <cfif IN_specGroupId eq "99" AND IN_ncbiList neq "">
                AND ncbi_taxid IN (<CFQUERYPARAM VALUE="#IN_ncbiList#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
            <cfelseif IN_specGroupId eq "99">
                <!--- do nothing - this is handled with species below --->
            <cfelse>
                AND v.species_list_id in (<CFQUERYPARAM VALUE="#IN_specGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
            </cfif>
        </cfif>

        <cfif IN_effGroupId neq "All" AND IN_effGroupId neq "99">
        <cfif ListLen(IN_effGroupId, ",") gt 1>
            AND (
                <cfloop from="1" to="#ListLen(IN_effGroupId)#" index="idx">
                    <cfif idx neq 1> OR </cfif>
                    (effect LIKE <CFQUERYPARAM VALUE="#ListGetAt(IN_effGroupId, idx)#%" CFSQLTYPE="CF_SQL_VARCHAR">)
                </cfloop>
            )
        <cfelse>
            AND effect LIKE <CFQUERYPARAM VALUE="#IN_effGroupId#%" CFSQLTYPE="CF_SQL_VARCHAR">
        </cfif>
        </cfif>

        <!--- check additional filters --->
        <cfif IN_chemListId neq "All">
            AND cas_number IN (
                SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
            )
        </cfif>

        <cfif IN_casId neq "All">
            AND v.cas_number IN (<CFQUERYPARAM VALUE="#IN_casId#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
        </cfif>
        
        <cfif IN_speciesListId neq "All">
            AND v.species_list_id in (<CFQUERYPARAM VALUE="#IN_speciesListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
        </cfif>		

        <cfif IN_class neq "All">
            AND v.class IN (<CFQUERYPARAM VALUE="#IN_class#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>		
        
        <cfif IN_taxOrder neq "All">
            AND v.tax_order IN (<CFQUERYPARAM VALUE="#IN_taxOrder#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>	

        <cfif IN_genus neq "All">
            AND v.genus IN (<CFQUERYPARAM VALUE="#IN_genus#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>
        
        <cfif IN_family neq "All">
            AND v.family IN (<CFQUERYPARAM VALUE="#IN_family#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>

        <cfif IN_speciesId neq "All">
            AND v.species_number IN (<CFQUERYPARAM VALUE="#IN_speciesId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
        </cfif>

        <cfif IN_special neq "All">
            <cfset loop = 0>
            AND (
            <cfloop index="thisSpecInt" list="#IN_special#" delimiters=",">
                <cfif loop gt 0> OR </cfif>
                (#thisSpecInt# = 'Y')
                <cfset loop = loop + 1>
            </cfloop>
            )
        </cfif>
        
        <cfif IN_effectId neq "All">
            AND v.effect IN (<CFQUERYPARAM VALUE="#IN_effectId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>
        
        <cfif IN_measurementId neq "All">
            AND v.measurement IN (<CFQUERYPARAM VALUE="#IN_measurementId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>
                
        <!--- custom effects / measurement groups --->
        <cfif concatCustEffMeasList neq "All">
            AND CONCAT(v.effect, v.measurement) IN (<CFQUERYPARAM VALUE="#concatCustEffMeasList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>
        
        <cfif IN_endpointId neq "All">
            AND v.endpoint IN (<CFQUERYPARAM VALUE="#IN_endpointId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>

        <!--- DURATION LOGIC HERE (v.) --->
        <cfinclude template="../../../pages/explore/duration_logic_sql.cfm">

        <cfif IN_habitat neq "All">
            AND v.habitat IN (<CFQUERYPARAM VALUE="#IN_habitat#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>
        
            AND v.publication_year between <CFQUERYPARAM VALUE="#IN_pubYearMin#" CFSQLTYPE="CF_SQL_VARCHAR"> AND <CFQUERYPARAM VALUE="#IN_pubYearMax#" CFSQLTYPE="CF_SQL_VARCHAR">
        
            <!--- special interest groups are no longer determined by species group, so include this to make sure not to return any of these items matching species_list_id between 13-15 --->
            AND (v.species_list_id IS NULL OR v.species_list_id NOT IN (13,14,15))
            
                    )
                )
            ) iq
            GROUP BY iq.ecoref_number, iq.citation, iq.publication_year
        ) oq
        INNER JOIN REFERENCES r ON r.reference_number = oq.ecoref_number

    </cfquery>
    
<!---     <cflog text ="#PubsSummaryExportVars.sql#"> --->
<!---     <cflog text ="#ArrayToList(PubsSummaryExportVars.sqlparameters)#"> --->
    
<cfcatch type="database">  
    
    <cfdump var="#cfcatch#" output="console"><cfabort>

<!--- ADD BACK IN AT LATER DATE			
    <cfset SQLErrorOccurred = 1>
--->

    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>

    <cfif thisInternalOnly eq 1>
        <cfinclude template="outputError.cfm">
    <cfelse>
        <cfinclude template="emailError.cfm">
    </cfif>

    <cfif errorDetail eq "[Macromedia][Oracle JDBC Driver]Execution timeout expired.">
        <cfinclude template="timeout_error.cfm">
    <cfelse>
        <cfinclude template="db_error.cfm">
    </cfif>
                    
</cfcatch>
</cftry>
</cflock>
