
<CFLOCK TIMEOUT="30" throwontimeout="no" TYPE="readonly" scope="application">
    <CFSET thisRecordMax = duplicate(Application.RecordMax)>  <!--- SPE 4/27/06 --->
    <CFSET thisInternalOnly = duplicate(Application.internalOnly)>  <!--- SPE 4/27/06 --->
</CFLOCK>

<cfif ExportQuery.RecordCount is 0>

    <div class="callout primary">
        <h5 class="title">Sorry</h5>
        <p>There were no results found for this search. Please refine your search.</p>
    </div>
  
<cfelseif ExportQuery.RecordCount gt thisRecordMax> <!--- SPE 04/27/06 --->

    <div class="callout alert">
        <h5 class="title">Warning</h5>
        <p>There were too many results found to display in a browser report format.  There is a limit of <cfoutput>#thisRecordMax#</cfoutput> records for a browser viewable report. Please refine your search.</p>
    </div>

<cfelse>
    <cfprocessingdirective suppressWhiteSpace = "Yes">
        <cfsetting enablecfoutputonly="Yes">
        
        <CFHEADER NAME="Content-Disposition" VALUE="attachment; filename=AquaticReport.txt">
        <CFCONTENT TYPE="text/plain">

        <cfset AquaticFieldList = "">
        <cfset indexList = "">
        <cfset count = 0>
        <cfset standardIndexList = "">
        <cfset standardUnitIndex = 0>
        <cfif ArrayLen(aquireOutputFields) is not 0>
            <CFLOOP index = "i" from = "1" to = "#ArrayLen(aquireOutputFields)#">
                <cfloop index=j list="#aquireOutputFields[i][1]#" delimiters=",">
                    <cfloop index=k list="#j#" delimiters="|">
                        <cfset indexOf = ListFind(AquaticFieldList,"#trim(k)#")>
                        <cfif indexOf eq 0>
                            <!--- Excludes heading contatenated full field display of each of these in favor of the meanOp/mean/minOp/min/maxOp/max display ---> 
                            <!--- 06/09/16 SPE - made this the same field list as Excel, from aquire_report_excel.cfm --->
                            <cfif  trim(k) neq "Temperature" and trim(k) neq "Hardness" and trim(k) neq "Alkalinity" and trim(k) neq "pH" and trim(k) neq "Salinity" and trim(k) neq "Conductivity" and trim(k) neq "Organic Carbon Value" and trim(k) neq "Dissolved Oxygen" and trim(k) neq "Water Depth" and trim(k) neq "Multiplier" and trim(k) neq "Calcium" and trim(k) neq "Chemical Purity" and trim(k) neq "Chlorine" and trim(k) neq "Dissolved Inorganic Carbon" and trim(k) neq "Humic Acid" and trim(k) neq "Magnesium" and trim(k) neq "Species Final Weight" and trim(k) neq "Organism Initial Weight" and trim(k) neq "Potassium" and trim(k) neq "Sodium" and trim(k) neq "Sulfate" and trim(k) neq "Sulfur" and trim(k) neq "Organism Age" and trim(k) neq "Observed Duration (Author)"  and trim(k) neq "Observed Duration (Days)" and trim(k) neq "Study Duration (Author)" and trim(k) neq "Study Duration (Days)" and trim(k) neq "Effect Percent" and trim(k) neq "Significance Level" and trim(k) neq "Application Frequency" and trim(k) neq "Result Percent Lipid" and trim(k) neq "Intake Rate" and trim(k) neq "Result Percent Dry/Wet Weight" and trim(k) neq "Exposure Duration (Author)" and trim(k) neq "Exposure Duration (Days)" and trim(k) neq "Organism Initial Length">
                                <cfset AquaticFieldList = Listappend(AquaticFieldList,trim(k))>
                                <cfif Find(" ",k)>
                                    <cfoutput>"#k#"|</cfoutput>
                                <cfelse>
                                    <cfoutput>#k#|</cfoutput>
                                </cfif>
                            </cfif>
                        <cfelse>
                            <cfset indexList = Listappend(indexList,count)>
                        </cfif>
                        <cfset count = count + 1>
                    </cfloop>
                </cfloop>
            </CFLOOP>
            <cfoutput>#chr(13)##chr(10)#</cfoutput>
        </cfif>
            
        <cfset fieldsToInclude="TEST_PURITY,AGE,BCF1_MEAN,BCF1_MIN,BCF1_MAX,TEST_DURATION_STD,MIN_DURATION_STD,MAX_DURATION_STD,TEST_DURATION,MIN_DURATION,MAX_DURATION,EFFECT_PERCENT_MEAN,EFFECT_PERCENT_MIN,EFFECT_PERCENT_MAX,STATISTICAL_SIG,CONC1_MEAN,CONC1_MIN,CONC1_MAX,APP_RATE,CONC1_MEAN_STD,CONC1_MIN_STD,CONC1_MAX_STD,APP_FREQUENCY_VALUE,TEMPERATURE,TEMP_MEAN_VALUE,TEMP_MIN_VALUE,TEMP_MAX_VALUE,HARDNESS,HARD_MEAN_VALUE,HARD_MIN_VALUE,HARD_MAX_VALUE,ALKALINITY,ALKA_MEAN_VALUE,ALKA_MIN_VALUE,ALKA_MAX_VALUE,PH,PH_MEAN_VALUE,PH_MIN_VALUE,PH_MAX_VALUE,SALINITY,SAL_MEAN_VALUE,SAL_MIN_VALUE,SAL_MAX_VALUE,CONDUCTIVITY,COND_MEAN_VALUE,COND_MIN_VALUE,COND_MAX_VALUE,ORGANIC_CARBON,ORG_MEAN_VALUE,ORG_MIN_VALUE,ORG_MAX_VALUE,DISSOLVED_OXYGEN,DISS_MEAN_VALUE,DISS_MIN_VALUE,DISS_MAX_VALUE,WATER_DEPTH,DEPTH_MEAN_VALUE,DEPTH_MIN_VALUE,DEPTH_MAX_VALUE,HALFLIFE_MEAN,HALFLIFE_MIN,HALFLIFE_MAX">
        <cfloop query="ExportQuery">
            <cfset count = 0>
            <cfif ArrayLen(aquireOutputFields) is not 0>
                <CFLOOP index = "i" from = "1" to = "#ArrayLen(aquireOutputFields)#">
                    <cfloop index=j list="#aquireOutputFields[i][3]#" delimiters=",">
                        <cfif ListFind(indexList,"#count#") eq 0>
                            <!--- Excludes column contatenated full field display of each of these in favor of the meanOp/mean/minOp/min/maxOp/max display ---> 
                            <cfif  trim(j) neq "TEMPERATURE" and trim(j) neq "HARDNESS" and trim(j) neq "ALKALINITY" and trim(j) neq "PH" and trim(j) neq "SALINITY" and trim(j) neq "CONDUCTIVITY" and trim(j) neq "ORGANIC_CARBON" and trim(j) neq "DISSOLVED_OXYGEN" and trim(j) neq "WATER_DEPTH" and trim(j) neq "UG_L_MULT" and trim(j) neq "CALCIUM" and trim(j) neq "TEST_PURITY" and trim(j) neq "CHLORINE" and trim(j) neq "DISS_CARBON" and trim(j) neq "HUMIC_ACID" and trim(j) neq "MAGNESIUM" and trim(j) neq "ORGANISM_FINAL_WT" and trim(j) neq "ORGANISM_INIT_WT" and trim(j) neq "POTASSIUM" and trim(j) neq "SODIUM" and trim(j) neq "SULFATE" and trim(j) neq "SULFUR" and trim(j) neq "AGE" and trim(j) neq "AGE_DESC" and trim(j) neq "TEST_DURATION_CONCAT" and trim(j) neq "TEST_DURATION_CONCAT_LONG" and trim(j) neq "TEST_DURATION_STD_CONCAT" and trim(j) neq "TEST_DURATION_STD_CONCAT_LONG" and trim(j) neq "STUDY_DURATION_CONCAT" and trim(j) neq "STUDY_DURATION_CONCAT_LONG" and trim(j) neq "STUDY_DURATION_STD_CONCAT" and trim(j) neq "STUDY_DURATION_STD_CONCAT_LONG" and trim(j) neq "EFFECT_PCT" and trim(j) neq "STATISTICAL_SIG" and trim(j) neq "APPLICATION_FREQ_SORT" AND TRIM(j) neq "PERCENT_LIPID" and trim(j) neq "INTAKE_RATE" and trim(j) neq "DRY_WEIGHT_PERCENT" and trim(j) neq "EXPOSURE_DURATION_CONCAT" and trim(j) neq "EXPOSURE_DURATION_CONCAT_LONG" and trim(j) neq "EXPOSURE_DUR_STD_CONCAT" and trim(j) neq "EXPOSURE_DUR_STD_CONCAT_LONG" and trim(j) neq "ORGANISM_LENGTH" and trim(j) neq "ORGANISM_LENGTH_DESC">

                                <cfset colVal = replace(evaluate(j), "#Chr(13)##Chr(10)#", " ", "ALL")>
                                <cfoutput><cfif Find("-",colVal) neq 0 and left(trim(colVal),1) neq "-" AND ListFind(fieldsToInclude,j,",") neq 0>'</cfif><cfif j eq "/">&nbsp;<cfelseif right(j,1) eq "/">#replace(right(colVal,len(colVal)-1),"<BR>"," , ","ALL")#|<cfelse>#replace(colVal,"<BR>"," , ","ALL")#|</cfif></cfoutput>
                            </cfif>
                        </cfif>
                        <cfset count = count + 1>
                    </cfloop>
                </CFLOOP>
                <cfoutput>#chr(13)##chr(10)#</cfoutput>
            </cfif>	
        </CFLOOP>
    </cfprocessingdirective>		
</cfif>