<cfset GenFunc = CreateObject("component", "cfc.generic_functions")>

<!--- format query data in JSON for Vega chart.  Example output:
[{"cas":335671,"dur":".0104","conc":"100000"},
{"cas":335671,"dur":".1875","conc":"1"}]
--->
<cfinclude template="explore_param_check.cfm" />

<cfprocessingdirective suppresswhitespace="yes">
<cfsetting showdebugoutput="no">

<cfset cleanConcMean = "CAST(REGEXP_REPLACE(v.conc1_mean_std, '[^0-9.]', '') as FLOAT)">
<cfset effect_group_mod = "REPLACE(v.effect_desc, ' (Delayed)', '')">
    
    <!--- ANY OTHERS HERE???? --->
    

<!--- cached for one hour --->
<cfquery name="CASQuery" datasource="#application.datasource#" cachedWithin="#CreateTimeSpan(0,0,5,0)#">

    SELECT iq.cas, iq.cas_num, iq.dur, iq.effect, iq.conc, iq.c_unit, iq.result_id, iq.latin_name, iq.endpoint, iq.class, iq.tax_order, iq.family, iq.genus, iq.measurement_desc, iq.species_group, iq.ecoref_number, iq.test_id
    FROM (
        SELECT DISTINCT
            CASE WHEN LENGTH(v.epa_chem_substance_name) > 25 THEN (
                CASE WHEN INSTR(SUBSTR(v.epa_chem_substance_name, 1, 25), ' ', -1) > 0 THEN SUBSTR(v.epa_chem_substance_name, 1, (INSTR(SUBSTR(v.epa_chem_substance_name, 1, 25), ' ', -1)-1)) || '...'
                ELSE SUBSTR(v.epa_chem_substance_name, 1, 25) || '...'
                END
            )
            ELSE v.epa_chem_substance_name
            END as cas
            , v.cas_number as cas_num, v.obs_duration_std as dur, #PreserveSingleQuotes(effect_group_mod)# as effect, #PreserveSingleQuotes(cleanConcMean)# as conc, v.conc_units_std as c_unit, result_id, v.latin_name, v.endpoint, v.class, v.tax_order, v.family, v.genus, v.measurement_desc, v.species_group, v.ecoref_number, v.test_id
                
        FROM ecotox_group_summary3_mv v

        WHERE NOT v.obs_duration_std like '%NR' AND NOT v.conc1_mean_std like '%NR'
            AND (conc_units_std IN ('AI mg/L','AI mg/kg food','AI mg/kg bdwt','AI mg/kg soil','AI ug/g food','AI ug/g org')
            OR conc_units_std IN (SELECT code FROM concentration_conversions WHERE mg_l_mult = 1))
            AND conc_units_std NOT LIKE '%/org%'

        <!---
            this refers to the original group of ecorefs from EP, if applicable.  we always want to filter by these if there is a value,
            regardless of whether there is further filtering by other user inputs (ie. author/title below)
        --->
        <cfif IN_origreflist neq "">
            <cfif ListLen(IN_origreflist) LTE 1000>
                AND v.ecoref_number IN (<CFQUERYPARAM VALUE="#IN_origreflist#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
            <cfelse>
                <cfset arrayOfLists = GenFunc.splitListToSublists(IN_origreflist, 1000)>
                <cfif ArrayLen(arrayOfLists) GTE 1>
                AND (
                    <cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
                        <cfset thisSubList = arrayOfLists[i]>
                        <cfif i GT 1> OR </cfif>                            
                        v.ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                    </cfloop>
                )
                </cfif>
            </cfif>
        </cfif>

        <!--- for author / title --->
        <cfif IN_ecoref neq "All">
            <cfif ListLen(IN_ecoref) LTE 1000>
                AND v.ecoref_number IN (<CFQUERYPARAM VALUE="#IN_ecoref#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
            <cfelse>
                <cfset arrayOfLists = GenFunc.splitListToSublists(IN_ecoref, 1000)>
                <cfif ArrayLen(arrayOfLists) GTE 1>
                AND (
                    <cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
                        <cfset thisSubList = arrayOfLists[i]>
                        <cfif i GT 1> OR </cfif>                            
                        v.ecoref_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                    </cfloop>
                )
                </cfif>
            </cfif>
        </cfif>
            
        <!--- check group selectors --->
        <cfif IN_chemGroupId neq "All">
            <cfif IN_chemGroupId eq "99" AND IN_casList neq "">
                <cfif len(IN_casList)>                
                    <cfif ListLen(IN_casList) LTE 1000>
                        AND cas_number IN (<CFQUERYPARAM VALUE="#IN_casList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                    <cfelse>
                        <cfset arrayOfLists = GenFunc.splitListToSublists(IN_casList, 1000)>
                        <cfif ArrayLen(arrayOfLists) GTE 1>
                        AND (
                            <cfloop index="i" from="1" to="#ArrayLen(arrayOfLists)#">
                                <cfset thisSubList = arrayOfLists[i]>
                                <cfif i GT 1> OR </cfif>                            
                                cas_number IN (<CFQUERYPARAM VALUE="#thisSubList#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
                            </cfloop>
                        )
                        </cfif>
                    </cfif>
                </cfif>
            <cfelseif IN_chemGroupId eq "99" AND IN_dtsxIdList neq "">
                AND dtxsid IN (<CFQUERYPARAM VALUE="#IN_dtsxIdList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
            <cfelseif IN_chemGroupId eq "99">
                <!--- do nothing - this is handled with chemicals below --->
            <cfelse>
                AND cas_number IN (
                    SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
                )
            </cfif>
        </cfif>
        
        <cfif IN_specGroupId neq "All">
            <cfif IN_specGroupId eq "99" AND IN_ncbiList neq "">
                AND ncbi_taxid IN (<CFQUERYPARAM VALUE="#IN_ncbiList#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
            <cfelseif IN_specGroupId eq "99">
                <!--- do nothing - this is handled with species below --->
            <cfelse>
                AND species_list_id in (<CFQUERYPARAM VALUE="#IN_specGroupId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
            </cfif>
        </cfif>
        
        <cfif IN_effGroupId neq "All" AND IN_effGroupId neq "99">
            <cfif ListLen(IN_effGroupId, ",") gt 1>
                AND (
                    <cfloop from="1" to="#ListLen(IN_effGroupId)#" index="idx">
                        <cfif idx neq 1> OR </cfif>
                        (effect LIKE <CFQUERYPARAM VALUE="#ListGetAt(IN_effGroupId, idx)#%" CFSQLTYPE="CF_SQL_VARCHAR">)
                    </cfloop>
                )
            <cfelse>
                AND effect LIKE <CFQUERYPARAM VALUE="#IN_effGroupId#%" CFSQLTYPE="CF_SQL_VARCHAR">
            </cfif>
        </cfif>
        
        <!--- check additional filters --->
        <cfif IN_chemListId neq "All">
            AND cas_number IN (
                SELECT DISTINCT CAS_NUMBER from CHEMICAL_LIST_XREF CX WHERE CX.CHEMICAL_LISTID IN (<CFQUERYPARAM VALUE="#IN_chemListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
            )
        </cfif>
        
        <cfif IN_casId neq "All">
            AND cas_number IN (<CFQUERYPARAM VALUE="#IN_casId#" CFSQLTYPE="CF_SQL_BIGINT" LIST="yes">)
        </cfif>

        <cfif IN_speciesListId neq "All">
            AND species_list_id in (<CFQUERYPARAM VALUE="#IN_speciesListId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
        </cfif>		
	
        <cfif IN_class neq "All">
            AND class IN (<CFQUERYPARAM VALUE="#IN_class#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>		

        <cfif IN_taxOrder neq "All">
            AND tax_order IN (<CFQUERYPARAM VALUE="#IN_taxOrder#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>	

        <cfif IN_genus neq "All">
            AND genus IN (<CFQUERYPARAM VALUE="#IN_genus#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>

        <cfif IN_family neq "All">
            AND family IN (<CFQUERYPARAM VALUE="#IN_family#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>
        
        <cfif IN_speciesId neq "All">
            AND species_number IN (<CFQUERYPARAM VALUE="#IN_speciesId#" CFSQLTYPE="CF_SQL_INTEGER" LIST="yes">)
        </cfif>

        <cfif IN_special neq "All">
            <cfset loop = 0>
            AND (
            <cfloop index="thisSpecInt" list="#IN_special#" delimiters=",">
                <cfif loop gt 0> OR </cfif>
                 (#thisSpecInt# = 'Y')
                <cfset loop = loop + 1>
            </cfloop>
            )
        </cfif>
        
        <cfif IN_effectId neq "All">
            AND effect IN (<CFQUERYPARAM VALUE="#IN_effectId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>

        <cfif IN_measurementId neq "All">
            AND measurement IN (<CFQUERYPARAM VALUE="#IN_measurementId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>
        
        <!--- custom effects / measurement groups --->
        <cfif concatCustEffMeasList neq "All">
            AND CONCAT(effect, measurement) IN (<CFQUERYPARAM VALUE="#concatCustEffMeasList#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>

        <cfif IN_endpointId neq "All">
            AND endpoint IN (<CFQUERYPARAM VALUE="#IN_endpointId#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>

        <!--- DURATION LOGIC HERE (v.) --->
	    <cfinclude template="duration_logic_sql.cfm">

        <cfif IN_habitat neq "All">
            AND v.habitat IN (<CFQUERYPARAM VALUE="#IN_habitat#" CFSQLTYPE="CF_SQL_VARCHAR" LIST="yes">)
        </cfif>

        AND publication_year between <CFQUERYPARAM VALUE="#IN_pubYearMin#" CFSQLTYPE="CF_SQL_VARCHAR"> AND <CFQUERYPARAM VALUE="#IN_pubYearMax#" CFSQLTYPE="CF_SQL_VARCHAR">

        <!--- special interest groups are no longer determined by species group, so include this to make sure not to return any of these items matching species_list_id between 13-15 --->
        <!--- algae/moss/fungi split into 3 groups so exclude the old combined group as well (11) --->
        AND (v.species_list_id IS NULL OR v.species_list_id NOT IN (11,13,14,15))
                
        <!--- THIS MAY CHANGE?? --->
        ORDER BY #PreserveSingleQuotes(cleanConcMean)#
    ) iq
    WHERE rownum <= #Application.ExploreRecordMax#  <!--- prevent overload of jQuery datatable; 5000 worked too. --->

</cfquery>

<cfset jsonString = "">
<cfloop query="CASQuery">
    
    <cfset jsonString = listAppend(jsonString,'{"cas":"#cas#","cas_num":"#cas_num#","effect":"#effect#","dur":"#dur#","conc":"#conc#","c_unit":"#c_unit#","id":"#result_id#","spec":"#latin_name#","endpoint":"#endpoint#","tax_class":"#class#","family":"#family#","tax_ord":"#tax_order#","genus":"#genus#","meas":"#measurement_desc#","spec_grp":"#species_group#","refNum":"#ecoref_number#","testId":"#test_id#"}')>	
        
</cfloop>
    
<cfoutput>
    [#jsonString#]
</cfoutput>

</cfprocessingdirective>