
<cfparam name="URL.category" default="">

<cfif URL.category eq "Chemicals">
	<cfset view_name = "chemical_group_top_mv">
	<cfset id_field = "chemical_list_id">
	<cfset desc_field = "chemical_list_desc">
<cfelseif URL.category eq "Species">
	<cfset view_name = "species_group_top_mv">
	<cfset id_field = "species_list_id">
	<cfset desc_field = "species_list_desc">
<cfelseif URL.category eq "Effects">
	<cfset view_name = "effects_group_top_mv">
	<cfset id_field = "effect_code">
	<cfset desc_field = "effect_description">
</cfif>

<cfquery name="TopQuery" datasource="#application.datasource#" dbtype="Oracle80" cachedWithin="#CreateTimeSpan(0,1,0,0)#">
	SELECT v.#id_field# as THIS_ID, v.#desc_field# as THIS_DESC, v.sel_index, v.num_records, v.pub_count, v.year_min, v.year_max
	FROM #view_name# v
	<cfif URL.category eq "Chemicals">
	WHERE NOT v.chemical_list_id = 33
	ORDER BY v.chemical_list_desc
	<cfelseif URL.category eq "Species">
	WHERE NOT v.species_list_id in (11,13,14,15)
	<cfelseif URL.category eq "Effects">
	WHERE NOT v.effect_code in ('NER')
	</cfif>
</cfquery>


<cfset jsonString = "">
<cfoutput>

<cfloop query="TopQuery">
	<cfset jsonString = listAppend(jsonString,'{"thisId":"#THIS_ID#","thisDesc":"#THIS_DESC#","numRecords":"#num_records#","pubCount":"#pub_count#","yearMin":"#year_min#","yearMax":"#year_max#"}')>
</cfloop>

[#jsonString#]
</cfoutput>