<cfset paramsList = "Chemicals,Effects,Endpoints,Species,Test Conditions,Publication Options" />
<cfset lParamsSidebarIDs = "">
<cfset sParamsSidebarIDs = "">
<cfloop index="ParamItem" list="#paramsList#">
  <cfscript>
    titleCase = Replace(LCase(ParamItem), " conditions", "");
    titleCase = Replace(LCase(titleCase), " options", "");
    titleCase = titleCase & "ParamsSidebar";

    // list form
    lParamsSidebarIDs = ListAppend(lParamsSidebarIDs, titleCase);
    // string form
    sParamsSidebarIDs = sParamsSidebarIDs & " " & titleCase;
  </cfscript>
</cfloop>

<cfset sParamsSidebarIDs = LTRIM(sParamsSidebarIDs)>

<aside id="searchSidebar" class="sidebar off-canvas-absolute position-left" data-off-canvas data-transition="overlap">
  <div class="inner" data-stick-container>
    <nav class="page-header sub-nav">
      <h3><a data-toggle="searchSidebar">
        <svg class="icon arrow hide-for-large" width="12" height="12"><use xlink:href="#chevron-left"></use></svg>
        Parameters
        <svg class="icon float-right" width="14" height="14"><use xlink:href="#adjust"></use></svg></a></h3>
    </nav>

    <cfset i = 1>
    <cfloop index="ParamItem" list="#paramsList#">
      <cfscript>
        titleCase = listGetAt(lParamsSidebarIDs,i);
        toggleCloseList = ListDeleteAt(lParamsSidebarIDs,i);
        toggleCloseListIDs = "";
      </cfscript>

      <cfloop index="ToggleCloseListItem" list="#toggleCloseList#">
        <cfscript>
          toggleCloseListIDs = toggleCloseListIDs & " " & ToggleCloseListItem;
        </cfscript>
      </cfloop>

      <cfset toggleCloseListIDs = LTRIM(toggleCloseListIDs)>

      <div class="card parameter default" data-search-param="<cfoutput>#ParamItem#</cfoutput>">
        <button data-toggle="<cfoutput>#titleCase#</cfoutput>" data-close="<cfoutput>#toggleCloseListIDs#</cfoutput>">
          <h4><cfoutput>#ParamItem#</cfoutput>
            <span class="new">
              <span class="show-for-sr">Has unapplied Changes</span>
              <svg class="icon" width="14" height="14"><use xlink:href="#circle-o"></use></svg>
            </span>
            <svg class="icon" width="14" height="14"><use xlink:href="#plus"></use></svg>
            <svg class="icon open" width="12" height="12"><use xlink:href="#chevron-right"></use></svg>
          </h4>
        </button>
        <div id="<cfoutput>#titleCase#Filters</cfoutput>" class="sidebarFilter"></div>
      </div>

      <cfset i = i + 1>
    </cfloop>

    <div class="text-center">
      <cfoutput><button class="reset-all button warning" data-close="#sParamsSidebarIDs# searchSidebar"></cfoutput>Reset All</button>
      <div class="update-search-container">
        <cfoutput><button class="update-search button success" data-close="#sParamsSidebarIDs# searchSidebar"></cfoutput>
          <svg class="icon left" width="14" height="14" aria-hidden="true"><use xlink:href="#update"></use></svg>
          Update Search</button>
      </div>
      <cfoutput><button class="show-all button" data-open="allParametersModal" data-close="#sParamsSidebarIDs#"></cfoutput>
        View All Applied</button>
    </div>
  </div>
</aside>

<div class="reveal" id="allParametersModal" data-reveal>
  <h2>All Applied Parameters</h2>
  <button class="close-button" data-close aria-label="Close modal" type="button">
    <span aria-hidden="true"><svg width="14" height="14"><use xlink:href="#times"></use></svg></span>
  </button>

  <div id="reviewSearchModal"></div>

  <div class="reveal-footer">
	<button id="exportSearchParams" class="button export">Export</button>
    <button class="button cancel" data-close>Close</button>
  </div>
</div>
