1
         This dataset is named 'STORET.HELP.SAS'.


        Issue "SPRINT 'STORET.HELP.SAS' UPLOW CC LOCAL FORMS(6371)"
          to obtain documentation-quality listings of this
                            dataset.

1XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 X                                                                     X
 X    X    X   X  X   X   XXX   X   X  X   X   XXX  XXX  X   X   XXX   X
 X   X X   XX  X  XX  X  X   X  X   X  XX  X  X   X  X   XX  X  X   X  X
 X  X   X  XX  X  XX  X  X   X  X   X  XX  X  X      X   XX  X  X      X
 X  XXXXX  X X X  X X X  X   X  X   X  X X X  X      X   X X X  X      X
 X  X   X  X  XX  X  XX  X   X  X   X  X  XX  X      X   X  XX  X  XX  X
 X  X   X  X  XX  X  XX  X   X  X   X  X  XX  X   X  X   X  XX  X   X  X
 X  X   X  X   X  X   X   XXX    XXX   X   X   XXX  XXX  X   X   XXX   X
 X                                                                     X
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXX        XXX         XXX        XXX         XXX         XX         XX
 XX          XX         XX          XX          XX         XX         XX
 XX   XXXX   XXXXX   XXXXX   XXXX   XX   XXXX   XX   XXXXXXXXXXX   XXXXX
 XX   XXXXXXXXXXXX   XXXXX   XXXX   XX   XXXX   XX   XXXXXXXXXXX   XXXXX
 XX         XXXXXX   XXXXX   XXXX   XX          XX      XXXXXXXX   XXXXX
 XXX         XXXXX   XXXXX   XXXX   XX         XXX      XXXXXXXX   XXXXX
 XXXXXXXXX   XXXXX   XXXXX   XXXX   XX   X   XXXXX   XXXXXXXXXXX   XXXXX
 XX   XXXX   XXXXX   XXXXX   XXXX   XX   XX   XXXX   XXXXXXXXXXX   XXXXX
 XX          XXXXX   XXXXX          XX   XXX   XXX         XXXXX   XXXXX
 XXX        XXXXXX   XXXXXX        XXX   XXXX   XX         XXXXX   XXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXX         XXX        XXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXX         XX          XXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXX   XXXXX   XXXX   XXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXX   XXXXX   XXXX   XXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXX   XXXXX   XXXX   XXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXX   XXXXX   XXXX   XXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXX   XXXXX   XXXX   XXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXX   XXXXX   XXXX   XXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXX   XXXXX          XXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXX   XXXXXX        XXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXX        XXXXXXX   XXXXXXX        XXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXX          XXXXX     XXXXX          XXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXX   XXXX   XXXX   X   XXXX   XXXX   XXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXX   XXXXXXXXXX   XXX   XXX   XXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXX         XXXX   XXX   XXX         XXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXX         XXX         XXXX         XXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXX   XXX         XXXXXXXXXX   XXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXX   XXXX   XXX   XXX   XXX   XXXX   XXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXX          XXX   XXX   XXX          XXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXX        XXXX   XXX   XXXX        XXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX                                 XX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX          COMPLIMENTS            XX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX              OF                 XX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX      STORET USER ASSISTANCE     XX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX                                 XX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX ENVIRONMENTAL PROTECTION AGENCY XX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX                                 XX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
1                                                                 Page 1

      The STORET User Assistance Section is pleased to announce the
 full availability of all SAS capabilities within STORET.  The excellent
 analytical software available in the Statistical Analysis System, a
 proprietary software package from The SAS Institute, Cary NC, has been
 interfaced to STORET, and may now be used by STORET users to enhance
 or extend their analyses of STORET water quality data.

      STORET users with knowledge of SAS techniques may now invoke SAS
 via the STORET keywords

                PGM= . . . .
                .
                (usual STORET request here)
                .
                SASPARMS=BEGIN,
                .
                (valid SAS statements here)
                .
                STOPSAS,

      Users should especially note that NO new IBM Job Control Language
 is required in order to use SAS.

      Users should also note that SAS may be a valid add-on to ANY
 STORET program, not just PGM=RET.

      Used in this way, SAS has the ability to read ANY of the several
 machine-readable files produced in the course of a STORET analysis.
 You need code only an appropriate SAS "INFILE" and "INPUT" sequence,
 to give SAS full access to your STORET data.

      We regret that our limited resources make us unable to provide
 training and documentation in the use of SAS.  However, The SAS
 Institute will provide training (at your expense), and their
 documentation ("SAS Users Guide" and "SAS Graph Users Guide") is
 excellent.  Many users have achieved competence without the benefit
 of formal training.

      Presented here are several examples of STORET-SAS runs, showing
 the type of capability available, and the general form of the keyword
 instructions necessary.


1                                                                 Page 2

      Example 1.  A Plot of Temperature and Dissolved Oxygen
      ------------------------------------------------------

      In this example, STORET is used to select a subset of available
 raw data at two sampling sites.  SAS is used to produce a plot of the
 data using its line-printer plotting package, "PROC PLOT".

       00010 PGM=RET,MORE=SAS,PRT=NO,
       00020 A=1110NET,S=230040,S=230041,P=10,P=300,BD=60,ED=62,
       00030   SASPARMS=BEGIN,
       00040 OPTIONS LS=71;
       00050 DATA ANYNAME;
       00060 INFILE FCF;
       00070 INPUT @26 YY $2. @;
       00080 IF YY='99' THEN DELETE; DROP YY;
       00090 FORMAT AGN_STA $24.;
       00100 FORMAT DATE YYMMDD8.;
       00110 INPUT @1   AGN        $8.
       00120       @9   STN       $15.
       00130       @26  DATE  YYMMDD6.
       00140       @36  TEMP_C    RB4.
       00150            DISS_OX   RB4.   ;
       00160 AGN_STA=AGN||' '||STN; DROP AGN STN;
       00170 PROC PLOT; BY AGN_STA;
       00180 PLOT TEMP_C * DATE / VPOS=40 ;
       00190 PLOT DISS_OX * DATE / VPOS=40 ;
       00200 TITLE 'EXAMPLE 1';
       00210 STOPSAS,
       00220 ./iii      JOB (aaaaSTORPuuu,Miii),STORET,TIME=5,
       00230 ./             MSGLEVEL=(1,1),PRTY=1
       00240 **ROUTE  PRINT HOLD
       00250 **JOBPARM LINES=10

      The retrieval is coded using the %RET command under a TSO session,
 in a manner identical to that used for any STORET request.  After it
 has been "SAVED", it is syntax-checked and submitted using the
 STORET command "%SCAN".

      SAS keywords are checked for syntax errors by the "%SCAN", and
 the retrieval thus submitted is free of both STORET and SAS errors.

         Explanation of Example 1
         ------------------------

 Lines 10   A typical STORET retrieval request, in which raw data
  thru 20   is requested (PGM=RET) from two sampling sites, on
            two parameters, for three years of the period of record.
            A Further Computational File (FCF) is requested using
            MORE=SAS.  With this format, any missing values in
            STORET will be output using SAS missing value
            conventions, and station descriptions and parameter
            headers are omitted.

 Line 30    SAS/STORET boundary. Below this point, only SAS
            statements are valid, up to the STOPSAS.
1                                                                 Page 3

 Line 40    SAS OPTIONS.  SAS Source will be limited to 72
            columns of user input.  SAS reports will be limited
            to 71 columns of printer output.

 Line 50    Start of the "DATA" step of SAS. Names the SAS
            scratch dataset to be used.

 Line 60    Tells SAS to use FCF as input data.

 Lines 70   Pre-read each record in FCF, checking for '99'
  thru 80   in the year portion of the date.  These records
            are STORET delimiters, placed between stations
            in the FCF, and are ignored here.

 Lines 90   Define default formats for two variables for
  thru 100  display purposes and length considerations.

 Lines 110  Input and format layout of incoming FCF data.
  thru 150  For further information, refer to STORET
            documentation, Advanced Section.

 Line  160  Create a new variable by concatenation of
            AGN, a blank, and STN.
            Last statement in the SAS DATA step.
            Statements in the DATA step will repeat
            in cycle until the INFILE is exhausted.

 Line 170   Invokes PROC PLOT.

 Lines 180  Request the desired plots. Limit the vertical
  thru 200  size of the plot field to 40 printer-lines.
            Title the plot as shown.

 Line  210  SAS/STORET delimiter.  NOTE THE COMMA.
            This is a STORET instruction, and uses
            the COMMA to indicate END-OF-INSTRUCTION.

 Lines 220  A Standard STORET imbedded job-card.
  thru 250  "iii" is your initials, "aaaa" your account,
            and so forth.

1                                                                 Page 4

         Output from Example 1
         ---------------------

      The first plot (there were 4 requested, two for each station)
 from the above request is shown below.

                                EXAMPLE 1                              1
                                          15:36 FRIDAY, OCTOBER 23, 1981
                         AGN_STA=1110NET  230040

        PLOT OF TEMP_C*DATE    LEGEND: A = 1 OBS, B = 2 OBS, ETC.

 TEMP_C |
        |
        |
 35     +
        |
        |                             A
        |                             A
        |          A
 30     +                           AA AA
        |         A  A  A             A                  A
        |           A                  A                A
        |         ABAAA             AA               ACBAA
        |        AA                     A            A   AA
 25     +        A   A                 A             A
        |      A                   A     A           A A
        |           A                                     AA
        |       A                                   B
        |        A    A                  A             AB   A
 20     +      A      A           A A   A  A        A       A
        |                         AA     A
        |     A        AA        A A                A      A
        |                                A                 BA
        |      AA      A          A
 15     +                                 C
        |                        A
        |               A                         AA
        |                       AA                B
        |     A                            B
 10     +     A                AA
        |                       A           A                B
        |    A           B                        AA         B
        |                AA                 A                 A
        |    A                 A                 A            B
  5     +  A                               A     A
        |  AA                                    A
        |    A            A A AA            A  AAA
        |A AA               A                BABA             AA
        | B A               ACA              ACAA              BA
  0     + A
        -+---------+---------+---------+---------+---------+---------+--
     60-01-01  60-07-19  61-02-04  61-08-23  62-03-11  62-09-27 63-04-15

                                     DATE

1                                                                 Page 5

      Example 2.  An Enhanced Plot of Temperature and Dissolved Oxygen
      ----------------------------------------------------------------

      This example is just like Example 1, except that it shows the
 use of the STORET "MACRO" Facility.  The macro "(FCFREAD)" is used
 to provide the INFILE, INPUT, and FORMAT instructions needed
 to interface the FCF with SAS.
      Also, the plots produced are enhanced through the use of
 user-specified tic-marks, and background grids are applied.
 A plot of Dissolved Oxygen vs. Temperature has been added for
 each station.

       00010 PGM=RET,MORE=SAS,PRT=NO,
       00020 A=1110NET,S=230040,S=230041,P=10,P=300,BD=60,ED=62,
       00030   SASPARMS=BEGIN,
       00040 OPTIONS LS=71;
       00050 DATA ANYNAME;
       00060 *
       00070 INCLUDE (FCFREAD)
       00080 RENAME    P1=TEMP_C   P2=DISS_OX ;
       00090 PROC PLOT; BY STATION;
       00100 PLOT TEMP_C * DATE / VPOS=40
       00110 VAXIS=0 5 10 15 20 25 30 35 40
       00120 VREF=0 10 20 30 40
       00130 HAXIS='1JAN60'D '30JUN60'D '1JAN61'D '30JUN61'D '1JAN62'D
       00140 '30JUN62'D '1JAN63'D
       00150 HREF='1JAN60'D '1JAN61'D '1JAN62'D '1JAN63'D;
       00160 PLOT DISS_OX * DATE / VPOS=40
       00170 VAXIS=0 5 10 15 20
       00180 VREF=0 5 10 15 20
       00190 HAXIS='1JAN60'D '30JUN60'D '1JAN61'D '30JUN61'D '1JAN62'D
       00200 '30JUN62'D '1JAN63'D
       00210 HREF='1JAN60'D '1JAN61'D '1JAN62'D '1JAN63'D;
       00220 PLOT DISS_OX * TEMP_C / VPOS=40
       00230 VAXIS=0 5 10 15 20
       00240 VREF=0 5 10 15 20
       00250 HAXIS=0 5 10 15 20 25 30 35 40
       00260 HREF=0 10 20 30 40 ;
       00270 TITLE 'EXAMPLE 2';
       00280 STOPSAS,
       00290 ./iii      JOB (aaaaSTORPuuu,Miii),STORET,TIME=5,
       00300 ./             MSGLEVEL=(1,1),PRTY=1
       00310 **ROUTE  PRINT HOLD
       00320 **JOBPARM LINES=10


         Explanation of Example 2
         ------------------------

 Lines 10   A typical STORET retrieval request, in which raw data
  thru 20   is requested (PGM=RET) from two sampling sites, on
            two parameters, for three years of the period of record.
            A Further Computational File (FCF) is requested using
            MORE=SAS.  With this format, any missing values in
            STORET will be output using SAS missing value
            conventions, and station descriptions and parameter
            headers are omitted.
1                                                                 Page 6
 Line 30    SAS/STORET boundary. Below this point, only SAS
            statements are valid, up to the STOPSAS.

 Line 40    SAS OPTIONS.  SAS Source will be limited to 72
            columns of user input.  SAS reports will be limited
            to 71 columns of printer output.

 Line 50    Begins the SAS DATA step. Names the SAS dataset to
            receive the incoming data.

 Lines 60   MACRO (FCFREAD) is invoked to provide SAS instructions
  thru 70   to read the FCF.  Among other things, FCFREAD creates
            SAS variables P1 thru P50 and assigns them the values
            of the STORET parameters in your request, in the order
            you request them.  In this request, P1 is Temperature
            and P2 is Dissolved Oxygen.

 Line 70    Renames the P1 and P2 values to conform to the actual
            parameters retrieved.

 Lines 90   Invokes PROC PLOT to do the plotting.  Three plots are
  thru 270  requested at each station, for a total of six plots.
            individual plots include Temperature vs Date, Dissolved
            Oxygen vs Date, and Dissolved Oxygen vs Temperature.
            PLOT keywords VAXIS and VREF are used to specify axis
            tics and grid lines for the vertical axes, and HAXIS and
            HREF are used for the same purpose on the horizontal
            axis.
            VPOS limits the vertical size of the graph field, and
            the graphs are TITLE'd.

 Line 280   SAS/STORET delimiter.

 Lines 290  A standard STORET imbedded job-card.
  thru 320  "iii" is your initials, "aaaa" your account,
            and so forth.

          DEFINITION OF VARIABLES CREATED BY MACRO (FCFREAD)

       MORE    - 3 CHAR CODE ('3','4', OR 'SAS')
       AGENCY  - 8 CHAR STORET AGENCY CODE
       STATION - 24 CHARACTERS
                    8 - STORET AGENCY CODE
                    1 - BLANK
                   15 - STORET PRIMARY STATION IDENTIFIER
       DATE    - SAMPLE DATE (SAS DATE FORM)
       TIME    - SAMPLE TIME (SAS TIME FORM)
       DEPTH   - 6 CHAR SAMPLE DEPTH + REMARK
       P1-P50  - 50 FLOATING POINT NUMBERS.
                 VALUES OF 50 PARAMETERS.
       R1-R50  - 50 1 CHAR STORET RMK CODES
       USGSRMK - 1 CHAR USGS 'SAMPLE' RMK CODE
       BEGDATE - COMPOSITE SAMPLE BEGINNING DATE
       BEGTIME - COMPOSITE SAMPLE BEGINNING TIME
       ENDDATE - COMPOSITE SAMPLE ENDING DATE
       ENDTIME - COMPOSITE SAMPLE ENDING TIME
       TYPE    - COMPOSITE SAMPLE TYPE (STB)
       CALC    - COMPOSITE SAMPLE CALC CODE (AHLN)
       NUMBER  - COMPOSITE SAMPLE NO. OF GRABS (OR 'C')
1                                                                 Page 7

         Output from Example 2
         ---------------------

      The first and third plots from the above request are shown
 below.

                                EXAMPLE 2                              1
                                          15:31 MONDAY, OCTOBER 26, 1981
                         STATION=1110NET  230040

        PLOT OF TEMP_C*DATE    LEGEND: A = 1 OBS, B = 2 OBS, ETC.

 TEMP_C | |                   |                   |                   |
        | |                   |                   |                   |
        | |                   |                   |                   |
 40     +-|-------------------|-------------------|-------------------|-
        | |                   |                   |                   |
        | |                   |                   |                   |
        | |                   |                   |                   |
 35     + |                   |                   |                   |
        | |                   |          A        |                   |
        | |                   |           A       |                   |
        | |                   |                   |                   |
 30     +-|---------AA--------|---------AAAAA-----|-------------------|-
        | |            A  A   |                   |           B       |
        | |          BA       |           A       |        BC AA      |
        | |        BA A B     |         AA  A     |       B           |
 25     + |        A   A      |            A A    |       B A  B      |
        | |     A     A       |        A          |             A     |
        | |       A           |                   |      B      A     |
        | |       A     A     |                   |          BA       |
 20     +-|------A-------A----|------AAA----AA-A--|------A-------AA---|-
        | |                   |       A      A    |              A    |
        | |     A        AA   |     A  A     A    |      A       BA   |
        | |      A        A   |                   |                   |
 15     + |      A            |      B        BA  |                   |
        | |                   |                   |    A              |
        | |                A  |    AA             |    AA             |
        | |                   |                B  |    A              |
 10     +-|----AA-------------|---AAA-----------A-|----------------A--|-
        | |                AA |                   |     A          B  |
        | |    A           AA |                  A|    A           AA |
        | |   A               |                   |                 A |
  5     + | B                 |   A             A |  AB             A |
        | |  A                |   A             A |  AA               |
        | | A A              A|A A               ABABA                |
        | AB AA               A AA               ABAA               AA|
  0     +-|A------------------|AB-----------------|-A----------------AB-
        | |                   |                   |                   |
        | |                   |                   |                   |
        | |                   |                   |                   |
        --+---------+---------+---------+---------+---------+---------+-
      60-01-01  60-06-30  61-01-01  61-06-30  62-01-01  62-06-3063-01-01

                                     DATE

1                                                                 Page 8

                                EXAMPLE 2                              3
                                          15:31 MONDAY, OCTOBER 26, 1981
                         STATION=1110NET  230040

      PLOT OF DISS_OX*TEMP_C    LEGEND: A = 1 OBS, B = 2 OBS, ETC.

 DISS_OX |  |             |             |             |             |
         |  |             |             |             |             |
 20      +--|-------------|-------------|-------------|-------------|---
         |  |             |             |             |             |
         |  |             |             |             |             |
         |  |             |             |             |             |
         |  |             |             |             |             |
         |  |             |             |             |             |
         |  |             |             |             |             |
         |  |             |             |             |             |
         |  |             |             |             |             |
 15      +--|-------------|-------------|-------------|-------------|---
         |  |             |             |             |             |
         |  |             |             |             |             |
         |  |CA           |             |             |             |
         |  AAAB A        |             |             |             |
         |  |BDACAA   B A |             |             |             |
         |  |ADBB AAB A A | A           |             |             |
         |  | AB AA A   AA|  A       A  |             |             |
         |  | C      A AA B  A          |             |             |
 10      +--|--AA-B-A--A--A----------A--|-------------|-------------|---
         |  |          A A|AAABA BAA    |             |             |
         |  |            A|A    A B AA  |    AA      A|             |
         |  |             |      A  ABAAA A      A    |             |
         |  |         A   |         A  ADC A    AA    |             |
         |  |             |         AAA A AA  AAAA  A |             |
         |  |             |             A   A  A BCB CAA            |
         |  |             |             |    AA  CCB  |A A A        |
         |  |             |             |B A AAA   AA B             |
  5      +--|-------------|-------------|------AB-----|-------------|---
         |  |             |             |        A    |             |
         |  |             |             |             |             |
         |  |             |             |             |             |
         |  |             |             |             |             |
         |  |             |             |             |             |
         |  |             |             |             |             |
         |  |             |             |             |             |
         |  |           A |             |             |             |
  0      +--|-------------|-------------|-------------|-------------|---
         |  |             |             |             |             |
         ---+------+------+------+------+------+------+------+------+---
            0      5     10     15     20     25     30     35     40

                                     TEMP_C

 NOTE:      1 OBS HAD MISSING VALUES OR WERE OUT OF RANGE

1                                                                 Page 9
     Example 3.
     ----------

     Create a SAS dataset in your permanent user library, on disk.
 Place data from STORET in it, for future analysis with SAS alone

     0010 PGM=RET,A=31DELRBC,S=091017,
     0020 MORE=SAS,PRT=NO,
     0030 P=10,P=300,P=400,P=900,P=1027,P=1042,P=1051,
     0040 SASPARMS=BEGIN,
     0050 OPTIONS S=72;
     0060 DATA DDNAME.SASNAME;
     0070 *
     0080 INCLUDE (FCFREAD)
     0090 STOPSAS,
     0100 ./iii      JOB (aaaaSTORPuuu,Miii),STORET,TIME=5,
     0110 ./             PRTY=1
     0120 **ROUTE  PRINT HOLD
     0130 **JOBPARM LINES=10
     0140 ./DDNAME DD DISP=(NEW,CATLG),UNIT=DISK,
     0150 ./  SPACE=(TRK,(10,10)),
     0160 ./  DSN=iiiaaaa.DSNAME

      Explanation of Example 3.
      -------------------------

 Lines 10      STORET retrieval request. Specifies station(s)
  thru  30     and data desired.

 Line  40      STORET/SAS Delimiter.

 Line  50      SAS Options. Source is 72 columns wide.

 Line  60      SAS Dataset is defined.  The two-part name,
               separated by the dot, indicates a permanent
               rather than temporary SAS dataset.  The front
               part serves as a reference to a JCL DD statement,
               the back part to a SAS dataset name.  This
               SAS instruction does -NOT- use the library
               dataset name by which you will reference the
               dataset from TSO.

 Lines 70      Uses the canned MACRO "(FCFREAD)" to read the
  thru 80      FCF.  Lines 60 thru 80 are the only statements
               needed.

 Line  90      SAS/STORET delimiter.

 Lines 100     Standard STORET imbedded JOBCARD.
  thru  130

 Lines 140     User-supplied JCL.  The task cannot be completed
  thru 160     without some knowledge of JCL.  In this case,
               the JCL DD (data definition) statement which
               specifies the actual library name to be given
               to this dataset, and its space requirements and
               after-job disposition.  Note that the prefix
               of the DSN must match your own TSO USERID and
               ACCOUNT, or the dataset will not belong to you.
1                                                                Page 10
     Example 3 (Continued)
     ---------------------

     Read the data from the SAS dataset created above, and perform
 an analysis on it.  Plot Dissolved oxygen vs. time.

   NOTE: When ready to run this job, use the MVS/TSO command "SUBMIT"
         rather than the STORET command "%SCAN" to place it into
         the batch processing queue.

     0010 //iii      JOB (aaaaSTORPuuu,Miii),STORET,TIME=5,
     0020 //             PRTY=1
     0030 /*ROUTE  PRINT HOLD
     0040 /*JOBPARM LINES=10
     0050 //SAS EXEC SAS
     0060 //SAS.DDNAME DD DISP=SHR,
     0070 //  DSN=iiiaaaa.DSNAME
     0080 //SAS.SYSIN DD DATA
     0090 PROC PLOT DATA=DDNAME.SASNAME; BY STATION;
     0100 PLOT P2 * DATE / VPOS=40
     0110 VAXIS=0 5 10 15 20
     0120 VREF=0 5 10 15 20
     0130 HAXIS='1JAN60'D '30JUN60'D '1JAN61'D '30JUN61'D '1JAN62'D
     0140 '30JUN62'D '1JAN63'D
     0150 HREF='1JAN60'D '1JAN61'D '1JAN62'D '1JAN63'D;

      Explanation (Continued)
      -----------------------

 Lines 10      JOBCARD and EXEC Statement which invokes SAS.  STORET
  thru  50     is NOT involved here.

 Lines 60      JCL statements which point to the library dataset which
  thru  80     was created above, and a "DD DATA" statement for the
               SAS control statements.

 Lines 90      SAS instructions which will perform the required plot
  thru 150     of dissolved oxygen vs. time.  Note the phrase added
               to the PROC statement which reads "DATA=DDNAME.SASNAME".
               This is the only reference required by SAS to recall
               the SAS dataset "SASNAME" from its library.
1                                                                Page 11
     Example 4.
     ----------

     Produce a report summarizing potential toxicity of several
 metals, where comparisons must be made of the metals concentration
 with an exponential function of hardness.
     Such reporting is consistent with current EPA Criteria for
 Freshwater Aquatic Life.
     The SAS program statements shown here are exceedingly
 complex, compared with more typical SAS applications.  Users
 are referred to 'STORET.HELP.EXAMPLES.SAS.LIBRARY(SASX04)' for a
 machine-readable form of this program.
     We suggest that you run this particular example yourself,
 and observe the resulting report.  A brief explanation of key
 parts of the program follows.

  SAS Listing
  -----------

  0001 PGM=MEAN,MORE=4,PRT=PAR,DG=PG,PCTL=50,
  0002 A=1116APCC,S=050151,S=050152,S=050153,
  0003 P=900,P=1027,P=1042,P=1051,P=1067,
  0004 P=1077,P=1092,BD=76,
  0005 NOECHO,
  0006 SASPARMS=BEGIN,
  0007 OPTIONS LS=120;
  0008 DATA RAWDATA;
  0009 *
  0010 INCLUDE (FCFREAD)
  0011 * ;
  0012 LENGTH C1-C50 $ 9; ARRAY C(I) $ C1-C50;
  0013 FORMAT TIMEDPTH $12.;
  0014 IF TIME^=. THEN TIMEDPTH=PUT(TIME,TIME5.)||DEPTH;
  0015            ELSE TIMEDPTH='     '||DEPTH;
  0016 IF P1=. THEN DELETE;
  0017 IF P2=.&P3=.&P4=.&P5=.&P6=.&P7=. THEN DELETE;
  0018 P11=LOG(P1) ;
  0019 DO OVER P; IF P^=. THEN C=PUT(P,7.1)||R; END;
  0020 *        BEGIN MAIN CALCULATION LOOP. FORMULAS HERE.   ;
  0021 IF P2^=. THEN DO; P12=2.71828**(1.05*P11-3.73); C12=PUT(P12,7.1);
  0022          C22='     -'; IF P2>P12 THEN DO; C22='  *OVER*';
  0023          IF R2='K'|R2='U'|R2='M' THEN C22='     ??'; END; END;
  0024 IF P3^=. THEN DO; P13=2.71828**(0.94*P11-1.23); C13=PUT(P13,7.1);
  0025          C23='     -'; IF P3>P13 THEN DO; C23='  *OVER*';
  0026          IF R3='K'|R3='U'|R3='M' THEN C23='     ??'; END; END;
  0027 IF P4^=. THEN DO; P14=2.71828**(1.22*P11-0.47); C14=PUT(P14,7.1);
  0028          C24='     -'; IF P4>P14 THEN DO; C24='  *OVER*';
  0029          IF R4='K'|R4='U'|R4='M' THEN C24='     ??'; END; END;
  0030 IF P5^=. THEN DO; P15=2.71828**(0.76*P11+4.02); C15=PUT(P15,7.1);
  0031          C25='     -'; IF P5>P15 THEN DO; C25='  *OVER*';
  0032          IF R5='K'|R5='U'|R5='M' THEN C25='     ??'; END; END;
  0033 IF P6^=. THEN DO; P16=2.71828**(1.72*P11-6.52); C16=PUT(P16,7.1);
  0034          C26='     -'; IF P6>P16 THEN DO; C26='  *OVER*';
  0035          IF R6='K'|R6='U'|R6='M' THEN C26='     ??'; END; END;
  0036 IF P7^=. THEN DO; P17=2.71828**(0.83*P11+1.95); C17=PUT(P17,7.1);
  0037          C27='     -'; IF P7>P17 THEN DO; C27='  *OVER*';
  0038          IF R7='K'|R7='U'|R7='M' THEN C27='     ??'; END; END;
1                                                                Page 12

  0039 DROP P1-P50 C28-C50 R1-R50 BEGDATE BEGTIME ENDDATE
  0040 ENDTIME TYPE CALC NUMBER;
  0041 *    END OF CALCULATIONS.  WRITE THE REPORT.    ;
  0042 PROC SORT; BY STATION DATE TIME DEPTH;
  0043 DATA _NULL_; SET RAWDATA END=EOD;
  0044 BY STATION; FORMAT RDATE YYMMDD8.; RDATE=TODAY( );
  0045 FILE PRINT HEADER=H NOTITLES LINESLEFT=LL ;
  0046 IF FIRST.STATION THEN DO;
  0047       PUT _PAGE_;  NSTN+1;
  0048       NS=0; N1=0; N2=0; N3=0; N4=0; N5=0; N6=0;
  0049       NV1=0; NV2=0; NV3=0; NV4=0; NV5=0; NV6=0;
  0050       NQ1=0; NQ2=0; NQ3=0; NQ4=0; NQ5=0; NQ6=0;
  0051       END;
  0052  NS+1; IF C2^=' ' THEN DO; N1+1; T1+1; END;
  0053  TS+1; IF C3^=' ' THEN DO; N2+1; T2+1; END;
  0054        IF C4^=' ' THEN DO; N3+1; T3+1; END;
  0055        IF C5^=' ' THEN DO; N4+1; T4+1; END;
  0056        IF C6^=' ' THEN DO; N5+1; T5+1; END;
  0057        IF C7^=' ' THEN DO; N6+1; T6+1; END;
  0058        IF C22='  *OVER*' THEN DO; NV1+1; TV1+1; END;
  0059        IF C23='  *OVER*' THEN DO; NV2+1; TV2+1; END;
  0060        IF C24='  *OVER*' THEN DO; NV3+1; TV3+1; END;
  0061        IF C25='  *OVER*' THEN DO; NV4+1; TV4+1; END;
  0062        IF C26='  *OVER*' THEN DO; NV5+1; TV5+1; END;
  0063        IF C27='  *OVER*' THEN DO; NV6+1; TV6+1; END;
  0064        IF C22='     ??' THEN DO; NQ1+1; TQ1+1; END;
  0065        IF C23='     ??' THEN DO; NQ2+1; TQ2+1; END;
  0066        IF C24='     ??' THEN DO; NQ3+1; TQ3+1; END;
  0067        IF C25='     ??' THEN DO; NQ4+1; TQ4+1; END;
  0068        IF C26='     ??' THEN DO; NQ5+1; TQ5+1; END;
  0069        IF C27='     ??' THEN DO; NQ6+1; TQ6+1; END;
  0070 *
  0071   NOTE: COMMENT OUT THE NEXT "PUT" STATEMENT TO
  0072         SUPPRESS PRINTING OF INDIVIDUAL SAMPLES.  ;
  0073 *  ;
  0074 PUT @1 DATE @10 TIMEDPTH  @25 C1 $9.
  0075  @40 'STORED VALUE -->' @57 (C2-C7) ($9.) /
  0076  @40 'CRITERIA  ----->' @57 (C12-C17) ($9.) /
  0077  @40 'VIOLATIONS ? -->' @57 (C22-C27) ($9.) / ;
  0078 IF LL<3 THEN PUT _PAGE_;
  0079 IF LAST.STATION THEN DO;
  0080 PUT _PAGE_; NG1=N1-NV1-NQ1; NG2=N2-NV2-NQ2; NG3=N3-NV3-NQ3;
  0081             NG4=N4-NV4-NQ4; NG5=N5-NV5-NQ5; NG6=N6-NV6-NQ6;
  0082 PUT // @45 'STATION SUMMARY' / @45 '------- -------' //
  0083 'SAMPLES ASSESSED' @19 NS 9.
  0084 @36 'OBSERVATIONS ------>'  @57 (N1-N6) (9.) /
  0085 @36 'WITHIN LIMITS ----->'  @57 (NG1-NG6) (9.) /
  0086 @36 'OVER CRITERIA ----->'  @57 (NV1-NV6) (9.) /
  0087 @36 'OVER BUT REMARKED ->' @57 (NQ1-NQ6) (9.) ;
  0088  END;
1                                                                Page 13

  0089 IF EOD THEN DO;  STATION='GRAND TOTALS';
  0090 PUT _PAGE_; TG1=T1-TV1-TQ1; TG2=T2-TV2-TQ2; TG3=T3-TV3-TQ3;
  0091             TG4=T4-TV4-TQ4; TG5=T5-TV5-TQ5; TG6=T6-TV6-TQ6;
  0092 PUT // @45 'RUN SUMMARY' / @45 '--- -------' /
  0093 'STATIONS EXAMINED' @19 NSTN 9. /
  0094 'SAMPLES ASSESSED' @19 TS 9.
  0095 @36 'OBSERVATIONS ------>'  @57 (T1-T6) (9.) /
  0096 @36 'WITHIN LIMITS ----->'  @57 (TG1-TG6) (9.) /
  0097 @36 'OVER CRITERIA ----->'  @57 (TV1-TV6) (9.) /
  0098 @36 'OVER BUT REMARKED ->'  @57 (TQ1-TQ6) (9.) ;
  0099  END;
  0100 RETURN;
  0101 H: PUT  'STORET RETRIEVAL DATE ' RDATE YYMMDD8.
  0102         '  STORET/SAS REPORT' //
  0103          @47 'FRESHWATER AQUATIC LIFE' /
  0104              'EPA PUBLISHED CRITERIA' @58 '-' /
  0105              '   REFER: FEDERAL REGISTER'
  0106          @50 'CRITERIA EXCEEDED' /
  0107              '          FRIDAY, NOV 28, 1980' @58 '-' /
  0108              '          VOL. 45, NO.231    PART V'
  0109          @50 'STORET/SAS REPORT' / @58 '-' /
  0110          @46 'STATION - ' STATION $24. ///
  0111 @25 '    900 '
  0112 @57 '    1027     1042     1051     1067     1077     1092' /
  0113 @25 'HARDNESS'
  0114 @57 '   TOTAL    TOTAL    TOTAL    TOTAL    TOTAL    TOTAL' /
  0115 @25 'AS CACO3'
  0116 @57 ' CADMIUM   COPPER     LEAD   NICKEL   SILVER     ZINC' /
  0117 '  DATE   TIME DEPTH         MG/L'
  0118 @57 '    UG/L     UG/L     UG/L     UG/L     UG/L     UG/L' /
  0119 ' ------  ---- -----       -------'
  0120 @57 '  -------  -------  -------  -------  -------  -------';
  0121 STOPSAS,
  0122 ./III      JOB (AAAASTORPUUU,MIII),STORET,NOTIFY=III,TIME=5,
  0123 ./             MSGLEVEL=(1,1),PRTY=1
  0124 **ROUTE  PRINT HOLD
  0125 **JOBPARM LINES=10

1                                                                Page 14
      Explanation of Example 4.
      -------------------------

 Lines 1     The STORET retrieval.  Here we take advantage of the
  thru 5     STORET MEAN program, to both calculate and print
             medians for all the parameters in the retrieval,
             as well as pass the FCF to SAS.

 Lines 6     The usual front-end of a SAS run which will read an
  thru 11    FCF, as in Example 2.

 Line  12    Define an array of character strings to hold the
             data values and violation types in their "picture"
             form.  Used for all printing.

 Lines 13    Pictures are created of time and depth, for
  thru 15    printing purposes.

 Lines 16    Main calculations.  Samples without useable data
  thru 41    are deleted.  Intermediate results of calculations
             are stored, for convenience, in the "P" array
             passed from MACRO (FCFREAD).  Character strings
             indicating the nature of the violation are stored
             in the "C" array (see Line 12).  Specific formulas
             for violations are coded here.  These are all
             exponential in nature.
             After computations, all pertinent data having been
             stored in the "C" array, variables no longer needed
             are dropped.

 Line 42     SAS dataset is sorted by STATION, to permit use of "BY"
             in report step.  This step is not necessary when STORET
             retrieval is in AGENCY-STATION order.

 Lines 43    Write the report.  The SAS report writing capability is
  thru 120   used to good advantage here to produce a report which
             offers headers and page breaks at the beginning of
             each station, a summary page at the end of each station,
             and a summary page at the end of the run.  Accumulator
             variables are created here as needed to keep totals by
             station, and grand totals.
             We suggest you run the report, and see for yourself what
             it does.

 Lines 121   The standard end of a STORET/SAS run stream, including
  thru 125   an appropriate imbedded job-card.

1                Appendix A                                    Page A-1
                 ----------

    Source listing for SAS/STORET macro "FCFREAD".  A machine
    readable copy may be found in

                'STORET.HELP.FCFREAD'

    A similar macro named "OTREAD" which reads the "OT" output
    from the MEAN program may be found in

                'STORET.HELP.OTREAD'

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 * MACRO (FCFREAD)  - SAS -  READS STORET MORE=3,4 & SAS FCF FORMATS
  *
   * WRITTEN BY LEE MANNING    LAST MODIFIED BY LEE MANNING 4/25/84
    *
     * FUNCTION -
        BREAKDOWN A STORET MORE=4 (MORE=3 OR MORE=SAS) FCF FILE
        INTO ITS ELEMENTS FOR SUBSEQUENT PROCESSING BY ANY SAS
        PROCEDURES ;
 OPTIONS NOSOURCE;
 *   REF  -  THE STORET ADVANCED RETRIEVAL MANUAL UNDER PROGRAM
         'RET' FOR A DETAILED DESCRIPTION OF THE MORE=3,4 & SAS
         RECORD FORMATS.
     NOTE -  THIS ROUTINE DECODES DOUBLE-CHARACTER REMARK CODES
         STORED WITH USGS DATA, AS DESCRIBED WITHIN THE DATASET
         'STORET.HELP.USGS.REMARKS'
   *;
 FORMAT DATE YYMMDD8.;
 FORMAT TIME HHMM5.;
 FORMAT DEPTH $6.;
 FORMAT USGSRMK $1.;
 FORMAT BEGDATE YYMMDD8.;
 FORMAT BEGTIME HHMM5.;
 FORMAT REMDATE YYMMDD8.;
 FORMAT REMTIME HHMM5.;
 FORMAT ENDDATE YYMMDD8.;
 FORMAT ENDTIME HHMM5.;
 LENGTH AGENCY $ 8;
 LENGTH STATION $ 24;
 ARRAY P(I) P1-P50;
 ARRAY R(I) $1 R1-R50;
 INFILE FCF LENGTH=L;
 FORMAT MORE $3.;
 RETAIN MORE '3';
 IF _N_=1 THEN DO; INPUT @24 MORE $1. @;
 IF MORE='9' THEN MORE='SAS';
 PUT ' ';
 PUT 'NOTE: FCF FORMAT IS MORE=' MORE;
 IF MORE='3' THEN DO;
 PUT '      REMARK CODES, DEPTH INFORMATION, AND COMPOSITE';
 PUT '      SAMPLE DESCRIPTORS WILL BE MISSING.';
 PUT ' ';
 END;  END;
 INPUT @26 YYDLIM $2. @ ;
 IF L=305 | L=350 | L=75 | L=120;
                  * OMITS PARAMETER HEADERS AND STATION HEADERS ;
 IF YYDLIM^='99'; * OMITS DELIMITER RECORDS ;
1                                                              Page A-2
               Macro FCFREAD (Continued)

 INPUT @1 AGENCY $8. @9 STATION $15. @26 DATE YYMMDD6.
 @32 KHR $2. KMN $2.
 @36 (P1-P10)(RB4.) @;
 IF MORE='3' THEN DO; INPUT; GO TO SKIP; END;
 INPUT
 @76 (P11-P50)(RB4.) @236 (R1-R50)($1.) @286 TYPE $1. @287 CALC $1.
 @288 RYY 2. RMM 2. RDD 2. @294 RHR $2. RMN $2. @298 NUMBER $2.
 @300 DEPTH $6.;
 IF RHR<'25' THEN REMTIME=HMS(INPUT(RHR,2.),INPUT(RMN,2.),0);
 IF RYY>0 THEN REMDATE=MDY(RMM,RDD,RYY);
 SKIP: IF KHR<'25' THEN TIME=HMS(INPUT(KHR,2.),INPUT(KMN,2.),0);
 STATION=AGENCY||' '||STATION;
 DO OVER P;  IF P > 0. & P < 1.E-15 THEN P=. ;  END;
 IF AGENCY='112WRD' THEN DO;
   USGSRMK=NUMBER;                  * USGS 'SAMPLE' RMK CODE ;
   NUMBER='  ';
   END;
 IF REMDATE ^= . &
     PUT(DATE,YYMMDD6.)||KHR||KMN <= PUT(REMDATE,YYMMDD6.)||RHR||RMN
      THEN DO;
        BEGDATE=DATE;BEGTIME=TIME;ENDDATE=REMDATE;ENDTIME=REMTIME;
      END;
 IF REMDATE ^= . &
     PUT(DATE,YYMMDD6.)||KHR||KMN > PUT(REMDATE,YYMMDD6.)||RHR||RMN
      THEN DO;
        BEGDATE=REMDATE;BEGTIME=REMTIME;ENDDATE=DATE;ENDTIME=TIME;
      END;
 DROP KHR KMN RYY RMM RDD RHR RMN REMDATE REMTIME YYDLIM I ;
 OPTIONS SOURCE;
        *
        *
     SOURCE LISTING SUPPRESSED
  (FULL SOURCE - 'STORET.HELP.FCFREAD')
        *
        *
     DEFINITION OF VARIABLES CREATED BY MACRO (FCFREAD)

  MORE    - 3 CHAR CODE ('3','4', OR 'SAS')
  AGENCY  - 8 CHAR STORET AGENCY CODE
  STATION - 24 CHARACTERS
               8 - STORET AGENCY CODE
               1 - BLANK
              15 - STORET PRIMARY STATION IDENTIFIER
  DATE    - SAMPLE DATE (SAS DATE FORM)
  TIME    - SAMPLE TIME (SAS TIME FORM)
  DEPTH   - 6 CHAR SAMPLE DEPTH + REMARK
  P1-P50  - 50 FLOATING POINT NUMBERS.
            VALUES OF 50 PARAMETERS.
  R1-R50  - 50 1 CHAR STORET RMK CODES
  USGSRMK - 1 CHAR USGS 'SAMPLE' RMK CODE
  BEGDATE - COMPOSITE SAMPLE BEGINNING DATE
  BEGTIME - COMPOSITE SAMPLE BEGINNING TIME
  ENDDATE - COMPOSITE SAMPLE ENDING DATE
  ENDTIME - COMPOSITE SAMPLE ENDING TIME
  TYPE    - COMPOSITE SAMPLE TYPE (STB)
  CALC    - COMPOSITE SAMPLE CALC CODE (AHLN)
  NUMBER  - COMPOSITE SAMPLE NO. OF GRABS (OR 'C') ;
1                                                              Page A-3
               Macro FCFREAD (Continued)

 *        ;
 * - - - - - - - - - - - - - - - - - - - - - - - - ;
 *                WARNING                          ;
 * MACRO (FCFREAD) CONTAINS A "DROP" STATEMENT.    ;
 * USERS MAY -NOT- USE THE "KEEP" STATEMENT.       ;
 *                                                 ;
 * - - - - - - - - - - - - - - - - - - - - - - - - ;
 * MACRO (FCFREAD)  - END-OF-MACRO ;
 * - - - - - - - - - - - - - - - - ;
1                                                              Page B-1
                 Appendix B
                 ----------

    Control code options for terminals with less than the full character
    set.

    Some terminals do not have keyboard keys corresponding to the
    underscore character (_), the vertical bar (|)  used by SAS when
    concatenating character strings, or the "NOT" symbol (^).  For the
    benefit of owners of such terminals, the following fix may be used.

    1. Specify the "CHARCODE" option via the SAS OPTIONS
       statement, as follows:

               OPTIONS CHARCODE;

       at or near the top of your SAS program.

    2. Within any subsequent SAS statement, you may then
       substitute two-character coded sequences for the
       desired characters, as follows:

             "?-" for underscore (_)

             "?/" for vertical bar (|)

             "?=" for NOT sign (^)

   For example:

          OPTIONS CHARCODE;
          AGN?-STA=AGENCY?/?/STATION;

   is treated just as if you typed

          AGN_STA=AGENCY||STATION;


    For further information, refer to the SAS User's Guide under
    the entry "OPTIONS".

1                                                              Page C-1
                 Appendix C - Use under TSO
                 --------------------------

    Under TSO, SAS is normally accessed (from the TSO "READY" prompt)
    by issuing the "SAS" command, as in
      .
      .
      READY
      sas <cr>
      .

    at which point control passes to SAS, which prompts for valid SAS
    instructions.  SAS can be terminated in this mode by keying the
    sequence "/*" from your terminal.  TSO will respond "READY".

    It will generally be required to use SAS under TSO whenever you
    request SAS/GRAPH displays (such as PROC GPLOT).

    When you plan to access previously created SAS matrices from your
    library, you must "allocate" the file in your library which
    contains the existing SAS matrix before you pass control to SAS.
      .
      .
      READY
      alloc ddname(ddname) dsname(anyname) shr <cr>
      READY
      sas <cr>
      .
    Note that the disposition on the allocate command shown is "SHR",
    and is sufficient only for reading the SAS data.  If you intend
    to write (create or modify) any SAS data, your allocate command
    must specify "OLD" for SAS to proceed.

    In the event that your SAS instructions will run more than
    a few lines in length, it may be desirable to make them a part
    of still another library dataset under your control, so that
    you can edit any errors without re-typing the entire instruction
    set.  The creation of such a dataset is trivial using the QED
    editor under TSO.
      .
      .
      READY
      edit sasstuff new <cr>
      INPUT
      00010 proc print data=ddname.sasname; <cr>
      00020 <cr>
      QED
      save <cr>
      SAVED
      end <cr>
      READY
      .
1                                                              Page C-2
                 Appendix C - (continued)
                 ------------------------

    Having keyed in the preceding sequence successfully, you are now the
    owner of a library file named "SASSTUFF".  It contains (on line 10)
    one valid SAS instruction.  You must now allocate this file using
    ddname "SYSIN".
      .
      READY
      alloc ddname(sysin) dsname(sasstuff) shr <cr>
      READY
      .
    Now invoke the STORET/SAS "QUICKY" option
      .
      READY
      sas q <cr>
      STORET/SAS "QUICKY" INVOKED
      .
    and watch SAS perform the instruction(s) found in library file
    "SASSTUFF".  Note: if SASSTUFF contains errors, processing will
    terminate, and SAS will display appropriate error messages.

    You can return to editing SASSTUFF (either to make corrections
    or to add additional instructions), and alternately "SAVE"
    and "SAS Q" to your heart's content.  You need not "END" a QED
    session to invoke "SAS Q".
      .
      READY
      edit sasstuff <cr>
      QED
      (add, change, or delete anything here) <cr>
      save <cr>
      SAVED
      sas q <cr>
      STORET/SAS "QUICKY" INVOKED
       (SAS will perform all your instructions - including graphics)
      QED  (when SAS completes your task)
      (add, change, or delete anything here) <cr>
      save <cr>
      SAVED
      sas q <cr>
      .
        (repeat as desired)
      QED
      end <cr>
      READY
      .
1                                                              Page C-3
                 Appendix C - (continued)
                 ------------------------

    You can continue this process in subsequent TSO sessions using
    an instruction sequence as follows.
      .
      READY
      alloc ddname(ddname) dsname(anyname) shr <cr>
      READY
      alloc ddname(sysin) dsname(sasstuff) shr <cr>
      READY
      edit sasstuff <cr>
      QED
      (add, change, or delete anything here) <cr>
      save <cr>
      SAVED
      sas q <cr>
      STORET/SAS "QUICKY" INVOKED
       (SAS will perform all your instructions - including graphics)
      QED  (when SAS completes your task)
      (add, change, or delete anything here) <cr>
      save
      SAVED
      sas q <cr>
      .
        (repeat as desired)
      .
      QED
      end
      READY
      .
      .
1
