// SplitterMFC.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "SplitterMFC.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// The one and only application object
CWinApp theApp;

using namespace std;

/* =============================== TYPEDEFS =============================== */
typedef vector<CString> FILEDATA;


/* ============================== CONSTANTS =============================== */
const int HEADER_START_ROW		= 1;
const int HEADER_END_ROW		= 2;
const long HEADER_REPEAT_ROW	= 50000;


/* =============================== MAIN APP =============================== */
int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	
	int		nRetCode = 0;			// return code
	long	lHeaderRepeatRow = -1;  // number or rows before the headers are repeated
	CString sHeaderText = "";		// the value of the header text
	FILEDATA  fileNames;			// vector of file names in the current directory
	FILEDATA::iterator fileIterator;// the iterator for looping through the vector of file names
	CFileFind finder;               // class object for getting data about a directory
   	CString sRootDir;

	// initialize MFC and print an error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		//display error message and close the application
		cerr << _T("Fatal Error: MFC initialization failed") << endl;
		nRetCode = 1;
		exit(nRetCode);  
	}

	sRootDir.Empty();

	//Parse out the arguments, setting local variables as appropriate
	while ((argc > 1) && (argv[1][0] == '-'))
	{
		switch (argv[1][1]) {
			//----------------------
			// 'd' or 'D' sets the directory to run the application in
			//----------------------
			case 'd':
			case 'D':
				if (SetCurrentDirectory(&argv[1][2]) == 0)
				{
					cerr << "Invalid directory name provided. Cannot set current directory to ";
					cerr << &argv[1][2] << endl;
					exit(8);
				} 
				break;
			//----------------------
			// Target directory for results
			//----------------------
			case 't':
			case 'T':
				cout << "Values are..." << &argv[1][2] << endl;
				sRootDir = &argv[1][2];
				break;
			//----------------------
			// 'h' or 'H' sets the row count for repeated headers
			//----------------------
			case 'h':
			case 'H':
				lHeaderRepeatRow = atol(&argv[1][2]);
				break;
			case '?':
				cout << "Usage: " << argv[0] << " [-dpathname] [-h#rowbreak] [-ttarget_directory]\n\n";
				exit(0);
				break;
		}
		//increase the arguments
		++argv;
		--argc;
	} // end while ((argc > 1 && (argv[1][0] == '-'))

	//if any of the arguments weren't provided, use the defaults
	if (lHeaderRepeatRow == -1)
		lHeaderRepeatRow = HEADER_REPEAT_ROW;

	//start working on the directory...
	cout << "Found the following files:\n";

	BOOL bWorking = finder.FindFile("*.*");
	while (bWorking)
	{
		bWorking = finder.FindNextFile();
		if (!finder.IsDots() && !finder.IsDirectory())
		{
			fileNames.push_back(finder.GetFileName());
			cout << "\t" << (LPCTSTR) finder.GetFileName() << endl;
		}
	}
    cout << endl;

	for (fileIterator = fileNames.begin(); fileIterator != fileNames.end(); 
	      fileIterator++)
	{
		//Process the file...
		CString newDirName;
		CString newFileName;
		CString fileEnding;
		CString fileName;
		char    paddedNum[4];

		int     fileNum = 0;
		long    lineCnt = 0;
		string  sLine;
		ifstream  originalFile;
		ofstream  newFile;
		int position;

        fileName = *fileIterator;
		fileName.MakeLower();

		//get the directory name for this file by getting the position of the ending
		position = fileName.Find("_res.txt");
		if (position < 0) // isn't a result file 
		{
			position = fileName.Find("_sta.txt");
		}
		if (position < 0) 
			continue;
		
		//create the new directory
		int length = fileIterator->GetLength();
			newDirName = fileIterator->Left(position);

        		
		CreateDirectory(sRootDir + newDirName, '\0');
		cout << "Creating directory '" << (LPCTSTR) newDirName << "'\n";
		
		//open the orig. file
		originalFile.open((LPCTSTR) *fileIterator);
		cout << "Opening file " << (LPCTSTR) *fileIterator << endl;
       
		lineCnt = 0;
		while(getline(originalFile, sLine)) 
		{
			lineCnt++;
			if (lineCnt == HEADER_START_ROW)
			{
				fileNum++;
				sprintf(paddedNum, "%03d", fileNum);
				
				fileEnding = fileIterator->Mid(position, strlen("_res"));
				newFileName = sRootDir + newDirName + "\\" + newDirName + fileEnding + "_" + paddedNum + ".txt";
				
				//open the new file
				newFile.open((LPCSTR) newFileName, ios::out);
				if (newFile.bad()) {
					cerr << "Cannot open output file " << (LPCSTR) newFileName << endl;
					exit(8);
				}
				cout << "\tCreating file " << (LPCSTR) newFileName << "\n";
			}
			else if (lineCnt == lHeaderRepeatRow )
			{	
				cout << "\tClosing file " << (LPCSTR) newFileName << " with " << lineCnt << " rows saved.\n\n";
				lineCnt = 0;
				newFile << sLine;
				newFile.close();
			} else {
				newFile << sLine << endl;
			}
		}

		//if we exited the loop without closing the file...
		if (lineCnt != 0)
		{
			cout << "\tClosing file " << (LPCSTR) newFileName << " with " << lineCnt << " rows saved.\n";
			newFile.close();
		}
		
		//close the original file...
		cout << "Closing file " << (LPCTSTR) *fileIterator << "\n\n";
		originalFile.close();
	}
return nRetCode;
}	


