CREATE TABLE "STORET_OWNER"."AGENCY"("CODE" CHAR(8) NOT NULL, 
    "AGENCY_NAME" VARCHAR2(25), "ORGANIZATION_TYPE" CHAR(3), 
    "DATA_DESCRIPTION01" VARCHAR2(25), "DATA_DESCRIPTION02" VARCHAR2(
    25), "DATA_DESCRIPTION03" VARCHAR2(25), "RETIREMENT_NAME" 
    VARCHAR2(25), "RETIREMENT_DATE" CHAR(8), "RETIREMENT_PHONE" 
    VARCHAR2(13), "EPA_REGION_LOCATION" VARCHAR2(2), 
    "FK_ORGANIZATION_CODE_ISN" NUMBER(12), "TMSP_ADDED" DATE NOT 
    NULL, "USERID_LAST_UPDT" CHAR(8) NOT NULL, "RECORD_MIGRATED" 
    CHAR(1) NOT NULL, 
    CONSTRAINT "FK_ORGANIZATION_AGENCY_1" FOREIGN KEY(
    "FK_ORGANIZATION_CODE_ISN") 
    REFERENCES "STORET_OWNER"."ORGANIZATION"("CODE_ISN") NOVALIDATE, 
    CONSTRAINT "PK_AGENCY_1" PRIMARY KEY("CODE") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 80K NEXT 24K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003051_1" CHECK("CODE" IS NOT NULL), 
    CONSTRAINT "SYS_C003052_1" CHECK("TMSP_ADDED" IS NOT NULL), 
    CONSTRAINT "SYS_C003053_1" CHECK("USERID_LAST_UPDT" IS NOT NULL), 
    CONSTRAINT "SYS_C003054_1" CHECK("RECORD_MIGRATED" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 240K NEXT 48K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."AQUIFER"("CODE" CHAR(15) NOT NULL, 
    "LONG_NAME" VARCHAR2(70), 
    CONSTRAINT "PK_AQUIFER_1" PRIMARY KEY("CODE") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 360K NEXT 72K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003056_1" CHECK("CODE" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 1040K NEXT 200K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."CHARACTERISTIC"("CODE_ISN" NUMBER(12) NOT NULL, 
    "UOM_TYPE" CHAR(5) NOT NULL, "SEARCH_NAME" VARCHAR2(60) NOT NULL, 
    "DISPLAY_NAME" VARCHAR2(60) NOT NULL, "CHARACTERISTIC_TYPE_CODE" 
    CHAR(1) NOT NULL, "TAXON_RANK_CODE" CHAR(8), 
    CONSTRAINT "SYS_C003058_1" CHECK("CODE_ISN" IS NOT NULL), 
    CONSTRAINT "SYS_C003059_1" CHECK("UOM_TYPE" IS NOT NULL), 
    CONSTRAINT "SYS_C003060_1" CHECK("SEARCH_NAME" IS NOT NULL), 
    CONSTRAINT "SYS_C003061_1" CHECK("DISPLAY_NAME" IS NOT NULL), 
    CONSTRAINT "SYS_C003062_1" CHECK("CHARACTERISTIC_TYPE_CODE" IS 
    NOT NULL), 
    CONSTRAINT "XPKCHARACTERISTIC_1" PRIMARY KEY("CODE_ISN") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 200K NEXT 24K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 2080K NEXT 136K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."CHILDLESS_SAMPLE"("SAMPLE_CODE_ISN" NUMBER(12)) 
    TABLESPACE "APPL_DATA" PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."COMPOSITE_METHOD"("CODE" CHAR(1) NOT NULL, "NAME" 
    VARCHAR2(20) NOT NULL, "DESCRIPTION" VARCHAR2(260) NOT NULL, 
    CONSTRAINT "PK_COMPOSITE_METHOD_1" PRIMARY KEY("CODE") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003064_1" CHECK("CODE" IS NOT NULL), 
    CONSTRAINT "SYS_C003065_1" CHECK("NAME" IS NOT NULL), 
    CONSTRAINT "SYS_C003066_1" CHECK("DESCRIPTION" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."COMPOSITE_STATISTIC"("CODE" CHAR(1) NOT NULL, "NAME" 
    VARCHAR2(60), "PRINT_FORMAT" CHAR(3), "PERFORMANCE_TYPE_IND" 
    CHAR(1), 
    CONSTRAINT "PK_COMPOSITE_STATISTIC_1" PRIMARY KEY("CODE") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003068_1" CHECK("CODE" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."DECIMAL_POINT"("CODE" NUMBER(2) NOT NULL, 
    "DESCRIPTION" VARCHAR2(20), 
    CONSTRAINT "PK_DECIMAL_POINT_1" PRIMARY KEY("CODE") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003070_1" CHECK("CODE" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."DESCRIPTIVE_PARAGRAPH_LINE"("FK_COMPUTER_SEQUENCE_NUMBER" 
    NUMBER(12) NOT NULL, "PARAGRAPH_LINE_NUMBER" NUMBER(2) NOT NULL, 
    "TEXT" CHAR(72), "TMSP_ADDED" DATE NOT NULL, "USERID_LAST_UPDT" 
    CHAR(8) NOT NULL, "RECORD_MIGRATED" CHAR(1) NOT NULL, 
    CONSTRAINT "PK_DESCRIPTIVE_PARAGRAPH_1" PRIMARY KEY(
    "FK_COMPUTER_SEQUENCE_NUMBER", "PARAGRAPH_LINE_NUMBER") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 43080K NEXT 13824K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003072_1" CHECK("FK_COMPUTER_SEQUENCE_NUMBER" 
    IS NOT NULL), 
    CONSTRAINT "SYS_C003073_1" CHECK("PARAGRAPH_LINE_NUMBER" IS NOT 
    NULL), 
    CONSTRAINT "SYS_C003074_1" CHECK("TMSP_ADDED" IS NOT NULL), 
    CONSTRAINT "SYS_C003075_1" CHECK("USERID_LAST_UPDT" IS NOT NULL), 
    CONSTRAINT "SYS_C003076_1" CHECK("RECORD_MIGRATED" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 75 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 165920K NEXT 33792K MINEXTENTS 1 MAXEXTENTS 
    505 PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."EFFLUENT_MONITORING_INTENT"("CODE" CHAR(2) NOT NULL, "NAME" 
    VARCHAR2(60) NOT NULL, 
    CONSTRAINT "PK_EFF_MONITOR_INTENT_1" PRIMARY KEY("CODE") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003078_1" CHECK("CODE" IS NOT NULL), 
    CONSTRAINT "SYS_C003079_1" CHECK("NAME" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."EFFLUENT_STATISTIC"("CODE" CHAR(1) NOT NULL, "NAME" 
    VARCHAR2(60), "PRINT_FORMAT" CHAR(3), 
    CONSTRAINT "PK_EFFLUENT_STATISTIC_1" PRIMARY KEY("CODE") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003081_1" CHECK("CODE" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."FIPS_HYDROLOGIC_UNIT"("FIPS_HYDROLOGICUNIT_STORETX" 
    NUMBER(12) NOT NULL, "FIPS_HYDROLOGIC_UNIT_CODE" CHAR(8), "NAME" 
    VARCHAR2(60), 
    CONSTRAINT "PK_FIPS_HUC_1" PRIMARY KEY(
    "FIPS_HYDROLOGICUNIT_STORETX") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 80K NEXT 16K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003108_1" CHECK("FIPS_HYDROLOGICUNIT_STORETX" 
    IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 160K NEXT 16K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."INT_ORG"("CONTACT_NAME" CHAR(25) NOT NULL, 
    "CONTACT_ADDRESS_LINE01" CHAR(25), "CONTACT_ADDRESS_LINE02" CHAR(
    25), "CONTACT_PHONE" CHAR(13) NOT NULL, "CONTACT_ADDRESS_LINE03" 
    CHAR(25), "CONTACT_ADDRESS_LINE04" CHAR(25), 
    "ALTERNATE_CONTACT_NAME" CHAR(25), "ALTERNATE_PHONE" CHAR(13), 
    CONSTRAINT "SYS_C003110_1" CHECK("CONTACT_NAME" IS NOT NULL), 
    CONSTRAINT "SYS_C003111_1" CHECK("CONTACT_PHONE" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 440K NEXT 216K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."LAT_LONG_PRECISION"("CODE" NUMBER(2) NOT NULL, "NAME" 
    VARCHAR2(20), 
    CONSTRAINT "PK_LAT_LONG_PRECISION_1" PRIMARY KEY("CODE") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003112_1" CHECK("CODE" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."LEGACY_STORET_LEVEL1"("NAME" VARCHAR2(12) NOT NULL, 
    "DESCRIPTION" VARCHAR2(260), 
    CONSTRAINT "PK_LEG_STORET_LEVEL1_1" PRIMARY KEY("NAME") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003114_1" CHECK("NAME" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 90 PCTUSED 5 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 40K NEXT 24K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."LEGACY_STORET_LEVEL2A"("NAME" VARCHAR2(12) NOT NULL, 
    "DESCRIPTION" VARCHAR2(260), 
    CONSTRAINT "PK_LEG_STORET_LEVEL2A_1" PRIMARY KEY("NAME") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003116_1" CHECK("NAME" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."LEGACY_STORET_LEVEL2B"("NAME" VARCHAR2(12) NOT NULL, 
    "DESCRIPTION" VARCHAR2(250), 
    CONSTRAINT "PK_LEG_STORET_LEVEL2B_1" PRIMARY KEY("NAME") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003118_1" CHECK("NAME" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."LEGACY_STORET_LEVEL3"("NAME" VARCHAR2(12) NOT NULL, 
    "DESCRIPTION" VARCHAR2(250), 
    CONSTRAINT "PK_LEG_STORET_LEVEL3_1" PRIMARY KEY("NAME") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003120_1" CHECK("NAME" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."LEGACY_STORET_LEVEL4"("NAME" VARCHAR2(12) NOT NULL, 
    "DESCRIPTION" VARCHAR2(250), 
    CONSTRAINT "PK_LEG_STORET_LEVEL4_1" PRIMARY KEY("NAME") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003122_1" CHECK("NAME" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."LEGACY_STORET_LEVEL5"("NAME" VARCHAR2(12) NOT NULL, 
    "DESCRIPTION" VARCHAR2(250), 
    CONSTRAINT "PK_LEG_STORET_LEVEL5_1" PRIMARY KEY("NAME") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003124_1" CHECK("NAME" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."LEGACY_STORET_LEVEL5_ASSIGN2"("CODE_ISN" NUMBER(12) NOT NULL, 
    "FK_LEGACY_STORET_LEVEL5_NAME" VARCHAR2(12) NOT NULL, 
    "FK_COMPUTER_SEQUENCE_NUMBER" NUMBER(12), "TMSP_ADDED" DATE NOT 
    NULL, "USERID_LAST_UPDT" CHAR(8) NOT NULL, "RECORD_MIGRATED" 
    CHAR(1) NOT NULL, 
    CONSTRAINT "FK_LEG_LEVEL5_LEG_LEV5_ASSIGN2_1" FOREIGN KEY(
    "FK_LEGACY_STORET_LEVEL5_NAME") 
    REFERENCES "STORET_OWNER"."LEGACY_STORET_LEVEL5"("NAME") 
    NOVALIDATE, 
    CONSTRAINT "FK_LEG_STN_TYPE_LEG_LEV5_ASSIN_1" FOREIGN KEY(
    "FK_COMPUTER_SEQUENCE_NUMBER") 
    REFERENCES "STORET_OWNER"."LEGACY_STORET_STATION_TYPE"(
    "FK_COMPUTER_SEQUENCE_NUMBER") NOVALIDATE, 
    CONSTRAINT "PK_LEG_STO_LEV5_ASSIGN_1" PRIMARY KEY("CODE_ISN") 
    USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 24600K NEXT 5120K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003126_1" CHECK("CODE_ISN" IS NOT NULL), 
    CONSTRAINT "SYS_C003127_1" CHECK("FK_LEGACY_STORET_LEVEL5_NAME" 
    IS NOT NULL), 
    CONSTRAINT "SYS_C003128_1" CHECK("TMSP_ADDED" IS NOT NULL), 
    CONSTRAINT "SYS_C003129_1" CHECK("USERID_LAST_UPDT" IS NOT NULL), 
    CONSTRAINT "SYS_C003130_1" CHECK("RECORD_MIGRATED" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 72720K NEXT 15360K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."LEGACY_STORET_STATION_TYPE"("FK_COMPUTER_SEQUENCE_NUMBER" 
    NUMBER(12) NOT NULL, "FK_LEGACY_STORET_LEVEL4_NAME" VARCHAR2(12), 
    "FK_LEGACY_STORET_LEVEL2A_NAME" VARCHAR2(12) NOT NULL, 
    "FK_LEGACY_STORET_LEVEL3_NAME" VARCHAR2(12), 
    "FK_LEGACY_STORET_LEVEL2B_NAME" VARCHAR2(12), 
    "FK_LEGACY_STORET_LEVEL1_NAME" VARCHAR2(12), "TMSP_ADDED" DATE 
    NOT NULL, "USERID_LAST_UPDT" CHAR(8) NOT NULL, "RECORD_MIGRATED" 
    CHAR(1) NOT NULL, 
    CONSTRAINT "FK_LEG_LEVEL1_LEG_STN_TYPE_1" FOREIGN KEY(
    "FK_LEGACY_STORET_LEVEL1_NAME") 
    REFERENCES "STORET_OWNER"."LEGACY_STORET_LEVEL1"("NAME") 
    NOVALIDATE, 
    CONSTRAINT "FK_LEG_LEVEL2A_LEG_STN_TYPE_1" FOREIGN KEY(
    "FK_LEGACY_STORET_LEVEL2A_NAME") 
    REFERENCES "STORET_OWNER"."LEGACY_STORET_LEVEL2A"("NAME") 
    NOVALIDATE, 
    CONSTRAINT "FK_LEG_LEVEL2B_LEG_STN_TYPE_1" FOREIGN KEY(
    "FK_LEGACY_STORET_LEVEL2B_NAME") 
    REFERENCES "STORET_OWNER"."LEGACY_STORET_LEVEL2B"("NAME") 
    NOVALIDATE, 
    CONSTRAINT "FK_LEG_LEVEL3_LEG_STN_TYPE_1" FOREIGN KEY(
    "FK_LEGACY_STORET_LEVEL3_NAME") 
    REFERENCES "STORET_OWNER"."LEGACY_STORET_LEVEL3"("NAME") 
    NOVALIDATE, 
    CONSTRAINT "FK_LEG_LEVEL4_LEG_STN_TYPE_1" FOREIGN KEY(
    "FK_LEGACY_STORET_LEVEL4_NAME") 
    REFERENCES "STORET_OWNER"."LEGACY_STORET_LEVEL4"("NAME") 
    NOVALIDATE, 
    CONSTRAINT "PK_LEG_STO_STN_TYPE_1" PRIMARY KEY(
    "FK_COMPUTER_SEQUENCE_NUMBER") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 64520K NEXT 13312K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003132_1" CHECK("FK_COMPUTER_SEQUENCE_NUMBER" 
    IS NOT NULL), 
    CONSTRAINT "SYS_C003133_1" CHECK("FK_LEGACY_STORET_LEVEL2A_NAME" 
    IS NOT NULL), 
    CONSTRAINT "SYS_C003134_1" CHECK("TMSP_ADDED" IS NOT NULL), 
    CONSTRAINT "SYS_C003135_1" CHECK("USERID_LAST_UPDT" IS NOT NULL), 
    CONSTRAINT "SYS_C003136_1" CHECK("RECORD_MIGRATED" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 251920K NEXT 51200K MINEXTENTS 1 MAXEXTENTS 
    505 PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."LOCATION_POINT_TYPE"("CODE" CHAR(1) NOT NULL, "NAME" 
    VARCHAR2(30), 
    CONSTRAINT "PK_LOCATION_POINT_TYPE_1" PRIMARY KEY("CODE") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003138_1" CHECK("CODE" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."OMERNICH_LEVEL3_ECOREGION"("CODE" CHAR(2) NOT NULL, "NAME" 
    VARCHAR2(60), 
    CONSTRAINT "PK_OMERNICH_LEV3_ECOR_1" PRIMARY KEY("CODE") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003140_1" CHECK("CODE" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."ORGANIZATION"("CODE_ISN" NUMBER(12) NOT NULL, 
    "CONTACT_NAME" VARCHAR2(25) NOT NULL, "CONTACT_PHONE" CHAR(13) 
    NOT NULL, "CONTACT_ADDRESS_LINE01" VARCHAR2(25), 
    "CONTACT_ADDRESS_LINE02" VARCHAR2(25), "CONTACT_ADDRESS_LINE03" 
    VARCHAR2(25), "CONTACT_ADDRESS_LINE04" VARCHAR2(25), 
    "ALTERNATE_CONTACT_NAME" VARCHAR2(25), "ALTERNATE_PHONE" CHAR(
    13), "TMSP_ADDED" DATE NOT NULL, "USERID_LAST_UPDT" CHAR(8) NOT 
    NULL, "RECORD_MIGRATED" CHAR(1) NOT NULL, 
    CONSTRAINT "PK_ORGANIZATION_1" PRIMARY KEY("CODE_ISN") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003142_1" CHECK("CODE_ISN" IS NOT NULL), 
    CONSTRAINT "SYS_C003143_1" CHECK("CONTACT_NAME" IS NOT NULL), 
    CONSTRAINT "SYS_C003144_1" CHECK("CONTACT_PHONE" IS NOT NULL), 
    CONSTRAINT "SYS_C003145_1" CHECK("TMSP_ADDED" IS NOT NULL), 
    CONSTRAINT "SYS_C003146_1" CHECK("USERID_LAST_UPDT" IS NOT NULL), 
    CONSTRAINT "SYS_C003147_1" CHECK("RECORD_MIGRATED" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 80K NEXT 16K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."PARAMETER"("CODE" CHAR(5) NOT NULL, 
    "LONG_NAME" VARCHAR2(50), "FK_PARAMETER_GROUP_CODE" NUMBER(2) 
    NOT NULL, "SHORT_NAME01" CHAR(8), "SHORT_NAME02" CHAR(8), 
    "SHORT_NAME03" CHAR(8), "FK_REPORTING_UNITS_CODE" VARCHAR2(8), 
    "FK_SMPL_MDIA_TYPE_CODE_ISN" NUMBER(12), "FK_DECIMAL_POINT_CODE" 
    NUMBER(2), "FK_CHARACTERISTIC_CODE_ISN" NUMBER(12), "CAS_NUMBER" 
    NUMBER(9), "NUMBER_OBSERVATIONS" NUMBER(12), 
    CONSTRAINT "PK_PARAMETER_1" PRIMARY KEY("CODE") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 200K NEXT 24K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003149_1" CHECK("CODE" IS NOT NULL), 
    CONSTRAINT "SYS_C003150_1" CHECK("FK_PARAMETER_GROUP_CODE" IS 
    NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 2080K NEXT 104K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."PARAMETER_GROUP"("CODE" NUMBER(2) NOT NULL, "NAME" 
    VARCHAR2(60) NOT NULL, "OFFICIAL_NAME" VARCHAR2(10) NOT NULL, 
    CONSTRAINT "PK_PARAM_GRP_1" PRIMARY KEY("CODE") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003154_1" CHECK("CODE" IS NOT NULL), 
    CONSTRAINT "SYS_C003155_1" CHECK("NAME" IS NOT NULL), 
    CONSTRAINT "SYS_C003156_1" CHECK("OFFICIAL_NAME" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."PRIMARY_ACTIVITY_CATEGORY"("CODE" CHAR(1) NOT NULL, "NAME" 
    VARCHAR2(60), 
    CONSTRAINT "PK_PRIM_ACT_CATEGORY_1" PRIMARY KEY("CODE") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003164_1" CHECK("CODE" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."PRMRY_SCNDRY_ACTVTY_COMBO2"("CODE_ISN" NUMBER(12) NOT NULL, 
    "FK_PRMRY_ACTVTY_CATEGORY_CODE" CHAR(1), 
    "FK_SCNDRY_ACTVTY_CATEGORY_CODE" NUMBER(4), 
    CONSTRAINT "FK_PRIM_ACT_CAT_PRMY_SCDRY_COM_1" FOREIGN KEY(
    "FK_PRMRY_ACTVTY_CATEGORY_CODE") 
    REFERENCES "STORET_OWNER"."PRIMARY_ACTIVITY_CATEGORY"("CODE"), 
    CONSTRAINT "FK_SEC_ACT_CAT_PRMY_SCDRY_COM_1" FOREIGN KEY(
    "FK_SCNDRY_ACTVTY_CATEGORY_CODE") 
    REFERENCES "STORET_OWNER"."SECONDARY_ACTIVITY_CATEGORY"("CODE") 
    NOVALIDATE, 
    CONSTRAINT "PK_PRMY_SECNDY_COMBO2_1" PRIMARY KEY("CODE_ISN") 
    USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003166_1" CHECK("CODE_ISN" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."REPORTING_UNITS"("CODE" VARCHAR2(8) NOT NULL, 
    "NAME" VARCHAR2(60), 
    CONSTRAINT "PK_REPORTING_UNITS_1" PRIMARY KEY("CODE") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003168_1" CHECK("CODE" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."RESULT"("CODE_ISN" NUMBER(12) NOT NULL, 
    "RESULT_VALUE" VARCHAR2(12), "FK_SAMPLE_CODE_ISN" NUMBER(12), 
    "FK_COMPOSITE_STATISTIC_CODE" CHAR(1), 
    "FK_EFFLUENT_STATISTIC_CODE" CHAR(1), "FK_PARAMETER_CODE" CHAR(
    5), "FK_STORET_RESULT_REMARK_CODE" CHAR(1), "TMSP_ADDED" DATE 
    NOT NULL, "USERID_LAST_UPDT" CHAR(8) NOT NULL, "RECORD_MIGRATED" 
    CHAR(1) NOT NULL, "RUN_NUMBER" NUMBER(3) NOT NULL, 
    CONSTRAINT "FK_COMPOSITE_STAT_RESULT_1" FOREIGN KEY(
    "FK_COMPOSITE_STATISTIC_CODE") 
    REFERENCES "STORET_OWNER"."COMPOSITE_STATISTIC"("CODE") 
    NOVALIDATE, 
    CONSTRAINT "FK_EFFLUENT_STAT_RESULT_1" FOREIGN KEY(
    "FK_EFFLUENT_STATISTIC_CODE") 
    REFERENCES "STORET_OWNER"."EFFLUENT_STATISTIC"("CODE") 
    NOVALIDATE, 
    CONSTRAINT "FK_STORET_RESULT_REMARK_RESULT_1" FOREIGN KEY(
    "FK_STORET_RESULT_REMARK_CODE") 
    REFERENCES "STORET_OWNER"."STORET_RESULT_REMARK"("CODE") 
    NOVALIDATE, 
    CONSTRAINT "PK_RESULT_1" PRIMARY KEY("CODE_ISN") USING 
    INDEX  
    TABLESPACE "APPL_DATA" 
    STORAGE ( INITIAL 2097152K NEXT 3145728K MINEXTENTS 1 MAXEXTENTS 
    505 PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003170_1" CHECK("CODE_ISN" IS NOT NULL), 
    CONSTRAINT "SYS_C003171_1" CHECK("TMSP_ADDED" IS NOT NULL), 
    CONSTRAINT "SYS_C003172_1" CHECK("USERID_LAST_UPDT" IS NOT NULL), 
    CONSTRAINT "SYS_C003173_1" CHECK("RECORD_MIGRATED" IS NOT NULL), 
    CONSTRAINT "SYS_C003174_1" CHECK("RUN_NUMBER" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 75 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 2097152K NEXT 1048576K MINEXTENTS 1 MAXEXTENTS 
    505 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."RF1_REACH"("STORET_X_CODE" NUMBER(12) NOT 
    NULL, "CATUNIT_CODE" VARCHAR2(8) NOT NULL, "RCHMILE_SEGMENT" 
    NUMBER(3), "RCHLENGTH" FLOAT(126), "RCHLEVEL" FLOAT(126), 
    "RCHTYPE" CHAR(1), "RCHNAME" VARCHAR2(60), 
    CONSTRAINT "PK_RF1_REACH_1" PRIMARY KEY("STORET_X_CODE") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 2080K NEXT 112K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003176_1" CHECK("STORET_X_CODE" IS NOT NULL), 
    CONSTRAINT "SYS_C003177_1" CHECK("CATUNIT_CODE" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 6160K NEXT 1024K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."RMI"("CODE_ISN" NUMBER(12) NOT NULL, 
    "RMI_MILE_DESC" VARCHAR2(112), "RMI_INDEX_DESC" VARCHAR2(112), 
    "FK_COMPUTER_SEQUENCE_NUMBER" NUMBER(12) NOT NULL, "TMSP_ADDED" 
    DATE NOT NULL, "USERID_LAST_UPDT" CHAR(8) NOT NULL, 
    "RECORD_MIGRATED" CHAR(1) NOT NULL, 
    CONSTRAINT "PK_RMI_1" PRIMARY KEY("CODE_ISN") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 12320K NEXT 3072K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003179_1" CHECK("CODE_ISN" IS NOT NULL), 
    CONSTRAINT "SYS_C003180_1" CHECK("FK_COMPUTER_SEQUENCE_NUMBER" 
    IS NOT NULL), 
    CONSTRAINT "SYS_C003181_1" CHECK("TMSP_ADDED" IS NOT NULL), 
    CONSTRAINT "SYS_C003182_1" CHECK("USERID_LAST_UPDT" IS NOT NULL), 
    CONSTRAINT "SYS_C003183_1" CHECK("RECORD_MIGRATED" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 75 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 163840K NEXT 32768K MINEXTENTS 1 MAXEXTENTS 
    505 PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."SAMPLE"("SAMPLE_CODE_ISN" NUMBER(12) NOT 
    NULL, "START_DATE" DATE, "START_TIME" NUMBER(4), "END_DATE" DATE, 
    "END_TIME" NUMBER(4), "SAMPLE_DEPTH" NUMBER(8, 2), 
    "SPECIES_NAME" VARCHAR2(60), "REPLICATE_NUMBER" NUMBER(12), 
    "TISSUE_NAME" VARCHAR2(60), "UMK" CHAR(8), "PIPE_ID" NUMBER(12), 
    "COMPOSITE_GRAB_NUMBER" NUMBER(2), "USGS_FIELD_LAB_CODE" CHAR(1), 
    "STORE_DATE" DATE, "FK_PRMY_SCNDY_COMBO2_CODE_ISN" NUMBER(12), 
    "FK_COMPUTER_SEQUENCE_NUMBER" NUMBER(12) NOT NULL, 
    "FK_COMPOSITE_METHOD_CODE" CHAR(1), 
    "FK_EFFLUENT_MONTRNG_INTNT_CODE" CHAR(2), "TMSP_ADDED" DATE NOT 
    NULL, "USERID_LAST_UPDT" CHAR(8) NOT NULL, "RECORD_MIGRATED" 
    CHAR(1) NOT NULL, "RUN_NUMBER" NUMBER(3) NOT NULL, 
    CONSTRAINT "PK_SAMPLE_1" PRIMARY KEY("SAMPLE_CODE_ISN") USING 
    INDEX  
    TABLESPACE "APPL_DATA" 
    STORAGE ( INITIAL 655640K NEXT 327712K MINEXTENTS 1 MAXEXTENTS 
    505 PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003192_1" CHECK("SAMPLE_CODE_ISN" IS NOT NULL), 
    CONSTRAINT "SYS_C003193_1" CHECK("FK_COMPUTER_SEQUENCE_NUMBER" 
    IS NOT NULL), 
    CONSTRAINT "SYS_C003194_1" CHECK("TMSP_ADDED" IS NOT NULL), 
    CONSTRAINT "SYS_C003195_1" CHECK("USERID_LAST_UPDT" IS NOT NULL), 
    CONSTRAINT "SYS_C003196_1" CHECK("RECORD_MIGRATED" IS NOT NULL), 
    CONSTRAINT "SYS_C003197_1" CHECK("RUN_NUMBER" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 75 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 2097152K NEXT 1024000K MINEXTENTS 1 MAXEXTENTS 
    505 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."SAMPLE_MEDIA_ANALYSIS_TYPE"("CODE_ISN" NUMBER(12) NOT NULL, 
    "ANALYSIS_TYPE_CODE" CHAR(1), "ANALYSIS_TYPE_NAME" VARCHAR2(80), 
    "SAMPLE_MEDIA_CODE" CHAR(1) NOT NULL, "SAMPLE_MEDIA_NAME" 
    VARCHAR2(60), 
    CONSTRAINT "PK_SAMP_MEDIA_ANAL_TYPE_1" PRIMARY KEY("CODE_ISN") 
    USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003199_1" CHECK("CODE_ISN" IS NOT NULL), 
    CONSTRAINT "SYS_C003200_1" CHECK("SAMPLE_MEDIA_CODE" IS NOT 
    NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."SECONDARY_ACTIVITY_CATEGORY"("CODE" NUMBER(4) NOT NULL, "NAME" 
    VARCHAR2(60), "OUTPUT_FORMAT" VARCHAR2(8), 
    CONSTRAINT "PK_SEC_ACT_CATEGORY_1" PRIMARY KEY("CODE") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003213_1" CHECK("CODE" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."STATE_COUNTY"("CODE_ISN" NUMBER(12) NOT NULL, 
    "STATE_CODE" CHAR(2), "COUNTY_CODE" CHAR(3), "STATE_NAME" CHAR(
    30), "COUNTY_NAME" CHAR(30), "FIPS_INDICATOR" CHAR(1), 
    CONSTRAINT "PK_STATE_COUNTY_1" PRIMARY KEY("CODE_ISN") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 80K NEXT 64K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003215_1" CHECK("CODE_ISN" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 90 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 320K NEXT 32K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."STATION"("COMPUTER_SEQUENCE_NUMBER" NUMBER(
    12) NOT NULL, "PRIMARY_STATION_ID" CHAR(15) NOT NULL, 
    "LGCY_STORET_STATION_TYPE_CODE" VARCHAR2(65), "ELEVATION" NUMBER(
    9), "ELEVATION_UNITS" CHAR(1), "LOCATION_NAME_2" CHAR(60), 
    "LOCATION_NAME_3" CHAR(60), "EPA_MAJOR_BASIN_CODE" CHAR(2), 
    "EPA_MINOR_BASIN_CODE" CHAR(2), "SUB_BASIN_CODE" CHAR(2), 
    "STATION_DEPTH" NUMBER(3), "STATION_DEPTH_UNITS" VARCHAR2(20), 
    "LOCATION_NAME" VARCHAR2(48), "STORE_DATE" DATE, "BEGIN_DATE" 
    DATE, "END_DATE" DATE, "SURFACE_WATER_INDICATOR" CHAR(1), 
    "GROUND_WATER_INDICATOR" CHAR(1), "PIPE_INDICATOR" CHAR(1), 
    "NUM_SAMPLES" NUMBER(10), "NUM_OBSERVATIONS" NUMBER(10), 
    "FK_AGENCY_CODE" CHAR(8) NOT NULL, 
    "FK_STORET_X_STATION_TYPE_CODE" NUMBER(12), "TMSP_ADDED" DATE 
    NOT NULL, "USERID_LAST_UPDT" CHAR(8) NOT NULL, "RECORD_MIGRATED" 
    CHAR(1) NOT NULL, "EFFLUENT_INDICATOR" CHAR(1), 
    CONSTRAINT "FK_AGENCY_STATION_1" FOREIGN KEY("FK_AGENCY_CODE") 
    REFERENCES "STORET_OWNER"."AGENCY"("CODE") NOVALIDATE, 
    CONSTRAINT "FK_STORETX_STATION_TYPE_STATN_1" FOREIGN KEY(
    "FK_STORET_X_STATION_TYPE_CODE") 
    REFERENCES "STORET_OWNER"."STORET_X_STATION_TYPE"(
    "STORET_X_CODE") NOVALIDATE, 
    CONSTRAINT "PK_STATION_1" PRIMARY KEY(
    "COMPUTER_SEQUENCE_NUMBER") USING 
    INDEX  
    TABLESPACE "STORETINDX" 
    STORAGE ( INITIAL 1024K NEXT 1480K MINEXTENTS 1 MAXEXTENTS 
    2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 
    1 INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003217_1" CHECK("COMPUTER_SEQUENCE_NUMBER" IS 
    NOT NULL), 
    CONSTRAINT "SYS_C003218_1" CHECK("PRIMARY_STATION_ID" IS NOT 
    NULL), 
    CONSTRAINT "SYS_C003219_1" CHECK("FK_AGENCY_CODE" IS NOT NULL), 
    CONSTRAINT "SYS_C003220_1" CHECK("TMSP_ADDED" IS NOT NULL), 
    CONSTRAINT "SYS_C003221_1" CHECK("USERID_LAST_UPDT" IS NOT NULL), 
    CONSTRAINT "SYS_C003222_1" CHECK("RECORD_MIGRATED" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 75 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 276480K NEXT 55296K MINEXTENTS 1 MAXEXTENTS 
    505 PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."STATION_ALIAS"("SECONDARY_STATION_ID" CHAR(12) 
    NOT NULL, "FK_COMPUTER_SEQUENCE_NUMBER" NUMBER(12) NOT NULL, 
    "TMSP_ADDED" DATE, "USERID_LAST_UPDT" CHAR(8) NOT NULL, 
    "RECORD_MIGRATED" CHAR(1) NOT NULL, 
    CONSTRAINT "PK_STATION_ALIAS_1" PRIMARY KEY(
    "SECONDARY_STATION_ID", "FK_COMPUTER_SEQUENCE_NUMBER") USING 
    INDEX  
    TABLESPACE "STORETINDX" 
    STORAGE ( INITIAL 3072K NEXT 3072K MINEXTENTS 1 MAXEXTENTS 
    2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 
    1 INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003227_1" CHECK("SECONDARY_STATION_ID" IS NOT 
    NULL), 
    CONSTRAINT "SYS_C003228_1" CHECK("FK_COMPUTER_SEQUENCE_NUMBER" 
    IS NOT NULL), 
    CONSTRAINT "SYS_C003229_1" CHECK("USERID_LAST_UPDT" IS NOT NULL), 
    CONSTRAINT "SYS_C003230_1" CHECK("RECORD_MIGRATED" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 75 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 68640K NEXT 14336K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."STATION_AQUIFER_ASSIGN2"("CODE_ISN" NUMBER(12) NOT NULL, 
    "FK_AQUIFER_CODE" CHAR(15) NOT NULL, 
    "FK_COMPUTER_SEQUENCE_NUMBER" NUMBER(12) NOT NULL, "TMSP_ADDED" 
    DATE, "USERID_LAST_UPDT" CHAR(8) NOT NULL, "RECORD_MIGRATED" 
    CHAR(1) NOT NULL, 
    CONSTRAINT "FK_AQUIFER_STN_AQUIFER_ASSIGN2_1" FOREIGN KEY(
    "FK_AQUIFER_CODE") 
    REFERENCES "STORET_OWNER"."AQUIFER"("CODE") NOVALIDATE, 
    CONSTRAINT "PK_STN_AQUIFER_ASSIGN2_1" PRIMARY KEY("CODE_ISN") 
    USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 12320K NEXT 3072K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003232_1" CHECK("CODE_ISN" IS NOT NULL), 
    CONSTRAINT "SYS_C003233_1" CHECK("FK_AQUIFER_CODE" IS NOT NULL), 
    CONSTRAINT "SYS_C003234_1" CHECK("FK_COMPUTER_SEQUENCE_NUMBER" 
    IS NOT NULL), 
    CONSTRAINT "SYS_C003235_1" CHECK("USERID_LAST_UPDT" IS NOT NULL), 
    CONSTRAINT "SYS_C003236_1" CHECK("RECORD_MIGRATED" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 42000K NEXT 9216K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."STATION_COUNT"("SOURCE_FILE" VARCHAR2(10), "CSN" 
    NUMBER(12) NOT NULL, "PRIMARY_ID" VARCHAR2(15), "CODE_ISN" 
    NUMBER(6) NOT NULL, 
    CONSTRAINT "SYS_C009892_1" PRIMARY KEY("CSN", "CODE_ISN") USING 
    INDEX  
    TABLESPACE "APPL_DATA" 
    STORAGE ( INITIAL 17120K NEXT 8520K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255) 
    TABLESPACE "APPL_DATA" PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 11440K NEXT 5680K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."STATION_LOCATION_POINT"("CODE_ISN" NUMBER(12) NOT NULL, 
    "LATITUDE" NUMBER(8, 6), "LONGITUDE" NUMBER(9, 6), 
    "FK_PRECISION_CODE" NUMBER(2), "FK_STATE_COUNTY_CODE_ISN" NUMBER(
    12) NOT NULL, "FK_FIPS_HYDROLOGICUNIT_STORETX" NUMBER(12), 
    "FK_RF1_REACH_STORET_X_CODE" NUMBER(12), "MILES_UP_REACH" FLOAT(
    126), "RCHONOFF" CHAR(3), "FK_ECOREGION_CODE" CHAR(2), 
    "ECOREGION_TYPE_FLAG" CHAR(1), "FK_LOCATION_POINT_TYPE_CODE" 
    CHAR(1) NOT NULL, "FK_COMPUTER_SEQUENCE_NUMBER" NUMBER(12) NOT 
    NULL, "TMSP_ADDED" DATE NOT NULL, "USERID_LAST_UPDT" CHAR(8) NOT 
    NULL, "RECORD_MIGRATED" CHAR(1) NOT NULL, 
    CONSTRAINT "FK_FIPS_HUC_STN_LOC_POINT_1" FOREIGN KEY(
    "FK_FIPS_HYDROLOGICUNIT_STORETX") 
    REFERENCES "STORET_OWNER"."FIPS_HYDROLOGIC_UNIT"(
    "FIPS_HYDROLOGICUNIT_STORETX") NOVALIDATE, 
    CONSTRAINT "FK_LAT_LONG_PREC_STN_LOC_POINT_1" FOREIGN KEY(
    "FK_PRECISION_CODE") 
    REFERENCES "STORET_OWNER"."LAT_LONG_PRECISION"("CODE") 
    NOVALIDATE, 
    CONSTRAINT "FK_LOC_POINT_TYPE_STN_LOC_POIN_1" FOREIGN KEY(
    "FK_LOCATION_POINT_TYPE_CODE") 
    REFERENCES "STORET_OWNER"."LOCATION_POINT_TYPE"("CODE") 
    NOVALIDATE, 
    CONSTRAINT "FK_OMER_LEV3_ECO_STN_LOC_POINT_1" FOREIGN KEY(
    "FK_ECOREGION_CODE") 
    REFERENCES "STORET_OWNER"."OMERNICH_LEVEL3_ECOREGION"("CODE") 
    NOVALIDATE, 
    CONSTRAINT "FK_RF1_REACH_STN_LOC_POINT_1" FOREIGN KEY(
    "FK_RF1_REACH_STORET_X_CODE") 
    REFERENCES "STORET_OWNER"."RF1_REACH"("STORET_X_CODE") 
    NOVALIDATE, 
    CONSTRAINT "FK_STATE_COUNTY_STN_LOC_POINT_1" FOREIGN KEY(
    "FK_STATE_COUNTY_CODE_ISN") 
    REFERENCES "STORET_OWNER"."STATE_COUNTY"("CODE_ISN") NOVALIDATE, 
    CONSTRAINT "PK_STATION_LOC_POINT_1" PRIMARY KEY("CODE_ISN") 
    USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 13320K NEXT 3072K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003239_1" CHECK("CODE_ISN" IS NOT NULL), 
    CONSTRAINT "SYS_C003240_1" CHECK("FK_STATE_COUNTY_CODE_ISN" IS 
    NOT NULL), 
    CONSTRAINT "SYS_C003241_1" CHECK("FK_LOCATION_POINT_TYPE_CODE" 
    IS NOT NULL), 
    CONSTRAINT "SYS_C003242_1" CHECK("FK_COMPUTER_SEQUENCE_NUMBER" 
    IS NOT NULL), 
    CONSTRAINT "SYS_C003243_1" CHECK("TMSP_ADDED" IS NOT NULL), 
    CONSTRAINT "SYS_C003244_1" CHECK("USERID_LAST_UPDT" IS NOT NULL), 
    CONSTRAINT "SYS_C003245_1" CHECK("RECORD_MIGRATED" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 5 PCTUSED 75 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 68640K NEXT 14336K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."STORET_RESULT_REMARK"("CODE" CHAR(1) NOT NULL, 
    "DESCRIPTION" VARCHAR2(254), 
    CONSTRAINT "PK_STORET_RES_REMARK_1" PRIMARY KEY("CODE") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003247_1" CHECK("CODE" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/

CREATE TABLE "STORET_OWNER"."STORET_X_STATION_TYPE"("STORET_X_CODE" NUMBER(12) NOT 
    NULL, "PRIMARY_TYPE_CODE" VARCHAR2(30), "SECONDARY_TYPE_CODE" 
    VARCHAR2(30), "NATURAL_INDICATOR_CODE" CHAR(1), 
    CONSTRAINT "PK_STORETX_STATN_TYPE_1" PRIMARY KEY(
    "STORET_X_CODE") USING 
    INDEX  
    TABLESPACE "APPL_INDEX" 
    STORAGE ( INITIAL 40K NEXT 40K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) PCTFREE 10 
    INITRANS 2 MAXTRANS 255, 
    CONSTRAINT "SYS_C003249_1" CHECK("STORET_X_CODE" IS NOT NULL)) 
    TABLESPACE "APPL_DATA" PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 
    255 
    STORAGE ( INITIAL 16K NEXT 8K MINEXTENTS 1 MAXEXTENTS 505 
    PCTINCREASE 50 FREELISTS 1 FREELIST GROUPS 1) 
    LOGGING 
/





