
rem /*
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  * Program : sch_STORET_OWNER.sql
rem  *
rem  * This program generate SCHEMA for STORET_OWNER directly from database
rem  *
rem  * 01-OCT-2004 :
rem  * Razi Chaudhry : Program Auto Generated from DB
rem  *
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  * Authors: 1. Razsoft Canada, Inc. : http://www.razsoft.com (Razi)
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  */



rem /*
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  * Config
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  */



    SET TRIMOUT   ON
    SET TRIMSPOOL ON
    SET HEADING   OFF
    SET FEEDBACK  ON
    SET PAUSE     OFF
    SET PAGESIZE  999
    SET LINESIZE  500
    SET TERM ON
    SET ECHO ON



rem /*
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  * DROP all objects
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  */


DROP INDEX           a1_ix1;
DROP INDEX           agency_station_indx;
DROP INDEX           csn2_pk;
DROP INDEX           end_date_indx;
DROP INDEX           f1_area_ix2;
DROP INDEX           f1_len_ix3;
DROP INDEX           f1_uk1;
DROP INDEX           fk_computer_sequence_number;
DROP INDEX           fk_result_sample_code_isn;
DROP INDEX           gw_indicator_indx;
DROP INDEX           huc_indx;
DROP INDEX           indx_county_name;
DROP INDEX           indx_psid;
DROP INDEX           indx_state_name;
DROP INDEX           ind_county_name;
DROP INDEX           ind_primary_station_id;
DROP INDEX           ind_state_name;
DROP INDEX           lat_long_indx;
DROP INDEX           parameter_x;
DROP INDEX           pbsyscatcoldict_idx;
DROP INDEX           pbsyscatfrmts_idx;
DROP INDEX           pbsyscatpbt_idx;
DROP INDEX           pbsyscatvlds_idx;
DROP INDEX           pbsyspbe_idx;
DROP INDEX           pipe_indicator_indx;
DROP INDEX           pk_agency;
DROP INDEX           pk_aquifer;
DROP INDEX           pk_composite_method;
DROP INDEX           pk_composite_statistic;
DROP INDEX           pk_decimal_point;
DROP INDEX           pk_descriptive_paragraph;
DROP INDEX           pk_effluent_statistic;
DROP INDEX           pk_eff_monitor_intent;
DROP INDEX           pk_error_log;
DROP INDEX           pk_fips_huc;
DROP INDEX           pk_lat_long_precision;
DROP INDEX           pk_leg_storet_level1;
DROP INDEX           pk_leg_storet_level2a;
DROP INDEX           pk_leg_storet_level2b;
DROP INDEX           pk_leg_storet_level3;
DROP INDEX           pk_leg_storet_level4;
DROP INDEX           pk_leg_storet_level5;
DROP INDEX           pk_leg_sto_lev5_assign;
DROP INDEX           pk_leg_sto_stn_type;
DROP INDEX           pk_location_point_type;
DROP INDEX           pk_omernich_lev3_ecor;
DROP INDEX           pk_organization;
DROP INDEX           pk_parameter;
DROP INDEX           pk_param_grp;
DROP INDEX           pk_prim_act_category;
DROP INDEX           pk_prmy_secndy_combo2;
DROP INDEX           pk_reporting_units;
DROP INDEX           pk_result;
DROP INDEX           pk_rf1_reach;
DROP INDEX           pk_rmi;
DROP INDEX           pk_sample;
DROP INDEX           pk_samp_media_anal_type;
DROP INDEX           pk_sec_act_category;
DROP INDEX           pk_state_county;
DROP INDEX           pk_station;
DROP INDEX           pk_station_alias;
DROP INDEX           pk_station_loc_point;
DROP INDEX           pk_stn_aquifer_assign2;
DROP INDEX           pk_storetx_statn_type;
DROP INDEX           pk_storet_res_remark;
DROP INDEX           result_run_no_indx;
DROP INDEX           s1_ix1;
DROP INDEX           s1_ix2;
DROP INDEX           sample_depth_indx;
DROP INDEX           sample_run_number_indx;
DROP INDEX           sde_logfiles_pk;
DROP INDEX           sde_logfiles_uk;
DROP INDEX           sde_logfiles_uk2;
DROP INDEX           sde_logfile_data_idx1;
DROP INDEX           sde_logfile_data_idx2;
DROP INDEX           start_date_indx;
DROP INDEX           state_county_indx;
DROP INDEX           sw_indicator_indx;
DROP INDEX           sys_c003087;
DROP INDEX           sys_c009892;
DROP INDEX           tpsql_idx;
DROP INDEX           tptbl_idx;
DROP INDEX           xif104sample;
DROP INDEX           xif108legacy_storet_station_ty;
DROP INDEX           xif110legacy_storet_station_ty;
DROP INDEX           xif112parameter;
DROP INDEX           xif114parameter;
DROP INDEX           xif38agency;
DROP INDEX           xif39station_alias;
DROP INDEX           xif41descriptive_paragraph;
DROP INDEX           xif42station_aquifer_assign2;
DROP INDEX           xif43station_aquifer_assign2;
DROP INDEX           xif44station_location_point_ty;
DROP INDEX           xif45station_location_point_ty;
DROP INDEX           xif48station_location_point_ty;
DROP INDEX           xif49station_location_point_ty;
DROP INDEX           xif50station_location_point_ty;
DROP INDEX           xif51station;
DROP INDEX           xif57station;
DROP INDEX           xif58old_storet_level_code_com;
DROP INDEX           xif60old_storet_level_code_com;
DROP INDEX           xif61old_storet_level_code_com;
DROP INDEX           xif62old_storet_level5_combo2;
DROP INDEX           xif63old_storet_level5_combo2;
DROP INDEX           xif73rmi;
DROP INDEX           xif74station_location_point;
DROP INDEX           xif75smple_rsltval_parmeter_as;
DROP INDEX           xif78parameter;
DROP INDEX           xif79result;
DROP INDEX           xif80result;
DROP INDEX           xif82parameter;
DROP INDEX           xif88sample;
DROP INDEX           xif89sample;
DROP INDEX           xif91station_location_point;
DROP INDEX           xif92parameter;
DROP INDEX           xif96prmry_scndry_actvty_combo;
DROP INDEX           xif97prmry_scndry_actvty_combo;
DROP INDEX           xpkcharacteristic;
DROP SEQUENCE        sde_logfile_lid_gen;
DROP SEQUENCE        seq_em_csn;
DROP SEQUENCE        seq_report;
DROP SEQUENCE        toad_seq;
DROP TABLE           agency;
DROP TABLE           aquifer;
DROP TABLE           characteristic;
DROP TABLE           childless_sample;
DROP TABLE           composite_method;
DROP TABLE           composite_statistic;
DROP TABLE           decimal_point;
DROP TABLE           descriptive_paragraph_line;
DROP TABLE           effluent_monitoring_intent;
DROP TABLE           effluent_statistic;
DROP TABLE           em_station_location_sde;
DROP TABLE           em_stn_loc_ix_hl61$;
DROP TABLE           em_stn_loc_ix_hl6n1$;
DROP TABLE           error_log;
DROP TABLE           f1;
DROP TABLE           fips_hydrologic_unit;
DROP TABLE           int_org;
DROP TABLE           lat_long_precision;
DROP TABLE           legacy_storet_level1;
DROP TABLE           legacy_storet_level2a;
DROP TABLE           legacy_storet_level2b;
DROP TABLE           legacy_storet_level3;
DROP TABLE           legacy_storet_level4;
DROP TABLE           legacy_storet_level5;
DROP TABLE           legacy_storet_level5_assign2;
DROP TABLE           legacy_storet_station_type;
DROP TABLE           location_point_type;
DROP TABLE           omernich_level3_ecoregion;
DROP TABLE           organization;
DROP TABLE           parameter;
DROP TABLE           parameter_copy;
DROP TABLE           parameter_group;
DROP TABLE           pbcatcol;
DROP TABLE           pbcatedt;
DROP TABLE           pbcatfmt;
DROP TABLE           pbcattbl;
DROP TABLE           pbcatvld;
DROP TABLE           plan_table;
DROP TABLE           primary_activity_category;
DROP TABLE           prmry_scndry_actvty_combo2;
DROP TABLE           reporting_units;
DROP TABLE           result;
DROP TABLE           rf1_reach;
DROP TABLE           rmi;
DROP TABLE           s1;
DROP TABLE           sample;
DROP TABLE           sample_media_analysis_type;
DROP TABLE           sde_exceptions;
DROP TABLE           sde_logfiles;
DROP TABLE           sde_logfile_data;
DROP TABLE           secondary_activity_category;
DROP TABLE           state_county;
DROP TABLE           station;
DROP TABLE           station2;
DROP TABLE           station_alias;
DROP TABLE           station_aquifer_assign2;
DROP TABLE           station_count;
DROP TABLE           station_location_point;
DROP TABLE           storet_result_remark;
DROP TABLE           storet_x_station_type;
DROP TABLE           toad_plan_sql;
DROP TABLE           toad_plan_table;
DROP TABLE           unused_pcode;


rem /*
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  * ROLE GRANTED by SYSTEM to user
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  */



CONNECT SYSTEM/STO2ET@STO2


GRANT dba                                 TO storet_owner;
GRANT connect                             TO storet_owner;
GRANT resource                            TO storet_owner;
GRANT storldci_acct                       TO storet_owner;
GRANT exp_full_database                   TO storet_owner;
GRANT imp_full_database                   TO storet_owner;


rem /*
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  * ALTER User for tablespaces
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  */


ALTER USER storet_owner
      DEFAULT TABLESPACE   appl_data
      TEMPORARY TABLESPACE temporary_data);


rem /*
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  * CREATE tables, primary keys, storage, and pct parameters
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  */


CREATE TABLE agency (
    code                                   CHAR(8)              NOT NULL ,
    agency_name                            VARCHAR2(25)        ,
    organization_type                      CHAR(3)             ,
    data_description01                     VARCHAR2(25)        ,
    data_description02                     VARCHAR2(25)        ,
    data_description03                     VARCHAR2(25)        ,
    retirement_name                        VARCHAR2(25)        ,
    retirement_date                        CHAR(8)             ,
    retirement_phone                       VARCHAR2(13)        ,
    epa_region_location                    VARCHAR2(2)         ,
    fk_organization_code_isn               NUMBER(12,0)        ,
    tmsp_added                             DATE                 NOT NULL ,
    userid_last_updt                       CHAR(8)              NOT NULL ,
    record_migrated                        CHAR(1)              NOT NULL )
    PRIMARY KEY pk_agency (
         code );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 245760 NEXT 49152 );

CREATE TABLE aquifer (
    code                                   CHAR(15)             NOT NULL ,
    long_name                              VARCHAR2(70)        )
    PRIMARY KEY pk_aquifer (
         code );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 1064960 NEXT 204800 );

CREATE TABLE characteristic (
    code_isn                               NUMBER(12,0)         NOT NULL ,
    uom_type                               CHAR(5)              NOT NULL ,
    search_name                            VARCHAR2(60)         NOT NULL ,
    display_name                           VARCHAR2(60)         NOT NULL ,
    characteristic_type_code               CHAR(1)              NOT NULL ,
    taxon_rank_code                        CHAR(8)             )
    PRIMARY KEY xpkcharacteristic (
         code_isn );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 2129920 NEXT 139264 );

CREATE TABLE childless_sample (
    sample_code_isn                        NUMBER(12,0)        )
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 40960 NEXT 40960 );

CREATE TABLE composite_method (
    code                                   CHAR(1)              NOT NULL ,
    name                                   VARCHAR2(20)         NOT NULL ,
    description                            VARCHAR2(260)        NOT NULL )
    PRIMARY KEY pk_composite_method (
         code );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE composite_statistic (
    code                                   CHAR(1)              NOT NULL ,
    name                                   VARCHAR2(60)        ,
    print_format                           CHAR(3)             ,
    performance_type_ind                   CHAR(1)             )
    PRIMARY KEY pk_composite_statistic (
         code );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE decimal_point (
    code                                   NUMBER(2,0)          NOT NULL ,
    description                            VARCHAR2(20)        )
    PRIMARY KEY pk_decimal_point (
         code );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE descriptive_paragraph_line (
    fk_computer_sequence_number            NUMBER(12,0)         NOT NULL ,
    paragraph_line_number                  NUMBER(2,0)          NOT NULL ,
    text                                   CHAR(72)            ,
    tmsp_added                             DATE                 NOT NULL ,
    userid_last_updt                       CHAR(8)              NOT NULL ,
    record_migrated                        CHAR(1)              NOT NULL )
    PRIMARY KEY pk_descriptive_paragraph (
         fk_computer_sequence_number,
         paragraph_line_number );
    PCTFREE 5 PCTUSED 75
    STORAGE ( INITIAL 169902080 NEXT 34603008 );

CREATE TABLE effluent_monitoring_intent (
    code                                   CHAR(2)              NOT NULL ,
    name                                   VARCHAR2(60)         NOT NULL )
    PRIMARY KEY pk_eff_monitor_intent (
         code );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE effluent_statistic (
    code                                   CHAR(1)              NOT NULL ,
    name                                   VARCHAR2(60)        ,
    print_format                           CHAR(3)             )
    PRIMARY KEY pk_effluent_statistic (
         code );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE em_station_location_sde (
    em_csn                                 NUMBER(,)            NOT NULL ,
    csn                                    NUMBER(12,0)         NOT NULL ,
    org_id                                 VARCHAR2(8)          NOT NULL ,
    org_name                               VARCHAR2(25)        ,
    stn_id                                 VARCHAR2(15)         NOT NULL ,
    stn_name                               VARCHAR2(48)        ,
    stn_loc1                               VARCHAR2(60)        ,
    stn_loc2                               VARCHAR2(60)        ,
    point                                  VARCHAR2(30)        ,
    latitude                               NUMBER(8,6)         ,
    longitude                              NUMBER(9,6)         ,
    county                                 VARCHAR2(30)        ,
    state_name                             VARCHAR2(30)        ,
    huc                                    VARCHAR2(8)         ,
    seg                                    VARCHAR2(4)         ,
    huc_name                               VARCHAR2(60)        ,
    seg_name                               VARCHAR2(60)        ,
    org_stn_id                             VARCHAR2(24)        ,
    type_indic                             CHAR(1)             ,
    fid                                    NUMBER(,0)          )
    PRIMARY KEY  (
         em_csn );
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 125829120 NEXT 20971520 );

CREATE TABLE em_stn_loc_ix_hl61$ (
    sdo_groupcode                          RAW(15)             ,
    sdo_rowid                              ROWID(10)           ,
    sdo_code                               RAW(15)             ,
    sdo_status                             VARCHAR2(1)         )
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 26255360 NEXT 13090816 );

CREATE TABLE em_stn_loc_ix_hl6n1$ (
    sdo_groupcode                          RAW(15)             ,
    sdo_rowid                              ROWID(10)           ,
    sdo_code                               RAW(15)             ,
    sdo_status                             VARCHAR2(1)         )
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 26255360 NEXT 13090816 );

CREATE TABLE error_log (
    computer_sequence_number               NUMBER(12,0)         NOT NULL ,
    error_code_isn                         NUMBER(12,0)         NOT NULL ,
    sample_code_isn                        NUMBER(12,0)        ,
    destination_table                      CHAR(30)             NOT NULL ,
    attribute                              CHAR(30)             NOT NULL ,
    reason                                 VARCHAR2(255)        NOT NULL ,
    required_attribute                     CHAR(1)              NOT NULL ,
    run_number                             NUMBER(3,0)          NOT NULL ,
    tmsp_added                             DATE                 NOT NULL ,
    userid_last_updt                       CHAR(8)              NOT NULL )
    PRIMARY KEY pk_error_log (
         error_code_isn );
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 88514560 NEXT 29458432 );

CREATE TABLE f1 (
    fid                                    NUMBER(,0)           NOT NULL ,
    numofpts                               NUMBER(,0)           NOT NULL ,
    entity                                 NUMBER(,0)           NOT NULL ,
    eminx                                  FLOAT(22)            NOT NULL ,
    eminy                                  FLOAT(22)            NOT NULL ,
    emaxx                                  FLOAT(22)            NOT NULL ,
    emaxy                                  FLOAT(22)            NOT NULL ,
    eminz                                  FLOAT(22)           ,
    emaxz                                  FLOAT(22)           ,
    min_measure                            FLOAT(22)           ,
    max_measure                            FLOAT(22)           ,
    area                                   FLOAT(22)            NOT NULL ,
    len                                    FLOAT(22)            NOT NULL ,
    points                                 LONG RAW(0)         )
    PRIMARY KEY f1_pk (
         fid );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 33996800 NEXT 409600 );

CREATE TABLE fips_hydrologic_unit (
    fips_hydrologicunit_storetx            NUMBER(12,0)         NOT NULL ,
    fips_hydrologic_unit_code              CHAR(8)             ,
    name                                   VARCHAR2(60)        )
    PRIMARY KEY pk_fips_huc (
         fips_hydrologicunit_storetx );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 163840 NEXT 16384 );

CREATE TABLE int_org (
    contact_name                           CHAR(25)             NOT NULL ,
    contact_address_line01                 CHAR(25)            ,
    contact_address_line02                 CHAR(25)            ,
    contact_phone                          CHAR(13)             NOT NULL ,
    contact_address_line03                 CHAR(25)            ,
    contact_address_line04                 CHAR(25)            ,
    alternate_contact_name                 CHAR(25)            ,
    alternate_phone                        CHAR(13)            )
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 450560 NEXT 221184 );

CREATE TABLE lat_long_precision (
    code                                   NUMBER(2,0)          NOT NULL ,
    name                                   VARCHAR2(20)        )
    PRIMARY KEY pk_lat_long_precision (
         code );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE legacy_storet_level1 (
    name                                   VARCHAR2(12)         NOT NULL ,
    description                            VARCHAR2(260)       )
    PRIMARY KEY pk_leg_storet_level1 (
         name );
    PCTFREE 90 PCTUSED 5
    STORAGE ( INITIAL 40960 NEXT 24576 );

CREATE TABLE legacy_storet_level2a (
    name                                   VARCHAR2(12)         NOT NULL ,
    description                            VARCHAR2(260)       )
    PRIMARY KEY pk_leg_storet_level2a (
         name );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE legacy_storet_level2b (
    name                                   VARCHAR2(12)         NOT NULL ,
    description                            VARCHAR2(250)       )
    PRIMARY KEY pk_leg_storet_level2b (
         name );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE legacy_storet_level3 (
    name                                   VARCHAR2(12)         NOT NULL ,
    description                            VARCHAR2(250)       )
    PRIMARY KEY pk_leg_storet_level3 (
         name );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE legacy_storet_level4 (
    name                                   VARCHAR2(12)         NOT NULL ,
    description                            VARCHAR2(250)       )
    PRIMARY KEY pk_leg_storet_level4 (
         name );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE legacy_storet_level5 (
    name                                   VARCHAR2(12)         NOT NULL ,
    description                            VARCHAR2(250)       )
    PRIMARY KEY pk_leg_storet_level5 (
         name );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE legacy_storet_level5_assign2 (
    code_isn                               NUMBER(12,0)         NOT NULL ,
    fk_legacy_storet_level5_name           VARCHAR2(12)         NOT NULL ,
    fk_computer_sequence_number            NUMBER(12,0)        ,
    tmsp_added                             DATE                 NOT NULL ,
    userid_last_updt                       CHAR(8)              NOT NULL ,
    record_migrated                        CHAR(1)              NOT NULL )
    PRIMARY KEY pk_leg_sto_lev5_assign (
         code_isn );
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 74465280 NEXT 15728640 );

CREATE TABLE legacy_storet_station_type (
    fk_computer_sequence_number            NUMBER(12,0)         NOT NULL ,
    fk_legacy_storet_level4_name           VARCHAR2(12)        ,
    fk_legacy_storet_level2a_name          VARCHAR2(12)         NOT NULL ,
    fk_legacy_storet_level3_name           VARCHAR2(12)        ,
    fk_legacy_storet_level2b_name          VARCHAR2(12)        ,
    fk_legacy_storet_level1_name           VARCHAR2(12)        ,
    tmsp_added                             DATE                 NOT NULL ,
    userid_last_updt                       CHAR(8)              NOT NULL ,
    record_migrated                        CHAR(1)              NOT NULL )
    PRIMARY KEY pk_leg_sto_stn_type (
         fk_computer_sequence_number );
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 257966080 NEXT 52428800 );

CREATE TABLE location_point_type (
    code                                   CHAR(1)              NOT NULL ,
    name                                   VARCHAR2(30)        )
    PRIMARY KEY pk_location_point_type (
         code );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE omernich_level3_ecoregion (
    code                                   CHAR(2)              NOT NULL ,
    name                                   VARCHAR2(60)        )
    PRIMARY KEY pk_omernich_lev3_ecor (
         code );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE organization (
    code_isn                               NUMBER(12,0)         NOT NULL ,
    contact_name                           VARCHAR2(25)         NOT NULL ,
    contact_phone                          CHAR(13)             NOT NULL ,
    contact_address_line01                 VARCHAR2(25)        ,
    contact_address_line02                 VARCHAR2(25)        ,
    contact_address_line03                 VARCHAR2(25)        ,
    contact_address_line04                 VARCHAR2(25)        ,
    alternate_contact_name                 VARCHAR2(25)        ,
    alternate_phone                        CHAR(13)            ,
    tmsp_added                             DATE                 NOT NULL ,
    userid_last_updt                       CHAR(8)              NOT NULL ,
    record_migrated                        CHAR(1)              NOT NULL )
    PRIMARY KEY pk_organization (
         code_isn );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 81920 NEXT 16384 );

CREATE TABLE parameter (
    code                                   CHAR(5)              NOT NULL ,
    long_name                              VARCHAR2(50)        ,
    fk_parameter_group_code                NUMBER(2,0)          NOT NULL ,
    short_name01                           CHAR(8)             ,
    short_name02                           CHAR(8)             ,
    short_name03                           CHAR(8)             ,
    fk_reporting_units_code                VARCHAR2(8)         ,
    fk_smpl_mdia_type_code_isn             NUMBER(12,0)        ,
    fk_decimal_point_code                  NUMBER(2,0)         ,
    fk_characteristic_code_isn             NUMBER(12,0)        ,
    cas_number                             NUMBER(9,0)         ,
    number_observations                    NUMBER(12,0)        )
    PRIMARY KEY pk_parameter (
         code );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 2129920 NEXT 106496 );

CREATE TABLE parameter_copy (
    code                                   CHAR(5)              NOT NULL ,
    fk_parameter_group_code                NUMBER(2,0)          NOT NULL ,
    long_name                              CHAR(50)            ,
    short_name01                           CHAR(8)             ,
    short_name02                           CHAR(8)             ,
    short_name03                           CHAR(8)             ,
    cas_number                             NUMBER(9,0)         ,
    fk_reporting_units_code                VARCHAR2(8)         ,
    fk_smpl_mdia_type_code_isn             NUMBER(12,0)        ,
    fk_decimal_point_code                  NUMBER(2,0)         ,
    fk_characteristic_code_isn             NUMBER(12,0)        ,
    number_observations                    NUMBER(15,0)        )
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 1597440 NEXT 761856 );

CREATE TABLE parameter_group (
    code                                   NUMBER(2,0)          NOT NULL ,
    name                                   VARCHAR2(60)         NOT NULL ,
    official_name                          VARCHAR2(10)         NOT NULL )
    PRIMARY KEY pk_param_grp (
         code );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE pbcatcol (
    pbc_tnam                               VARCHAR2(30)         NOT NULL ,
    pbc_tid                                NUMBER(,0)          ,
    pbc_ownr                               VARCHAR2(30)         NOT NULL ,
    pbc_cnam                               VARCHAR2(30)         NOT NULL ,
    pbc_cid                                NUMBER(,0)          ,
    pbc_labl                               VARCHAR2(254)       ,
    pbc_lpos                               NUMBER(,0)          ,
    pbc_hdr                                VARCHAR2(254)       ,
    pbc_hpos                               NUMBER(,0)          ,
    pbc_jtfy                               NUMBER(,0)          ,
    pbc_mask                               VARCHAR2(31)        ,
    pbc_case                               NUMBER(,0)          ,
    pbc_hght                               NUMBER(,0)          ,
    pbc_wdth                               NUMBER(,0)          ,
    pbc_ptrn                               VARCHAR2(31)        ,
    pbc_bmap                               CHAR(1)             ,
    pbc_init                               VARCHAR2(254)       ,
    pbc_cmnt                               VARCHAR2(254)       ,
    pbc_edit                               VARCHAR2(31)        ,
    pbc_tag                                VARCHAR2(254)       )
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 40960 NEXT 40960 );

CREATE TABLE pbcatedt (
    pbe_name                               VARCHAR2(30)        ,
    pbe_edit                               VARCHAR2(254)       ,
    pbe_type                               NUMBER(,0)          ,
    pbe_cntr                               NUMBER(,0)          ,
    pbe_seqn                               NUMBER(,0)          ,
    pbe_flag                               NUMBER(,0)          ,
    pbe_work                               VARCHAR2(32)        )
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 40960 NEXT 40960 );

CREATE TABLE pbcatfmt (
    pbf_name                               VARCHAR2(30)        ,
    pbf_frmt                               VARCHAR2(254)       ,
    pbf_type                               NUMBER(,0)           NOT NULL ,
    pbf_cntr                               NUMBER(,0)          )
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 40960 NEXT 40960 );

CREATE TABLE pbcattbl (
    pbt_tnam                               VARCHAR2(30)         NOT NULL ,
    pbt_tid                                NUMBER(,0)          ,
    pbt_ownr                               VARCHAR2(30)         NOT NULL ,
    pbd_fhgt                               NUMBER(,0)          ,
    pbd_fwgt                               NUMBER(,0)          ,
    pbd_fitl                               CHAR(1)             ,
    pbd_funl                               CHAR(1)             ,
    pbd_fchr                               NUMBER(,0)          ,
    pbd_fptc                               NUMBER(,0)          ,
    pbd_ffce                               VARCHAR2(18)        ,
    pbh_fhgt                               NUMBER(,0)          ,
    pbh_fwgt                               NUMBER(,0)          ,
    pbh_fitl                               CHAR(1)             ,
    pbh_funl                               CHAR(1)             ,
    pbh_fchr                               NUMBER(,0)          ,
    pbh_fptc                               NUMBER(,0)          ,
    pbh_ffce                               VARCHAR2(18)        ,
    pbl_fhgt                               NUMBER(,0)          ,
    pbl_fwgt                               NUMBER(,0)          ,
    pbl_fitl                               CHAR(1)             ,
    pbl_funl                               CHAR(1)             ,
    pbl_fchr                               NUMBER(,0)          ,
    pbl_fptc                               NUMBER(,0)          ,
    pbl_ffce                               VARCHAR2(18)        ,
    pbt_cmnt                               VARCHAR2(254)       )
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 40960 NEXT 40960 );

CREATE TABLE pbcatvld (
    pbv_name                               VARCHAR2(30)        ,
    pbv_vald                               VARCHAR2(254)       ,
    pbv_type                               NUMBER(,0)          ,
    pbv_cntr                               NUMBER(,0)          ,
    pbv_msg                                VARCHAR2(254)       )
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 40960 NEXT 40960 );

CREATE TABLE plan_table (
    statement_id                           VARCHAR2(30)        ,
    timestamp                              DATE                ,
    remarks                                VARCHAR2(80)        ,
    operation                              VARCHAR2(30)        ,
    options                                VARCHAR2(30)        ,
    object_node                            VARCHAR2(128)       ,
    object_owner                           VARCHAR2(30)        ,
    object_name                            VARCHAR2(30)        ,
    object_instance                        NUMBER(,0)          ,
    object_type                            VARCHAR2(30)        ,
    optimizer                              VARCHAR2(255)       ,
    search_columns                         NUMBER(,0)          ,
    id                                     NUMBER(,0)          ,
    parent_id                              NUMBER(,0)          ,
    position                               NUMBER(,0)          ,
    cost                                   NUMBER(,0)          ,
    cardinality                            NUMBER(,0)          ,
    bytes                                  NUMBER(,0)          ,
    other_tag                              VARCHAR2(255)       ,
    partition_start                        VARCHAR2(255)       ,
    partition_stop                         VARCHAR2(255)       ,
    partition_id                           NUMBER(,0)          ,
    other                                  LONG                ,
    distribution                           VARCHAR2(30)        )
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 40960 NEXT 40960 );

CREATE TABLE primary_activity_category (
    code                                   CHAR(1)              NOT NULL ,
    name                                   VARCHAR2(60)        )
    PRIMARY KEY pk_prim_act_category (
         code );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE prmry_scndry_actvty_combo2 (
    code_isn                               NUMBER(12,0)         NOT NULL ,
    fk_prmry_actvty_category_code          CHAR(1)             ,
    fk_scndry_actvty_category_code         NUMBER(4,0)         )
    PRIMARY KEY pk_prmy_secndy_combo2 (
         code_isn );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE reporting_units (
    code                                   VARCHAR2(8)          NOT NULL ,
    name                                   VARCHAR2(60)        )
    PRIMARY KEY pk_reporting_units (
         code );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE result (
    code_isn                               NUMBER(12,0)         NOT NULL ,
    result_value                           VARCHAR2(12)        ,
    fk_sample_code_isn                     NUMBER(12,0)        ,
    fk_composite_statistic_code            CHAR(1)             ,
    fk_effluent_statistic_code             CHAR(1)             ,
    fk_parameter_code                      CHAR(5)             ,
    fk_storet_result_remark_code           CHAR(1)             ,
    tmsp_added                             DATE                 NOT NULL ,
    userid_last_updt                       CHAR(8)              NOT NULL ,
    record_migrated                        CHAR(1)              NOT NULL ,
    run_number                             NUMBER(3,0)          NOT NULL )
    PRIMARY KEY pk_result (
         code_isn );
    PCTFREE 5 PCTUSED 75
    STORAGE ( INITIAL 2147483648 NEXT 1073741824 );

CREATE TABLE rf1_reach (
    storet_x_code                          NUMBER(12,0)         NOT NULL ,
    catunit_code                           VARCHAR2(8)          NOT NULL ,
    rchmile_segment                        NUMBER(3,0)         ,
    rchlength                              FLOAT(22)           ,
    rchlevel                               FLOAT(22)           ,
    rchtype                                CHAR(1)             ,
    rchname                                VARCHAR2(60)        )
    PRIMARY KEY pk_rf1_reach (
         storet_x_code );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 6307840 NEXT 1048576 );

CREATE TABLE rmi (
    code_isn                               NUMBER(12,0)         NOT NULL ,
    rmi_mile_desc                          VARCHAR2(112)       ,
    rmi_index_desc                         VARCHAR2(112)       ,
    fk_computer_sequence_number            NUMBER(12,0)         NOT NULL ,
    tmsp_added                             DATE                 NOT NULL ,
    userid_last_updt                       CHAR(8)              NOT NULL ,
    record_migrated                        CHAR(1)              NOT NULL )
    PRIMARY KEY pk_rmi (
         code_isn );
    PCTFREE 5 PCTUSED 75
    STORAGE ( INITIAL 167772160 NEXT 33554432 );

CREATE TABLE s1 (
    sp_fid                                 NUMBER(,0)           NOT NULL ,
    gx                                     NUMBER(,0)           NOT NULL ,
    gy                                     NUMBER(,0)           NOT NULL ,
    eminx                                  NUMBER(,0)           NOT NULL ,
    eminy                                  NUMBER(,0)           NOT NULL ,
    emaxx                                  NUMBER(,0)           NOT NULL ,
    emaxy                                  NUMBER(,0)           NOT NULL )
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 17612800 NEXT 409600 );

CREATE TABLE sample (
    sample_code_isn                        NUMBER(12,0)         NOT NULL ,
    start_date                             DATE                ,
    start_time                             NUMBER(4,0)         ,
    end_date                               DATE                ,
    end_time                               NUMBER(4,0)         ,
    sample_depth                           NUMBER(8,2)         ,
    species_name                           VARCHAR2(60)        ,
    replicate_number                       NUMBER(12,0)        ,
    tissue_name                            VARCHAR2(60)        ,
    umk                                    CHAR(8)             ,
    pipe_id                                NUMBER(12,0)        ,
    composite_grab_number                  NUMBER(2,0)         ,
    usgs_field_lab_code                    CHAR(1)             ,
    store_date                             DATE                ,
    fk_prmy_scndy_combo2_code_isn          NUMBER(12,0)        ,
    fk_computer_sequence_number            NUMBER(12,0)         NOT NULL ,
    fk_composite_method_code               CHAR(1)             ,
    fk_effluent_montrng_intnt_code         CHAR(2)             ,
    tmsp_added                             DATE                 NOT NULL ,
    userid_last_updt                       CHAR(8)              NOT NULL ,
    record_migrated                        CHAR(1)              NOT NULL ,
    run_number                             NUMBER(3,0)          NOT NULL )
    PRIMARY KEY pk_sample (
         sample_code_isn );
    PCTFREE 5 PCTUSED 75
    STORAGE ( INITIAL 2147483648 NEXT 1048576000 );

CREATE TABLE sample_media_analysis_type (
    code_isn                               NUMBER(12,0)         NOT NULL ,
    analysis_type_code                     CHAR(1)             ,
    analysis_type_name                     VARCHAR2(80)        ,
    sample_media_code                      CHAR(1)              NOT NULL ,
    sample_media_name                      VARCHAR2(60)        )
    PRIMARY KEY pk_samp_media_anal_type (
         code_isn );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE sde_exceptions (
    row_id                                 ROWID(10)           ,
    owner                                  VARCHAR2(30)        ,
    table_name                             VARCHAR2(30)        ,
    constraint                             VARCHAR2(30)        )
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 122880 NEXT 98304 );

CREATE TABLE sde_logfiles (
    logfile_name                           VARCHAR2(256)        NOT NULL ,
    logfile_id                             NUMBER(,0)           NOT NULL ,
    logfile_data_id                        NUMBER(,0)           NOT NULL ,
    registration_id                        NUMBER(,0)           NOT NULL ,
    flags                                  NUMBER(,0)           NOT NULL ,
    session_tag                            NUMBER(,0)           NOT NULL )
    PRIMARY KEY sde_logfiles_pk (
         logfile_id );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 1064960 NEXT 1048576 );

CREATE TABLE sde_logfile_data (
    logfile_data_id                        NUMBER(,0)           NOT NULL ,
    sde_row_id                             NUMBER(,0)           NOT NULL )
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 1064960 NEXT 1048576 );

CREATE TABLE secondary_activity_category (
    code                                   NUMBER(4,0)          NOT NULL ,
    name                                   VARCHAR2(60)        ,
    output_format                          VARCHAR2(8)         )
    PRIMARY KEY pk_sec_act_category (
         code );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE state_county (
    code_isn                               NUMBER(12,0)         NOT NULL ,
    state_code                             CHAR(2)             ,
    county_code                            CHAR(3)             ,
    state_name                             CHAR(30)            ,
    county_name                            CHAR(30)            ,
    fips_indicator                         CHAR(1)             )
    PRIMARY KEY pk_state_county (
         code_isn );
    PCTFREE 5 PCTUSED 90
    STORAGE ( INITIAL 327680 NEXT 32768 );

CREATE TABLE station (
    computer_sequence_number               NUMBER(12,0)         NOT NULL ,
    primary_station_id                     CHAR(15)             NOT NULL ,
    lgcy_storet_station_type_code          VARCHAR2(65)        ,
    elevation                              NUMBER(9,0)         ,
    elevation_units                        CHAR(1)             ,
    location_name_2                        CHAR(60)            ,
    location_name_3                        CHAR(60)            ,
    epa_major_basin_code                   CHAR(2)             ,
    epa_minor_basin_code                   CHAR(2)             ,
    sub_basin_code                         CHAR(2)             ,
    station_depth                          NUMBER(3,0)         ,
    station_depth_units                    VARCHAR2(20)        ,
    location_name                          VARCHAR2(48)        ,
    store_date                             DATE                ,
    begin_date                             DATE                ,
    end_date                               DATE                ,
    surface_water_indicator                CHAR(1)             ,
    ground_water_indicator                 CHAR(1)             ,
    pipe_indicator                         CHAR(1)             ,
    num_samples                            NUMBER(10,0)        ,
    num_observations                       NUMBER(10,0)        ,
    fk_agency_code                         CHAR(8)              NOT NULL ,
    fk_storet_x_station_type_code          NUMBER(12,0)        ,
    tmsp_added                             DATE                 NOT NULL ,
    userid_last_updt                       CHAR(8)              NOT NULL ,
    record_migrated                        CHAR(1)              NOT NULL ,
    effluent_indicator                     CHAR(1)             )
    PRIMARY KEY pk_station (
         computer_sequence_number );
    PCTFREE 5 PCTUSED 75
    STORAGE ( INITIAL 283115520 NEXT 56623104 );

CREATE TABLE station2 (
    computer_sequence_number               NUMBER(12,0)         NOT NULL ,
    fk_agency_code                         CHAR(8)             ,
    primary_station_id                     CHAR(15)             NOT NULL ,
    lgcy_storet_station_type_code          VARCHAR2(65)        ,
    location_name                          VARCHAR2(48)        ,
    location_name_2                        CHAR(60)            ,
    location_name_3                        CHAR(60)            ,
    station_depth                          NUMBER(3,0)         ,
    station_depth_units                    VARCHAR2(20)        ,
    surface_water_indicator                CHAR(1)             ,
    ground_water_indicator                 CHAR(1)             ,
    description                            VARCHAR2(1100)      ,
    latitude                               NUMBER(8,6)         ,
    longitude                              NUMBER(9,6)         ,
    rchonoff                               CHAR(3)             ,
    miles_up_reach                         FLOAT(22)           ,
    fips_hydrologic_unit_code              CHAR(8)             ,
    state_name                             CHAR(30)            ,
    county_name                            CHAR(30)            ,
    rchmile_segment                        NUMBER(3,0)         ,
    rchname                                VARCHAR2(60)        ,
    agency_name                            VARCHAR2(25)        ,
    station_alias                          VARCHAR2(40)        ,
    state_code                             VARCHAR2(30)        )
    PRIMARY KEY csn2_pk (
         computer_sequence_number );
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 282951680 NEXT 65019904 );

CREATE TABLE station_alias (
    secondary_station_id                   CHAR(12)             NOT NULL ,
    fk_computer_sequence_number            NUMBER(12,0)         NOT NULL ,
    tmsp_added                             DATE                ,
    userid_last_updt                       CHAR(8)              NOT NULL ,
    record_migrated                        CHAR(1)              NOT NULL )
    PRIMARY KEY pk_station_alias (
         secondary_station_id,
         fk_computer_sequence_number );
    PCTFREE 5 PCTUSED 75
    STORAGE ( INITIAL 70287360 NEXT 14680064 );

CREATE TABLE station_aquifer_assign2 (
    code_isn                               NUMBER(12,0)         NOT NULL ,
    fk_aquifer_code                        CHAR(15)             NOT NULL ,
    fk_computer_sequence_number            NUMBER(12,0)         NOT NULL ,
    tmsp_added                             DATE                ,
    userid_last_updt                       CHAR(8)              NOT NULL ,
    record_migrated                        CHAR(1)              NOT NULL )
    PRIMARY KEY pk_stn_aquifer_assign2 (
         code_isn );
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 43008000 NEXT 9437184 );

CREATE TABLE station_count (
    source_file                            VARCHAR2(10)        ,
    csn                                    NUMBER(12,0)         NOT NULL ,
    primary_id                             VARCHAR2(15)        ,
    code_isn                               NUMBER(6,0)          NOT NULL )
    PRIMARY KEY  (
         csn,
         code_isn );
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 11714560 NEXT 5816320 );

CREATE TABLE station_location_point (
    code_isn                               NUMBER(12,0)         NOT NULL ,
    latitude                               NUMBER(8,6)         ,
    longitude                              NUMBER(9,6)         ,
    fk_precision_code                      NUMBER(2,0)         ,
    fk_state_county_code_isn               NUMBER(12,0)         NOT NULL ,
    fk_fips_hydrologicunit_storetx         NUMBER(12,0)        ,
    fk_rf1_reach_storet_x_code             NUMBER(12,0)        ,
    miles_up_reach                         FLOAT(22)           ,
    rchonoff                               CHAR(3)             ,
    fk_ecoregion_code                      CHAR(2)             ,
    ecoregion_type_flag                    CHAR(1)             ,
    fk_location_point_type_code            CHAR(1)              NOT NULL ,
    fk_computer_sequence_number            NUMBER(12,0)         NOT NULL ,
    tmsp_added                             DATE                 NOT NULL ,
    userid_last_updt                       CHAR(8)              NOT NULL ,
    record_migrated                        CHAR(1)              NOT NULL )
    PRIMARY KEY pk_station_loc_point (
         code_isn );
    PCTFREE 5 PCTUSED 75
    STORAGE ( INITIAL 70287360 NEXT 14680064 );

CREATE TABLE storet_result_remark (
    code                                   CHAR(1)              NOT NULL ,
    description                            VARCHAR2(254)       )
    PRIMARY KEY pk_storet_res_remark (
         code );
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE storet_x_station_type (
    storet_x_code                          NUMBER(12,0)         NOT NULL ,
    primary_type_code                      VARCHAR2(30)        ,
    secondary_type_code                    VARCHAR2(30)        ,
    natural_indicator_code                 CHAR(1)             )
    PRIMARY KEY pk_storetx_statn_type (
         storet_x_code );
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 16384 NEXT 8192 );

CREATE TABLE toad_plan_sql (
    username                               VARCHAR2(30)        ,
    statement_id                           VARCHAR2(32)        ,
    timestamp                              DATE                ,
    statement                              VARCHAR2(2000)      )
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 40960 NEXT 24576 );

CREATE TABLE toad_plan_table (
    statement_id                           VARCHAR2(32)        ,
    timestamp                              DATE                ,
    remarks                                VARCHAR2(80)        ,
    operation                              VARCHAR2(30)        ,
    options                                VARCHAR2(30)        ,
    object_node                            VARCHAR2(128)       ,
    object_owner                           VARCHAR2(30)        ,
    object_name                            VARCHAR2(30)        ,
    object_instance                        NUMBER(,)           ,
    object_type                            VARCHAR2(30)        ,
    search_columns                         NUMBER(,)           ,
    id                                     NUMBER(,)           ,
    cost                                   NUMBER(,)           ,
    parent_id                              NUMBER(,)           ,
    position                               NUMBER(,)           ,
    cardinality                            NUMBER(,)           ,
    optimizer                              VARCHAR2(255)       ,
    bytes                                  NUMBER(,)           ,
    other_tag                              VARCHAR2(255)       ,
    other                                  LONG                )
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 81920 NEXT 40960 );

CREATE TABLE unused_pcode (
    code                                   CHAR(5)             )
    PCTFREE 10 PCTUSED 40
    STORAGE ( INITIAL 40960 NEXT 40960 );



rem /*
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  * ALTER tables for foreign key constraint
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  */


ALTER TABLE aq$_internet_agent_privs

          ADD constraint agent_must_be_created


          FOREIGN KEY ( agent_name )


          REFERENCES  aq$_internet_agents (

           agent_name )

ALTER TABLE def$_calldest

          ADD constraint def$_call_destination


          FOREIGN KEY ( dblink,

       catchup )

          REFERENCES  def$_destination (

           dblink,
           catchup )

ALTER TABLE mview$_adv_ajg

          ADD constraint mview$_adv_ajg_fk


          FOREIGN KEY ( runid# )


          REFERENCES  mview$_adv_log (

           runid# )

ALTER TABLE mview$_adv_basetable

          ADD constraint mview$_adv_basetable_fk


          FOREIGN KEY ( queryid# )


          REFERENCES  mview$_adv_workload (

           queryid# )

ALTER TABLE mview$_adv_clique

          ADD constraint mview$_adv_clique_fk


          FOREIGN KEY ( runid# )


          REFERENCES  mview$_adv_log (

           runid# )

ALTER TABLE mview$_adv_eligible

          ADD constraint mview$_adv_eligible_fk


          FOREIGN KEY ( runid# )


          REFERENCES  mview$_adv_log (

           runid# )

ALTER TABLE mview$_adv_exceptions

          ADD constraint mview$_adv_exception_fk


          FOREIGN KEY ( runid# )


          REFERENCES  mview$_adv_log (

           runid# )

ALTER TABLE mview$_adv_filterinstance

          ADD constraint mview$_adv_filterinstance_fk


          FOREIGN KEY ( runid# )


          REFERENCES  mview$_adv_log (

           runid# )

ALTER TABLE mview$_adv_fjg

          ADD constraint mview$_adv_fjg_fk


          FOREIGN KEY ( ajgid# )


          REFERENCES  mview$_adv_ajg (

           ajgid# )

ALTER TABLE mview$_adv_gc

          ADD constraint mview$_adv_gc_fk


          FOREIGN KEY ( fjgid# )


          REFERENCES  mview$_adv_fjg (

           fjgid# )

ALTER TABLE mview$_adv_info

          ADD constraint mview$_adv_info_fk


          FOREIGN KEY ( runid# )


          REFERENCES  mview$_adv_log (

           runid# )

ALTER TABLE mview$_adv_journal

          ADD constraint mview$_adv_journal_fk


          FOREIGN KEY ( runid# )


          REFERENCES  mview$_adv_log (

           runid# )

ALTER TABLE mview$_adv_level

          ADD constraint mview$_adv_level_fk


          FOREIGN KEY ( runid# )


          REFERENCES  mview$_adv_log (

           runid# )

ALTER TABLE mview$_adv_output

          ADD constraint mview$_adv_output_fk


          FOREIGN KEY ( runid# )


          REFERENCES  mview$_adv_log (

           runid# )

ALTER TABLE mview$_adv_rollup

          ADD constraint mview$_adv_rollup_cfk


          FOREIGN KEY ( runid#,

       clevelid# )

          REFERENCES  mview$_adv_level (

           runid#,
           clevelid# )

ALTER TABLE mview$_adv_rollup

          ADD constraint mview$_adv_rollup_fk


          FOREIGN KEY ( runid# )


          REFERENCES  mview$_adv_log (

           runid# )

ALTER TABLE mview$_adv_rollup

          ADD constraint mview$_adv_rollup_pfk


          FOREIGN KEY ( runid#,

       plevelid# )

          REFERENCES  mview$_adv_level (

           runid#,
           plevelid# )

ALTER TABLE repcat$_audit_column

          ADD constraint repcat$_audit_column_f1


          FOREIGN KEY ( attribute )


          REFERENCES  repcat$_audit_attribute (

           attribute )

ALTER TABLE repcat$_audit_column

          ADD constraint repcat$_audit_column_f2


          FOREIGN KEY ( base_sname,

       base_oname,
       base_conflict_type_id,
       base_reference_name )

          REFERENCES  repcat$_conflict (

           base_sname,
           base_oname,
           base_conflict_type_id,
           base_reference_name )

ALTER TABLE repcat$_ddl

          ADD constraint repcat$_ddl_prnt


          FOREIGN KEY ( log_id,

       source,
       role,
       master )

          REFERENCES  repcat$_repcatlog (

           log_id,
           source,
           role,
           master )

ALTER TABLE repcat$_flavors

          ADD constraint repcat$_flavors_fk1


          FOREIGN KEY ( gname,

       gowner )

          REFERENCES  repcat$_repcat (

           gname,
           gowner )

ALTER TABLE repcat$_flavor_objects

          ADD constraint repcat$_flavor_objects_fk1


          FOREIGN KEY ( gname,

       gowner )

          REFERENCES  repcat$_repcat (

           gname,
           gowner )

ALTER TABLE repcat$_flavor_objects

          ADD constraint repcat$_flavor_objects_fk2


          FOREIGN KEY ( gname,

       flavor_id,
       gowner )
           gname,
           flavor_id,
           gowner )

ALTER TABLE repcat$_generated

          ADD constraint repcat$_repgen_prnt


          FOREIGN KEY ( sname,

       oname,
       type )

          REFERENCES  repcat$_repobject (

           sname,
           oname,
           type )

ALTER TABLE repcat$_generated

          ADD constraint repcat$_repgen_prnt2


          FOREIGN KEY ( base_sname,

       base_oname,
       base_type )

          REFERENCES  repcat$_repobject (

           base_sname,
           base_oname,
           base_type )

ALTER TABLE repcat$_grouped_column

          ADD constraint repcat$_grouped_column_f1


          FOREIGN KEY ( sname,

       oname,
       group_name )

          REFERENCES  repcat$_column_group (

           sname,
           oname,
           group_name )

ALTER TABLE repcat$_instantiation_ddl

          ADD constraint repcat$_instantiation_ddl_fk1


          FOREIGN KEY ( refresh_template_id )


          REFERENCES  repcat$_refresh_templates (

           refresh_template_id )

ALTER TABLE repcat$_key_columns

          ADD constraint repcat$_key_columns_prnt


          FOREIGN KEY ( sname,

       oname,
       type )

          REFERENCES  repcat$_repobject (

           sname,
           oname,
           type )

ALTER TABLE repcat$_object_parms

          ADD constraint repcat$_object_parms_fk1


          FOREIGN KEY ( template_parameter_id )


          REFERENCES  repcat$_template_parms (

           template_parameter_id )

ALTER TABLE repcat$_object_parms

          ADD constraint repcat$_object_parms_fk2


          FOREIGN KEY ( template_object_id )


          REFERENCES  repcat$_template_objects (

           template_object_id )

ALTER TABLE repcat$_parameter_column

          ADD constraint repcat$_parameter_column_f1


          FOREIGN KEY ( sname,

       oname,
       conflict_type_id,
       reference_name,
       sequence_no )

          REFERENCES  repcat$_resolution (

           sname,
           oname,
           conflict_type_id,
           reference_name,
           sequence_no )

ALTER TABLE repcat$_priority

          ADD constraint repcat$_priority_f1


          FOREIGN KEY ( priority_group,

       sname )

          REFERENCES  repcat$_priority_group (

           priority_group,
           sname )

ALTER TABLE repcat$_refresh_templates

          ADD constraint repcat$_refresh_templates_fk1


          FOREIGN KEY ( template_type_id )


          REFERENCES  repcat$_template_types (

           template_type_id )

ALTER TABLE repcat$_refresh_templates

          ADD constraint repcat$_refresh_templates_fk2


          FOREIGN KEY ( template_status_id )


          REFERENCES  repcat$_template_status (

           template_status_id )

ALTER TABLE repcat$_repcolumn

          ADD constraint repcat$_repcolumn_fk


          FOREIGN KEY ( sname,

       oname,
       type )

          REFERENCES  repcat$_repobject (

           sname,
           oname,
           type )

ALTER TABLE repcat$_repgroup_privs

          ADD constraint repcat$_repgroup_privs_fk


          FOREIGN KEY ( gname,

       gowner )

          REFERENCES  repcat$_repcat (

           gname,
           gowner )

ALTER TABLE repcat$_repobject

          ADD constraint repcat$_repobject_prnt


          FOREIGN KEY ( gname,

       gowner )

          REFERENCES  repcat$_repcat (

           gname,
           gowner )

ALTER TABLE repcat$_repprop

          ADD constraint repcat$_repprop_prnt


          FOREIGN KEY ( sname,

       oname,
       type )

          REFERENCES  repcat$_repobject (

           sname,
           oname,
           type )

ALTER TABLE repcat$_repschema

          ADD constraint repcat$_repschema_dest


          FOREIGN KEY ( dblink,

       extension_id )

          REFERENCES  def$_destination (

           dblink,
           extension_id )

ALTER TABLE repcat$_repschema

          ADD constraint repcat$_repschema_prnt


          FOREIGN KEY ( sname,

       gowner )

          REFERENCES  repcat$_repcat (

           sname,
           gowner )

ALTER TABLE repcat$_resolution

          ADD constraint repcat$_resolution_f1


          FOREIGN KEY ( conflict_type_id,

       method_name )

          REFERENCES  repcat$_resolution_method (

           conflict_type_id,
           method_name )

ALTER TABLE repcat$_resolution

          ADD constraint repcat$_resolution_f3


          FOREIGN KEY ( sname,

       oname,
       conflict_type_id,
       reference_name )

          REFERENCES  repcat$_conflict (

           sname,
           oname,
           conflict_type_id,
           reference_name )

ALTER TABLE repcat$_sites_new

          ADD constraint repcat$_sites_new_fk1


          FOREIGN KEY ( extension_id )


          REFERENCES  repcat$_extension (

           extension_id )

ALTER TABLE repcat$_sites_new

          ADD constraint repcat$_sites_new_fk2


          FOREIGN KEY ( gname,

       gowner )

          REFERENCES  repcat$_repcat (

           gname,
           gowner )

ALTER TABLE repcat$_site_objects

          ADD constraint repcat$_site_objects_fk1


          FOREIGN KEY ( object_type_id )


          REFERENCES  repcat$_object_types (

           object_type_id )

ALTER TABLE repcat$_site_objects

          ADD constraint repcat$_site_object_fk2


          FOREIGN KEY ( template_site_id )


          REFERENCES  repcat$_template_sites (

           template_site_id )

ALTER TABLE repcat$_template_objects

          ADD constraint repcat$_template_objects_fk1


          FOREIGN KEY ( refresh_template_id )


          REFERENCES  repcat$_refresh_templates (

           refresh_template_id )

ALTER TABLE repcat$_template_objects

          ADD constraint repcat$_template_objects_fk3


          FOREIGN KEY ( object_type )


          REFERENCES  repcat$_object_types (

           object_type )

ALTER TABLE repcat$_template_parms

          ADD constraint repcat$_template_parms_fk1


          FOREIGN KEY ( refresh_template_id )


          REFERENCES  repcat$_refresh_templates (

           refresh_template_id )

ALTER TABLE repcat$_template_refgroups

          ADD constraint repcat$_template_refgroups_fk1


          FOREIGN KEY ( refresh_template_id )


          REFERENCES  repcat$_refresh_templates (

           refresh_template_id )

ALTER TABLE repcat$_user_authorizations

          ADD constraint repcat$_user_authorization_fk2


          FOREIGN KEY ( refresh_template_id )


          REFERENCES  repcat$_refresh_templates (

           refresh_template_id )

ALTER TABLE repcat$_user_parm_values

          ADD constraint repcat$_user_parm_values_fk1


          FOREIGN KEY ( template_parameter_id )


          REFERENCES  repcat$_template_parms (

           template_parameter_id )



rem /*
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  * CREATE Indexes, unique indexes, pct parameters
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  */


CREATE UNIQUE INDEX a1_ix1 ON em_station_location_sde
    (fid)
    PCTFREE 5
    STORAGE ( INITIAL 5980160 NEXT 40960 );
CREATE  INDEX agency_station_indx ON station
    (fk_agency_code,
     primary_station_id)
    PCTFREE 10
    STORAGE ( INITIAL 39362560 NEXT 19636224 );
CREATE UNIQUE INDEX csn2_pk ON station2
    (computer_sequence_number)
    PCTFREE 10
    STORAGE ( INITIAL 10485760 NEXT 10485760 );
CREATE  INDEX end_date_indx ON sample
    (end_date)
    PCTFREE 10
    STORAGE ( INITIAL 39362560 NEXT 19636224 );
CREATE  INDEX f1_area_ix2 ON f1
    (area)
    PCTFREE 10
    STORAGE ( INITIAL 5488640 NEXT 40960 );
CREATE  INDEX f1_len_ix3 ON f1
    (len)
    PCTFREE 10
    STORAGE ( INITIAL 5488640 NEXT 40960 );
CREATE UNIQUE INDEX f1_uk1 ON f1
    (fid)
    PCTFREE 10
    STORAGE ( INITIAL 6348800 NEXT 40960 );
CREATE  INDEX fk_computer_sequence_number ON sample
    (fk_computer_sequence_number)
    PCTFREE 10
    STORAGE ( INITIAL 671416320 NEXT 335577088 );
CREATE  INDEX fk_result_sample_code_isn ON result
    (fk_sample_code_isn)
    PCTFREE 10
    STORAGE ( INITIAL 2147483648 NEXT 3221225472 );
CREATE  INDEX gw_indicator_indx ON station
    (ground_water_indicator)
    PCTFREE 10
    STORAGE ( INITIAL 7823360 NEXT 3874816 );
CREATE  INDEX huc_indx ON fips_hydrologic_unit
    (fips_hydrologic_unit_code)
    PCTFREE 10
    STORAGE ( INITIAL 81920 NEXT 65536 );
CREATE  INDEX indx_county_name ON state_county
    (county_name)
    PCTFREE 10
    STORAGE ( INITIAL 286720 NEXT 147456 );
CREATE  INDEX indx_psid ON station
    (primary_station_id)
    PCTFREE 10
    STORAGE ( INITIAL 39362560 NEXT 19636224 );
CREATE  INDEX indx_state_name ON state_county
    (state_name)
    PCTFREE 10
    STORAGE ( INITIAL 286720 NEXT 147456 );
CREATE  INDEX ind_county_name ON station2
    (county_name)
    PCTFREE 10
    STORAGE ( INITIAL 20971520 NEXT 12582912 );
CREATE  INDEX ind_primary_station_id ON station2
    (primary_station_id)
    PCTFREE 10
    STORAGE ( INITIAL 20971520 NEXT 12582912 );
CREATE  INDEX ind_state_name ON station2
    (state_name)
    PCTFREE 10
    STORAGE ( INITIAL 20971520 NEXT 12582912 );
CREATE  INDEX lat_long_indx ON station_location_point
    (latitude,
     longitude)
    PCTFREE 10
    STORAGE ( INITIAL 26255360 NEXT 13090816 );
CREATE UNIQUE INDEX parameter_x ON parameter_copy
    (code)
    PCTFREE 10
    STORAGE ( INITIAL 450560 NEXT 221184 );
CREATE UNIQUE INDEX pbsyscatcoldict_idx ON pbcatcol
    (pbc_tnam,
     pbc_ownr,
     pbc_cnam)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pbsyscatfrmts_idx ON pbcatfmt
    (pbf_name)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pbsyscatpbt_idx ON pbcattbl
    (pbt_tnam,
     pbt_ownr)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pbsyscatvlds_idx ON pbcatvld
    (pbv_name)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pbsyspbe_idx ON pbcatedt
    (pbe_name,
     pbe_seqn)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE  INDEX pipe_indicator_indx ON station
    (pipe_indicator)
    PCTFREE 10
    STORAGE ( INITIAL 696320 NEXT 335872 );
CREATE UNIQUE INDEX pk_agency ON agency
    (code)
    PCTFREE 10
    STORAGE ( INITIAL 81920 NEXT 24576 );
CREATE UNIQUE INDEX pk_aquifer ON aquifer
    (code)
    PCTFREE 10
    STORAGE ( INITIAL 368640 NEXT 73728 );
CREATE UNIQUE INDEX pk_composite_method ON composite_method
    (code)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_composite_statistic ON composite_statistic
    (code)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_decimal_point ON decimal_point
    (code)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_descriptive_paragraph ON descriptive_paragraph_line
    (fk_computer_sequence_number,
     paragraph_line_number)
    PCTFREE 10
    STORAGE ( INITIAL 44113920 NEXT 14155776 );
CREATE UNIQUE INDEX pk_effluent_statistic ON effluent_statistic
    (code)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_eff_monitor_intent ON effluent_monitoring_intent
    (code)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_error_log ON error_log
    (error_code_isn)
    PCTFREE 10
    STORAGE ( INITIAL 7823360 NEXT 3874816 );
CREATE UNIQUE INDEX pk_fips_huc ON fips_hydrologic_unit
    (fips_hydrologicunit_storetx)
    PCTFREE 10
    STORAGE ( INITIAL 81920 NEXT 16384 );
CREATE UNIQUE INDEX pk_lat_long_precision ON lat_long_precision
    (code)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_leg_storet_level1 ON legacy_storet_level1
    (name)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_leg_storet_level2a ON legacy_storet_level2a
    (name)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_leg_storet_level2b ON legacy_storet_level2b
    (name)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_leg_storet_level3 ON legacy_storet_level3
    (name)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_leg_storet_level4 ON legacy_storet_level4
    (name)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_leg_storet_level5 ON legacy_storet_level5
    (name)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_leg_sto_lev5_assign ON legacy_storet_level5_assign2
    (code_isn)
    PCTFREE 10
    STORAGE ( INITIAL 25190400 NEXT 5242880 );
CREATE UNIQUE INDEX pk_leg_sto_stn_type ON legacy_storet_station_type
    (fk_computer_sequence_number)
    PCTFREE 10
    STORAGE ( INITIAL 66068480 NEXT 13631488 );
CREATE UNIQUE INDEX pk_location_point_type ON location_point_type
    (code)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_omernich_lev3_ecor ON omernich_level3_ecoregion
    (code)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_organization ON organization
    (code_isn)
    PCTFREE 10
    STORAGE ( INITIAL 16384 NEXT 8192 );
CREATE UNIQUE INDEX pk_parameter ON parameter
    (code)
    PCTFREE 10
    STORAGE ( INITIAL 204800 NEXT 24576 );
CREATE UNIQUE INDEX pk_param_grp ON parameter_group
    (code)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_prim_act_category ON primary_activity_category
    (code)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_prmy_secndy_combo2 ON prmry_scndry_actvty_combo2
    (code_isn)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_reporting_units ON reporting_units
    (code)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_result ON result
    (code_isn)
    PCTFREE 10
    STORAGE ( INITIAL 2147483648 NEXT 3221225472 );
CREATE UNIQUE INDEX pk_rf1_reach ON rf1_reach
    (storet_x_code)
    PCTFREE 10
    STORAGE ( INITIAL 2129920 NEXT 114688 );
CREATE UNIQUE INDEX pk_rmi ON rmi
    (code_isn)
    PCTFREE 10
    STORAGE ( INITIAL 12615680 NEXT 3145728 );
CREATE UNIQUE INDEX pk_sample ON sample
    (sample_code_isn)
    PCTFREE 10
    STORAGE ( INITIAL 671375360 NEXT 335577088 );
CREATE UNIQUE INDEX pk_samp_media_anal_type ON sample_media_analysis_type
    (code_isn)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_sec_act_category ON secondary_activity_category
    (code)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_state_county ON state_county
    (code_isn)
    PCTFREE 10
    STORAGE ( INITIAL 81920 NEXT 65536 );
CREATE UNIQUE INDEX pk_station ON station
    (computer_sequence_number)
    PCTFREE 10
    STORAGE ( INITIAL 20520960 NEXT 7077888 );
CREATE UNIQUE INDEX pk_station_alias ON station_alias
    (secondary_station_id,
     fk_computer_sequence_number)
    PCTFREE 10
    STORAGE ( INITIAL 47185920 NEXT 9437184 );
CREATE UNIQUE INDEX pk_station_loc_point ON station_location_point
    (code_isn)
    PCTFREE 10
    STORAGE ( INITIAL 13639680 NEXT 3145728 );
CREATE UNIQUE INDEX pk_stn_aquifer_assign2 ON station_aquifer_assign2
    (code_isn)
    PCTFREE 10
    STORAGE ( INITIAL 12615680 NEXT 3145728 );
CREATE UNIQUE INDEX pk_storetx_statn_type ON storet_x_station_type
    (storet_x_code)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX pk_storet_res_remark ON storet_result_remark
    (code)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE  INDEX result_run_no_indx ON result
    (run_number)
    PCTFREE 10
    STORAGE ( INITIAL 2147483648 NEXT 99426304 );
CREATE UNIQUE INDEX s1_ix1 ON s1
    (gx,
     gy,
     emaxx,
     emaxy,
     eminx,
     eminy,
     sp_fid)
    PCTFREE 5
    STORAGE ( INITIAL 19619840 NEXT 40960 );
CREATE  INDEX s1_ix2 ON s1
    (sp_fid)
    PCTFREE 5
    STORAGE ( INITIAL 6389760 NEXT 40960 );
CREATE  INDEX sample_depth_indx ON sample
    (sample_depth)
    PCTFREE 10
    STORAGE ( INITIAL 199024640 NEXT 99426304 );
CREATE  INDEX sample_run_number_indx ON sample
    (run_number)
    PCTFREE 10
    STORAGE ( INITIAL 453754880 NEXT 5816320 );
CREATE UNIQUE INDEX sde_logfiles_pk ON sde_logfiles
    (logfile_id)
    PCTFREE 5
    STORAGE ( INITIAL 1064960 NEXT 1048576 );
CREATE UNIQUE INDEX sde_logfiles_uk ON sde_logfiles
    (logfile_name)
    PCTFREE 5
    STORAGE ( INITIAL 1064960 NEXT 1048576 );
CREATE UNIQUE INDEX sde_logfiles_uk2 ON sde_logfiles
    (logfile_data_id)
    PCTFREE 5
    STORAGE ( INITIAL 1064960 NEXT 1048576 );
CREATE  INDEX sde_logfile_data_idx1 ON sde_logfile_data
    (logfile_data_id)
    PCTFREE 5
    STORAGE ( INITIAL 1064960 NEXT 1048576 );
CREATE  INDEX sde_logfile_data_idx2 ON sde_logfile_data
    (sde_row_id)
    PCTFREE 5
    STORAGE ( INITIAL 1064960 NEXT 1048576 );
CREATE  INDEX start_date_indx ON sample
    (start_date)
    PCTFREE 10
    STORAGE ( INITIAL 671375360 NEXT 335577088 );
CREATE  INDEX state_county_indx ON state_county
    (state_name,
     county_name)
    PCTFREE 10
    STORAGE ( INITIAL 450560 NEXT 221184 );
CREATE  INDEX sw_indicator_indx ON station
    (surface_water_indicator)
    PCTFREE 10
    STORAGE ( INITIAL 5242880 NEXT 2580480 );
CREATE UNIQUE INDEX tpsql_idx ON toad_plan_sql
    (statement_id)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE  INDEX tptbl_idx ON toad_plan_table
    (statement_id)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE  INDEX xif104sample ON sample
    (fk_prmy_scndy_combo2_code_isn)
    PCTFREE 10
    STORAGE ( INITIAL 39362560 NEXT 19636224 );
CREATE  INDEX xif108legacy_storet_station_ty ON legacy_storet_station_type
    (fk_legacy_storet_level2b_name)
    PCTFREE 10
    STORAGE ( INITIAL 696320 NEXT 335872 );
CREATE  INDEX xif110legacy_storet_station_ty ON legacy_storet_station_type
    (fk_legacy_storet_level2a_name)
    PCTFREE 10
    STORAGE ( INITIAL 7864320 NEXT 3874816 );
CREATE  INDEX xif112parameter ON parameter
    (fk_parameter_group_code)
    PCTFREE 10
    STORAGE ( INITIAL 286720 NEXT 147456 );
CREATE  INDEX xif114parameter ON parameter
    (fk_characteristic_code_isn)
    PCTFREE 10
    STORAGE ( INITIAL 163840 NEXT 98304 );
CREATE  INDEX xif38agency ON agency
    (fk_organization_code_isn)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE  INDEX xif39station_alias ON station_alias
    (fk_computer_sequence_number)
    PCTFREE 10
    STORAGE ( INITIAL 7823360 NEXT 3874816 );
CREATE  INDEX xif41descriptive_paragraph ON descriptive_paragraph_line
    (fk_computer_sequence_number)
    PCTFREE 10
    STORAGE ( INITIAL 39362560 NEXT 19636224 );
CREATE  INDEX xif42station_aquifer_assign2 ON station_aquifer_assign2
    (fk_computer_sequence_number)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE  INDEX xif43station_aquifer_assign2 ON station_aquifer_assign2
    (fk_aquifer_code)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE  INDEX xif44station_location_point_ty ON station_location_point
    (fk_computer_sequence_number)
    PCTFREE 10
    STORAGE ( INITIAL 26255360 NEXT 13090816 );
CREATE  INDEX xif45station_location_point_ty ON station_location_point
    (fk_location_point_type_code)
    PCTFREE 10
    STORAGE ( INITIAL 11714560 NEXT 5816320 );
CREATE  INDEX xif48station_location_point_ty ON station_location_point
    (fk_ecoregion_code)
    PCTFREE 10
    STORAGE ( INITIAL 286720 NEXT 147456 );
CREATE  INDEX xif49station_location_point_ty ON station_location_point
    (fk_fips_hydrologicunit_storetx)
    PCTFREE 10
    STORAGE ( INITIAL 17530880 NEXT 8724480 );
CREATE  INDEX xif50station_location_point_ty ON station_location_point
    (fk_rf1_reach_storet_x_code)
    PCTFREE 10
    STORAGE ( INITIAL 3522560 NEXT 1720320 );
CREATE  INDEX xif51station ON station
    (fk_agency_code)
    PCTFREE 10
    STORAGE ( INITIAL 26255360 NEXT 13090816 );
CREATE  INDEX xif57station ON station
    (fk_storet_x_station_type_code)
    PCTFREE 10
    STORAGE ( INITIAL 17530880 NEXT 8724480 );
CREATE  INDEX xif58old_storet_level_code_com ON legacy_storet_station_type
    (fk_legacy_storet_level1_name)
    PCTFREE 10
    STORAGE ( INITIAL 7823360 NEXT 3874816 );
CREATE  INDEX xif60old_storet_level_code_com ON legacy_storet_station_type
    (fk_legacy_storet_level3_name)
    PCTFREE 10
    STORAGE ( INITIAL 696320 NEXT 335872 );
CREATE  INDEX xif61old_storet_level_code_com ON legacy_storet_station_type
    (fk_legacy_storet_level4_name)
    PCTFREE 10
    STORAGE ( INITIAL 696320 NEXT 335872 );
CREATE  INDEX xif62old_storet_level5_combo2 ON legacy_storet_level5_assign2
    (fk_computer_sequence_number)
    PCTFREE 10
    STORAGE ( INITIAL 1064960 NEXT 507904 );
CREATE  INDEX xif63old_storet_level5_combo2 ON legacy_storet_level5_assign2
    (fk_legacy_storet_level5_name)
    PCTFREE 10
    STORAGE ( INITIAL 1064960 NEXT 507904 );
CREATE  INDEX xif73rmi ON rmi
    (fk_computer_sequence_number)
    PCTFREE 10
    STORAGE ( INITIAL 1064960 NEXT 507904 );
CREATE  INDEX xif74station_location_point ON station_location_point
    (fk_state_county_code_isn)
    PCTFREE 10
    STORAGE ( INITIAL 17530880 NEXT 8724480 );
CREATE  INDEX xif75smple_rsltval_parmeter_as ON result
    (fk_storet_result_remark_code)
    PCTFREE 10
    STORAGE ( INITIAL 671375360 NEXT 335577088 );
CREATE  INDEX xif78parameter ON parameter
    (fk_smpl_mdia_type_code_isn)
    PCTFREE 10
    STORAGE ( INITIAL 286720 NEXT 147456 );
CREATE  INDEX xif79result ON result
    (fk_effluent_statistic_code)
    PCTFREE 10
    STORAGE ( INITIAL 26255360 NEXT 13090816 );
CREATE  INDEX xif80result ON result
    (fk_composite_statistic_code)
    PCTFREE 10
    STORAGE ( INITIAL 2147483648 NEXT 1132576768 );
CREATE  INDEX xif82parameter ON parameter
    (fk_reporting_units_code)
    PCTFREE 10
    STORAGE ( INITIAL 286720 NEXT 147456 );
CREATE  INDEX xif88sample ON sample
    (fk_composite_method_code)
    PCTFREE 10
    STORAGE ( INITIAL 447651840 NEXT 223715328 );
CREATE  INDEX xif89sample ON sample
    (fk_effluent_montrng_intnt_code)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE  INDEX xif91station_location_point ON station_location_point
    (fk_precision_code)
    PCTFREE 10
    STORAGE ( INITIAL 17530880 NEXT 8724480 );
CREATE  INDEX xif92parameter ON parameter
    (fk_decimal_point_code)
    PCTFREE 10
    STORAGE ( INITIAL 286720 NEXT 147456 );
CREATE  INDEX xif96prmry_scndry_actvty_combo ON prmry_scndry_actvty_combo2
    (fk_scndry_actvty_category_code)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE  INDEX xif97prmry_scndry_actvty_combo ON prmry_scndry_actvty_combo2
    (fk_prmry_actvty_category_code)
    PCTFREE 10
    STORAGE ( INITIAL 40960 NEXT 40960 );
CREATE UNIQUE INDEX xpkcharacteristic ON characteristic
    (code_isn)
    PCTFREE 10
    STORAGE ( INITIAL 204800 NEXT 24576 );


rem /*
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  * CREATE Sequences, start_with=min_value
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  */


CREATE SEQUENCE sde_logfile_lid_gen
       INCREMENT BY 1
         START WITH 1
           MAXVALUE 999999999999999999999999999
           MINVALUE 1

CACHE 20
;

CREATE SEQUENCE seq_em_csn
       INCREMENT BY 1
         START WITH 1
           MAXVALUE 999999999999999999999999999
           MINVALUE 1

CACHE 0
;

CREATE SEQUENCE seq_report
       INCREMENT BY 1
         START WITH 1
           MAXVALUE 999999999999999999999999999
           MINVALUE 1

CACHE 20
;

CREATE SEQUENCE toad_seq
       INCREMENT BY 1
         START WITH 1
           MAXVALUE 999999999999999999999999999
           MINVALUE 1

CACHE 20
;



rem /*
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  * CREATE Triggers
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  */



rem /*
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  * CREATE Views
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  */

10:15:06 DOC>rem  INTO max_long_length
10:15:06 DOC>rem  FROM all_views WHERE owner=upper('&schema_user'); */
  INTO max_long_length
       *
ERROR at line 2:
ORA-00905: missing keyword




rem /*
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  * CREATE Packages and Package Body
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  */



rem /*
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  * CREATE Independent Procedures
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  */



rem /*
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  * GRANT Table privileges
rem  * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rem  */

