#if !defined __CFILESPLIT_HH__07162002
#define __CFILESPLIT_HH__07162002

/*********************************************************
* File:		CFileSplit.h
*
* Purpose:  Define the CFileSplit class. FileSplit class
*           is responsible for breaking a file into smaller
*           files, by line count
*
*=========================================================
* Modification History
*=========================================================
* Who              When              What
*---------------------------------------------------------
* Will Lowrey      07/16/2002	     Author
**********************************************************/


class CFileSplit {

private:
	bool mRepeatHeadersByFile;

	CString mFileName;
	CString mDirName;
	CString mSaveDir;
	CString mSaveFileName;

	int  mFileCount;
	int  mMode;
	int  mPadding;
    int  mNumHeaderRows;
	
	unsigned int mNumRowsHeadersRepeated;
	unsigned int mNumLines;

public:
	//Constructor
	CFileSplit();

	//Constructor
	CFileSplit(const CString fileName);

	//set the local variable
	void SetFileName(const CString fileName);

	//get the local variable
	void GetFileName(CString fileName);

	void SetSaveDir(const CString dirName);

	void SetSaveName(const CString fileName);

	void SetHeadersByFile(bool onOff);

	void SetMode(int mode);

	void SetPadding(int pad);

	void SetHeaderRowCount(int count);

	void SetNumRowsHeaderRepeated(unsigned int num);

};

#endif