@echo off
REM *******************************************************************
REM *  File : Ext_taxa.bat
REM *  Release : UB2.0.3
REM *  SIR     : 1683
REM *  Author : Ganesh Thadkamalla
REM *  Date :  04/27/2005
REM *  Description :  This will log in to STORET 
REM *    database with appropriate user and run a number sql files to 
REM *    extract ITIS taxonomy data and report the data problems.  
REM *  
REM *  Comments :  Step 2 of 3.
REM *    Database connection information should be updated accordingly.
REM *  
REM *******************************************************************
cls
@echo off
title STORET Taxonomy Update Process 
echo ************************************************************
echo *            STORET Taxonomy Update Process
echo *  This script will perform the following tasks
echo *   1) Create TSRCHDUP table in STORET schema.
echo *   2) Extract the Taxonomy data into ITISTAXA table.
echo *   3) Report and fix duplicate TSNs.
echo *   4) Report duplicate display names.
echo *   5) Create DUPL_NAMES table with duplicate names.
echo *   6) Report missing TSN in ITIS extraction.
echo *   7) Update STORET.TSRCHDUP table with duplicate names.
echo *
echo *************************************************************
pause
rem create storet.tsrchdup table if not present
sqlplus system/sto2et@storet @scripts\tsrchdup.sql
cls
rem analyze storet tables for collecting statistics.
sqlplus system/sto2et@storet @scripts\analyze_tbls.sql
cls
title STORET Taxonomy Update Process.  Extraction of Taxonomy data from ITIS tables.
rem extraction of ITIS data into ITISTAXA table.
sqlplus itis/itis@storet @Ext_taxa.sql
cls
rem report missing tsns
title STORET Taxonomy Update Process.  Generating report of missing TSNs.
sqlplus system/sto2et@storet @scripts\rep_missing_tsn.sql
cls
rem cleanup tsrchdup table including deleting the TSNs that are not duplicate, updating display names that are changed yet duplicate and adding new TSNs with duplicate names.
title STORET Taxonomy Update Process.  Updating TSRCHDUP with duplicate name information for review.
sqlplus system/sto2et@storet @scripts\updt_chdup.sql
cls
rem report Duplicate names between ITIS and non-Taxon STORET Characteristics.
title STORET Taxonomy Update Process.
sqlplus system/sto2et@storet @scripts\Rep_IT_dupname.sql
cls
rem Report and add non-ascii names into tsrchdup table.
title STORET Taxonomy Update Process.  Processing Non-ASCII names.
sqlplus system/sto2et@storet @scripts\non_ascii_names.sql
cls
rem Generate report of TSRCHDUP Data
title STORET Taxonomy Update Process.  Generating report of TSRCHDUP Data
sqlplus system/sto2et@storet @scripts\rep_chdup_data.sql
cls

title STORET Taxonomy Update Process
cls
echo Extraction process and data problem reporting is complete.
echo Review log files in logs\ directory for errors.
echo Review and update STORET.TSRCHDUP table to resolve duplicate names.
echo After resolving duplicate names in STORET.TSRCHDUP proceed with the Upd_STORET.bat file to update STORET tables with ITIS data.
pause
exit