{ DATABASE itis  delimiter | }

grant dba to "itis";
grant dba to "informix";
grant dba to "public";
grant dba to "root";
grant connect to "http";








 


 


 


 


 


 


 


 



{ TABLE "itis".change_comments row size = 263 number of columns = 4 index size = 
              30 }
{ unload file name = chang00100.unl number of rows = 0 }

create table "itis".change_comments 
  (
    change_track_id integer not null ,
    chg_cmt_id serial not null ,
    change_detail varchar(250,1) not null ,
    update_date date not null 
  );
revoke all on "itis".change_comments from "public";

{ TABLE "itis".change_operations row size = 12 number of columns = 3 index size = 
              42 }
{ unload file name = chang00101.unl number of rows = 0 }

create table "itis".change_operations 
  (
    change_track_id integer not null ,
    chg_op_id integer not null ,
    update_date date not null 
  );
revoke all on "itis".change_operations from "public";

{ TABLE "itis".chg_operation_lkp row size = 34 number of columns = 3 index size = 
              12 }
{ unload file name = chg_o00102.unl number of rows = 0 }

create table "itis".chg_operation_lkp 
  (
    chg_op_id serial not null ,
    change_operation varchar(25,5) not null ,
    update_date date not null 
  );
revoke all on "itis".chg_operation_lkp from "public";

{ TABLE "itis".change_tracks row size = 367 number of columns = 9 index size = 12 
              }
{ unload file name = chang00103.unl number of rows = 0 }

create table "itis".change_tracks 
  (
    change_track_id serial not null ,
    old_tsn integer,
    change_reason varchar(40,18) not null ,
    change_initiator varchar(100,1) not null ,
    change_reviewer varchar(100,1) not null ,
    change_certifier varchar(100,1) not null ,
    change_time_stamp datetime year to minute not null ,
    tsn integer not null ,
    update_date date not null 
  );
revoke all on "itis".change_tracks from "public";

{ TABLE "itis".kingdoms row size = 18 number of columns = 3 index size = 12 }
{ unload file name = kingd00104.unl number of rows = 6 }

create table "itis".kingdoms 
  (
    kingdom_id serial not null ,
    kingdom_name char(10) not null ,
    update_date date not null 
  );
revoke all on "itis".kingdoms from "public";

{ TABLE "itis".taxon_unit_types row size = 29 number of columns = 6 index size = 
              15 }
{ unload file name = taxon00105.unl number of rows = 136 }

create table "itis".taxon_unit_types 
  (
    kingdom_id integer not null ,
    rank_id smallint not null ,
    rank_name char(15) not null ,
    dir_parent_rank_id smallint not null ,
    req_parent_rank_id smallint not null ,
    update_date date not null 
  );
revoke all on "itis".taxon_unit_types from "public";

{ TABLE "itis".geographic_div row size = 54 number of columns = 3 index size = 93 
              }
{ unload file name = geogr00106.unl number of rows = 97067 }

create table "itis".geographic_div 
  (
    tsn integer not null ,
    geographic_value varchar(45,6) not null ,
    update_date date not null 
  );
revoke all on "itis".geographic_div from "public";

{ TABLE "itis".jurisdiction row size = 59 number of columns = 4 index size = 70 }
{ unload file name = juris00107.unl number of rows = 48586 }

create table "itis".jurisdiction 
  (
    tsn integer not null ,
    jurisdiction_value varchar(30,6) not null ,
    origin varchar(19,6) not null ,
    update_date date not null 
  );
revoke all on "itis".jurisdiction from "public";

{ TABLE "itis".nodc_ids row size = 20 number of columns = 3 index size = 42 }
{ unload file name = nodc_00108.unl number of rows = 209565 }

create table "itis".nodc_ids 
  (
    nodc_id char(12) not null ,
    update_date date not null ,
    tsn integer not null ,
    primary key (nodc_id,tsn)  constraint "itis".u833_145
  );
revoke all on "itis".nodc_ids from "public";

{ TABLE "itis".taxon_authors_lkp row size = 111 number of columns = 4 index size 
              = 15 }
{ unload file name = taxon00109.unl number of rows = 92535 }

create table "itis".taxon_authors_lkp 
  (
    taxon_author_id serial not null ,
    taxon_author varchar(100,30) not null ,
    update_date date not null ,
    kingdom_id smallint not null 
  );
revoke all on "itis".taxon_authors_lkp from "public";

{ TABLE "itis".synonym_links row size = 12 number of columns = 3 index size = 30 
              }
{ unload file name = synon00110.unl number of rows = 87141 }

create table "itis".synonym_links 
  (
    tsn integer not null ,
    tsn_accepted integer not null ,
    update_date date not null 
  );
revoke all on "itis".synonym_links from "public";

{ TABLE "itis".reference_links row size = 102 number of columns = 8 index size = 
              46 }
{ unload file name = refer00111.unl number of rows = 743086 }

create table "itis".reference_links 
  (
    tsn integer not null ,
    doc_id_prefix char(3) not null ,
    documentation_id integer not null ,
    original_desc_ind char(1),
    init_itis_desc_ind char(1),
    change_track_id integer,
    vernacular_name varchar(80,5),
    update_date date not null 
  );
revoke all on "itis".reference_links from "public";

{ TABLE "itis".experts row size = 368 number of columns = 5 index size = 16 }
{ unload file name = exper00112.unl number of rows = 83 }

create table "itis".experts 
  (
    expert_id_prefix char(3) not null ,
    expert_id serial not null ,
    expert varchar(100,1) not null ,
    exp_comment varchar(255),
    update_date date not null 
  );
revoke all on "itis".experts from "public";

{ TABLE "itis".other_sources row size = 356 number of columns = 8 index size = 16 
              }
{ unload file name = other00113.unl number of rows = 164 }

create table "itis".other_sources 
  (
    source_id_prefix char(3) not null ,
    source_id serial not null ,
    source_type char(10) not null ,
    source varchar(64,4) not null ,
    version char(10) not null ,
    acquisition_date date not null ,
    source_comment varchar(255),
    update_date date not null 
  );
revoke all on "itis".other_sources from "public";

{ TABLE "itis".publications row size = 1060 number of columns = 14 index size = 16 
              }
{ unload file name = publi00114.unl number of rows = 2556 }

create table "itis".publications 
  (
    pub_id_prefix char(3) not null ,
    publication_id serial not null ,
    reference_author varchar(100,1) not null ,
    title varchar(255,10),
    publication_name varchar(255,1) not null ,
    listed_pub_date date,
    actual_pub_date date not null ,
    publisher varchar(80,10),
    pub_place varchar(40,10),
    isbn varchar(16),
    issn varchar(16),
    pages varchar(15),
    pub_comment varchar(255),
    update_date date not null 
  );
revoke all on "itis".publications from "public";

{ TABLE "itis".reviews row size = 399 number of columns = 7 index size = 30 }
{ unload file name = revie00115.unl number of rows = 0 }

create table "itis".reviews 
  (
    tsn integer not null ,
    review_start_date date not null ,
    review_end_date date,
    review_reason varchar(25,8) not null ,
    reviewer varchar(100,25) not null ,
    review_comment varchar(255),
    update_date date not null 
  );
revoke all on "itis".reviews from "public";

{ TABLE "itis".tu_comments_links row size = 12 number of columns = 3 index size = 
              42 }
{ unload file name = tu_co00116.unl number of rows = 60234 }

create table "itis".tu_comments_links 
  (
    tsn integer not null ,
    comment_id integer not null ,
    update_date date not null 
  );
revoke all on "itis".tu_comments_links from "public";

{ TABLE "itis".comments row size = 2117 number of columns = 5 index size = 12 }
{ unload file name = comme00117.unl number of rows = 12865 }

create table "itis".comments 
  (
    comment_id serial not null ,
    commentator varchar(100),
    comment_detail char(2000) not null ,
    comment_time_stamp datetime year to second not null ,
    update_date date not null 
  );
revoke all on "itis".comments from "public";

{ TABLE "itis".taxonomic_units row size = 321 number of columns = 24 index size = 
              106 }
{ unload file name = taxon00118.unl number of rows = 386843 }

create table "itis".taxonomic_units 
  (
    tsn serial not null ,
    unit_ind1 char(1),
    unit_name1 char(35) not null constraint "itis".nsue_53,
    unit_ind2 char(1),
    unit_name2 varchar(35),
    unit_ind3 varchar(7),
    unit_name3 varchar(35),
    unit_ind4 varchar(7),
    unit_name4 varchar(35),
    unnamed_taxon_ind char(1),
    usage varchar(12,5) not null constraint "itis".nsue_54,
    unaccept_reason varchar(50,9),
    credibility_rtng varchar(40,17) not null constraint "itis".nsue_55,
    completeness_rtng char(10),
    currency_rating char(7),
    phylo_sort_seq smallint,
    initial_time_stamp datetime year to second not null constraint "itis".nsue_56,
    parent_tsn integer,
    taxon_author_id integer,
    hybrid_author_id integer,
    kingdom_id smallint not null constraint "itis".nsue_57,
    rank_id smallint not null constraint "itis".nsue_58,
    update_date date not null constraint "itis".nsue_59,
    uncertain_prnt_ind char(3)
  );
revoke all on "itis".taxonomic_units from "public";

{ TABLE "itis".vernaculars row size = 110 number of columns = 6 index size = 169 
              }
{ unload file name = verna00119.unl number of rows = 94254 }

create table "itis".vernaculars 
  (
    tsn integer not null ,
    vernacular_name varchar(80,5) not null ,
    language varchar(15) not null ,
    approved_ind char(1),
    update_date date not null ,
    vern_id serial not null ,
    unique (tsn,vernacular_name,language)  constraint "itis".u_vern,
    primary key (vern_id)  constraint "itis".vern_key
  );
revoke all on "itis".vernaculars from "public";

{ TABLE "itis".vern_ref_links row size = 19 number of columns = 5 index size = 28 
              }
{ unload file name = vern_00120.unl number of rows = 21121 }

create table "itis".vern_ref_links 
  (
    tsn integer not null ,
    doc_id_prefix char(3) not null ,
    documentation_id integer not null ,
    update_date date not null ,
    vern_id integer not null ,
    primary key (tsn,doc_id_prefix,documentation_id,vern_id)  constraint "itis".vern_rf_lnks_key
  );
revoke all on "itis".vern_ref_links from "public";


grant select on "itis".change_comments to "public" as "itis";
grant update on "itis".change_comments to "public" as "itis";
grant insert on "itis".change_comments to "public" as "itis";
grant delete on "itis".change_comments to "public" as "itis";
grant index on "itis".change_comments to "public" as "itis";
grant select on "itis".change_operations to "public" as "itis";
grant update on "itis".change_operations to "public" as "itis";
grant insert on "itis".change_operations to "public" as "itis";
grant delete on "itis".change_operations to "public" as "itis";
grant index on "itis".change_operations to "public" as "itis";
grant select on "itis".chg_operation_lkp to "public" as "itis";
grant update on "itis".chg_operation_lkp to "public" as "itis";
grant insert on "itis".chg_operation_lkp to "public" as "itis";
grant delete on "itis".chg_operation_lkp to "public" as "itis";
grant index on "itis".chg_operation_lkp to "public" as "itis";
grant select on "itis".change_tracks to "public" as "itis";
grant update on "itis".change_tracks to "public" as "itis";
grant insert on "itis".change_tracks to "public" as "itis";
grant delete on "itis".change_tracks to "public" as "itis";
grant index on "itis".change_tracks to "public" as "itis";
grant select on "itis".kingdoms to "public" as "itis";
grant update on "itis".kingdoms to "public" as "itis";
grant insert on "itis".kingdoms to "public" as "itis";
grant delete on "itis".kingdoms to "public" as "itis";
grant index on "itis".kingdoms to "public" as "itis";
grant select on "itis".taxon_unit_types to "public" as "itis";
grant update on "itis".taxon_unit_types to "public" as "itis";
grant insert on "itis".taxon_unit_types to "public" as "itis";
grant delete on "itis".taxon_unit_types to "public" as "itis";
grant index on "itis".taxon_unit_types to "public" as "itis";
grant select on "itis".geographic_div to "public" as "itis";
grant update on "itis".geographic_div to "public" as "itis";
grant insert on "itis".geographic_div to "public" as "itis";
grant delete on "itis".geographic_div to "public" as "itis";
grant index on "itis".geographic_div to "public" as "itis";
grant select on "itis".jurisdiction to "public" as "itis";
grant update on "itis".jurisdiction to "public" as "itis";
grant insert on "itis".jurisdiction to "public" as "itis";
grant delete on "itis".jurisdiction to "public" as "itis";
grant index on "itis".jurisdiction to "public" as "itis";
grant select on "itis".nodc_ids to "public" as "itis";
grant update on "itis".nodc_ids to "public" as "itis";
grant insert on "itis".nodc_ids to "public" as "itis";
grant delete on "itis".nodc_ids to "public" as "itis";
grant index on "itis".nodc_ids to "public" as "itis";
grant select on "itis".taxon_authors_lkp to "public" as "itis";
grant update on "itis".taxon_authors_lkp to "public" as "itis";
grant insert on "itis".taxon_authors_lkp to "public" as "itis";
grant delete on "itis".taxon_authors_lkp to "public" as "itis";
grant index on "itis".taxon_authors_lkp to "public" as "itis";
grant select on "itis".synonym_links to "public" as "itis";
grant update on "itis".synonym_links to "public" as "itis";
grant insert on "itis".synonym_links to "public" as "itis";
grant delete on "itis".synonym_links to "public" as "itis";
grant index on "itis".synonym_links to "public" as "itis";
grant select on "itis".reference_links to "public" as "itis";
grant update on "itis".reference_links to "public" as "itis";
grant insert on "itis".reference_links to "public" as "itis";
grant delete on "itis".reference_links to "public" as "itis";
grant index on "itis".reference_links to "public" as "itis";
grant select on "itis".experts to "public" as "itis";
grant update on "itis".experts to "public" as "itis";
grant insert on "itis".experts to "public" as "itis";
grant delete on "itis".experts to "public" as "itis";
grant index on "itis".experts to "public" as "itis";
grant select on "itis".other_sources to "public" as "itis";
grant update on "itis".other_sources to "public" as "itis";
grant insert on "itis".other_sources to "public" as "itis";
grant delete on "itis".other_sources to "public" as "itis";
grant index on "itis".other_sources to "public" as "itis";
grant select on "itis".publications to "public" as "itis";
grant update on "itis".publications to "public" as "itis";
grant insert on "itis".publications to "public" as "itis";
grant delete on "itis".publications to "public" as "itis";
grant index on "itis".publications to "public" as "itis";
grant select on "itis".reviews to "public" as "itis";
grant update on "itis".reviews to "public" as "itis";
grant insert on "itis".reviews to "public" as "itis";
grant delete on "itis".reviews to "public" as "itis";
grant index on "itis".reviews to "public" as "itis";
grant select on "itis".tu_comments_links to "public" as "itis";
grant update on "itis".tu_comments_links to "public" as "itis";
grant insert on "itis".tu_comments_links to "public" as "itis";
grant delete on "itis".tu_comments_links to "public" as "itis";
grant index on "itis".tu_comments_links to "public" as "itis";
grant select on "itis".comments to "public" as "itis";
grant update on "itis".comments to "public" as "itis";
grant insert on "itis".comments to "public" as "itis";
grant delete on "itis".comments to "public" as "itis";
grant index on "itis".comments to "public" as "itis";
grant select on "itis".taxonomic_units to "public" as "itis";
grant update on "itis".taxonomic_units to "public" as "itis";
grant insert on "itis".taxonomic_units to "public" as "itis";
grant delete on "itis".taxonomic_units to "public" as "itis";
grant index on "itis".taxonomic_units to "public" as "itis";
grant select on "itis".vernaculars to "public" as "itis";
grant update on "itis".vernaculars to "public" as "itis";
grant insert on "itis".vernaculars to "public" as "itis";
grant delete on "itis".vernaculars to "public" as "itis";
grant index on "itis".vernaculars to "public" as "itis";
grant select on "itis".vern_ref_links to "public" as "itis";
grant update on "itis".vern_ref_links to "public" as "itis";
grant insert on "itis".vern_ref_links to "public" as "itis";
grant delete on "itis".vern_ref_links to "public" as "itis";
grant index on "itis".vern_ref_links to "public" as "itis";







create unique index "itis".change_comments_ky on "itis".change_comments 
    (change_track_id,chg_cmt_id) using btree ;
alter table "itis".change_comments add constraint primary key 
    (change_track_id,chg_cmt_id) constraint "itis".u111_1  ;
create unique index "itis".chg_operations_key on "itis".change_operations 
    (change_track_id,chg_op_id) using btree ;
alter table "itis".change_operations add constraint primary key 
    (change_track_id,chg_op_id) constraint "itis".u112_2  ;
create unique index "itis".chg_oper_lkp_ky on "itis".chg_operation_lkp 
    (chg_op_id) using btree ;
alter table "itis".chg_operation_lkp add constraint primary key 
    (chg_op_id) constraint "itis".u113_3  ;
create unique index "itis".change_tracks_key on "itis".change_tracks 
    (change_track_id) using btree ;
alter table "itis".change_tracks add constraint primary key (change_track_id) 
    constraint "itis".u114_4  ;
create unique index "itis".kingdoms_key on "itis".kingdoms (kingdom_id) 
    using btree ;
alter table "itis".kingdoms add constraint primary key (kingdom_id) 
    constraint "itis".u119_9  ;
create unique index "itis".taxon_unit_type_ky on "itis".taxon_unit_types 
    (kingdom_id,rank_id) using btree ;
alter table "itis".taxon_unit_types add constraint primary key 
    (kingdom_id,rank_id) constraint "itis".u571_81  ;
create unique index "itis".geographic_div_key on "itis".geographic_div 
    (tsn,geographic_value) using btree ;
alter table "itis".geographic_div add constraint primary key 
    (tsn,geographic_value) constraint "itis".u831_143  ;
create unique index "itis".jurisdiction_key on "itis".jurisdiction 
    (tsn,jurisdiction_value) using btree ;
alter table "itis".jurisdiction add constraint primary key (tsn,
    jurisdiction_value) constraint "itis".u832_144  ;
create index "itis".nodc_ids1 on "itis".nodc_ids (tsn) using btree 
    ;
create unique index "itis".txn_authors_lkp_ky on "itis".taxon_authors_lkp 
    (taxon_author_id,kingdom_id) using btree ;
alter table "itis".taxon_authors_lkp add constraint primary key 
    (taxon_author_id,kingdom_id) constraint "itis".u839_151  ;
    
create index "itis".synonym_links1 on "itis".synonym_links (tsn_accepted) 
    using btree ;
create unique index "itis".synonym_links_key on "itis".synonym_links 
    (tsn,tsn_accepted) using btree ;
alter table "itis".synonym_links add constraint primary key (tsn,
    tsn_accepted) constraint "itis".u843_165  ;
create unique index "itis".reference_links_ky on "itis".reference_links 
    (tsn,doc_id_prefix,documentation_id) using btree ;
alter table "itis".reference_links add constraint primary key 
    (tsn,doc_id_prefix,documentation_id) constraint "itis".u844_167 
     ;
create unique index "itis".experts_key on "itis".experts (expert_id_prefix,
    expert_id) using btree ;
alter table "itis".experts add constraint primary key (expert_id_prefix,
    expert_id) constraint "itis".u859_192  ;
create unique index "itis".other_sources_key on "itis".other_sources 
    (source_id_prefix,source_id) using btree ;
alter table "itis".other_sources add constraint primary key (source_id_prefix,
    source_id) constraint "itis".u860_193  ;
create unique index "itis".publications_key on "itis".publications 
    (pub_id_prefix,publication_id) using btree ;
alter table "itis".publications add constraint primary key (pub_id_prefix,
    publication_id) constraint "itis".u861_194  ;
create unique index "itis".reviews_key on "itis".reviews (tsn,
    review_start_date) using btree ;
alter table "itis".reviews add constraint primary key (tsn,review_start_date) 
    constraint "itis".u862_195  ;
create unique index "itis".tu_comments_lnk_ky on "itis".tu_comments_links 
    (tsn,comment_id) using btree ;
alter table "itis".tu_comments_links add constraint primary key 
    (tsn,comment_id) constraint "itis".u864_198  ;
create unique index "itis".comments_key on "itis".comments (comment_id) 
    using btree ;
alter table "itis".comments add constraint primary key (comment_id) 
    constraint "itis".u863_197  ;
create index "itis".taxon_unit1 on "itis".taxonomic_units (parent_tsn) 
    using btree ;
create index "itis".taxon_unit2 on "itis".taxonomic_units (unit_name1) 
    using btree ;
create index "itis".taxon_unit3 on "itis".taxonomic_units (kingdom_id,
    rank_id) using btree ;
create index "itis".taxon_unit4 on "itis".taxonomic_units (taxon_author_id) 
    using btree ;
create unique index "itis".taxonomic_units_ky on "itis".taxonomic_units 
    (tsn) using btree ;
alter table "itis".taxonomic_units add constraint primary key 
    (tsn) constraint "itis".tu_const1  ;

alter table "itis".change_comments add constraint (foreign key 
    (change_track_id) references "itis".change_tracks  constraint 
    "itis".further_described);

alter table "itis".change_operations add constraint (foreign 
    key (chg_op_id) references "itis".chg_operation_lkp  constraint 
    "itis".detail);

alter table "itis".change_operations add constraint (foreign 
    key (change_track_id) references "itis".change_tracks  constraint 
    "itis".are_typed_by);

alter table "itis".geographic_div add constraint (foreign key 
    (tsn) references "itis".taxonomic_units  constraint "itis".are_located_within);
    

alter table "itis".jurisdiction add constraint (foreign key (tsn) 
    references "itis".taxonomic_units  constraint "itis".id_us_interest_via);
    

alter table "itis".synonym_links add constraint (foreign key 
    (tsn_accepted) references "itis".taxonomic_units  constraint 
    "itis".supercede);

alter table "itis".reference_links add constraint (foreign key 
    (change_track_id) references "itis".change_tracks  constraint 
    "itis".are_documented_by1);

alter table "itis".reference_links add constraint (foreign key 
    (tsn) references "itis".taxonomic_units  constraint "itis".are_documented_by3);
    

alter table "itis".reviews add constraint (foreign key (tsn) 
    references "itis".taxonomic_units  constraint "itis".are_validated_by);
    

alter table "itis".tu_comments_links add constraint (foreign 
    key (comment_id) references "itis".comments  constraint "itis"
    .are_assoc_with_tus);

alter table "itis".tu_comments_links add constraint (foreign 
    key (tsn) references "itis".taxonomic_units  constraint "itis"
    .are_assoc_with_cmt);



update statistics medium for table comments (
     comment_detail, comment_id, comment_time_stamp, commentator, update_date) 
     resolution   2.50000   0.95000 ;
update statistics medium for table experts (
     exp_comment, expert, expert_id, expert_id_prefix, update_date) 
     resolution   2.50000   0.95000 ;
update statistics medium for table geographic_div (
     geographic_value, tsn, update_date) 
     resolution   2.50000   0.95000 ;
update statistics medium for table jurisdiction (
     jurisdiction_value, origin, tsn, update_date) 
     resolution   2.50000   0.95000 ;
update statistics medium for table kingdoms (
     kingdom_id, kingdom_name, update_date) 
     resolution   2.50000   0.95000 ;
update statistics medium for table nodc_ids (
     nodc_id, tsn, update_date) 
     resolution   2.50000   0.95000 ;
update statistics medium for table other_sources (
     acquisition_date, source, source_comment, source_id, source_id_prefix, 
     source_type, update_date, version) 
     resolution   2.50000   0.95000 ;
update statistics medium for table publications (
     actual_pub_date, isbn, issn, listed_pub_date, pages, 
     pub_comment, pub_id_prefix, pub_place, publication_id, publication_name, 
     publisher, reference_author, title, update_date) 
     resolution   2.50000   0.95000 ;
update statistics medium for table reference_links (
     change_track_id, doc_id_prefix, documentation_id, init_itis_desc_ind, original_desc_ind, 
     tsn, update_date, vernacular_name) 
     resolution   2.50000   0.95000 ;
update statistics medium for table synonym_links (
     tsn, tsn_accepted, update_date) 
     resolution   2.50000   0.95000 ;
update statistics medium for table taxon_authors_lkp (
     kingdom_id, taxon_author, taxon_author_id, update_date) 
     resolution   2.50000   0.95000 ;
update statistics medium for table taxon_unit_types (
     dir_parent_rank_id, kingdom_id, rank_id, rank_name, req_parent_rank_id, 
     update_date) 
     resolution   2.50000   0.95000 ;
update statistics medium for table taxonomic_units (
     completeness_rtng, credibility_rtng, currency_rating, hybrid_author_id, initial_time_stamp, 
     kingdom_id, parent_tsn, phylo_sort_seq, rank_id, taxon_author_id, 
     tsn, unaccept_reason, uncertain_prnt_ind, unit_ind1, unit_ind2, 
     unit_ind3, unit_ind4, unit_name1, unit_name2, unit_name3, 
     unit_name4, unnamed_taxon_ind, update_date, usage) 
     resolution   2.50000   0.95000 ;
update statistics medium for table tu_comments_links (
     comment_id, tsn, update_date) 
     resolution   2.50000   0.95000 ;
update statistics medium for table vern_ref_links (
     doc_id_prefix, documentation_id, tsn, update_date, vern_id) 
     resolution   2.50000   0.95000 ;
update statistics medium for table vernaculars (
     approved_ind, language, tsn, update_date, vern_id, 
     vernacular_name) 
     resolution   2.50000   0.95000 ;

 

