@echo off
REM *************************************************************************
REM *  File : loadITIS.bat
REM *  Release : UB2.0.3
REM *  SIR     : 1683
REM *  Author : Ganesh Thadkamalla
REM *  Date :  04/27/2005
REM *  Description :  Creates ITIS schema and ITIS tables in STORET database
REM *    and loads the datafiles using sql*loader scripts.  
REM *    Identifies single word comments in ITIS datafiles for review.
REM *  
REM *  Comments :  Step 1 of 3.
REM *    Database connection information should be updated accordingly.
REM *  
REM **************************************************************************
cls
@echo off
echo *******************************************************
echo *         STORET Taxonomy Update Process
echo *  This script will perform the following:
echo *    1)  Create Tablespaces ITIS_TABS and ITIS_INDS.
echo *    2)  Create ITIS schema.
echo *    3)  Drop and Create tables to hold ITIS data.
echo *    4)  Load ITIS data into ITIS schema.
echo *    5)  Reports a list of single word comments for synonyms.
echo *
echo * Note:  Datafiles are created in STORET schema datafile location.
echo ********************************************************   
pause
title STORET Taxonomy Update Process.  Loading ITIS data into STORET instance.
sqlplus system/sto2et@storet @scripts\itisuser.sql
sqlplus itis/itis@storet @scripts\cr_itistabs.sql
sqlldr USERID=itis/itis@storet CONTROL=ctlfiles\ld_taxonomic_units.ctl LOG=logs\ld_taxonomic_units.log
sqlldr USERID=itis/itis@storet CONTROL=ctlfiles\ld_taxon_unit_types.ctl LOG=logs\ld_taxon_unit_types.log
sqlldr USERID=itis/itis@storet CONTROL=ctlfiles\ld_nodc_ids.ctl LOG=logs\ld_nodc_ids.log
sqlldr USERID=itis/itis@storet CONTROL=ctlfiles\ld_taxon_authors_lkp.ctl LOG=logs\ld_taxon_authors_lkp.log
sqlldr USERID=itis/itis@storet CONTROL=ctlfiles\ld_tu_comments_links.ctl LOG=logs\ld_tu_comments_links.log
sqlldr USERID=itis/itis@storet CONTROL=ctlfiles\ld_comments.ctl LOG=logs\ld_comments.log
sqlldr USERID=itis/itis@storet CONTROL=ctlfiles\ld_vernaculars.ctl LOG=logs\ld_vernaculars.log
sqlldr USERID=itis/itis@storet CONTROL=ctlfiles\ld_synonym_links.ctl LOG=logs\ld_synonym_links.log
sqlplus itis/itis@storet @scripts\analyze_itis.sql
title STORET Taxonomy Update Process.  Reviewing ITIS Comments.
sqlplus system/sto2et@storet @scripts\itis_comments.sql
title STORET Taxonomy Update Process. 
cls
echo ITIS data loading into temporary schema is complete.  
echo Please review log files located in logs\ directory for errors.
echo ---
echo Single word comments for synonyms are loaded into STORET.TSRITISC table.  The data from this table is available in logs\Rep_itis_comments.log file.  Please review the file and update STORET.TSRITISC table's Action field to 'APPLY' to consider the comment in establishing synonym's Display Name.
echo ---
echo Proceed to extracting the Taxonomy data from ITIS tables using the script Ext_taxa.bat.
pause
exit