/************************************************
File : Rep_IT_dupname.sql
Release : UB2.0.3
SIR     : 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description :  Generates and report of Duplicate names between Taxa and STORET's non-Taxa characteristics.

Comments :


*************************************************/

set echo off
set heading off
set linesize 100
set trimspool on

spool logs\Rep_IT_dupname.log

SELECT 'Duplicate names between Taxa and non-Taxa characteristics.  The TAXA information from the following list will be added to STORET.TSRCHDUP table.' from dual;

select 'TSN    ScreenType   DisplayName' from dual;

select tsn||'     '||'TAXA     '||itis_name
from itis.itistaxa t
where exists (select 1 from storet.tsrchar c
    where c.display_name= t.itis_name
      and c.extrnl_serial_num != t.tsn
      and c.d_scr_type_cd not in ('TAXA','VAR'))
union
select extrnl_serial_num||'     '||rtrim(d_scr_type_cd)||'    '||display_name
from storet.tsrchar c
where c.d_scr_type_cd not in ('TAXA','VAR')
and  exists (select 1 from itis.itistaxa t
    where c.display_name = t.itis_name
      and c.extrnl_serial_num != t.tsn)
/

spool off;
spool logs\IT_dupname.log


Prompt Adding ITIS names that match with STORET's non-Taxon names into TSRCHDUP TABLE.

Prompt Pre Statistics
select count(*) from storet.tsrchdup;

--DML

SET SERVEROUTPUT ON SIZE 1000000
DECLARE
  CURSOR ITIS_CUR IS 
  select tsn,itis_name
  from itis.itistaxa t
  where exists (select 1 from storet.tsrchar c
    where c.display_name= t.itis_name
      and c.extrnl_serial_num != t.tsn
      and c.d_scr_type_cd not in ('TAXA','VAR'));

BEGIN
  for c_var in itis_cur loop
    BEGIN 
      insert into storet.tsrchdup (tsn,itis_name,pref_display_name)
      values (c_var.tsn,c_var.itis_name,substr(c_var.itis_name,1,60));

    EXCEPTION WHEN OTHERS THEN
      DBMS_OUTPUT.PUT_LINE('Unable to insert into TSRCHDUP. Data = '||c_var.tsn||'~'||c_var.itis_name);
    END;

  end loop;
  commit;

END;
/

Prompt Post Statistics
select count(*) from storet.tsrchdup;
 
spool off;
exit;
