
/************************************************
File : Rep_missing_tsn.sql
Release : UB2.0.3
SIR     : 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description : Generates report of missing TSNs for review. These TSNs should be reviewed with the source organization, ITIS. 

Comments :


*************************************************/
set heading off;
set echo off
set feedback off
set time off
set timing off
set trimspool on
set linesize 100
set pagesize 1000

spool logs\Rep_missing_tsn.log
select 'Report of STORET TSNs that are missing in the extracted Taxonomy data from ITIS.' from dual;
select 'This list includes both TSNs that are deleted from ITIS and TSNs with invalid parent_TSN.' from dual;

select 'TSN~DisplayName~Parent_TSN' from dual;
select extrnl_serial_num||'~'||display_name||'~'||parent_tsn
from storet.tsrchar  c
where d_scr_type_cd in ('TAXA','VAR')
AND  uom_type = 'TAX'
and not exists
 (select 1 from itis.itistaxa t
   where t.tsn = c.extrnl_serial_num);

spool off;
exit
