/************************************************
File : cr_itistabs.sql
Release : UB2.0.3
SIR     : 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description :  Create ITIS tables in ITIS schema in STORET Instance

Comments :


*************************************************/

spool logs\cr_itistabs.log
set echo on

--drop table if exists in ITIS schema
begin
  execute immediate 'drop table itis.taxonomic_units' ;
exception when others then
 null;
end;
/
begin
  execute immediate 'drop table itis.taxon_unit_types' ;
exception when others then
 null;
end;
/
begin
  execute immediate 'drop table itis.nodc_ids' ;
exception when others then
 null;
end;
/
begin
  execute immediate 'drop table itis.taxon_authors_lkp ';
exception when others then
 null;
end;
/
begin
  execute immediate 'drop table itis.tu_comments_links ';
exception when others then
 null;
end;
/
begin
  execute immediate 'drop table itis.comments' ;
exception when others then
 null;
end;
/
begin
  execute immediate 'drop table itis.vernaculars' ;
exception when others then
 null;
end;
/
begin
  execute immediate 'drop table itis.synonym_links ';
exception when others then
 null;
end;
/


--{ TABLE itis.taxonomic_units number of columns = 24 }
--{ unload file name = taxon00118.unl }


create table itis.taxonomic_units 
  (
    tsn integer not null ,
    unit_ind1 char(1),
    unit_name1 char(35) not null,
    unit_ind2 char(1),
    unit_name2 varchar2(35),
    unit_ind3 varchar2(7),
    unit_name3 varchar2(35),
    unit_ind4 varchar2(7),
    unit_name4 varchar2(35),
    unnamed_taxon_ind char(1),
    usage varchar2(12) not null,
    unaccept_reason varchar2(50),
    credibility_rtng varchar2(40) not null,
    completeness_rtng char(10),
    currency_rating char(7),
    phylo_sort_seq smallint,
    initial_time_stamp date not null,
    parent_tsn integer,
    taxon_author_id integer,
    hybrid_author_id integer,
    kingdom_id smallint not null,
    rank_id smallint not null,
    update_date date not null,
    uncertain_prnt_ind char(3)
  );


--{ TABLE itis.taxon_unit_types number of columns = 6 }
--{ unload file name = taxon00105.unl  }


create table itis.taxon_unit_types 
  (
    kingdom_id integer not null ,
    rank_id smallint not null ,
    rank_name char(15) not null ,
    dir_parent_rank_id smallint not null ,
    req_parent_rank_id smallint not null ,
    update_date date not null 
  );

--{ TABLE itis.nodc_ids number of columns = 3 }
--{ unload file name = nodc_00108.unl  }


create table itis.nodc_ids 
  (
    nodc_id char(12) not null ,
    update_date date not null ,
    tsn integer not null ,
    primary key (nodc_id,tsn)
  );

--{ TABLE itis.taxon_authors_lkp number of columns = 4 }
--{ unload file name = taxon00109.unl  }


create table itis.taxon_authors_lkp 
  (
    taxon_author_id number not null ,
    taxon_author varchar2(100) not null ,
    update_date date not null ,
    kingdom_id smallint not null 
  );

--{ TABLE itis.tu_comments_links number of columns = 3 }
--{ unload file name = tu_co00116.unl  }


create table itis.tu_comments_links 
  (
    tsn integer not null ,
    comment_id integer not null ,
    update_date date not null 
  );

--{ TABLE itis.comments number of columns = 5 }
--{ unload file name = comme00117.unl }


create table itis.comments 
  (
    comment_id number not null ,
    commentator varchar2(100),
    comment_detail char(2000) not null ,
    comment_time_stamp date not null ,
    update_date date not null 
  );

--{ TABLE itis.vernaculars number of columns = 6 }
--{ unload file name = verna00119.unl  }


create table itis.vernaculars 
  (
    tsn integer not null ,
    vernacular_name varchar2(80) not null ,
    language varchar2(15) not null ,
    approved_ind char(1),
    update_date date not null ,
    vern_id number not null ,
    unique (tsn,vernacular_name,language)  ,
    primary key (vern_id)
  );

--{ TABLE itis.synonym_links  number of columns = 3 }
--{ unload file name = synon00110.unl  }


create table itis.synonym_links 
  (
    tsn integer not null ,
    tsn_accepted integer not null ,
    update_date date not null 
  );


spool off;
exit;
