/************************************************
File : fix_missing_tsn.sql
Release : UB2.0.3
SIR     : 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description :  STORET TSNs that are missing in the extracted ITIS list are considered as missing TSNs.  The taxonomy information of these TSNs in STORET will be set to null.

Comments :


*************************************************/
set heading off;
set echo off
spool logs\fix_missing_tsn.log

Prompt The following record(s) listed below are present in STORET but were not extracted from ITIS.  The taxonomy associated information for the characteristic(s) will be deleted from STORET.

Prompt 

select 'TSN~ITIS_Name~Parent_TSN' from dual;
select extrnl_serial_num||'~'||display_name||'~'||parent_tsn
from storet.tsrchar  c
where  d_scr_type_cd in ('TAXA','VAR')
AND  uom_type = 'TAX' 
AND not exists
 (select 1 from itis.itistaxa t
   where t.tsn = c.extrnl_serial_num);


--DML
update storet.tsrchar c
set taxon_sort_code=null, parent_tsn=null, taxon_rank_code=null, taxon_rank_name=null, TRUE_NAME_TSN=NULL
where d_scr_type_cd in ('TAXA','VAR')
AND  uom_type = 'TAX' 
AND not exists
 (select 1 from itis.itistaxa t
   where t.tsn = c.extrnl_serial_num)
/

commit;

--post stats
select 'TSN~ITIS_Name~Parent_TSN' from dual;
select extrnl_serial_num||'~'||display_name||'~'||parent_tsn
from storet.tsrchar  c
where d_scr_type_cd in ('TAXA','VAR')
AND  uom_type = 'TAX' 
AND not exists
 (select 1 from itis.itistaxa t
   where t.tsn = c.extrnl_serial_num)
AND (TAXON_SORT_CODE IS NOT NULL
     OR PARENT_TSN IS NOT NULL
     OR TAXON_RANK_CODE IS NOT NULL
     OR TAXON_RANK_NAME IS NOT NULL
     OR TRUE_NAME_TSN IS NOT NULL);


spool off;
exit
