/************************************************
File : itisuser.sql
Release : UB2.0.3
SIR     : 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description : Creates tablespaces, user ITIS and Rollback segment RBSBIG.  Also issues grants.  

Comments :


*************************************************/
set serveroutput on
spool logs\itisuser.log
show user;

--Create itis_tabs and itis_inds tablespaces.

declare

  lv_tbs_status number default 0;
  lv_data_dir dba_data_files.file_name%type;
  lv_index_dir dba_data_files.file_name%type;
  lv_data_file dba_data_files.file_name%type;
  lv_index_file dba_data_files.file_name%type;
  lv_itis_status number:=0;
  lv_rbs_status number:=0;
  lv_rbsbig_status dba_rollbacK_segs.status%type;

begin 

  select substr(file_name,1,(instr(file_name,'TSSTRD01.DBF')-1))
    into lv_data_dir
  from dba_data_files
  where tablespace_name = 'STORET_TABS'
   and file_name like '%TSSTRD01.DBF';

  select substr(file_name,1,(instr(file_name,'TSSTRI01.DBF')-1))
    into lv_index_dir
  from dba_data_files
  where tablespace_name = 'STORET_INDS'
   and file_name like '%TSSTRI01.DBF';


dbms_output.put_line('Data directory = '||lv_data_dir);
dbms_output.put_line('Index directory = '||lv_index_dir);

lv_data_file:=lv_data_dir||'itistabs1.dbf';
lv_index_file:= lv_index_dir||'itisinds1.dbf';

--cHECK and create itis_tabs tablespace.
lv_tbs_status:=0;
SELECT COUNT(*) INTO lv_tbs_status
from dba_tablespaces
where tablespace_name = 'ITIS_TABS';

IF lv_tbs_status = 1 THEN
  NULL;
ELSIF lv_tbs_status = 0 THEN
  EXECUTE IMMEDIATE 'create tablespace itis_tabs
  datafile '''||lv_data_file||''' size 300 M
  autoextend on next 32m maxsize 2048m
  extent management local';
END IF;

--cHECK and create itis_INDS tablespace.
lv_tbs_status:=0;
SELECT COUNT(*) INTO lv_tbs_status
from dba_tablespaces
where tablespace_name = 'ITIS_INDS';

IF lv_tbs_status = 1 THEN
  NULL;
ELSIF lv_tbs_status = 0 THEN
  execute immediate 'create tablespace itis_inds
  datafile '''||lv_index_file||''' size 75 M
  autoextend on next 32m maxsize 2048m
  extent management local';
END IF;

-- coalesce itis tablespaces.

execute immediate 'alter tablespace itis_tabs coalesce';
execute immediate 'alter tablespace itis_inds coalesce';

--check and create ITIS schema.

select count(*) into lv_itis_status from dba_users
where username='ITIS';

if lv_itis_status = 0 then
execute immediate 'create user itis identified by itis
  default tablespace itis_tabs
  temporary tablespace temporary_data
  quota unlimited on itis_tabs
  quota unlimited on itis_inds';


elsif lv_itis_status=1 then
  null;
end if;

-- System Grants to itis
execute immediate 'grant create session to itis';
execute immediate 'grant create table to itis';
execute immediate 'grant create procedure to itis';
execute immediate 'grant create sequence to itis';
execute immediate 'grant select any table to itis';

--check and create rbsbign rollback segment

select count(*) into lv_rbs_status from dba_rollback_segs
where segment_name ='RBSBIG';


if lv_rbs_status=0 then 
  execute immediate 'create rollback segment rbsbig
  storage (initial 20M next 20M minextents 2 maxextents 100)
  tablespace tsrollback';
  execute immediate 'alter rollback segment rbsbig online';
elsif lv_rbs_status=1 then
  select status into lv_rbsbig_status from dba_rollback_segs
  where segment_name ='RBSBIG';
  if lv_rbsbig_status = 'OFFLINE' then 
    execute immediate 'alter rollback segment rbsbig online';
  end if;
end if;

end;
/

show errors;
spool off;
exit;