/***********************************************************************
File :  	sir1625b.sql	
Release :	U2.0.2
SIR : 		1625, 1683
Author : 	Ganesh B. Thadkamalla
Date :   	8/17/2004
Description :  	Insert new rows provided in ITIS data files into storet.tsrchar table except common names.
Comments : 	Run this after the sir1625a.sql
		This scirpt is dependent on ITISparams.sql
***********************************************************************/
-- add new characteristics into storet.tsrchar table from ITIS file.
--connect storet/sto2et
set time on
set timing on
spool logs\sir1625b.log

-- run ITISparams.sql for defining userid and buffer variables.
@scripts\ITISparams.sql

ALTER ROLLBACK SEGMENT "RBSBIG" ONLINE;
-- Pre DML
select count(*) from storet.tsrchar;

-- create itis.tsrchar_vio table to catch any violations in inserting ITIS characteristics.
drop table itis.tsrchar_vio;
create table itis.tsrchar_vio
as select * from itis.itistaxa
where rownum < 1;
truncate table itis.tsrchar_vio;
commit;

--DML

set serveroutput on;
SET TRANSACTION USE ROLLBACK SEGMENT RBSBIG;

DECLARE
  -- local variables
  lv_tsrchar_is_number storet.tsrchar.tsrchar_is_number%type;
  lv_tsrchar_org_id storet.tsrchar.tsrchar_org_id%type;
  lv_counter number:=0;
  lv_tsrchar_isn_buf number;
  lv_userid storet.tsrchar.D_USERID_CODE%type;

  -- CURSOR to read first 10000 new ITIS characteristic rows from itis.itistaxa table 
  cursor c1 is 
  select TSN, PARENT_TSN, TRUE_NAME_TSN, TAXON_RANK_CODE,
    substr(TAXON_RANK_NAME,1,12)  TAXON_RANK_NAME,
    STATUS, TAXON_SORT_CODE, DISPLAY_NAME,
    substr(AUTHOR_DATE,1,45)  AUTHOR_DATE
  from itis.itistaxa ct
  where not exists (select 'x' from storet.tsrchar c
                  where ct.tsn = c.extrnl_serial_num)
  and rownum < 10000;
  -- other variables.
  i number;
  x number;
  y number;
  z number;

BEGIN

-- read defined variables in ITISparams.sql file.
lv_tsrchar_isn_buf := &gv_char_isn_buffer;
lv_userid := upper('&gv_userid');

select count(*) into x from itis.itistaxa;
select count(*) into y from itis.itistaxa ct
where  exists (select 'x' from storet.tsrchar c
                  where ct.tsn = c.extrnl_serial_num);
select ceil((x-y)/10000) into z from dual;

for i in 1 .. z loop
  if i = 1 then
    select max(tsrchar_is_number) into lv_tsrchar_is_number from storet.tsrchar;
    lv_tsrchar_is_number := lv_tsrchar_is_number+lv_tsrchar_isn_buf;
  else 
    select max(tsrchar_is_number) into lv_tsrchar_is_number from storet.tsrchar;
  end if;
  lv_tsrchar_org_id := 'ZZZZZZZZ';
  commit;
  dbms_transaction.use_rollback_segment('RBSBIG');
  for c1_var in c1 loop
    lv_tsrchar_is_number:=lv_tsrchar_is_number+1;
    begin
     insert into storet.tsrchar
      (TSRCHAR_IS_NUMBER      ,
      TSRCHAR_ORG_ID         ,
      EXTRNL_SERIAL_NUM      ,
      UOM_TYPE               ,
      SEARCH_NAME            ,
      DISPLAY_NAME           ,
      D_SCR_TYPE_CD          ,
      PROC_REQ_IND_CD        ,
      VALID_FOR_QC_IND       ,
      SAMP_FRAC_REQ_CD       ,
      CHAR_TYPE_CODE         ,
      TAXON_RANK_CODE        ,
      D_USERID_CODE          ,
      D_LAST_UPDATE_TS       ,
      TRUE_NAME_TSN          ,
      PARENT_TSN             ,
      TAXON_SORT_CODE        ,
      AUTHOR_DATE            ,
      STATUS                 ,
      TAXON_RANK_NAME        )
     values
      (lv_TSRCHAR_IS_NUMBER      ,
      lv_TSRCHAR_ORG_ID         ,
      c1_var.tsn      ,
      'TAX',   --UOM_TYPE --This may be VAR
      upper(c1_var.display_name) , --SEARCH_NAME            ,
      c1_var.DISPLAY_NAME           ,
      'TAXA',   --D_SCR_TYPE_CD -- This may be VAR
      'N',  --PROC_REQ_IND_CD--May be Y
      'N',  --VALID_FOR_QC_IND       ,
      'N',  --SAMP_FRAC_REQ_CD       ,
      'T',  --CHAR_TYPE_CODE         ,
      c1_var.TAXON_RANK_CODE        ,
      lv_userid, --D_USERID_CODE          ,
      sysdate, --D_LAST_UPDATE_TS       ,
      c1_var.TRUE_NAME_TSN          ,
      c1_var.PARENT_TSN             ,
      c1_var.TAXON_SORT_CODE        ,
      c1_var.AUTHOR_DATE            ,
      c1_var.STATUS                 ,
      c1_var.TAXON_RANK_NAME        );
    exception
      when others then
        insert into itis.tsrchar_vio
        (tsn      ,
        PARENT_TSN             ,
        TRUE_NAME_TSN          ,
        TAXON_RANK_CODE        ,
        TAXON_RANK_NAME        ,
        STATUS                 ,
        TAXON_SORT_CODE        ,
        DISPLAY_NAME           ,
        AUTHOR_DATE            )
      values
      (c1_var.tsn      ,
       c1_var.PARENT_TSN             ,
       c1_var.TRUE_NAME_TSN          ,
       c1_var.TAXON_RANK_CODE        ,
       c1_var.TAXON_RANK_NAME        ,
       c1_var.STATUS                 ,
       c1_var.TAXON_SORT_CODE        ,
       c1_var.DISPLAY_NAME           ,
       c1_var.AUTHOR_DATE            );
    end;  -- end of inner block
  --commit every 500 inserts.
  lv_counter:=lv_counter+1;
  if (lv_counter > 1000 ) then
     commit;
     dbms_transaction.use_rollback_segment('RBSBIG');
     lv_counter:=0;
  end if;
end loop;
  commit;
  dbms_transaction.use_rollback_segment('RBSBIG');
end loop; --end of i loop
COMMIT;
end;
/
SHOW ERRORS;

select count(*) from storet.tsrchar;
select d_scr_type_cd,count(*) from storet.tsrchar
group by d_scr_type_cd;
commit;

analyze table storet.tsrchar compute statistics;

Prompt TSMEISN table is updated in sir1625e.sql
set echo off;
set time off;
set timing off;
set heading off;
set linesize 100;
set trimspool on;

Prompt
Prompt
Prompt Checking violations during new taxonomy insert.
PROMPT ***********************
PROMPT 
select decode(count(*),0,'No violations found.','WARNING: Violations found during new taxonomy insert.  Please review logs\sir1625b_vio.log file for more information.')  from itis.tsrchar_vio;
pROMPT 
PROMPT ***********************
PROMPT

SPOOL OFF;

set linesize 250;
set trimspool on;
set pagesize 0;
set echo off;
set time off;
set timing off;

SPOOL logs\sir1625b_vio.log

-- Checking violations during new taxonomy insert.

select decode(count(*),0,'No violations.  Ignore rest of this file.','Following is the list of violations found during new taxonomy insert.')  from itis.tsrchar_vio;

Prompt TSN~DISPLAY_NAME~TAXON_RANK_CODE~TAXON_SORT_CODE
SELECT TSN||'~'||DISPLAY_NAME||'~'||TAXON_RANK_CODE||'~'||TAXON_SORT_CODE FROM ITIS.TSRCHAR_VIO;
spool off;

disconnect
exit