/***********************************************************************
File :  	sir1625c.sql	
Release :	U2.0.2
SIR : 		1625, 1683
Author : 	Ganesh B. Thadkamalla
Date :   	8/17/2004
Description :  	Insert common names from ITIS datafiles into storet.tsrchals table.
Comments : 	Run this after sir1625b.sql
		This script is dependent on ITISparams.sql file.
***********************************************************************/
spool logs\sir1625c.log
--connect storet/storet
set echo on
set time on
set timing on

-- run ITISparams.sql for defining userid and buffer variables.
@scripts\ITISparams.sql

ALTER ROLLBACK SEGMENT "RBSBIG" ONLINE;
-- disable triggers.
alter trigger storet.CHALS_AFT_ROW_ALL disable;
alter trigger storet.CHALS_AFT_STM_ALL disable;
alter trigger storet.CHALS_BEF_STM_ALL disable;

--pre DML
Prompt Distribution of aliases by alias type.
select tsrcalt_is_number,tsrcalt_org_id,count(*) from storet.tsrchals
group by tsrcalt_is_number,tsrcalt_org_id;

Prompt Following two queries are for record keeping.
select max(d_last_update_ts) from storet.tsrchals;
select max(tsrchals_is_number) from storet.tsrchals;

/*************************
Temporary Table : itis.itis_cnames
Description :  This table has common name alias records extracted from ITIS downloads.
Attributes:
	True_name_tsn - maps to extrnl_serial_num of the storet.tsrchar table.
	Display_name - it is same as tsrchals.name
	status	- All rows will have a value of C.  
	flag - Default 0. All rows that will be added to tsrchals are set to 1.
Note: rest of the attributes in this table can be ignored.
**************************/

--new common names available for insert.

SELECT count(*)
FROM itis.itis_cnames A
where not EXISTS (SELECT 'X' FROM storet.tsrchals B,storet.tsrchar d
         WHERE upper(A.NAME)=upper(B.NAME)
           AND B.TSRCALT_IS_NUMBER = &gv_calt_isn_com_name
           AND d.TSRCHAR_IS_NUMBER = B.TSRCHAR_IS_NUMBER
	   and d.extrnl_serial_num=a.true_name_tsn);
           --AND d.TSRCHAR_ORG_ID = B.TSRCHAR_ORG_ID

SET serveroutput on
DECLARE
-- cursor to select all new common names for inserting into storet.tsrchals table.
  cursor c1 is
  SELECT c.tsrchar_is_number, a.name, a.true_name_tsn
  FROM itis.itis_cnames A,
       storet.tsrchar c
  where c.extrnl_serial_num=a.true_name_tsn
  and not EXISTS (SELECT 'X' FROM storet.tsrchals B,storet.tsrchar d
         WHERE upper(A.NAME)=upper(B.NAME)
           AND B.TSRCALT_IS_NUMBER = &gv_calt_isn_com_name
           AND d.TSRCHAR_IS_NUMBER = B.TSRCHAR_IS_NUMBER
           --AND d.TSRCHAR_ORG_ID = B.TSRCHAR_ORG_ID
	   and d.extrnl_serial_num=a.true_name_tsn);

  -- other local variables.
  lv_tsrchals_is_number storet.tsrchals.tsrchals_is_number%type;
  lv_commit_counter number:=0;
  lv_tsrchals_isn_buf number;
  lv_userid storet.tsrchals.D_USERID_CODE%type;
BEGIN
  -- read defined variables in ITISparams.sql file.
  lv_tsrchals_isn_buf := &gv_chals_isn_buffer;
  lv_userid := upper('&gv_userid');

  COMMIT;
  dbms_transaction.use_rollback_segment('RBSBIG');

  select max(tsrchals_is_number) into lv_tsrchals_is_number from storet.tsrchals;
  lv_tsrchals_is_number:=lv_tsrchals_is_number+lv_tsrchals_isn_buf;
  -- process the cursor.
  for c1_var in c1 loop
    lv_tsrchals_is_number:=lv_tsrchals_is_number+1;
    insert into storet.tsrchals 
    (TSRCHAR_IS_NUMBER      ,
    TSRCHAR_ORG_ID         ,
    TSRCHALS_IS_NUMBER     ,
    TYPE_NAME,
    NAME                   ,
    D_USERID_CODE          ,
    D_LAST_UPDATE_TS       ,
    TSRCALT_IS_NUMBER      ,
    TSRCALT_ORG_ID         ,
    SEARCH_NAME             )
    values
    (c1_var.TSRCHAR_IS_NUMBER,
    'ZZZZZZZZ'    ,
    lv_TSRCHALS_IS_NUMBER    ,
    'TAXON COMMON NAME'      ,  -- NOT NULL COLUMN.
    c1_var.NAME      , 	
    lv_userid                , 		
    SYSDATE, 			
    &gv_calt_isn_com_name,    --TSRCALT_IS_NUMBER
    'ZZZZZZZZ', --TSRCALT_ORG_ID
    upper(c1_var.name));
    
    lv_commit_counter:=lv_commit_counter+1;
    if lv_commit_counter > 2000 then
      commit;
      dbms_transaction.use_rollback_segment('RBSBIG');
      lv_commit_counter:=0;
    end if;
  end loop; 
  commit;
end;
/

--post DML
Prompt Distribution of aliases by alias type.
select tsrcalt_is_number,tsrcalt_org_id,count(*) from storet.tsrchals
group by tsrcalt_is_number,tsrcalt_org_id;

Prompt Following two querries are for record keeping.
select max(d_last_update_ts) from storet.tsrchals;
select max(tsrchals_is_number) from storet.tsrchals;

Prompt The following select should return 0 count.  
SELECT count(*)
FROM itis.itis_cnames A
where not EXISTS (SELECT 'X' FROM storet.tsrchals B,storet.tsrchar d
         WHERE upper(A.NAME)=upper(B.NAME)
           AND B.TSRCALT_IS_NUMBER = &gv_calt_isn_com_name
           AND d.TSRCHAR_IS_NUMBER = B.TSRCHAR_IS_NUMBER
           --AND d.TSRCHAR_ORG_ID = B.TSRCHAR_ORG_ID
	   and d.extrnl_serial_num=a.true_name_tsn);

-- enabling triggers.
alter trigger storet.CHALS_AFT_ROW_ALL enable;
alter trigger storet.CHALS_AFT_STM_ALL enable;
alter trigger storet.CHALS_BEF_STM_ALL enable;


Prompt tsmeisn is synchronized in sir1625e.sql

disconnect
spool off;
exit