/************************************************
File : sort_code_pkg.sql
Release : UB2.0.3
SIR     : 1683
Author : Ganesh Thadkamalla
Date :  04/27/2005
Description : Creates sort_code_pkg stored package. This is used for generating the taxon sort code. 

Comments :


*************************************************/

set echo off;
set heading off;

spool logs\sort_code_pkg.log

select 'Creating Sort_code_pkg package.' from dual;

create or replace package sort_code_pkg is
v_kng number(1,0);
v_sbk number(1,0);
--v_phy number(2,0);
v_div number(2,0);
--v_sbp number(1,0);
v_sbd number(1,0);
v_spc number(1,0);
v_cls number(2,0);
v_sbc number(1,0);
v_ifc number(1,0);
v_spo number(2,0);
v_ord number(2,0);
v_sbo number(2,0);
v_ifo number(1,0);
v_spf number(2,0);
v_fam number(3,0);
v_sbf number(2,0);
v_tri number(2,0);
v_sbt number(1,0);
v_gen number(3,0);
v_sbg number(2,0);
v_spe number(3,0);
v_ssp number(2,0);
v_var number(2,0);
v_for number(2,0);

function f_sort_code(p_rankcode char) return varchar2;
procedure reset_ranks(p_rankcode char);
procedure inc_rank(p_rankcode char);

end sort_code_pkg;
/
show errors;

-- Package body
create or replace package body sort_code_pkg as

procedure reset_ranks(p_rankcode char) is
begin
  if p_rankcode = 'KNG' then
    --v_kng :=0;
    v_sbk :=0;
    v_div :=0;
    v_sbd :=0;
    v_spc :=0;
    v_cls :=0;
    v_sbc :=0;
    v_ifc :=0;
    v_spo :=0;
    v_ord :=0;
    v_sbo :=0;
    v_ifo :=0;
    v_spf :=0;
    v_fam :=0;
    v_sbf :=0;
    v_tri :=0;
    v_sbt :=0;
    v_gen :=0;
    v_sbg :=0;
    v_spe :=0;
    v_ssp :=0;
    v_var :=0;
    v_for :=0;
  elsif p_rankcode = 'SBK' then
    --v_sbk :=0;
    v_div :=0;
    v_sbd :=0;
    v_spc :=0;
    v_cls :=0;
    v_sbc :=0;
    v_ifc :=0;
    v_spo :=0;
    v_ord :=0;
    v_sbo :=0;
    v_ifo :=0;
    v_spf :=0;
    v_fam :=0;
    v_sbf :=0;
    v_tri :=0;
    v_sbt :=0;
    v_gen :=0;
    v_sbg :=0;
    v_spe :=0;
    v_ssp :=0;
    v_var :=0;
    v_for :=0;
  elsif p_rankcode = 'DIV' or  p_rankcode = 'PHY' then
    --v_div :=0;
    v_sbd :=0;
    v_spc :=0;
    v_cls :=0;
    v_sbc :=0;
    v_ifc :=0;
    v_spo :=0;
    v_ord :=0;
    v_sbo :=0;
    v_ifo :=0;
    v_spf :=0;
    v_fam :=0;
    v_sbf :=0;
    v_tri :=0;
    v_sbt :=0;
    v_gen :=0;
    v_sbg :=0;
    v_spe :=0;
    v_ssp :=0;
    v_var :=0;
    v_for :=0;

  elsif p_rankcode = 'SBD' or p_rankcode = 'SBP' then
    --v_sbd :=0;
    v_spc :=0;
    v_cls :=0;
    v_sbc :=0;
    v_ifc :=0;
    v_spo :=0;
    v_ord :=0;
    v_sbo :=0;
    v_ifo :=0;
    v_spf :=0;
    v_fam :=0;
    v_sbf :=0;
    v_tri :=0;
    v_sbt :=0;
    v_gen :=0;
    v_sbg :=0;
    v_spe :=0;
    v_ssp :=0;
    v_var :=0;
    v_for :=0;

  elsif p_rankcode = 'SPC' then
    --v_spc :=0;
    v_cls :=0;
    v_sbc :=0;
    v_ifc :=0;
    v_spo :=0;
    v_ord :=0;
    v_sbo :=0;
    v_ifo :=0;
    v_spf :=0;
    v_fam :=0;
    v_sbf :=0;
    v_tri :=0;
    v_sbt :=0;
    v_gen :=0;
    v_sbg :=0;
    v_spe :=0;
    v_ssp :=0;
    v_var :=0;
    v_for :=0;

  elsif p_rankcode = 'CLS' then
    --v_cls :=0;
    v_sbc :=0;
    v_ifc :=0;
    v_spo :=0;
    v_ord :=0;
    v_sbo :=0;
    v_ifo :=0;
    v_spf :=0;
    v_fam :=0;
    v_sbf :=0;
    v_tri :=0;
    v_sbt :=0;
    v_gen :=0;
    v_sbg :=0;
    v_spe :=0;
    v_ssp :=0;
    v_var :=0;
    v_for :=0;

  elsif p_rankcode = 'SBC' then
    --v_sbc :=0;
    v_ifc :=0;
    v_spo :=0;
    v_ord :=0;
    v_sbo :=0;
    v_ifo :=0;
    v_spf :=0;
    v_fam :=0;
    v_sbf :=0;
    v_tri :=0;
    v_sbt :=0;
    v_gen :=0;
    v_sbg :=0;
    v_spe :=0;
    v_ssp :=0;
    v_var :=0;
    v_for :=0;

  elsif p_rankcode = 'IFC' then
    --v_ifc :=0;
    v_spo :=0;
    v_ord :=0;
    v_sbo :=0;
    v_ifo :=0;
    v_spf :=0;
    v_fam :=0;
    v_sbf :=0;
    v_tri :=0;
    v_sbt :=0;
    v_gen :=0;
    v_sbg :=0;
    v_spe :=0;
    v_ssp :=0;
    v_var :=0;
    v_for :=0;

  elsif p_rankcode = 'SPO' then
    --v_spo :=0;
    v_ord :=0;
    v_sbo :=0;
    v_ifo :=0;
    v_spf :=0;
    v_fam :=0;
    v_sbf :=0;
    v_tri :=0;
    v_sbt :=0;
    v_gen :=0;
    v_sbg :=0;
    v_spe :=0;
    v_ssp :=0;
    v_var :=0;
    v_for :=0;

  elsif p_rankcode = 'ORD' then
    --v_ord :=0;
    v_sbo :=0;
    v_ifo :=0;
    v_spf :=0;
    v_fam :=0;
    v_sbf :=0;
    v_tri :=0;
    v_sbt :=0;
    v_gen :=0;
    v_sbg :=0;
    v_spe :=0;
    v_ssp :=0;
    v_var :=0;
    v_for :=0;

  elsif p_rankcode = 'SBO' then
    --v_sbo :=0;
    v_ifo :=0;
    v_spf :=0;
    v_fam :=0;
    v_sbf :=0;
    v_tri :=0;
    v_sbt :=0;
    v_gen :=0;
    v_sbg :=0;
    v_spe :=0;
    v_ssp :=0;
    v_var :=0;
    v_for :=0;

  elsif p_rankcode = 'IFO' then
    --v_ifo :=0;
    v_spf :=0;
    v_fam :=0;
    v_sbf :=0;
    v_tri :=0;
    v_sbt :=0;
    v_gen :=0;
    v_sbg :=0;
    v_spe :=0;
    v_ssp :=0;
    v_var :=0;
    v_for :=0;
  elsif p_rankcode = 'SPF' then
    --v_spf :=0;
    v_fam :=0;
    v_sbf :=0;
    v_tri :=0;
    v_sbt :=0;
    v_gen :=0;
    v_sbg :=0;
    v_spe :=0;
    v_ssp :=0;
    v_var :=0;
    v_for :=0;
  elsif p_rankcode = 'FAM' then
    --v_fam :=0;
    v_sbf :=0;
    v_tri :=0;
    v_sbt :=0;
    v_gen :=0;
    v_sbg :=0;
    v_spe :=0;
    v_ssp :=0;
    v_var :=0;
    v_for :=0;
  elsif p_rankcode = 'SBF' then
    --v_sbf :=0;
    v_tri :=0;
    v_sbt :=0;
    v_gen :=0;
    v_sbg :=0;
    v_spe :=0;
    v_ssp :=0;
    v_var :=0;
    v_for :=0;
  elsif p_rankcode = 'TRI' then
    --v_tri :=0;
    v_sbt :=0;
    v_gen :=0;
    v_sbg :=0;
    v_spe :=0;
    v_ssp :=0;
    v_var :=0;
    v_for :=0;
  elsif p_rankcode = 'SBT' then
    --v_sbt :=0;
    v_gen :=0;
    v_sbg :=0;
    v_spe :=0;
    v_ssp :=0;
    v_var :=0;
    v_for :=0;
  elsif p_rankcode = 'GEN' then
    --v_gen :=0;
    v_sbg :=0;
    v_spe :=0;
    v_ssp :=0;
    v_var :=0;
    v_for :=0;
  elsif p_rankcode = 'SBG' then
    --v_sbg :=0;
    v_spe :=0;
    v_ssp :=0;
    v_var :=0;
    v_for :=0;
  elsif p_rankcode = 'SPE' then
    --v_spe :=0;
    v_ssp :=0;
    v_var :=0;
    v_for :=0;
  elsif p_rankcode = 'SSP' then
    --v_ssp :=0;
    v_var :=0;
    v_for :=0;
  elsif p_rankcode = 'VAR' then
    --v_var :=0;
    v_for :=0;
  elsif p_rankcode = 'FOR' then
    null;
  end if;
end reset_ranks;

procedure inc_rank(p_rankcode char) is
begin
  if p_rankcode = 'KNG' then
    v_KNG :=v_KNG +1;
  elsif p_rankcode = 'SBK' then
    v_SBK :=v_SBK +1;
  elsif p_rankcode = 'DIV' or  p_rankcode = 'PHY' then
    v_DIV :=v_DIV +1;
  elsif p_rankcode = 'SBD' or  p_rankcode = 'SBP' then
    v_SBD :=v_SBD +1;
  elsif p_rankcode = 'SPC' then
    v_SPC :=v_SPC +1;
  elsif p_rankcode = 'CLS' then
    v_CLS :=v_CLS +1;
  elsif p_rankcode = 'SBC' then
    v_SBC :=v_SBC +1;
  elsif p_rankcode = 'IFC' then
    v_IFC :=v_IFC +1;
  elsif p_rankcode = 'SPO' then
    v_SPO :=v_SPO +1;
  elsif p_rankcode = 'ORD' then
    v_ORD :=v_ORD +1;
  elsif p_rankcode = 'SBO' then
    v_SBO :=v_SBO +1;
  elsif p_rankcode = 'IFO' then
    v_IFO :=v_IFO +1;
  elsif p_rankcode = 'SPF' then
    v_SPF :=v_SPF +1;
  elsif p_rankcode = 'FAM' then
    v_FAM :=v_FAM +1;
  elsif p_rankcode = 'SBF' then
    v_SBF :=v_SBF +1;
  elsif p_rankcode = 'TRI' then
    v_TRI :=v_TRI +1;
  elsif p_rankcode = 'SBT' then
    v_SBT :=v_SBT +1;
  elsif p_rankcode = 'GEN' then
    v_GEN :=v_GEN +1;
  elsif p_rankcode = 'SBG' then
    v_SBG :=v_SBG +1;
  elsif p_rankcode = 'SPE' then
    v_SPE :=v_SPE +1;
  elsif p_rankcode = 'SSP' then
    v_SSP :=v_SSP +1;
  elsif p_rankcode = 'VAR' then
    v_VAR :=v_VAR +1;
  elsif p_rankcode = 'FOR' then
    v_FOR :=v_FOR +1;
  end if;
end inc_rank;

function f_sort_code(p_rankcode char) return varchar2 is 
  vc_kng char(1) := lpad(to_char(v_kng),1,'0');
  vc_sbk char(1) := lpad(to_char(v_sbk),1,'0');
  vc_div char(2) := lpad(to_char(v_div),2,'0');
  vc_sbd char(1) := lpad(to_char(v_sbd),1,'0');
  vc_spc char(1) := lpad(to_char(v_spc),1,'0');
  vc_cls char(2) := lpad(to_char(v_cls),2,'0');
  vc_sbc char(1) := lpad(to_char(v_sbc),1,'0');
  vc_ifc char(1) := lpad(to_char(v_ifc),1,'0');
  vc_spo char(2) := lpad(to_char(v_spo),2,'0');
  vc_ord char(2) := lpad(to_char(v_ord),2,'0');
  vc_sbo char(2) := lpad(to_char(v_sbo),2,'0');
  vc_ifo char(1) := lpad(to_char(v_ifo),1,'0');
  vc_spf char(2) := lpad(to_char(v_spf),2,'0');
  vc_fam char(3) := lpad(to_char(v_fam),3,'0');
  vc_sbf char(2) := lpad(to_char(v_sbf),2,'0');
  vc_tri char(2) := lpad(to_char(v_tri),2,'0');
  vc_sbt char(1) := lpad(to_char(v_sbt),1,'0');
  vc_gen char(3) := lpad(to_char(v_gen),3,'0');
  vc_sbg char(2) := lpad(to_char(v_sbg),2,'0');
  vc_spe char(3) := lpad(to_char(v_spe),3,'0');
  vc_ssp char(2) := lpad(to_char(v_ssp),2,'0');
  vc_var char(2) := lpad(to_char(v_var),2,'0');
  vc_for char(2) := lpad(to_char(v_for),2,'0');
  lv_sort_code varchar2(45);
  lv_sclen number:=0;
begin

  if p_rankcode = 'KNG' then
    lv_sclen:= 1;
  elsif p_rankcode = 'SBK' then
    lv_sclen:= 2;
  elsif p_rankcode = 'DIV' or  p_rankcode = 'PHY' then
    lv_sclen:= 4;
  elsif p_rankcode = 'SBD' or  p_rankcode = 'SBP' then
    lv_sclen:= 5;
  elsif p_rankcode = 'SPC' then
    lv_sclen:= 6;
  elsif p_rankcode = 'CLS' then
    lv_sclen:= 8;
  elsif p_rankcode = 'SBC' then
    lv_sclen:= 9;
  elsif p_rankcode = 'IFC' then
    lv_sclen:= 10;
  elsif p_rankcode = 'SPO' then
    lv_sclen:= 12;
  elsif p_rankcode = 'ORD' then
    lv_sclen:= 14;
  elsif p_rankcode = 'SBO' then
    lv_sclen:= 16;
  elsif p_rankcode = 'IFO' then
    lv_sclen:= 17;
  elsif p_rankcode = 'SPF' then
    lv_sclen:= 19;
  elsif p_rankcode = 'FAM' then
    lv_sclen:= 22;
  elsif p_rankcode = 'SBF' then
    lv_sclen:= 24;
  elsif p_rankcode = 'TRI' then
    lv_sclen:= 26;
  elsif p_rankcode = 'SBT' then
    lv_sclen:= 27;
  elsif p_rankcode = 'GEN' then
    lv_sclen:= 30;
  elsif p_rankcode = 'SBG' then
    lv_sclen:= 32;
  elsif p_rankcode = 'SPE' then
    lv_sclen:= 35;
  elsif p_rankcode = 'SSP' then
    lv_sclen:= 37;
  elsif p_rankcode = 'VAR' then
    lv_sclen:= 39;
  elsif p_rankcode = 'FOR' then
    lv_sclen:= 41;
  end if;


  lv_sort_code:=vc_kng||vc_sbk||vc_div||vc_sbd||vc_spc||vc_cls||
	vc_sbc||vc_ifc||vc_spo||vc_ord||vc_sbo||vc_ifo||vc_spf||vc_fam||
	vc_sbf||vc_tri||vc_sbt||vc_gen||vc_sbg||vc_spe||vc_ssp||vc_var||vc_for;
  --  lv_sort_code:= rtrim(lv_sort_code,'0');
  lv_sort_code:=substr(lv_sort_code,1,lv_sclen);
  return lv_sort_code;
end f_sort_code;

begin

v_kng :=0;
v_sbk :=0;
--v_phy :=0;
v_div :=0;
--v_sbp :=0;
v_sbd :=0;
v_spc :=0;
v_cls :=0;
v_sbc :=0;
v_ifc :=0;
v_spo :=0;
v_ord :=0;
v_sbo :=0;
v_ifo :=0;
v_spf :=0;
v_fam :=0;
v_sbf :=0;
v_tri :=0;
v_sbt :=0;
v_gen :=0;
v_sbg :=0;
v_spe :=0;
v_ssp :=0;
v_var :=0;
v_for :=0;

end sort_code_pkg;
/
SHOW ERRORS;
spool off;