CREATE or REPLACE function f_char_name (is_number in number,
                  org_id in varchar2) return varchar2 as
       char_name tsrchar.display_name%type;
     begin
       if is_number is null then
          return(null);
       else
        select display_name into char_name from tsrchar
        where tsrchar_is_number = is_number
        and tsrchar_org_id = org_id;
        return (char_name);
       end if;
     exception
        when no_data_found or value_error then
          return (null);
        when others then
          return (null);
     end;
/
show errors

